﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using System.Data;
using System.Collections.Specialized;

public partial class AdminSendEmailToUser : BasePage
{
    private List<STD_GUI_CONTROL_AHOBPR> _dbControls = null;
    private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    private AHOBPRUserManager _userManager = new AHOBPRUserManager();

    public string selectedQuestion = null;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            ShowGridViewSendEmail(false);
        }
        UserSession.RegistrantId = 0;
        HiddenFieldTotalUsers.Value = "0";

        LoadBaseControls();
    }


    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        ClearSearchCriteria();
        ShowGridViewSendEmail(false);
        PanelSend.Visible = false;
        gridViewPageSizeDdl.Visible = false;
        LabelItemsPerPage.Visible = false;
    }
    protected void ButtonClearSelection_Click(object sender, EventArgs e)
    {
        Response.Redirect("AdminSendEmailToUser.aspx");
    }
 
    private void LoadBaseControls()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_SEND_EMAIL_USER"))
        {
            Control userControl = PanelParameterSendMessage.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                switch (dbItem.BASE_CONTROL_TYPE)
                {
                    case (int)AhobprBaseControlType.DropDownList:
                        controls_BaseControlDropDownList baseControlDropdown = (controls_BaseControlDropDownList)userControl;

                        baseControlDropdown.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY,
                                                                 dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.REQUIRED);
                        if (dbItem.USER_CONTROL_ID != "BaseControlDropDownListTemplate")
                        {
                            baseControlDropdown.RemoveEmptyItem();
                        }

                        break;
                    case (int)AhobprBaseControlType.TextBox:
                        controls_BaseControlTextBox baseControlTextBox = (controls_BaseControlTextBox)userControl;

                        baseControlTextBox.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH,
                            dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.VALIDATION_REGULAR_EXPRESSION, dbItem.REQUIRED);
                        break;

                }
            }
        }
    }

    private List<STD_GUI_CONTROL_AHOBPR> GetGuiControls(string controlCategory)
    {
        if (UserSession.GuiControlsUserEmailTemplate == null)
        {
            _dbControls = _baseControlManager.SelectGuiControlList(controlCategory).ToList<STD_GUI_CONTROL_AHOBPR>();
            UserSession.GuiControlsUserEmailTemplate = _dbControls;
        }
        else
        {
            _dbControls = UserSession.GuiControlsUserEmailTemplate;
        }

        return _dbControls;
    }


    protected void ButtonFind_Click(object sender, EventArgs e)
    {
        ViewState["selecteduserids"] = null;
        FindUsers();
    }

    private void FindUsers()
    {
        ShowGridViewSendEmail(true);
        gridViewPageSizeDdl.Visible = true;
        LabelItemsPerPage.Visible = true;
        PanelSend.Visible = (Helpers.getIntFromString(HiddenFieldTotalUsers.Value) > 0);
    }



    private void ShowGridViewSendEmail(bool show)
    {
        if (show)
        {
            GridViewSendMessage.DataBind();
            int total = _userManager.SearchUserSendEmailCount(BaseControlTextBoxLastName.Text, BaseControlTextBoxFirstName.Text,
                                                              BaseControlDropDownListUserRole.Text, BaseControlDropDownListUserStatus.Text,
                                                              null, 0, 0);
            LabelNumberOfResultsFound.Text = "Total Number of Results Found: " + total.ToString();
            HiddenFieldTotalUsers.Value = total.ToString();
        }

        PanelSendMessage.Visible = show;
    }


   private void ClearSearchCriteria()
    {
        BaseControlTextBoxLastName.Text = string.Empty;
        BaseControlTextBoxFirstName.Text = string.Empty;
        BaseControlDropDownListUserRole.Text = string.Empty;
        BaseControlDropDownListUserStatus.Text = string.Empty;
    }


    public override string MenuItemName()
    {
        return "Send Email to Users";
    }
    public override string AppObjectCode()
    {
        return "AHOBPR SEND MESSAGE";
    }
    public override string TopMenuName()
    {
        return "Administration";
    }

    private List<int> SelectedUserIds
    {
        get
        {
            if (ViewState["selecteduserids"] == null)
            {
                ViewState["selecteduserids"] = new List<int>();
            }
            return (List<int>)ViewState["selecteduserids"];
        }
    }

    protected void ButtonSendMessageAll_Click(object sender, EventArgs e)
    {
        IList<SP_UserListForSendEmailResult> userListAll = GetUserListSentAll();
        CustomValidatorSelectedRecords.IsValid = (userListAll.Count() > 0);

        //Send email to checked rows from viewState
        if (userListAll.Count > 0)
        {
            List<int> userList = (from q in userListAll
                                        select q.USER_ID).ToList();
            AddMessagesToQueueBatch(userList);

        }
     }


    private void AddMessagesToQueueBatch(List<int> userList)
    {
        AHOBPREmailTemplateManager emailTemplateManager = new AHOBPREmailTemplateManager();
        int emailTemplateId = Convert.ToInt32(BaseControlDropDownListTemplate.Text);
        AHOBPRQueueManager queueManager = new AHOBPRQueueManager();

        //Add to Audit Log
        UserAccountManager user = (UserAccountManager)HttpContext.Current.User;
        string message = BaseControlDropDownListTemplate.DescriptionText;
        Helpers.AddActivityToAuditLog(user.UserId.ToString(), message,
            string.Empty, AuditLogType.EmailSentToUsers, userList.Count());

        // send messages to queue
        int batchSize = Helpers.GetQueueBatchSize();
        int totalBatches = userList.Count % batchSize == 0 ? userList.Count / batchSize : Convert.ToInt32(userList.Count / batchSize) + 1;
        int batchNumber = 0;
        for (int i = 1; i <= totalBatches; i++)
        {
            batchNumber++;
            string userIds = Helpers.GetIdBatch(userList, batchNumber, batchSize, totalBatches);
            int actualBatchSize = batchNumber < totalBatches ? batchSize : userIds.Split(',').Length;
            string adminFlag = "Email \"" + BaseControlDropDownListTemplate.DescriptionText + "\" Sent";
            queueManager.AddQueueBatch(null, (int)Enums.queueType.UserEmail, emailTemplateId, adminFlag, actualBatchSize, userIds);
        }
        Alert.Show("Save Successful!");
    }



    private IList<SP_UserListForSendEmailResult> GetUserListSentAll()
    {
        IList<SP_UserListForSendEmailResult> userList = _userManager.SearchUserSendEmail(BaseControlTextBoxLastName.Text, BaseControlTextBoxFirstName.Text,
                                                              BaseControlDropDownListUserRole.Text, BaseControlDropDownListUserStatus.Text, null, 0, 0);
        return userList;
     }


    protected void ButtonSendMessageSelected_Click(object sender, EventArgs e)
    {
        GetSelectedUsers();
        CustomValidatorSelectedRecords.IsValid = (SelectedUserIds.Count > 0);
        
        //Send email to checked rows from viewState
        if (SelectedUserIds.Count > 0)
        {
            AddMessagesToQueueBatch(SelectedUserIds);
        }
    }


    protected void GridViewSendMessage_PageIndexChanged(object sender, EventArgs e)
    {
        GetSelectedUsers();
    }

    protected void GridViewSendMessage_Sorting(object sender, GridViewSortEventArgs e)
    {
        GetSelectedUsers();
    }

    private void GetSelectedUsers()
    {
        foreach (GridViewRow row in GridViewSendMessage.Rows)
        {

            if (row.RowType == DataControlRowType.DataRow)
            {
                var foundLabel = (row.Cells[1].FindControl("LabelUserId") as Label);
                int id = 0;
                if (foundLabel != null)
                {
                    id = int.Parse(foundLabel.Text);
                }

                CheckBox chkRow = (row.Cells[0].FindControl("checkBoxSend") as CheckBox);
                if (chkRow != null && chkRow.Checked)
                {
                    if (!IsUserSelected(id))
                    {
                        SelectedUserIds.Add(id);
                    }
                }
                else
                {
                    if (IsUserSelected(id))
                    {
                        SelectedUserIds.Remove(id);
                    }
                }
            }
        }
    }

    private bool IsUserSelected(int userId)
    {
        foreach (int id in SelectedUserIds)
        {
            if (id == userId)
            {
                return true;
            }
        }
        return false;
    }

    protected void GridViewSendMessage_DataBound(object sender, EventArgs e)
    {
        foreach (GridViewRow row in GridViewSendMessage.Rows)
        {

            if (row.RowType == DataControlRowType.DataRow)
            {
                var foundLabel = (row.Cells[1].FindControl("LabelUserId") as Label);
                int id = 0;
                if (foundLabel != null)
                {
                    id = int.Parse(foundLabel.Text);
                }

                if (IsUserSelected(id))
                {
                    CheckBox chkRow = (row.Cells[0].FindControl("checkBoxSend") as CheckBox);
                    if (chkRow != null)
                    {
                        chkRow.Checked = true;
                    }
                }
            }
        }
    }

    protected void gridViewPageSizeDdlChanged(Object sender, EventArgs e)
    {

        GridViewSendMessage.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);

    }

    protected void gridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewSendMessage.PageIndex = e.NewPageIndex;

    }
}