﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using AntiXssEnc = Microsoft.Security.Application;
using System.Configuration;

public partial class AdminEditUsers : BasePage
{
    private string _currentRegistry = Helpers.GetConfigEntry("Registry");
    //private List<STD_GUI_CONTROL_AHOBPR> _dbControls = null;
    private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    AHOBPRUserManager _ahobprUserManager = new AHOBPRUserManager();

    USER userEntry;
    AHOBPR_USER _ahobprUserEntry;

    UsersManager usersManager = new UsersManager();
    USER_STATES_FILTER _stateFilter = new USER_STATES_FILTER();
    private bool _isOnlyAdvancedUser = false;

    #region Protected Methods
    protected void Page_Load(object sender, EventArgs e)
    {
        StateFilterLimit.Text = ConfigurationManager.AppSettings["ChangeStatusStateFilterLimit"] == null ? "4" : ConfigurationManager.AppSettings["ChangeStatusStateFilterLimit"].ToString();
        if (!IsPostBack)
        {
            HiddenFieldBreadCrumbBaseText.Value = LabelBreadCrumb.Text.Remove(0,4).Remove(17,5);

            //if page is loading for first time get ID from querystring and set to hidden field to use on postbacks
            int? userID = Convert.ToInt32(Request.QueryString["id"]);
            HiddenFieldUserID.Value = userID.GetValueOrDefault().ToString();

            //Check if the request is to create a new item
            //a new item page request is signified when the querystring parameter id equals zero or is not present

            if (userID == null || userID == 0)
            {
                //set userID to zero so that a default linq entity will be instantiated
                userID = 0;

                //set page display for new item
                SetFormDisplay(true);

            }
            else
            {
                //set page to display for existing item
                SetFormDisplay(false);

            }

        }



        //Create User Entity object and Set properties to state of form
        getEntry(Convert.ToInt32(HiddenFieldUserID.Value));

        if ((userEntry != null) && (HiddenFieldUserID.Value != "0"))
        {
            UserAccountManager userManager = new UserAccountManager(userEntry.USERNAME, "AHOBPR");
            AlterPageForAdvancedUsers(userManager, ConfigurationManager.AppSettings["ChangeStatusStateFilterLimit"].ToString());
            LabelBreadCrumb.Text = "<H1>" + AntiXssEnc.Encoder.HtmlEncode(HiddenFieldBreadCrumbBaseText.Value + " Users > " + userEntry.USERNAME) + "</H1>";
            LoadBaseControls();
        }
        else
        {
            LabelBreadCrumb.Text = "<H1>" + AntiXssEnc.Encoder.HtmlEncode(HiddenFieldBreadCrumbBaseText.Value + " Add User") + "</H1>";
            SetVisibilityOfStateFilterDiv(false, StateFilterLimit.Text);
            LoadBaseControls();
        }

        if (IsPostBack && userEntry != null)
        {
            LoadObjectFromControls();
            //LoadBaseControls();
        }
        if (_isOnlyAdvancedUser)
        {
            LoadUserControlListBox();
        }
    }
    protected void getEntry(int id)
    {
        userEntry = usersManager.SelectByID(_currentRegistry, id);
        _ahobprUserEntry = _ahobprUserManager.GetUser(id);
        //initial display panels
        PanelNoAccess.Visible = false;
        PanelIdNotFound.Visible = false;
        PanelObjectContent.Visible = false;

        if (userEntry == null)
        {
            PanelObjectContent.Visible = false;

            if (usersManager.UserIDExists(id))
            {
                PanelNoAccess.Visible = true;
            }
            else
            {
                PanelIdNotFound.Visible = true;
            }
        }
        else
        {
            PanelObjectContent.Visible = true;
        }
    }
    protected void SetFormForInsertNewUser(string newUsername)
    {

        PanelNewUserSearchID.Visible = false;
        PanelUserInformation.Visible = true;
        TextBoxUsername.Text = newUsername;
        TextBoxUsername.ReadOnly = true;
        HiddenFieldInsertingNewUser.Value = "true";
        ButtonSave.Visible = true;
        TextBoxUsername.ReadOnly = true;
        TextBoxUsername.BackColor = System.Drawing.Color.LightGray;
        LabelCreatedBy.Visible = false;
        LabelCreatedOn.Visible = false;
        LabelUpdatedBy.Visible = false;
        LabelUpdatedOn.Visible = false;
        LabelCreatedByCaption.Visible = false;
        LabelCreatedOnCaption.Visible = false;
        LabelUpdatedByCaption.Visible = false;
        LabelUpdatedOnCaption.Visible = false;
        LabelLastLogin.Visible = false;
        LabelLastLoginCaption.Visible = false;
        LabelLastVistaLogin.Visible = false;
        LabelLastVistaLoginCaption.Visible = false;
        LabelStatus.Visible = false;
        LabelStatusCaption.Visible = false;
        ButtonActivate.Visible = false;
        ButtonApprove.Visible = false;

    }
    protected void SetFormDisplay(bool isNewItem)
    {
        //LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");

        if (isNewItem)
        {
            //set page display for new item
            PanelNewUserSearchID.Visible = true;
            PanelUserInformation.Visible = false;
            ButtonSave.Visible = false;

            LabelUsernameExists.Visible = false;
            GridViewUsers.Visible = false;
            ButtonAddUser.Visible = false;
            LabelUsernameIsInRegistry.Visible = false;
            ButtonViewEditUser.Visible = false;

            //Modify breadcrumb to display adding new
            //LabelBreadCrumb.Text = HiddenFieldBreadCrumbBaseText.Value + " > User Search / Edit / Add";

        }
        else
        {
            //set page display for existing item 
            PanelNewUserSearchID.Visible = false;
            PanelUserInformation.Visible = true;
            ButtonSave.Visible = true;
            LabelCreatedByCaption.Visible = true;
            LabelCreatedOnCaption.Visible = true;
            LabelUpdatedByCaption.Visible = true;
            LabelUpdatedOnCaption.Visible = true;
            LabelCreatedBy.Visible = true;
            LabelCreatedOn.Visible = true;
            LabelUpdatedBy.Visible = true;
            LabelUpdatedOn.Visible = true;
            LabelLastLogin.Visible = true;
            LabelLastLoginCaption.Visible = true;
            LabelLastVistaLogin.Visible = true;
            LabelLastVistaLoginCaption.Visible = true;
            LabelStatus.Visible = true;
            LabelStatusCaption.Visible = true;
            ButtonActivate.Visible = true;
            ButtonApprove.Visible = true;
            //Modify breadcrumb to display editing user id
            //LabelBreadCrumb.Text = HiddenFieldBreadCrumbBaseText.Value + " > Edit User ID : " + HiddenFieldUserID.Value;

        }
    }
    #endregion Protected Methods
    #region Public Methods
    #endregion Public Methods
    public override string TopMenuName()
    {
        return "Administration";
    }
    public override string MenuItemName()
    {
        //return "Add / Edit Users";
        //return "Edit Users";
        return "AHOBPR ADMIN EDIT USERS";
    }
    public override string AppObjectCode()
    {
        return "AHOBPR ADMIN EDIT USERS";
    }
    void Page_PreRender(object sender, EventArgs e)
    {
        if (userEntry != null)
        {
            //This is the last event in the page life cycle where changes can be made to the page object
            //so enforce business rules on the object (which could possibly change the propertie of the object
            //then load the form controls from the object

            //Enforce business rules on the referral object
            //need to call EnforceBusinessRules method in the ReferralManager because some rules require a database call
            //pass in the local instance of referral to the method.  The method will return the object with modifications due to business rules.
            if (IsPostBack)
            {
                int ret;
                ret = usersManager.EnforceBusinessRules(ref userEntry);
            }

            //Load Controls from the Object
            LoadControlsFromObject();
        }

    }
    #region Object/Form Mapping

    private void LoadControlsFromObject()
    {
        if (userEntry != null &&
            userEntry.USER_ID != 0)
        {
            AHOBPRUserManager ahobprUserManager = new AHOBPRUserManager();
            AHOBPR_USER ahobprUser = ahobprUserManager.GetUser(userEntry.USER_ID);
            //If this is a registry-wide user but not an AHOBPR user,
            if (ahobprUser == null)
            {
                //We want to add them to AHOBPR:
                ahobprUserManager.AddUserToRegistry(userEntry, usersManager);
                if (ahobprUserManager.CreateAccount(userEntry, true, false, null, null, null, null))
                {
                    ahobprUser = ahobprUserManager.GetUser(userEntry.USER_ID);
                }
                else
                {
                    return;
                }
            }

            //Username:
            TextBoxUsername.Text = userEntry.USERNAME;

            //Full Name:
            TextBoxFullName.Text = userEntry.FULL_NAME;

            //First Name:
            TextBoxFirstName.Text = userEntry.FIRST_NAME;

            //Middle Name:
            TextBoxMiddleName.Text = userEntry.MIDDLE_NAME;

            //Last Name:
            TextBoxLastName.Text = userEntry.LAST_NAME;

            //Maiden Name:
            TextBoxMaidenName.Text = userEntry.MAIDEN_NAME;

            //Employee Number:
            TextBoxEmployeeNumber.Text = userEntry.EMPLOYEE_NUMBER;

            //Job Title:
            TextBoxJobTitle.Text = userEntry.JOB_TITLE;

            //Email Address:
            TextBoxEmailAddress.Text = userEntry.EMAIL_ADDRESS;

            //Telephone:
            TextBoxTelephone.Text = userEntry.TELEPHONE_NUMBER;

            //Fax:
            TextBoxFax.Text = userEntry.FAX_NUMBER;

            //Created By:
            string createdBy = string.IsNullOrEmpty(userEntry.CREATEDBY) ? userEntry.USERNAME : userEntry.CREATEDBY;
            LabelCreatedBy.Text = AntiXssEnc.Encoder.HtmlEncode(createdBy);

            //Created On:
            LabelCreatedOn.Text = Helpers.getShortDateStringFromNullableDate(userEntry.CREATED);

            //Updated By:
            string updatedBy = string.IsNullOrEmpty(userEntry.UPDATEDBY) ? userEntry.USERNAME : userEntry.UPDATEDBY;
            LabelUpdatedBy.Text = AntiXssEnc.Encoder.HtmlEncode(updatedBy);

            //Updated On:
            LabelUpdatedOn.Text = Helpers.getShortDateStringFromNullableDate(userEntry.UPDATED);

            //Last Login
            LabelLastLogin.Text = ahobprUser.LAST_LOGIN == null ? "[None]" : ahobprUser.LAST_LOGIN.Value.ToString();

            //Last VistA Login:
            LabelLastVistaLogin.Text = ahobprUser.LAST_VISTA_LOGIN == null ? "[None]" : ahobprUser.LAST_VISTA_LOGIN.Value.ToString();

            //Primary Job, Secondary Job and Work Location
            BaseControlDropdownListPrimaryJob.Text = ahobprUser.PRIMARY_JOB_ID.ToString();
            BaseControlDropdownListSecondaryJob.Text = ahobprUser.SECONDARY_JOB_ID.ToString();
            BaseControlDropdownListWorkLocation.Text = ahobprUser.WORK_LOCATION_ID.ToString();

            //Status label, Activate & Approve buttons:
            if (ahobprUser.ACTIVE_FLAG)
            {
                if (ahobprUser.PENDING_FLAG)
                {
                    LabelStatus.Text = "Pending";
                    ButtonActivate.Visible = false;
                    ButtonApprove.Visible = true;
                    ButtonApprove.Text = "Approve";
                }
                else
                {
                    LabelStatus.Text = "Active";
                    ButtonActivate.Visible = true;
                    ButtonActivate.Text = "Deactivate";
                    ButtonApprove.Visible = false;
                }
            }
            else
            {
                LabelStatus.Text = "Inactive";
                ButtonActivate.Visible = true;
                ButtonActivate.Text = "Activate";
                ButtonApprove.Visible = false;
            }

            // user state filter
            //Only advanced users have the opportunity to select the states to filter on
            //The UserConotrolListBoxState won't be loaded for a non-advanced user, so
            // don't try to set that control
            if (_isOnlyAdvancedUser)
            {
                _stateFilter = _ahobprUserManager.GetStatesFilter(userEntry.USER_ID);
                if (_stateFilter == null)
                {
                    //USER isn't set up in this table, better create an entry to be saved later
                    _stateFilter = new USER_STATES_FILTER
                    {
                        USER_ID = userEntry.USER_ID,
                        STATES = ""
                    };
                }
                this.UserControlListBoxState.DataElementValue = Helpers.ConvertToKeyValuePair(_stateFilter.STATES);
            }
        }
    }

    private void LoadObjectFromControls()
    {
        getEntry(Convert.ToInt32(HiddenFieldUserID.Value));
        //Username:
        userEntry.USERNAME = TextBoxUsername.Text;

        //Full Name:
        userEntry.FULL_NAME = TextBoxFullName.Text;

        //First Name:
        userEntry.FIRST_NAME = TextBoxFirstName.Text;

        //Middle Name:
        userEntry.MIDDLE_NAME = TextBoxMiddleName.Text;

        //Last Name:
        userEntry.LAST_NAME = TextBoxLastName.Text;

        //Maiden Name:
        userEntry.MAIDEN_NAME = TextBoxMaidenName.Text;

        //Employee Number:
        userEntry.EMPLOYEE_NUMBER = TextBoxEmployeeNumber.Text;

        //Job Title:
        userEntry.JOB_TITLE = TextBoxJobTitle.Text;
      

        //Email Address:
        userEntry.EMAIL_ADDRESS = TextBoxEmailAddress.Text;

        //Telephone:
        userEntry.TELEPHONE_NUMBER = TextBoxTelephone.Text;

        //Fax:
        userEntry.FAX_NUMBER = TextBoxFax.Text;

       
        //Primary job, secondary job and work location
        if (_ahobprUserEntry == null || _ahobprUserEntry.USER_ID == 0)
        {
            _ahobprUserEntry = new AHOBPR_USER();
            _ahobprUserEntry.USER_ID = userEntry.USER_ID;
        }
        var primaryId = string.IsNullOrEmpty(BaseControlDropdownListPrimaryJob.Text) ? null : (int?)Helpers.getIntFromString(BaseControlDropdownListPrimaryJob.Text);
        var secondaryId = string.IsNullOrEmpty(BaseControlDropdownListSecondaryJob.Text) ? null : (int?)Helpers.getIntFromString(BaseControlDropdownListSecondaryJob.Text);
        var workLocation = string.IsNullOrEmpty(BaseControlDropdownListWorkLocation.Text) ? null : (int?)Helpers.getIntFromString(BaseControlDropdownListWorkLocation.Text);
        _ahobprUserManager.UpdatePrimaryJob(_ahobprUserEntry, primaryId);
        _ahobprUserManager.UpdateSecondaryJob(_ahobprUserEntry, secondaryId);
        _ahobprUserManager.UpdateWorkLocation(_ahobprUserEntry, workLocation);

        if (_isOnlyAdvancedUser)
        {
            //TODO Add STATE_FILTER settings here
            _stateFilter.USER_ID = Convert.ToInt32(HiddenFieldUserID.Value);
            _stateFilter.STATES = UserControlListBoxState.Text;
        }
    }

   
    #endregion
    #region Postback Events

    protected void ButtonSave_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            int returnSaveValue;

            returnSaveValue = usersManager.Update(userEntry);
            _ahobprUserManager.UpdateUser(_ahobprUserEntry);
            //Only advanced users have the opportunity to select the states to filter on
            //If the user doesn't have the advanced users role, don't make a call to the DB
            if (_isOnlyAdvancedUser)
            {
                _ahobprUserManager.UpdateUserStateFilter(_stateFilter);
            }

            //Set Broken Rule Error Display
            if (userEntry.BrokenRules.Count == 0)
            {
                ErrorList1.Visible = false;

                //if inseted a new user and no errors, set the form to editing user mode.
                if (HiddenFieldInsertingNewUser.Value == "true")
                {
                    HiddenFieldInsertingNewUser.Value = "false";
                    HiddenFieldUserID.Value = userEntry.USER_ID.ToString();
                    SetFormDisplay(false);
                }
                var master = (this.Master as RegistryMaster);
                if (master != null)
                {
                    master.SetDirtyFlag(false);
                }
                Alert.ShowSaveSuccess();
            }
            else
            {
                ErrorList1.Visible = true;
            }


            ErrorList1.BrokenRules = userEntry.BrokenRules;
        }

    }

    protected void ButtonClose_Click(object sender, EventArgs e)
    {
        Response.Redirect("AdminListUsers.aspx");
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        this.TextBoxSearchCriteria.Text = "";
        SetFormDisplay(true);
    }
    
    protected void ButtonActivate_Click(object sender, EventArgs e)
    {
        AHOBPRUserManager userManager = new AHOBPRUserManager();
        AHOBPR_USER ahobprUser = userManager.GetUser(userEntry.USER_ID);
        userManager.EnableAccount(ahobprUser, !ahobprUser.ACTIVE_FLAG);
        SetFormDisplay(true);
    }

    protected void ButtonApprove_Click(object sender, EventArgs e)
    {
        AHOBPRUserManager userManager = new AHOBPRUserManager();
        userManager.ApproveAccount(userEntry.USER_ID);
        SetFormDisplay(true);
    }

    protected void ButtonSearch_Click(object sender, EventArgs e)
    {

        userEntry = usersManager.SelectByUsername(TextBoxSearchCriteria.Text.Trim());

        if (userEntry != null)
        {
            HiddenFieldUserID.Value = userEntry.USER_ID.ToString();
            HiddenFieldSelectedUsername.Value = userEntry.USERNAME;

            if (usersManager.IsInRegistry(userEntry.USERNAME, _currentRegistry))
            {
                LabelUsernameIsInRegistry.Visible = true;
                ButtonViewEditUser.Visible = true;
            }
            else
            {
                LabelUsernameExists.Visible = true;
                GridViewUsers.Visible = true;
                ButtonAddUser.Visible = true;

                GridViewUsers.DataSourceID = "ObjectDataSourceUsers";
                GridViewUsers.DataBind();
            }

        }
        else
        {
            HiddenFieldUserID.Value = "0";
            HiddenFieldSelectedUsername.Value = "";

            if (!String.IsNullOrEmpty(TextBoxSearchCriteria.Text.Trim()))
            {
                getEntry(0);
                if (userEntry != null)
                    userEntry.USERNAME = AntiXssEnc.Encoder.HtmlEncode(TextBoxSearchCriteria.Text.Trim());

                SetFormForInsertNewUser(TextBoxSearchCriteria.Text);
                LabelBreadCrumb.Text = "<H1>" + AntiXssEnc.Encoder.HtmlEncode(HiddenFieldBreadCrumbBaseText.Value + " Add User > " + TextBoxSearchCriteria.Text.Trim()) + "</H1>";
            }
            else
            {
                ShowMessage("Please specify a user name for the search.");
            }
        }

    }

    protected void ButtonAddUser_Click(object sender, EventArgs e)
    {
        //if HiddenFieldSelectedUserID has a value, 
        //this signifies that the user selected to add an existing user to the current registry
        if (HiddenFieldSelectedUsername.Value != "")
        {
            userEntry = usersManager.SelectByUsername(TextBoxSearchCriteria.Text.Trim());
            HiddenFieldUserID.Value = userEntry.USER_ID.ToString();
            if (userEntry != null)
            {
                userEntry.SetAsChangeTrackingRoot();
            }
            //Add user to registry and display in edit mode
            if (usersManager.AddUserToRegistry(userEntry, _currentRegistry) == 1)
            {
                SetFormDisplay(false);
                getEntry(userEntry.USER_ID);
            }
            else
            {
                //could not add to registry
                //TO DO : display error message
            }
        }
    }

    protected void ButtonViewEditUser_Click(object sender, EventArgs e)
    {
        SetFormDisplay(false);
    }

    #endregion

    protected void ShowMessage(string message)
    {
        string script = "<script language=\"javascript\"  type=\"text/javascript\">alert('" + message.Replace("'", "\\'") + "');</script>";
        ScriptManager.RegisterStartupScript(Page, this.GetType(), "AlertMessage", script, false);
    }


    private void AlterPageForAdvancedUsers(UserAccountManager user, string filterLimit)
    {
        //set class field as it will be referenced when saving the user
        _isOnlyAdvancedUser = CheckIfUserHasAdvancedUserRole(user);
        SetVisibilityOfStateFilterDiv(_isOnlyAdvancedUser, filterLimit);

    }

    private bool CheckIfUserHasAdvancedUserRole(UserAccountManager user)
    {
        if (user.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleAdvancedUserCode)) &&
            !user.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleRegistryManagerCode)))
        {
            _isOnlyAdvancedUser = true;
        }
        return _isOnlyAdvancedUser;
    }

    private void SetVisibilityOfStateFilterDiv(bool isAdvancedUser, string filterLimit)
    {
        if (_isOnlyAdvancedUser)
        {
            ListBoxState.Visible = true;
            StateFilterLimit.Text = filterLimit;
            UserControlListBoxState.IsRequired = true;
        }
        else
        {
            //DEBUGGING: Remove and find a better way to TEST
            ListBoxState.Visible = false;
            //todo put code in javascript that will pass by validation if limit set to 0
            //todo add button save functionality that will not submit state filter info if user isn't an advanced user
            StateFilterLimit.Text = "0";
            UserControlListBoxState.IsRequired = false;
        }
    }
    private void LoadUserControlListBox()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_MYACCOUNT_ACCOUNTINFORMATION"))
        {
            //PanelUserInformation is the Panel ID found in MyAccountEditUser.aspx
            Control userControl = PanelUserInformation.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                if (dbItem.BASE_CONTROL_TYPE == (int)AhobprBaseControlType.ListBox)
                {
                    controls_UserControlListBoxState baseControl = (controls_UserControlListBoxState)userControl;
                    baseControl.LoadControlsFromObject(dbItem.LOOKUP_LIST_CATEGORY, string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                            dbItem.INCLUDE_LABEL, dbItem.DATA_ELEMENT_WIDTH, dbItem.VALIDATION_GROUP, dbItem.REQUIRED);
                }
            }
        }

    }

    private List<STD_GUI_CONTROL_AHOBPR> GetGuiControls(string controlCategory)
    {
        if (UserSession.GuiControlsMyAccountEditUser == null)
        {
            UserSession.GuiControlsMyAccountEditUser = _baseControlManager.SelectGuiControlList(controlCategory).ToList<STD_GUI_CONTROL_AHOBPR>();
        }
      
        return UserSession.GuiControlsMyAccountEditUser;
    }


    private void LoadBaseControls()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_MYACCOUNT_ACCOUNTINFORMATION"))
        {
            Control userControl = PanelUserInformation.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                switch (dbItem.BASE_CONTROL_TYPE)
                {
                    case (int)AhobprBaseControlType.DropDownList:
                        controls_BaseControlDropDownList baseControlDropdown = (controls_BaseControlDropDownList)userControl;

                        baseControlDropdown.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY,
                                                                   dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.REQUIRED);
                        break;

                }
            }
        }
    }
 
}
