﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" EnableEventValidation="false" CodeFile="AdminEditUsers.aspx.cs" Inherits="AdminEditUsers" %>
<%@ Register src="controls/ErrorList.ascx" tagname="ErrorList" tagprefix="uc1" %>
<%@ Register Src="controls/UserControlListBoxState.ascx" TagName="UserControlListBoxState" TagPrefix="UC" %>
<%@ Register src="controls/BaseControlDropDownList.ascx" tagname="BaseControlDropDownList" tagprefix="UserControl" %>
 
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
 <asp:Literal runat="server" ID="StateFilterLimit" EnableViewState="false" Visible ="false" />

    <script src="scripts/jquery.meio.mask.js" type="text/javascript"></script>
    <script type ="text/javascript">
        $(document).ready(function()
        {
            $('#<%= TextBoxTelephone.ClientID %>').setMask("phone-us");
            $('#<%= TextBoxFax.ClientID %>').setMask("phone-us");
            

        });
        // Add items selected in source listbox to destination listbox
        function ListboxAdd(sourceID, destinationID, hiddenFieldID) {
            var limit = <%= StateFilterLimit.Text %>;
            var source = document.getElementById(sourceID);
            var destination = document.getElementById(destinationID);          
            for (var count = 0; count < source.options.length; count++) {
                if (source.options[count].selected == true) {
                    var option = source.options[count];

                    var foundInDestination = false;
                    for (var index = 0; index < destination.options.length; index++) {
                        if (destination.options[index].value == option.value) {
                            foundInDestination = true;
                        }
                    }

                    if (!foundInDestination) {
                        if(destination.options.length < limit){
                            var newOption = document.createElement("option");
                            newOption.value = option.value;
                            newOption.text = option.text;
                            if (option.text.length * 8 > destination.clientWidth) {
                                newOption.title = option.text;
                            }
                            newOption.selected = true;

                            try {
                                destination.add(newOption, null); //Standard
                            } catch (error) {
                                destination.add(newOption); // IE only
                            }
                        }else {
                            alert("You may only select " + limit + " states to filter on. " + option.text + " was not added.");
                        }
                    }
                    source.options[count].selected = false;
                }
            }
           
            PopulateHiddenField(destination, hiddenFieldID);
        }
    </script>  

    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
     <div class="breadcrumb" role="heading" aria-level="1">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="<H1>Administration > </H1>"/>
    </div>    
    <asp:Panel ID="PanelObjectContent" runat="server">
        <br /><uc1:ErrorList ID="ErrorList1" runat="server" />
        <asp:Panel ID="PanelNewUserSearchID" runat="server" GroupingText="Search Username" Width="95%">
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelSearchInstructions" runat="server">
        To add a new user, first search if the username exists in the Registries application:
        </asp:Label>
        <br /><br />
        <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Search Username:</asp:Label>
                            
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="100"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" Search " 
                onclick="ButtonSearch_Click" />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " 
            onclick="ButtonClear_Click" />
        <br />
        <br />
            <asp:Label SkinID="DataLabel" ID="LabelUsernameExists" runat="server" Visible="false">
                The following account has the username.  If you want to grant this account access to your registry click the "Add" button below.
                <br />
                <br />
            </asp:Label>
            <asp:GridView ID="GridViewUsers" runat="server" AllowPaging="True" 
                AllowSorting="True" AutoGenerateColumns="False" Caption="To sort please click table headings"  
                DataKeyNames="USER_ID" DataSourceID="" EmptyDataText="No Users"
                Visible="false" Width="90%">
                <Columns>
                    <asp:BoundField DataField="USER_ID" HeaderText="Id" 
                        SortExpression="USER_ID" />
                    <asp:BoundField DataField="USERNAME" HeaderText="Username" 
                        SortExpression="USERNAME" />
                    <asp:BoundField DataField="FULL_NAME" HeaderText="Name"  
                        SortExpression="LAST_NAME" />
                    <asp:BoundField DataField="EMAIL_ADDRESS" HeaderText="Email" 
                        SortExpression="EMAIL_ADDRESS" />
                </Columns>
            </asp:GridView>
            <br />
            <asp:Button ID="ButtonAddUser" runat="server" Text="  Add  " Visible="false" 
                onclick="ButtonAddUser_Click"/>
            <asp:Label SkinID="DataLabel" ID="LabelUsernameIsInRegistry" runat="server" Visible="false">
                You cannot add this username.  An account with the username above is already a member of the registry.
                <br />
                <br />
            </asp:Label>
            <asp:Button ID="ButtonViewEditUser" runat="server" Text=" View / Edit User Account " 
                Visible="false" onclick="ButtonViewEditUser_Click"/>
                <br />
            <asp:ObjectDataSource ID="ObjectDataSourceUsers" runat="server" 
                SelectMethod="SelectByUsername"
                TypeName="VeteransAffairs.Registries.BusinessManager.UsersManager">
                <SelectParameters>
                    <asp:ControlParameter ControlID="TextBoxSearchCriteria" DefaultValue="" 
                        Name="Username" PropertyName="Text" Type="String" />
                </SelectParameters>
            </asp:ObjectDataSource>
    </asp:Panel>
    <asp:Panel ID="PanelUserInformation" runat="server" GroupingText="Edit User Account Information" 
        Width="65%">
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelforTextBoxUsername" runat="server" AssociatedControlID="TextBoxUsername">Username:</asp:Label>
                            
        <asp:TextBox ID="TextBoxUsername" runat="server" MaxLength="30" Text="" 
            Width="145px" />


        <br />
        <hr style="width:1" />
        <asp:Label SkinID="DataLabel" ID="LabelforTextBoxFullName" runat="server" AssociatedControlID="TextBoxFullName">Full Name:</asp:Label>
                            
        <br />
        <asp:TextBox ID="TextBoxFullName" runat="server" MaxLength="100" Text="" 
            Width="400px" />
        <asp:RequiredFieldValidator ID="RequiredFieldValidatorFullName" runat="server" ControlToValidate="TextBoxFullName" ErrorMessage="Full Name is required" ValidationGroup="UserSave"></asp:RequiredFieldValidator>
        <br />
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelforTextBoxFirstName" runat="server" AssociatedControlID="TextBoxFirstName">First Name:</asp:Label>
                            
        <br />
        <asp:TextBox ID="TextBoxFirstName" runat="server" MaxLength="30" Text="" 
            Width="145px" />
        <asp:RequiredFieldValidator ID="RequiredFieldValidatorFirstName" runat="server" ControlToValidate="TextBoxFirstName" ErrorMessage="First Name is required" ValidationGroup="UserSave"></asp:RequiredFieldValidator>
        <br />
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelforTextBoxMiddleName" runat="server" AssociatedControlID="TextBoxMiddleName">Middle Name:</asp:Label>
              <br />
        <asp:TextBox ID="TextBoxMiddleName" runat="server" MaxLength="30" Text="" 
            Width="145px" />
        <br />
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelforTextBoxLastName" runat="server" AssociatedControlID="TextBoxLastName">Last Name:</asp:Label>
                            
        <br />
        <asp:TextBox ID="TextBoxLastName" runat="server" MaxLength="40" Text="" 
            Width="200px" />
        <asp:RequiredFieldValidator ID="RequiredFieldValidatorLastName" runat="server" ControlToValidate="TextBoxLastName" ErrorMessage="Last Name is required" ValidationGroup="UserSave"></asp:RequiredFieldValidator>
        <br />
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelforTextBoxMaidenName" runat="server" AssociatedControlID="TextBoxMaidenName">Maiden Name:</asp:Label>
                            
        <br />
        <asp:TextBox ID="TextBoxMaidenName" runat="server" MaxLength="40" Text="" 
            Width="200px" />
        <br />
        <hr style="width:1" />
        <asp:Label SkinID="DataLabel" ID="LabelforTextBoxEmployeeNumber" runat="server" AssociatedControlID="TextBoxEmployeeNumber">Employee Number:</asp:Label>
                            
        <br />
        <asp:TextBox ID="TextBoxEmployeeNumber" runat="server" MaxLength="50" Text="" 
            Width="200px" />
       <br />
        <br />
        <UserControl:BaseControlDropDownList ID="BaseControlDropdownListPrimaryJob" runat="server"/>
        <br />
        <br />
        <UserControl:BaseControlDropDownList ID="BaseControlDropdownListSecondaryJob" runat="server"/>
        <br />
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelforTextBoxJobTitle" runat="server" AssociatedControlID="TextBoxJobTitle">Job Title:</asp:Label>
        <br />
        <asp:TextBox ID="TextBoxJobTitle" runat="server" MaxLength="80" Text="" 
            Width="400px" />
        <asp:RequiredFieldValidator ID="RequiredFieldValidatorJobTitle" runat="server" ControlToValidate="TextBoxJobTitle" ErrorMessage="Job Title is required" ValidationGroup="UserSave"></asp:RequiredFieldValidator>
        <br />
        <br />
         <UserControl:BaseControlDropDownList ID="BaseControlDropdownListWorkLocation" runat="server" />
        <br />
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelforTextBoxEmailAddress" runat="server" AssociatedControlID="TextBoxEmailAddress">Email Address:</asp:Label>
                            
        <br />
        <asp:TextBox ID="TextBoxEmailAddress" runat="server" MaxLength="128" Text="" 
            Width="500px" />
            <asp:RegularExpressionValidator ID = "UserEMailValidator" runat = "server" ControlToValidate = "TextBoxEmailAddress" ForeColor="DarkRed" 
                 ErrorMessage = "* Invalid e-mail" ValidationExpression = "^\s*\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*\s*$" 
                  ValidationGroup = "UserSave" Display="Dynamic"></asp:RegularExpressionValidator>
                                    
        <asp:RequiredFieldValidator ID="RequiredFieldValidatorEmailAddress" runat="server" ControlToValidate="TextBoxEmailAddress" Display="Dynamic" ErrorMessage="Email Address is required" ValidationGroup="UserSave"></asp:RequiredFieldValidator>
        <br />
        <hr style="width:1" />
        <asp:Label SkinID="DataLabel" ID="LabelforTextBoxTelephone" runat="server" AssociatedControlID="TextBoxTelephone">Telephone:</asp:Label>
                            
        <br />
        <asp:TextBox ID="TextBoxTelephone" runat="server" MaxLength="30" Text="" 
            Width="145px" />
        <asp:RequiredFieldValidator ID="RequiredFieldValidatorTelephone" runat="server" ControlToValidate="TextBoxTelephone" ErrorMessage="Telephone is required" ValidationGroup="UserSave"></asp:RequiredFieldValidator>
        <br />
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelforTextBoxFax" runat="server" AssociatedControlID="TextBoxFax">Fax:</asp:Label>
                            
        <br />
        <asp:TextBox ID="TextBoxFax" runat="server" MaxLength="30" Text="" 
            Width="145px" />

        <div id="ListBoxState" runat="server">
            <br />
                <UC:UserControlListBoxState ID="UserControlListBoxState" runat="server" />
            <br />
        </div>

        <hr style="width:1" />
        <asp:Label ID="LabelCreatedByCaption" SkinID="DataLabel" runat="server" AssociatedControlID="LabelCreatedBy">Created By:</asp:Label>
        <asp:Label ID="LabelCreatedBy" SkinID="DataLabel" runat="server" Text=""></asp:Label>
        <asp:Label ID="LabelCreatedOnCaption" SkinID="DataLabel" runat="server" AssociatedControlID="LabelCreatedOn">&nbsp;&nbsp; Created On:</asp:Label>
        <asp:Label ID="LabelCreatedOn" SkinID="DataLabel" runat="server" Text=""></asp:Label>
        <br />
        <asp:Label ID="LabelUpdatedByCaption" SkinID="DataLabel" runat="server" AssociatedControlID="LabelUpdatedBy">Updated By:</asp:Label>
        <asp:Label ID="LabelUpdatedBy" SkinID="DataLabel" runat="server" Text=""></asp:Label>
        <asp:Label ID="LabelUpdatedOnCaption" SkinID="DataLabel" runat="server" AssociatedControlID="LabelUpdatedOn">&nbsp;&nbsp; Updated On:</asp:Label>
        <asp:Label ID="LabelUpdatedOn" SkinID="DataLabel" runat="server" Text=""></asp:Label>
        <br />
        <asp:Label ID="LabelLastLoginCaption" SkinID="DataLabel" runat="server" AssociatedControlID="LabelUpdatedBy">Last Login:</asp:Label>
        <asp:Label ID="LabelLastLogin" SkinID="DataLabel" runat="server" Text=""></asp:Label>
        <br />
        <asp:Label ID="LabelLastVistaLoginCaption" SkinID="DataLabel" runat="server" AssociatedControlID="LabelUpdatedOn">Last VistA Login:</asp:Label>
        <asp:Label ID="LabelLastVistaLogin" SkinID="DataLabel" runat="server" Text=""></asp:Label>
        <br />
        <asp:Label ID="LabelStatusCaption" SkinID="DataLabel" runat="server" AssociatedControlID="LabelUpdatedBy">Account Status:</asp:Label>
        <asp:Label ID="LabelStatus" SkinID="DataLabel" runat="server" Text=""></asp:Label>
        <br />
        <asp:HiddenField ID="HiddenFieldUserID" runat="server" />
        <asp:HiddenField ID="HiddenFieldInsertingNewUser" runat="server" />
        <asp:HiddenField ID="HiddenFieldSelectedUsername" runat="server" />
        <asp:HiddenField ID="HiddenFieldBreadCrumbBaseText" runat="server" />
        <br />
        <asp:ValidationSummary ID="ValidationSummary1" runat="server" DisplayMode="List" Height="140px" ValidationGroup="UserSave" />
        <br />
        &nbsp;</asp:Panel>
    <br />
    <asp:Button ID="ButtonSave" runat="server" onclick="ButtonSave_Click" 
        Text="&nbsp;&nbsp;Save&nbsp;&nbsp;" ValidationGroup = "UserSave" />
    &nbsp;&nbsp;
    <asp:Button ID="ButtonClose" runat="server" onclick="ButtonClose_Click" 
        Text="&nbsp;&nbsp;Close &nbsp;&nbsp;" UseSubmitBehavior = "false" CssClass = "cancel" />
    &nbsp;&nbsp;
    <asp:Button ID="ButtonActivate" runat="server" onclick="ButtonActivate_Click" 
        Text="&nbsp;&nbsp;Activate &nbsp;&nbsp;" UseSubmitBehavior = "false" CssClass = "cancel" />
    &nbsp;&nbsp;
    <asp:Button ID="ButtonApprove" runat="server" onclick="ButtonApprove_Click" 
        Text="&nbsp;&nbsp;Approve &nbsp;&nbsp;" UseSubmitBehavior = "false" CssClass = "cancel" />
    <br />
</asp:Panel>
    <asp:Panel ID="PanelNoAccess" runat="server" Visible="false">
            You do not have access to the user id supplied.
            <br /><br />
            Please contact the Registry Manager to grant access or verify that your permissions are correct.
    </asp:Panel>
    <asp:Panel ID="PanelIdNotFound" runat="server" Visible="false">
            No record found for the user ID supplied.
            <br />
            <br />
            If you tried accessing using a link within an email or typed the link in the browser, please check the link to ensure you have supplied a correct id.
    </asp:Panel>      
</asp:Content>



