﻿using System;
using System.IO;
using System.Linq;
using System.Diagnostics;


namespace AHOBPR_PDF_Utility
{
    public class Logger
    {
        private string _logFileName = Directory.GetCurrentDirectory() + "\\" + "AHOBPR_PDF_Utility" + "_" + DateTime.Now.ToString("yyyyMMdd") + ".log";

        public void StartLog()
        {
            if (!File.Exists(_logFileName))
            {
                FileStream fs = File.Create(_logFileName);
                fs.Close();
            }
            LogMessageToFile("---------------------------------------------------------------------");
        }

        public void LogErrorMessage(Exception ex)
        {
            using (StreamWriter writer = File.AppendText("AHOBPR_PDF_Utility" + "_" + DateTime.Now.ToString("yyyyMMdd") + ".log"))
            {
                string message = string.Empty;
                StackTrace stack = new StackTrace(ex, true);

                writer.WriteLine("{0}: {1}", DateTime.Now.ToShortDateString() + " " + DateTime.Now.ToLongTimeString(), "EXCEPTION: " + ex.Message.Replace("\r\n", "\r\n                       "));
                foreach (StackFrame frame in stack.GetFrames())
                {
                    if (string.IsNullOrEmpty(frame.GetFileName()))
                    {
                        message = string.Format("METHOD: {0}", frame.GetMethod().ToString());
                    }
                    else
                    {
                        message = string.Format("FILE: {0}, LINE: {1}, METHOD: {2}",
                            frame.GetFileName(), frame.GetFileLineNumber().ToString(), frame.GetMethod().ToString());
                    }

                    writer.WriteLine("                       " + message);
                }
            }
        }

        public void LogMessageToFile(string message)
        {
            using (StreamWriter writer = File.AppendText("AHOBPR_PDF_Utility" + "_" + DateTime.Now.ToString("yyyyMMdd") + ".log"))
            {
                writer.WriteLine("{0}: {1}", DateTime.Now.ToShortDateString() + " " + DateTime.Now.ToLongTimeString(), message);
            }
        }


    }
}
