﻿using System;
using System.ServiceProcess;
using System.Configuration;
using System.Timers;

using NLog;


namespace BENSClientService
{
    public partial class Scheduler : ServiceBase
    {
        static Logger logger = LogManager.GetCurrentClassLogger();
        Timer timer;
        BensMQClient _client;
        BensMQProperties _props;
        public Scheduler()
        {
            logger.Debug("Constructing Scheduler");
            InitializeComponent();
            logger.Debug("Setting BensMQProperties");
            _props = new BensMQProperties(ConfigurationManager.AppSettings);
            logger.Debug("Initializing RestClient");
            var restClient = new RestfulClient(ConfigurationManager.AppSettings["RestServiceUrl"], ConfigurationManager.AppSettings["secretKey"]);
            logger.Debug($"Setting MQCHLLIB to {_props.MQCHLLIB}");            
            Environment.SetEnvironmentVariable("MQCHLLIB", _props.MQCHLLIB);
            logger.Debug($"Setting MQCHLTAB to {_props.MQCHLTAB}");
            Environment.SetEnvironmentVariable("MQCHLTAB", _props.MQCHLTAB);
            logger.Debug("Creating BensMQClient");
            _client =  new BensMQClient(_props, restClient);
            logger.Debug("Created.");
        }

        protected override void OnStart(string[] args)
        {         
            logger.Info("Starting Bens Client Service");
            try
            {
                ConfigureTimer(_props.ConnectionInterval);
                logger.Debug($"timer set");
                logger.Debug($"timer AutoReset set to: {timer.AutoReset}");
                logger.Debug($"timer will trigger to: {timer.Interval/1000} seconds");
                timer.Elapsed += OnTimedEvent;
                _client.ReceiveMessages();
            }
            catch(ArgumentNullException)
            {
                logger.Error("NullArguments padded to OnStart(). Possible that configuration file is missing.");
            }
        }

        public BensMQClient Client { get { return _client; } }
        protected override void OnStop()
        {
            logger.Info("Stopping Bens Client Service");
            timer.Enabled = false;
        }

        private void ConfigureTimer(int interval)
        {
            logger.Debug($"Configuring timer with {interval/1000} second interval");
            timer = new Timer();
            timer.Interval = interval;
            timer.Enabled = true;
            timer.AutoReset = true;
           
        }

        private void OnTimedEvent(object sender, ElapsedEventArgs e)
        {
            logger.Debug("Int OnTimedEvent: ");
            _client.ReceiveMessages();
        }
    }
}
