﻿using NLog;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;

namespace BENSClientService
{
    public class RestfulClient
    {
        string _url;
        string _secretKey;
        private static Logger logger = LogManager.GetCurrentClassLogger();
        public RestfulClient(string url, string secretKey)
        {
            _url = url;
            _secretKey = secretKey;
        }
        public bool AddEdipiToDatabase(string edipi)
        {
            var addedToDb = false;
            try
            {
                var fullUrl = _url + "/bensupdate/" + edipi;
                var request = WebRequest.Create(fullUrl);
                logger.Debug("REST service url: " + fullUrl);
                request.Method = "GET";
                request.ContentType = @"application/json; charset=utf-8";

                request.Headers.Add("Authorization", "Basic " + _secretKey);

                using (HttpWebResponse response = (HttpWebResponse)request.GetResponse())
                {
                    var jsonResponse = string.Empty;
                    using (StreamReader sr = new StreamReader(response.GetResponseStream()))
                    {
                        jsonResponse = sr.ReadToEnd();
                        logger.Debug("Response from REST service: " + jsonResponse);
                        addedToDb |= jsonResponse == @"{""AddEdipiForUpdateResult"":true}";
                    }
                }

            }
            catch (Exception ex)
            {
                logger.Error("Exception in web request -- ");
                logger.Error(nameof(ex) + ": " + ex.Message);
            }
            return addedToDb;
        }
    }
}
