﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Linq;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    [Serializable]
    public class AHOBPRShared : AHOBPRBaseBO 
    {
        public enum RegistrantStatus
        {
            NoConcent = 1,
            Concent = 2,
            NotEligible = 3,
            Review = 4,
            ReviewedNotEligible = 5,
            Eligible = 6,
            Participant = 7,
            ReviewEligible = 8
        }

        //Predefined Registry Flag Ids
        public enum PredefinedAdminFlag
        {
            ReviewToReviewEligible = 1,
            ReviewToReviewNotEligible = 2,
            NotEligibleToReviewEligible = 3,
            NotEligibleToReviewNotEligible = 4,
            ReviewNotEligibleToReviewEligible = 5,
            ReviewNotEligibleToReviewNotEligible = 6,
            ParticipantToReviewEligible = 7,
            ParticipantToReviewNotEligible = 8,
            NoConsentToReviewEligible = 9,
            NoConsentToReviewNotEligible = 10,
            ConsentToReviewEligible = 11,
            ConsentToReviewNotEligible = 12,
            EligibleToReviewEligible = 13,
            EligibleToReviewNotEligible = 14,
            ReviewHEC = 15,
            MoreDocumentationNeeded = 16,
            ReviewEligibleToReviewEligible = 17,
            ReviewEligibleToReviewNotEligible = 18
        }

        public enum DeploymentStage
        {
            New = 1,
            NotEligible = 2,
            Verified = 3,
            Refuted = 4,
            Accepted = 5,
            Rejected = 6
        }

        public enum HeathFactorCategory
        {
            ChiefComplaint = 1,
            ExposureConcerns = 2,
            Asthma = 3,
            SmokingDuringDeployment = 4,
            Tobacco = 5,
            BirthDefects = 6,
            Abnormalities = 7,
            Orders = 8
        }


        public static int GetRegistryID()
        {
            int id = 0;

            if (AHOBPRGlobal.AhobprRegistryId > 0)
            {
                id = AHOBPRGlobal.AhobprRegistryId;
            }
            else
            {
                using (_dbRegistry = GetRegistryDataContext())
                {
                    AHOBPRGlobal.AhobprRegistryId = (from e in _dbRegistry.STD_REGISTRies
                                                     where e.CODE == AHOBPRGlobal.AhobprRegistryCode
                                                     select e.ID).FirstOrDefault();
                    id = AHOBPRGlobal.AhobprRegistryId;
                }
            }

            return id;
        }

        public static int GetUserRoleId(string roleCode)
        {
            int id = 0;

            switch (roleCode)
            {
                case AHOBPRGlobal.AhobprUserRoleRegistryManagerCode:
                    if (AHOBPRGlobal.AhobprUserRoleRegistryManagerId > 0)
                    {
                        id = AHOBPRGlobal.AhobprUserRoleRegistryManagerId;
                    }
                    else
                    {
                        using (_dbRegistry = GetRegistryDataContext())
                        {
                            AHOBPRGlobal.AhobprUserRoleRegistryManagerId = (from e in _dbRegistry.STD_ROLEs
                                                                            where e.CODE == AHOBPRGlobal.AhobprUserRoleRegistryManagerCode
                                                                            select e.ID).FirstOrDefault();
                            id = AHOBPRGlobal.AhobprUserRoleRegistryManagerId;
                        }
                    }
                    break;
                case AHOBPRGlobal.AhobprUserRoleAdvancedUserCode:
                    if (AHOBPRGlobal.AhobprUserRoleAdvancedUserId > 0)
                    {
                        id = AHOBPRGlobal.AhobprUserRoleAdvancedUserId;
                    }
                    else
                    {
                        using (_dbRegistry = GetRegistryDataContext())
                        {
                            AHOBPRGlobal.AhobprUserRoleAdvancedUserId = (from e in _dbRegistry.STD_ROLEs
                                                                            where e.CODE == AHOBPRGlobal.AhobprUserRoleAdvancedUserCode
                                                                            select e.ID).FirstOrDefault();
                            id = AHOBPRGlobal.AhobprUserRoleAdvancedUserId;
                        }
                    }
                    break;
                case AHOBPRGlobal.AhobprUserRoleCareTeamCode:
                    if (AHOBPRGlobal.AhobprUserRoleCareTeamId > 0)
                    {
                        id = AHOBPRGlobal.AhobprUserRoleCareTeamId;
                    }
                    else
                    {
                        using (_dbRegistry = GetRegistryDataContext())
                        {
                            AHOBPRGlobal.AhobprUserRoleCareTeamId = (from e in _dbRegistry.STD_ROLEs
                                                                     where e.CODE == AHOBPRGlobal.AhobprUserRoleCareTeamCode
                                                                     select e.ID).FirstOrDefault();
                            id = AHOBPRGlobal.AhobprUserRoleCareTeamId;
                        }
                    }
                    break;
                case AHOBPRGlobal.AhobprUserRoleHelpDeskCode:
                    if (AHOBPRGlobal.AhobprUserRoleHelpDeskId > 0)
                    {
                        id = AHOBPRGlobal.AhobprUserRoleHelpDeskId;
                    }
                    else
                    {
                        using (_dbRegistry = GetRegistryDataContext())
                        {
                            AHOBPRGlobal.AhobprUserRoleHelpDeskId = (from e in _dbRegistry.STD_ROLEs
                                                                     where e.CODE == AHOBPRGlobal.AhobprUserRoleHelpDeskCode
                                                                     select e.ID).FirstOrDefault();
                            id = AHOBPRGlobal.AhobprUserRoleHelpDeskId;
                        }
                    }
                    break;
            }

            return id;

        }


        public bool LogErrorMessage(string errorType, string errorSource, string errorMessage)
        {
            bool returnStatus = true;

            if (string.IsNullOrEmpty(errorType) || string.IsNullOrEmpty(errorSource) || string.IsNullOrEmpty(errorMessage))
            {
                return returnStatus;
            }

            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.DeferredLoadingEnabled = false;

                //check if registry flag exists
                ERROR_LOG  errorLog = new ERROR_LOG();
                errorLog.ERROR_TYPE = errorType;
                errorLog.ERROR_SOURCE = errorSource;
                errorLog.ERROR_MESSAGE = errorMessage;
                errorLog.COMPONENT_TYPE = "Staff Web Application";

                _dbAhopbr.ERROR_LOGs.InsertOnSubmit(errorLog);

                try
                {
                    _dbAhopbr.SubmitChanges(ConflictMode.ContinueOnConflict);

                    returnStatus =true;
                }
                catch (System.Data.SqlClient.SqlException e)
                {
                    returnStatus = false;
                }
                catch (ChangeConflictException e)
                {
                    _dbAhopbr.ChangeConflicts.ResolveAll(RefreshMode.KeepCurrentValues);

                    try
                    {
                        _dbAhopbr.SubmitChanges(ConflictMode.FailOnFirstConflict);

                        returnStatus = true;
                    }
                    catch
                    {
                        returnStatus = false;
                    }
                }
                catch
                {
                    returnStatus = false;
                }

           }

            return returnStatus;
        }

        public string GetFacilityDescription(int institutionId)
        {
            string result = string.Empty;
            using (_dbAhopbr = GetDataContext())
            {
              result = (from f in _dbAhopbr.viewFacilitiesByVisns
                         where f.institution_id == institutionId
                          select f.Name).FirstOrDefault();
            }

            return result;
        }

        /// <summary>
        /// Get the closest facility description
        /// </summary>
        /// <param name="registrantId"></param>
        /// <returns></returns>
        public string GetClosestFacilityDescription(int registrantId)
        {
            string facilityDescription = string.Empty;
            int facilityId = 0;

            using (_dbAhopbr = GetDataContext())
            {
                VIEW_REGISTRANT_CLOSEST_FACILITY result = (from f in _dbAhopbr.VIEW_REGISTRANT_CLOSEST_FACILITies
                                  where f.REGISTRANT_ID == registrantId
                                  select f).FirstOrDefault();
                facilityId = result == null ? 0 : result.STD_INSTITUTION_ID;
            }

           if (facilityId > 0)
           {
               facilityDescription = GetFacilityDescription(facilityId);
           }

           return facilityDescription;
        }
    }
}
