﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Linq;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using System.Reflection;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;




namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public enum QuestionnaireDisplayType
    {
        Summary = 1,
        Full = 2,
        Section = 3
    }

    public class AHOBPRQuestionnaireManager : AHOBPRBaseBO 
    {
        private AHOBPRShared _sharedManager = new AHOBPRShared();
        private AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();
        
        private int _totalFollowupQuestions = 0;
        
        #region Methods for SelectFormById

        /// <summary>
        /// 
        /// </summary>
        /// <param name="registrantId"></param>
        /// <returns></returns>
        public STD_FORM GetFormByRegistrantId(int registrantId)
        {
            bool refresh = false;

            if (AHOBPRGlobal.FormLookup == null)
            {
                refresh = true;
            }
            else if (AHOBPRGlobal.FormLookup.RegistrantId != registrantId)
            {
                refresh = true;
            }

            if (refresh && registrantId > 0)
            {
                using (_dbAhopbr = GetDataContext())
                {
                    SetLoadWithForStdForm(_dbAhopbr);

                    AHOBPRGlobal.FormLookup = (from e in _dbAhopbr.FORM_RESPONSEs
                                               where e.REGISTRANT_ID == registrantId
                                               select e.STD_FORM).FirstOrDefault();

                }
            }

            return AHOBPRGlobal.FormLookup;
        }

        /// <summary>
        /// Check if a registrant has followup questions
        /// </summary>
        /// <param name="registrantId"></param>
        /// <returns></returns>
        public bool HasFollowUpQuestions(int registrantId)
        {
            bool result = false;

            if ( registrantId > 0)
            {
                using (_dbAhopbr = GetDataContext())
                {
                    int count = (from e in _dbAhopbr.FOLLOWUP_FORM_RESPONSEs
                                 where e.REGISTRANT_ID == registrantId
                                 select e.STD_FORM_ID).Count();
                    result = (count > 0);
                }
            }

            return result;
        }

        public string GetQuestionnaireVersion(int registrantId)
        {
            string version = string.Empty;
            STD_FORM form = GetFormByRegistrantId(registrantId);
            if (form != null)
            {
                version = form.VERSION;
            }
            return version;
        }


        /// <summary>
        /// 
        /// </summary>
        /// <param name="registrantId"></param>
        /// <param name="sectionId"></param>
        /// <param name="subSectionId"></param>
        /// <returns></returns>
        public string GetSectionAndSubSectionDescription(int registrantId, int sectionId, int subSectionId)
        {
            string description = string.Empty;

            STD_FORM form = GetFormByRegistrantId(registrantId);
            if (form != null && sectionId > 0 && subSectionId > 0)
            {
                STD_FORM_SECTION sectionObject = (from e in form.STD_FORM_SECTIONs
                                  where e.STD_FORM_SECTION_ID == sectionId
                                  select e).FirstOrDefault();

                string section = sectionObject == null? string.Empty :sectionObject.MENU_ITEM_NAME;
                string subSection = string.Empty;

                int subSectionCount = (from e in form.STD_FORM_SUB_SECTIONs
                                       where e.STD_FORM_SECTION_ID == sectionId
                                       select e).Count();
                if (subSectionCount > 1)
                {
                    STD_FORM_SUB_SECTION subSectionObject = (from e in form.STD_FORM_SUB_SECTIONs
                                                             where e.STD_FORM_SUB_SECTION_ID == subSectionId
                                                             select e).FirstOrDefault();
                    subSection = subSectionObject == null ? string.Empty : subSectionObject.MENU_ITEM_NAME;
                }
                description = string.IsNullOrEmpty(subSection) ? section : section + " > " + subSection;
            }

            return description;
        }


        /// <summary>
        /// 
        /// </summary>
        /// <param name="registrantId"></param>
        /// <param name="sectionId"></param>
        /// <param name="subSectionId"></param>
        /// <returns></returns>
        public string GetSectionAndSubSectionBprId(int registrantId, int sectionId, int subSectionId)
        {
            string id = string.Empty;

            STD_FORM form = GetFormByRegistrantId(registrantId);
            if (form != null && sectionId > 0 && subSectionId > 0)
            {
                STD_FORM_SECTION sectionObject = (from e in form.STD_FORM_SECTIONs
                                                  where e.STD_FORM_SECTION_ID == sectionId
                                                  select e).FirstOrDefault();

                string sectionBprId = sectionObject == null ? string.Empty : sectionObject.BRP_FORM_SECTION_ID.ToString();
                string subSectionBprId = string.Empty;

                int subSectionCount = (from e in form.STD_FORM_SUB_SECTIONs
                                       where e.STD_FORM_SECTION_ID == sectionId
                                       select e).Count();
                if (subSectionCount > 1)
                {
                    STD_FORM_SUB_SECTION subSectionObject = (from e in form.STD_FORM_SUB_SECTIONs
                                                             where e.STD_FORM_SUB_SECTION_ID == subSectionId
                                                             select e).FirstOrDefault();
                    subSectionBprId = subSectionObject == null ? string.Empty : subSectionObject.BRP_FORM_SUB_SECTION_ID.ToString();
                }
                id = string.IsNullOrEmpty(subSectionBprId) ? sectionBprId : sectionBprId + "." + subSectionBprId;
            }

            return id;
        }

        private void SetLoadWithForStdForm(AHOBPRDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            lo.LoadWith<STD_FORM>(e => e.STD_FORM_SECTIONs);
            lo.LoadWith<STD_FORM>(e => e.STD_FORM_SUB_SECTIONs);
            lo.LoadWith<STD_FORM_SECTION>(e => e.STD_FORM_SUB_SECTIONs);
            lo.LoadWith<STD_FORM_SUB_SECTION>(e => e.STD_FORM_QUESTIONs);
            lo.LoadWith<STD_FORM_QUESTION>(e => e.STD_FORM_ANSWERs);

            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;
        }

        #endregion

        #region Methods for SearchFormResponses
        public IEnumerable<FORM_RESPONSE_QUESTION> GetFormResponses(string registrantId, string displayType, string sectionId, string subSectionId, string sort, int startRow, int maxRows)
        {
            if (String.IsNullOrEmpty(sort))
                sort = "STD_FORM_QUESTION_ID";

            using (_dbAhopbr = GetDataContext())
            {
                SetLoadWithForFormResponses(_dbAhopbr);
                IEnumerable<FORM_RESPONSE_QUESTION> entities = GetFormResponsesLinqFilter(registrantId, displayType, sectionId, subSectionId).OrderBy(sort).Skip(startRow).Take(maxRows).ToList();

                return entities;
            }
        }

        public IEnumerable<FORM_RESPONSE_QUESTION> GetFormResponsesNoPaging(string registrantId, string displayType, string sectionId, string subSectionId, string sort)
        {
            if (String.IsNullOrEmpty(sort))
                sort = "STD_FORM_QUESTION_ID";

            using (_dbAhopbr = GetDataContext())
            {
                SetLoadWithForFormResponses(_dbAhopbr);
                IEnumerable<FORM_RESPONSE_QUESTION> entities = GetFormResponsesLinqFilter(registrantId, displayType, sectionId, subSectionId).OrderBy(sort).ToList();

                return entities;
            }
        }

        public int GetFormResponsesCount(string registrantId, string displayType, string sectionId, string subSectionId, string sort, int startRow, int maxRows)
        {
            int count = 0;
            using (_dbAhopbr = GetDataContext())
            {
                count = GetFormResponsesLinqFilter(registrantId, displayType, sectionId, subSectionId).Count();
            }
            return count;
        }

        public IEnumerable<FORM_RESPONSE_QUESTION> GetFormResponsesDeploymentExposure(string registrantId, string deploymentId, string sectionId, string subSectionId, string sort)
        {
            if (String.IsNullOrEmpty(sort))
                sort = "STD_FORM_QUESTION_ID";

            using (_dbAhopbr = GetDataContext())
            {
                SetLoadWithForFormResponses(_dbAhopbr);
                IEnumerable<FORM_RESPONSE_QUESTION> entities = GetFormResponsesDeploymentExposureLinqFilter(registrantId, deploymentId, sectionId, subSectionId).OrderBy(sort).ToList();

                return entities;
            }
        }

        private IQueryable<FORM_RESPONSE_QUESTION> GetFormResponsesDeploymentExposureLinqFilter(string registrantId, string deploymentId, string sectionId, string subSectionId)
        {
            IQueryable<FORM_RESPONSE_QUESTION> linqFilter = null;
            if (string.IsNullOrEmpty(registrantId))
            {
                linqFilter = from q in _dbAhopbr.FORM_RESPONSE_QUESTIONs
                             where q.FORM_RESPONSE_QUESTION_ID == 0
                             select q;
            }
            else
            {
                linqFilter = from q in _dbAhopbr.FORM_RESPONSE_QUESTIONs
                             where q.FORM_RESPONSE.REGISTRANT_ID == Convert.ToInt32(registrantId)
                                && q.STD_FORM_QUESTION.STD_FORM_SECTION_ID == Convert.ToInt32(sectionId)
                                && q.STD_FORM_QUESTION.STD_FORM_SUB_SECTION_ID == Convert.ToInt32(subSectionId)
                                && q.REGISTRANT_DEPLOYMENT_ID == Convert.ToInt32(deploymentId)
                             select q;
            }
            return linqFilter;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="registrantId"></param>
        /// <param name="formId"></param>
        /// <param name="sort"></param>
        /// <returns></returns>
        public IEnumerable<FOLLOWUP_FORM_RESPONSE_QUESTION> GetFormResponsesFollowup(string registrantId, string formId, string sort)
        {
            if (String.IsNullOrEmpty(sort))
                sort = "STD_FORM_QUESTION_ID";

            using (_dbAhopbr = GetDataContext())
            {
                SetLoadWithForFormResponsesFollowup(_dbAhopbr);
                IEnumerable<FOLLOWUP_FORM_RESPONSE_QUESTION> entities = GetFormResponsesFollowupLinqFilter(registrantId, formId).OrderBy(sort).ToList();

                return entities;
            }
        }

        private void SetLoadWithForFormResponsesFollowup(AHOBPRDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            lo.LoadWith<FOLLOWUP_FORM_RESPONSE_QUESTION>(e => e.FOLLOWUP_FORM_RESPONSE_ANSWERs);
            lo.LoadWith<FOLLOWUP_FORM_RESPONSE_QUESTION>(e => e.STD_FORM_QUESTION);
            lo.LoadWith<FOLLOWUP_FORM_RESPONSE_ANSWER>(e => e.STD_FORM_ANSWER);

            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }


        private IQueryable<FOLLOWUP_FORM_RESPONSE_QUESTION> GetFormResponsesFollowupLinqFilter(string registrantId, string formId)
        {
            IQueryable<FOLLOWUP_FORM_RESPONSE_QUESTION> linqFilter = null;
            if (string.IsNullOrEmpty(registrantId))
            {
                linqFilter = from q in _dbAhopbr.FOLLOWUP_FORM_RESPONSE_QUESTIONs
                             where q.FOLLOWUP_FORM_RESPONSE_QUESTION_ID == 0
                             select q;
            }
            else
            {
                linqFilter = from q in _dbAhopbr.FOLLOWUP_FORM_RESPONSE_QUESTIONs
                             where q.FOLLOWUP_FORM_RESPONSE.REGISTRANT_ID == Convert.ToInt32(registrantId)
                                && q.STD_FORM_QUESTION.STD_FORM.STD_FORM_ID  == Convert.ToInt32(formId)
                             select q;
            }
            return linqFilter;
        }

        public List<DeploymentExposure> GetDeploymentExposureList(string registrantId, string sectionId, string subSectionId)
        {
            List<DeploymentExposure> deploymentExposureList = new List<DeploymentExposure>();

            using (_dbAhopbr = GetDataContext())
            {
                List<int?> deploymentIds = (from e in _dbAhopbr.FORM_RESPONSE_QUESTIONs
                                           where e.FORM_RESPONSE.REGISTRANT_ID == Convert.ToInt32(registrantId)
                                                 && e.REGISTRANT_DEPLOYMENT_ID != null
                                           select e.REGISTRANT_DEPLOYMENT_ID).Distinct().ToList();
                foreach (int deploymentId in deploymentIds)
                {
                    DeploymentExposure exposure = new DeploymentExposure();
                    exposure.DeploymentId = deploymentId;
                    exposure.RegistrantId = Convert.ToInt32(registrantId);
                    exposure.SectionId = Convert.ToInt32(sectionId);
                    exposure.SubsectionId = Convert.ToInt32(subSectionId);

                    deploymentExposureList.Add(exposure);
                }

            }

            return deploymentExposureList;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="registrantId"></param>
        /// <returns></returns>
        public List<FOLLOWUP_FORM_RESPONSE> GetFollowupFormResponseList(string registrantId)
        {
            List<FOLLOWUP_FORM_RESPONSE> followupFormResponseList = new List<FOLLOWUP_FORM_RESPONSE>();

            using (_dbAhopbr = GetDataContext())
            {
                followupFormResponseList = (from e in _dbAhopbr.FOLLOWUP_FORM_RESPONSEs
                                           where e.REGISTRANT_ID == Convert.ToInt32(registrantId)
                                           select e).ToList();
            }

            return followupFormResponseList;
        }
        private IQueryable<FORM_RESPONSE_QUESTION> GetFormResponsesLinqFilter(string registrantId, string displayType, string sectionId, string subSectionId)
        {
            IQueryable<FORM_RESPONSE_QUESTION> linqFilter = null;
            if (string.IsNullOrEmpty(registrantId))
            {
                linqFilter = from q in _dbAhopbr.FORM_RESPONSE_QUESTIONs
                             where q.FORM_RESPONSE_QUESTION_ID == 0
                             select q;
            }
            else
            {
                linqFilter = from q in _dbAhopbr.FORM_RESPONSE_QUESTIONs
                             where q.FORM_RESPONSE.REGISTRANT_ID == Convert.ToInt32(registrantId)
                             select q;

                if (displayType == "Summary")
                {
                    linqFilter = linqFilter.Where(q => q.FORM_RESPONSE_ANSWERs.Any(s => s.STD_FORM_ANSWER.CLINICAL_RELEVANT_FLAG == true));
                }
                else if (displayType == "Section")
                {
                    linqFilter = linqFilter.Where(q => q.STD_FORM_QUESTION.STD_FORM_SECTION_ID == Convert.ToInt32(sectionId)
                                                        && q.STD_FORM_QUESTION.STD_FORM_SUB_SECTION_ID == Convert.ToInt32(subSectionId));
                }
            }
            return linqFilter;
        }

       private void SetLoadWithForFormResponses(AHOBPRDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            lo.LoadWith<FORM_RESPONSE_QUESTION>(e => e.FORM_RESPONSE_ANSWERs);
            lo.LoadWith<FORM_RESPONSE_QUESTION>(e => e.STD_FORM_QUESTION);
            lo.LoadWith<FORM_RESPONSE_ANSWER>(e => e.STD_FORM_ANSWER);
            lo.LoadWith<STD_FORM_QUESTION>(e => e.STD_FORM_SECTION);
            lo.LoadWith<STD_FORM_QUESTION>(e => e.STD_FORM_SUB_SECTION);

            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="registrantId"></param>
        /// <returns></returns>
        public IList<SP_ReportClinicallyRevelantSummaryResult> GetClinicallyRelevantSummary(int registrantId)
        {

           IQueryable<SP_ReportClinicallyRevelantSummaryResult> mainQueryGridView;
           
           using (AHOBPRLinqDataContext _dbAhopbr = GetDataContext())
           {
               _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;

               //call stored procedure
               var results = _dbAhopbr.SP_ReportClinicallyRevelantSummary(registrantId).ToList();

               mainQueryGridView = results.AsQueryable();
           }


           return (mainQueryGridView).OrderBy("QuestionNumber").ToList<SP_ReportClinicallyRevelantSummaryResult>();
        }

        #endregion

        #region Methods for Follow-up Questions

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public IList<SP_GetFailedtoSendQuestionsResult> GetFailedSendQuestions()
        {
            IList<SP_GetFailedtoSendQuestionsResult> followupQuestions = new List<SP_GetFailedtoSendQuestionsResult>();

            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;
                followupQuestions = _dbAhopbr.SP_GetFailedtoSendQuestions().ToList(); 
            }
            _totalFollowupQuestions = followupQuestions.Count();
            return followupQuestions;
        }

        public int GetFailedSendQuestionsCount()
        {
            return _totalFollowupQuestions;
        }

        /// <summary>
        /// Send Follow-up Questions to Registrants
        /// </summary>
        /// <param name="registrantIds"></param>
        /// <param name="followupFormId"></param>
        /// <returns></returns>
        public bool SendFollowupQuestionsToRegistrants(List<int> registrantIds, int followupFormId)
        {
            bool result = true;

            foreach (int registrantId in registrantIds)
            {
                int status = AddFollowupQuestionsToOneReigstrant(registrantId, followupFormId);
                if (status == -1)
                {
                    result = false;
                    break;
                }
            }

            return result;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="registrantId"></param>
        /// <param name="followupFormId"></param>
        /// <returns></returns>
        public int AddFollowupQuestionsToOneReigstrant(int registrantId, int followupFormId)
        {
            int returnStatus = 0;
            if (registrantId == 0 || followupFormId == 0)
            {
                return returnStatus;
            }

            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.DeferredLoadingEnabled = false;

                //check if registry flag exists
                FOLLOWUP_FORM_RESPONSE followupFormResponse = (from e in _dbAhopbr.FOLLOWUP_FORM_RESPONSEs
                                                  where e.REGISTRANT_ID  == registrantId && e.STD_FORM_ID == followupFormId
                                                  select e).FirstOrDefault();

                //insert if not exists
                if (followupFormResponse == null)
                {
                    followupFormResponse = new FOLLOWUP_FORM_RESPONSE();

                    followupFormResponse.REGISTRANT_ID = registrantId;
                    followupFormResponse.STD_FORM_ID = followupFormId;

                    _dbAhopbr.FOLLOWUP_FORM_RESPONSEs.InsertOnSubmit(followupFormResponse);

                    try
                    {
                        _dbAhopbr.SubmitChanges(ConflictMode.ContinueOnConflict);

                        returnStatus = 1;
                    }
                    catch (System.Data.SqlClient.SqlException ex)
                    {
                        _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                        returnStatus = -1;
                    }
                    catch (ChangeConflictException e)
                    {
                        _dbAhopbr.ChangeConflicts.ResolveAll(RefreshMode.KeepCurrentValues);

                        try
                        {
                            _dbAhopbr.SubmitChanges(ConflictMode.FailOnFirstConflict);

                            returnStatus = 1;
                        }
                        catch (Exception ex)
                        {
                            _sharedManager.LogErrorMessage("Database Update", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                            returnStatus = -1;
                        }
                    }
                    catch
                    {
                        returnStatus = 0;
                    }

                }
                // if the registry flag already exists, ignore and consider as success insert
                else
                {
                    returnStatus = 1;
                }
            }

            return returnStatus;

        }
        
        public int GetStdFormIdByName(string name)
        {
            int questionGroupId;
            using (_dbAhopbr = GetDataContext())

            {
                 questionGroupId = (from e in _dbAhopbr.STD_FORMs
                                       where e.NAME == name
                                       select e.STD_FORM_ID).FirstOrDefault();
            }

             return questionGroupId; 
        }

        #endregion

        /// <summary>
        /// 
        /// </summary>
        /// <param name="registrantId"></param>
        /// <returns></returns>
        public string GetQuestionnaireProgressNote(string RegistrantId)
        {
            string buildQuestionnaire = string.Empty;

            REGISTRANT registrant = _registrantManager.GetRegistrantById(Convert.ToInt32(RegistrantId));

            if (registrant == null)
            {
                return string.Empty;
            }
            else if (registrant.FORM_RESPONSEs.Count == 0)
            {
                return string.Empty;
            }
            else if (string.IsNullOrEmpty(registrant.QuestionnaireCompletionDateTime))
            {
                return string.Empty;
            }
            else
            {
                //Build header
                buildQuestionnaire = buildQuestionnaire = "The following Clinically Relevant Summary is a extract from the self-entered Airborne Hazards and Open Burn Pit Registry Questionnaire";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "          Open Burn Pit Registry";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Name:               " + registrant.Name;
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "SSN:                " + registrant.Snum;
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "EDIPI:              " + registrant.EDIPI;
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Service Status:     " + registrant.STD_SERVICE_STATUS.SERVICE_STATUS; 
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Registry Status:    " + registrant.STD_REGISTRANT_STATUS.REGISTRANT_STATUS;
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Date Started:       " + Convert.ToDateTime(registrant.QuestionnaireStartDateTime).ToString("dddd, MMMM dd, yyyy");
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Date Completed:     " + Convert.ToDateTime(registrant.QuestionnaireCompletionDateTime).ToString("dddd, MMMM dd, yyyy"); ;
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";

                //get Questionnarie Clinically Relevant Summary data
                string clinicallyRelevantSummary = GetProgressNoteClinicallyRelevantSummary(RegistrantId);
                
                buildQuestionnaire = buildQuestionnaire + clinicallyRelevantSummary;

                //replace html new-line <br /> with "," to separate the answers on questions with multiple answers.
                buildQuestionnaire = buildQuestionnaire.Replace("<br/>", ",");

                var questionnaire = new System.Security.SecureString();

                foreach (char c in buildQuestionnaire)
                    questionnaire.AppendChar(c);

                questionnaire.MakeReadOnly();

                return questionnaire.ToString();
                
            }           
        }

        public string GetProgressNoteClinicallyRelevantSummary(string RegistrantId)
        {

            string buildQuestionnaire = string.Empty;
            string timePeriod = string.Empty;

            //questions numbersbuildQuestionnaire = buildQuestionnaire + "|";
            List<string> qNumAirborneHazardsExposures = new List<string>() { "1.2.A", "1.2.F", "1.2.G" };
            List<string> qNumSmokeAndDustStorms = new List<string>() { "1.3.B", "1.4.C" };
            List<string> qNumSymptomsDuringDeployment = new List<string>() { "1.4.D", "1.4.E", "1.4.F" };
            List<string> qNumCurrentSymptoms = new List<string>() { "2.1.D", "2.1.E", "2.1.F" };
            List<string> qNumToldByDoctor = new List<string>() { "2.2.1.B", "2.2.1.C", "2.2.1.D", "2.2.1.E", "2.2.1.F", "2.2.1.G", "2.2.1.H" };
            List<string> qNumRespiratoryConditions = new List<string>() { "2.2.1.I", "2.2.1.J" };
            List<string> qNumShortnessOfBreath = new List<string>() { "2.2.1.M" };
            List<string> qNumCancer = new List<string>() { "2.4.A", "2.4.B" };
            List<string> qNumSmoking = new List<string>() { "2.5" };
            List<string> qNumHealthConcerns = new List<string>() { "3.A", "3.E", "3.F", "3.H", "3.J" };
            List<string> qNumNonMilitaryExposures = new List<string>() { "5.4.A", "5.4.B.4", "5.5.D" };

            var results = GetClinicallyRelevantSummary(Convert.ToInt32(RegistrantId));
            IQueryable<SP_ReportClinicallyRevelantSummaryResult> clinicallyRelevantQuery = results.AsQueryable();


            if (clinicallyRelevantQuery != null)
            {
                //Break out the answers to the clinically relevant questions 
                IQueryable<SP_ReportClinicallyRevelantSummaryResult> AirborneHazardsExposures = clinicallyRelevantQuery.Where(q => qNumAirborneHazardsExposures.Contains(q.QuestionNumber));
                if (AirborneHazardsExposures.Count() > 0)
                {
                    List<REGISTRANT_DEPLOYMENT> deploymentHistory = _registrantManager.SelectDistinctRegistrantDeploymentHistory(RegistrantId);


                    buildQuestionnaire = "AHOBPR Deployments with Responses";
                    buildQuestionnaire = buildQuestionnaire + "|";
                    buildQuestionnaire = buildQuestionnaire + "|";

                    if (deploymentHistory.Count() > 0)
                    {

                        foreach (REGISTRANT_DEPLOYMENT deployment in deploymentHistory)
                        {

                            //convert to two position date
                            if (!string.IsNullOrEmpty(deployment.TimePeriod))
                            {
                                string beginDeploy = deployment.TimePeriod.Substring(0, deployment.TimePeriod.LastIndexOf(("-"))).Trim();
                                string endDeploy = deployment.TimePeriod.Substring(deployment.TimePeriod.LastIndexOf(("-")) + 1).Trim();

                                timePeriod = Convert.ToDateTime(beginDeploy).ToString("MM/dd/yyyy") + " - " + Convert.ToDateTime(endDeploy).ToString("MM/dd/yyyy");
                            }

                            buildQuestionnaire = buildQuestionnaire + timePeriod;
                            buildQuestionnaire = buildQuestionnaire + "  " + deployment.DUTY_PROJECT_CODE;
                            buildQuestionnaire = buildQuestionnaire + "  " + deployment.DEPLOYMENT_COUNTRY;
                            buildQuestionnaire = buildQuestionnaire + "|";
                        }

                        buildQuestionnaire = buildQuestionnaire + "|";
                        buildQuestionnaire = buildQuestionnaire + "|";
                        buildQuestionnaire = buildQuestionnaire + "Exposures for Individual Deployments";
                        buildQuestionnaire = buildQuestionnaire + "|";
                        buildQuestionnaire = buildQuestionnaire + "|";

                        foreach (SP_ReportClinicallyRevelantSummaryResult e in AirborneHazardsExposures)
                        {
                            buildQuestionnaire = buildQuestionnaire + e.QuestionNumber;
                            buildQuestionnaire = buildQuestionnaire + "  " + e.QuestionText;
                            buildQuestionnaire = buildQuestionnaire + "|";
                            buildQuestionnaire = buildQuestionnaire + "       " + e.AnswerValues;
                            buildQuestionnaire = buildQuestionnaire + "|";
                        }
                    }
                    else
                    {
                        buildQuestionnaire = "       No positive responses for Exposures for Individual Deployments.";
                    }
                }


                //add "days in a month" to answer
                int number;
                IQueryable<SP_ReportClinicallyRevelantSummaryResult> SmokeDustStorms = (from list in clinicallyRelevantQuery
                                                                                        where (qNumSmokeAndDustStorms.Contains(list.QuestionNumber))
                                                                                        select new SP_ReportClinicallyRevelantSummaryResult
                                                                                        {
                                                                                            QuestionNumber = list.QuestionNumber,
                                                                                            QuestionText = list.QuestionText,
                                                                                            AnswerValues = int.TryParse(list.AnswerValues, out number) ? list.AnswerValues + " days in a month" : list.AnswerValues,
                                                                                            SectionAndSubSection = list.SectionAndSubSection,
                                                                                            SectionId = list.SectionId,
                                                                                            SubsectionId = list.SubsectionId,

                                                                                        });
                //Smoke and Dust Exposures
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Smoke and Dust Exposures";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";

                if (SmokeDustStorms.Count() > 0)
                {

                    foreach (SP_ReportClinicallyRevelantSummaryResult sd in SmokeDustStorms)
                    {
                        buildQuestionnaire = buildQuestionnaire + sd.QuestionNumber;
                        buildQuestionnaire = buildQuestionnaire + "  " + sd.QuestionText;
                        buildQuestionnaire = buildQuestionnaire + "|";
                        buildQuestionnaire = buildQuestionnaire + "       " + sd.AnswerValues;
                        buildQuestionnaire = buildQuestionnaire + "|";
                    }
                }
                else
                {
                    buildQuestionnaire = buildQuestionnaire + "       No positive responses for Smoke and Dust Storms.";
                }

                //add "days in a month" to answer
                IQueryable<SP_ReportClinicallyRevelantSummaryResult> SymptomsDuringDeployment = (from list in clinicallyRelevantQuery
                                                                                                 where (qNumSymptomsDuringDeployment.Contains(list.QuestionNumber))
                                                                                                 select new SP_ReportClinicallyRevelantSummaryResult
                                                                                                 {
                                                                                                     QuestionNumber = list.QuestionNumber,
                                                                                                     QuestionText = list.QuestionText,
                                                                                                     AnswerValues = int.TryParse(list.AnswerValues, out number) ? list.AnswerValues + " days in a month" : list.AnswerValues,
                                                                                                     SectionAndSubSection = list.SectionAndSubSection,
                                                                                                     SectionId = list.SectionId,
                                                                                                     SubsectionId = list.SubsectionId,
                                                                                                 });
                //Symptoms During Deployment 
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Symptoms During Deployment";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";

                if (SymptomsDuringDeployment.Count() > 0)
                {
                    foreach (SP_ReportClinicallyRevelantSummaryResult s in SymptomsDuringDeployment)
                    {
                        buildQuestionnaire = buildQuestionnaire + s.QuestionNumber;
                        buildQuestionnaire = buildQuestionnaire + "  " + s.QuestionText;
                        buildQuestionnaire = buildQuestionnaire + "|";
                        buildQuestionnaire = buildQuestionnaire + "       " + s.AnswerValues;
                        buildQuestionnaire = buildQuestionnaire + "|";
                    }
                }
                else
                {
                    buildQuestionnaire = buildQuestionnaire + "       No positive responses for Symptoms during Deployment.";
                }

                //Current Symptoms 
                IQueryable<SP_ReportClinicallyRevelantSummaryResult> CurrentSymptoms = clinicallyRelevantQuery.Where(q => qNumCurrentSymptoms.Contains(q.QuestionNumber));

                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Current Symptoms";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                if (CurrentSymptoms.Count() > 0)
                {
                    foreach (SP_ReportClinicallyRevelantSummaryResult cs in CurrentSymptoms)
                    {
                        buildQuestionnaire = buildQuestionnaire + cs.QuestionNumber;
                        buildQuestionnaire = buildQuestionnaire + "  " + cs.QuestionText;
                        buildQuestionnaire = buildQuestionnaire + "|";
                        buildQuestionnaire = buildQuestionnaire + "       " + cs.AnswerValues;
                        buildQuestionnaire = buildQuestionnaire + "|";
                    }
                }
                else
                {
                    buildQuestionnaire = buildQuestionnaire + "       No positive responses for Current Symptoms.";
                }

                //Have you been told by a Doctor? 
                IQueryable<SP_ReportClinicallyRevelantSummaryResult> BeenToldByDoctor = clinicallyRelevantQuery.Where(q => qNumToldByDoctor.Contains(q.QuestionNumber));

                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Have you been told by a Doctor?";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";

                if (BeenToldByDoctor.Count() > 0)
                {
                    foreach (SP_ReportClinicallyRevelantSummaryResult d in BeenToldByDoctor)
                    {
                        buildQuestionnaire = buildQuestionnaire + d.QuestionNumber;
                        buildQuestionnaire = buildQuestionnaire + "  " + d.QuestionText;
                        buildQuestionnaire = buildQuestionnaire + "|";
                        buildQuestionnaire = buildQuestionnaire + "       " + d.AnswerValues;
                        buildQuestionnaire = buildQuestionnaire + "|";
                    }
                }
                else
                {
                    buildQuestionnaire = buildQuestionnaire + "       No positive responses for Have you been told by a Doctor?";
                }

                //Relationship between Respiratory Conditions & Deployment
                IQueryable<SP_ReportClinicallyRevelantSummaryResult> RespiratoryConditions = clinicallyRelevantQuery.Where(q => qNumRespiratoryConditions.Contains(q.QuestionNumber));

                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Relationship between Respiratory Conditions & Deployment";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";

                if (RespiratoryConditions.Count() > 0)
                {
                    foreach (SP_ReportClinicallyRevelantSummaryResult rc in RespiratoryConditions)
                    {
                        buildQuestionnaire = buildQuestionnaire + rc.QuestionNumber;
                        buildQuestionnaire = buildQuestionnaire + "  " + rc.QuestionText;
                        buildQuestionnaire = buildQuestionnaire + "|";
                        buildQuestionnaire = buildQuestionnaire + "       " + rc.AnswerValues;
                        buildQuestionnaire = buildQuestionnaire + "|";
                    }
                }
                else
                {
                    buildQuestionnaire = buildQuestionnaire + "       No positive responses for Relationship between Respiratory Conditions & Deployment.";
                }

                //Shortness of Breath
                IQueryable<SP_ReportClinicallyRevelantSummaryResult> ShortnessOfBreath = clinicallyRelevantQuery.Where(q => qNumShortnessOfBreath.Contains(q.QuestionNumber));

                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Patient Reported Currently Experiencing Shortness of Breath";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";

                if (ShortnessOfBreath.Count() > 0)
                {
                    foreach (SP_ReportClinicallyRevelantSummaryResult sb in ShortnessOfBreath)
                    {
                        buildQuestionnaire = buildQuestionnaire + sb.QuestionNumber;
                        buildQuestionnaire = buildQuestionnaire + "  " + sb.QuestionText;
                        buildQuestionnaire = buildQuestionnaire + "|";
                        buildQuestionnaire = buildQuestionnaire + "         " + sb.AnswerValues;
                        buildQuestionnaire = buildQuestionnaire + "|";
                    }
                }
                else
                {
                    buildQuestionnaire = buildQuestionnaire + "         No positive responses for Patient Reported Currently Experiencing Shortness of Breath.";
                }

                //Cancer
                IQueryable<SP_ReportClinicallyRevelantSummaryResult> Cancer = clinicallyRelevantQuery.Where(q => qNumCancer.Contains(q.QuestionNumber));

                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Cancer";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";

                if (Cancer.Count() > 0)
                {
                    foreach (SP_ReportClinicallyRevelantSummaryResult c in Cancer)
                    {
                        buildQuestionnaire = buildQuestionnaire + c.QuestionNumber;
                        buildQuestionnaire = buildQuestionnaire + "  " + c.QuestionText;
                        buildQuestionnaire = buildQuestionnaire + "|";
                        buildQuestionnaire = buildQuestionnaire + "       " + c.AnswerValues;
                        buildQuestionnaire = buildQuestionnaire + "|";
                    }
                }
                else
                {
                    buildQuestionnaire = buildQuestionnaire + "       No positive responses for Cancer.";
                }

                //Smoking
                IQueryable<SP_ReportClinicallyRevelantSummaryResult> Smoking = clinicallyRelevantQuery.Where(q => qNumSmoking.Contains(q.QuestionNumber));

                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Smoking";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";

                if (Smoking.Count() > 0)
                {
                    foreach (SP_ReportClinicallyRevelantSummaryResult sm in Smoking)
                    {
                        buildQuestionnaire = buildQuestionnaire + sm.QuestionNumber;
                        buildQuestionnaire = buildQuestionnaire + "  " + sm.QuestionText;
                        buildQuestionnaire = buildQuestionnaire + "|";
                        buildQuestionnaire = buildQuestionnaire + "     " + sm.AnswerValues;
                        buildQuestionnaire = buildQuestionnaire + "|";
                    }
                }
                else
                {
                    buildQuestionnaire = buildQuestionnaire + "     No positive responses for Smoking.";
                }

                //HealthConcerns
                IQueryable<SP_ReportClinicallyRevelantSummaryResult> HealthConcerns = clinicallyRelevantQuery.Where(q => qNumHealthConcerns.Contains(q.QuestionNumber));

                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Current & Future Health Concerns Related to Deployment.";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";

                if (HealthConcerns.Count() > 0)
                {
                    foreach (SP_ReportClinicallyRevelantSummaryResult hc in HealthConcerns)
                    {
                        buildQuestionnaire = buildQuestionnaire + hc.QuestionNumber;
                        buildQuestionnaire = buildQuestionnaire + "  " + hc.QuestionText;
                        buildQuestionnaire = buildQuestionnaire + "|";
                        buildQuestionnaire = buildQuestionnaire + "     " + hc.AnswerValues;
                        buildQuestionnaire = buildQuestionnaire + "|";
                    }
                }
                else
                {
                    buildQuestionnaire = buildQuestionnaire + "     No positive responses for Current & Future Health Concerns Related to Deployment.";
                }

                //Non Military Exposures
                IQueryable<SP_ReportClinicallyRevelantSummaryResult> NonMilitaryExposures = clinicallyRelevantQuery.Where(q => qNumNonMilitaryExposures.Contains(q.QuestionNumber));

                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "Non-Military Exposures.";
                buildQuestionnaire = buildQuestionnaire + "|";
                buildQuestionnaire = buildQuestionnaire + "|";

                if (NonMilitaryExposures.Count() > 0)
                {

                    foreach (SP_ReportClinicallyRevelantSummaryResult nme in NonMilitaryExposures)
                    {
                        buildQuestionnaire = buildQuestionnaire + nme.QuestionNumber;
                        buildQuestionnaire = buildQuestionnaire + "  " + nme.QuestionText;
                        buildQuestionnaire = buildQuestionnaire + "|";
                        buildQuestionnaire = buildQuestionnaire + "       " + nme.AnswerValues;
                        buildQuestionnaire = buildQuestionnaire + "|";
                    }
                }
                else
                {
                    buildQuestionnaire = buildQuestionnaire + "       No positive responses for Non-Military Exposures.";
                }

            }
           

            return buildQuestionnaire;
        }
    }
}
