﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System.Data.SqlClient;
using System.Reflection;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class AHOBPRFileManager : AHOBPRBaseBO
    {
        private AHOBPRShared _sharedManager = new AHOBPRShared();

        #region Get File
        /// <summary>
        /// Get PDF file
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public byte[] GetFile(string fileId, string fileType)
        {
            byte[] fileContent = null;

            try
            {
                using (AHOBPRLinqDataContext db = GetDataContext())
                {
                    //call stored procedure
                    IList<SP_GetRegistrantFileResult> results = db.SP_GetRegistrantFile(fileType, fileId).ToList();
                    if (results != null)
                    {
                        if (results.Count > 0)
                        {
                            fileContent = (byte[])results.FirstOrDefault().FILE_CONTENT.ToArray();
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
            }

            return fileContent;
        }
        #endregion
    }
}
