﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using VeteransAffairs.Registries.Validation;

namespace VeteransAffairs.Registries.BusinessAHOBPR
{
    [Serializable()]
    public partial class REGISTRANT_DEPLOYMENT
    {
        public string TimePeriod
        {
            get
            {
                string period = string.Empty;

                if (DEPLOYMENT_START_DATE.HasValue && DEPLOYMENT_END_DATE.HasValue )
                {
                    period = Convert.ToDateTime(DEPLOYMENT_START_DATE).ToString("MM/dd/yyyy") + " - " + Convert.ToDateTime(DEPLOYMENT_END_DATE).ToString("MM/dd/yyyy");
                }

                return period;
            }
        }

        public string DeploymentStartDate
        {
            get
            {
                string startDate = string.Empty;

                if (DEPLOYMENT_START_DATE.HasValue)
                {
                    startDate = Convert.ToDateTime(DEPLOYMENT_START_DATE).ToShortDateString();
                }

                return startDate;
            }
        }

        public string DeploymentEndDate
        {
            get
            {
                string endDate = string.Empty;

                if (DEPLOYMENT_END_DATE.HasValue)
                {
                    endDate = Convert.ToDateTime(DEPLOYMENT_END_DATE).ToShortDateString();
                }

                return endDate;
            }
        }

        public string DataSource
        {
            get
            {
                return (bool) USER_ENTERED_FLAG ? "Self Reported" : "DoD";
            }
        }

        public string ExposureResponse
        {
            get
            {
                string hasExposureResponse = string.Empty;

                if (FORM_RESPONSE_QUESTIONs.Count > 0)
                {
                    hasExposureResponse = "Yes";
                }

                return hasExposureResponse;
            }
        }

        public string DeploymentStage
        {
            get
            {
                return STD_DEPLOYMENT_STAGE.DEPLOYMENT_STAGE;
            }
        }

        public string ServiceOccupation
        {
            get 
            {
                string occupation = string.Empty;

                if (STD_SERVICE_OCCUPATION != null)
                {
                    occupation = STD_SERVICE_OCCUPATION.SERVICE_TITLE;
                }
                return occupation;
            }
        }

        public string UnitComponent
        {
            get
            {
                string unitComponent = string.Empty;

                if (STD_COMPONENT != null)
                {
                    unitComponent = STD_COMPONENT.DESCRIPTION;
                }
                return unitComponent;
            }
        }

        public string DeploymentDescription
        {
            get
            {
                string description = DEPLOYMENT_COUNTRY + ": ";

                if (DEPLOYMENT_START_DATE.HasValue && DEPLOYMENT_END_DATE.HasValue)
                {
                    description = description + Convert.ToDateTime(DEPLOYMENT_START_DATE).ToString("MM/dd/yyyy")
                        + " to " + Convert.ToDateTime(DEPLOYMENT_END_DATE).ToString("MM/dd/yyyy");
                    
                }

                if (STD_BRANCH_OF_SERVICE != null)
                {
                    description = description + ", " + STD_BRANCH_OF_SERVICE.BRANCH_OF_SERVICE;
                }

                if (!string.IsNullOrEmpty(DUTY_PROJECT_CODE))
                {
                    description = description + ", " + DUTY_PROJECT_CODE;
                }

                if (USER_ENTERED_FLAG.HasValue)
                {
                    description = description + " (" + DataSource + ")";
                }

                return description;
            }
        }
        //used for Text Pdf on Progess Note
        public string DeploymentDescriptionForProgressNote
        {
            get
            {
                string description = DEPLOYMENT_COUNTRY + ": ";

                if (DEPLOYMENT_START_DATE.HasValue && DEPLOYMENT_END_DATE.HasValue)
                {
                    description = description + Convert.ToDateTime(DEPLOYMENT_START_DATE).ToString("MM/dd/yyyy")
                        + " to " + Convert.ToDateTime(DEPLOYMENT_END_DATE).ToString("MM/dd/yyyy");

                }

                if (STD_BRANCH_OF_SERVICE != null)
                {
                    description = description + ", " + STD_BRANCH_OF_SERVICE.BRANCH_OF_SERVICE;
                }

                if (!string.IsNullOrEmpty(DUTY_PROJECT_CODE))
                {
                    description = description + ", " + DUTY_PROJECT_CODE;
                }
                else
                {
                    description = description + ", " + "unknown";
                }

                if (IS_ELIGIBLE_FLAG == true)
                {
                    description = description + " -- BPR Eligible";
                }
                else
                {
                    description = description + " -- BPR Not Eligible";
                }

                if (IS_GULF_WAR_VETERAN_FLAG == true)
                {
                    description = description + ", GWVIS";
                }
                else
                {
                    description = description + ", Not GWVIS";
                }

                if (USER_VERIFIED_FLAG == true)
                {
                    description = description + ", Correct";
                }
                else
                {
                    description = description + ", Incorrect";
                }

                return description;
            }
        }

        //used for Text Pdf on Progess Note
        public string DeploymentDescriptionLocationSpecfic
        {
            get
            {
                string description = DEPLOYMENT_COUNTRY + ": ";

                if (DEPLOYMENT_START_DATE.HasValue && DEPLOYMENT_END_DATE.HasValue)
                {
                    description = description + Convert.ToDateTime(DEPLOYMENT_START_DATE).ToString("MM/dd/yyyy")
                        + " to " + Convert.ToDateTime(DEPLOYMENT_END_DATE).ToString("MM/dd/yyyy");

                }

                if (STD_BRANCH_OF_SERVICE != null)
                {
                    description = description + ", " + STD_BRANCH_OF_SERVICE.BRANCH_OF_SERVICE;
                }

                if (!string.IsNullOrEmpty(DUTY_PROJECT_CODE))
                {
                    description = description + ", " + DUTY_PROJECT_CODE;
                }
                else
                {
                    description = description + ", " + "unknown";
                }
                                
                return description;
            }
        }

    }
}
