﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using VeteransAffairs.Registries.Validation;

namespace VeteransAffairs.Registries.BusinessAHOBPR
{
    [Serializable()]
    public partial class REGISTRANT
    {
        public string Name
        {
            get
            {
                string name = string.Empty;

                string middleName = string.IsNullOrEmpty(MIDDLE_NAME) ? string.Empty : MIDDLE_NAME;
                name = LAST_NAME + ", " + FIRST_NAME + " " + middleName;

                return name;
            }
        }

        public string RegistryFlag
        {
            get
            {
                string flags = string.Empty;

                if (REGISTRANT_REGISTRY_FLAGs.Count > 0)
                {
                    foreach (REGISTRANT_REGISTRY_FLAG item in REGISTRANT_REGISTRY_FLAGs)
                    {
                        flags = string.IsNullOrEmpty(flags) ? item.STD_REGISTRY_FLAG.REGISTRY_FLAG_NAME : flags + ", " + item.STD_REGISTRY_FLAG.REGISTRY_FLAG_NAME;
                    }
                }

                return flags;
            }
        }

        public string QuestionnaireCompletionDateTime
        {
            get
            {
                string dateTime = string.Empty;

                if (FORM_RESPONSEs.Count > 0)
                {
                    if (FORM_RESPONSEs.FirstOrDefault().FORM_RESPONSE_STATUS.Count > 0)
                    {
                        dateTime = FORM_RESPONSEs.FirstOrDefault().FORM_RESPONSE_STATUS.FirstOrDefault().QUESTIONNAIRE_COMPLETED_DATE.ToString();
                    }
                }

                return dateTime;
            }
        }

        public string QuestionnaireStartDateTime
        {
            get
            {
                string dateTime = string.Empty;

                if (FORM_RESPONSEs.Count > 0)
                {
                    if (FORM_RESPONSEs.FirstOrDefault().FORM_RESPONSE_STATUS.Count > 0)
                    {
                        dateTime = FORM_RESPONSEs.FirstOrDefault().FORM_RESPONSE_STATUS.FirstOrDefault().QUESTIONNAIRE_STARTED_DATE.ToString();
                    }
                }

                return dateTime;
            }
        }

        public string ReportsHealthConcerns
        {
            get
            {
                return HEALTH_CONCERNS_RESPONSE;
            }
        }

        public string Email
        {
            get
            {
                string email = string.Empty;

                if (REGISTRANT_CONTACT_INFO != null)
                {
                    if (REGISTRANT_CONTACT_INFO.REGISTRANT_EMAILs.Count > 0)
                    {
                        foreach (REGISTRANT_EMAIL emailInfo in REGISTRANT_CONTACT_INFO.REGISTRANT_EMAILs)
                        {
                            if (!string.IsNullOrEmpty(email))
                            {
                                email = email + "; ";
                            }
                            email = string.IsNullOrEmpty(emailInfo.EMAIL) ? string.Empty : email + emailInfo.EMAIL;
                            if (!string.IsNullOrEmpty(emailInfo.TYPE))
                            {
                                email = email + " (" + emailInfo.TYPE + ")";
                            }
                        }
                    }
                }

                return email;
            }
        }

        public string Phone
        {
            get
            {
                string phone = string.Empty;

                if (this.REGISTRANT_CONTACT_INFO != null)
                {
                     if (REGISTRANT_CONTACT_INFO.REGISTRANT_PHONEs.Count > 0)
                    {
                        foreach (REGISTRANT_PHONE phoneInfo in REGISTRANT_CONTACT_INFO.REGISTRANT_PHONEs)
                        {
                            if (!string.IsNullOrEmpty(phone))
                            {
                                phone = phone + "; ";
                            }
                            phone = string.IsNullOrEmpty(phoneInfo.PHONE_NUMBER) ? string.Empty : phone + phoneInfo.PHONE_NUMBER;
                            if (!string.IsNullOrEmpty(phoneInfo.TYPE))
                            {
                                phone = phone + " (" + phoneInfo.TYPE + ")";
                            }
                        }
                    }
                }

                return phone;
            }
        }

        public string Address
        {
            get
            {
                string address = string.Empty;

                if (this.REGISTRANT_CONTACT_INFO != null)
                {
                    if (REGISTRANT_CONTACT_INFO.REGISTRANT_ADDRESSes.Count > 0)
                    {
                        REGISTRANT_ADDRESS addressObject = REGISTRANT_CONTACT_INFO.REGISTRANT_ADDRESSes.Last();

                        if (!string.IsNullOrEmpty(addressObject.STREET1))
                        {
                            address = addressObject.STREET1;
                        }
                        if (!string.IsNullOrEmpty(addressObject.STREET2))
                        {
                            address = string.IsNullOrEmpty(address) ? addressObject.STREET2 : address + ", " + addressObject.STREET2;
                        }
                        if (!string.IsNullOrEmpty(addressObject.CITY))
                        {
                            address = string.IsNullOrEmpty(address) ? addressObject.CITY : address + ", " + addressObject.CITY;
                        }
                        if (!string.IsNullOrEmpty(addressObject.STATE))
                        {
                            address = string.IsNullOrEmpty(address) ? addressObject.STATE : address + ", " + addressObject.STATE;
                        }
                        if (!string.IsNullOrEmpty(addressObject.ZIP))
                        {
                            address = string.IsNullOrEmpty(address) ? addressObject.ZIP : address + " " + addressObject.ZIP;
                        }

                    }
                }

                return address;
            }
        }
 
        public string RequestToBeSeen
        {
            get
            {
                return REQUEST_SEEN_RESPONSE;
            }
        }

        public string Last4Ssn
        {
            get
            {
                return string.IsNullOrEmpty(Snum) ? string.Empty : Snum.Length > 4 ? Snum.Substring(Snum.Length - 4) : string.Empty; ;
            }
        }

        public string Dob
        {
            get
            {
                return BIRTH_DATE.HasValue ? Convert.ToDateTime(BIRTH_DATE).ToShortDateString() : string.Empty; ;
            }
        }


        public string LastAdminFlag
        {
            get
            {
                string adminFlag = string.Empty;

                if (REGISTRANT_REGISTRY_FLAGs.Count > 0)
                {
                    REGISTRANT_REGISTRY_FLAG registrantFlag = (from e in REGISTRANT_REGISTRY_FLAGs
                                                               where e.STD_REGISTRY_FLAG.STD_REGISTRY_FLAG_TYPE_ID == 1
                                                               select e).LastOrDefault();
                    if (registrantFlag != null)
                    {
                        adminFlag = registrantFlag.STD_REGISTRY_FLAG.REGISTRY_FLAG_NAME + " (" + registrantFlag.CREATED + ")";
                    }
                }

                return adminFlag;
            }
        }

        public string SubpopulationFlags
        {
            get
            {
                string subpopulationFlags = string.Empty;

                if (REGISTRANT_REGISTRY_FLAGs.Count > 0)
                {
                    List<REGISTRANT_REGISTRY_FLAG> flags = (from e in REGISTRANT_REGISTRY_FLAGs
                                                               where e.STD_REGISTRY_FLAG.STD_REGISTRY_FLAG_TYPE_ID == 2
                                                               select e).ToList();

                    foreach (REGISTRANT_REGISTRY_FLAG flag in flags)
                    {
                        subpopulationFlags = string.IsNullOrEmpty(subpopulationFlags) ? subpopulationFlags : subpopulationFlags + ", ";
                        subpopulationFlags = subpopulationFlags + flag.STD_REGISTRY_FLAG.REGISTRY_FLAG_NAME;
                    }
                }

                return subpopulationFlags;
            }
        }

        public string PhoneNotMobile
        {
            get
            {
                string phone = string.Empty;

                if (this.REGISTRANT_CONTACT_INFO != null)
                {
                    if (REGISTRANT_CONTACT_INFO.REGISTRANT_PHONEs.Count > 0)
                    {
                        foreach (REGISTRANT_PHONE phoneInfo in REGISTRANT_CONTACT_INFO.REGISTRANT_PHONEs)
                        {
                            if (phoneInfo.TYPE != "Mobile")
                            {
                                if (!string.IsNullOrEmpty(phone))
                                {
                                    phone = phone + "; ";
                                }
                                phone = string.IsNullOrEmpty(phoneInfo.PHONE_NUMBER) ? string.Empty : phone + phoneInfo.PHONE_NUMBER;
                                
                            }
                        }
                    }
                }

                return phone;
            }
        }

        public string MobilePhone
        {
            get
            {
                string phone = string.Empty;

                if (this.REGISTRANT_CONTACT_INFO != null)
                {
                    if (REGISTRANT_CONTACT_INFO.REGISTRANT_PHONEs.Count > 0)
                    {
                        foreach (REGISTRANT_PHONE phoneInfo in REGISTRANT_CONTACT_INFO.REGISTRANT_PHONEs)
                        {
                            if (phoneInfo.TYPE == "Mobile")
                            {
                                if (!string.IsNullOrEmpty(phone))
                                {
                                    phone = phone + "; ";
                                }
                                phone = string.IsNullOrEmpty(phoneInfo.PHONE_NUMBER) ? string.Empty : phone + phoneInfo.PHONE_NUMBER;
                                //if (!string.IsNullOrEmpty(phoneInfo.TYPE))
                                //{
                                //    phone = phone + " (" + phoneInfo.TYPE + ")";
                                //}
                            }
                        }
                    }
                }

                return phone;
            }
        }

    }
}

