﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using VeteransAffairs.Registries.Validation;

namespace VeteransAffairs.Registries.BusinessAHOBPR
{
    [Serializable()]
    public partial class FORM_RESPONSE_QUESTION
    {
         public string Answers
        {
            get
            {
                string answers = string.Empty;

                if (this.FORM_RESPONSE_ANSWERs.Count > 0)
                {
                    foreach (FORM_RESPONSE_ANSWER answer in this.FORM_RESPONSE_ANSWERs)
                    {
                        if (!string.IsNullOrEmpty(answers))
                        {
                            answers = answers + "<br />";
                        }
                        answers = string.IsNullOrEmpty(answer.STD_FORM_ANSWER_ID.ToString()) ? answers : answers + answer.STD_FORM_ANSWER.TEXT;
                        answers = string.IsNullOrEmpty(answer.ANSWER_VALUE) ? answers : answers + answer.ANSWER_VALUE;
                    }
                }

                return answers;
            }
        }

         public string SectionAndSubsection
         {
             get
             {
                 string sectionId = string.Empty;
                 string subSectionId = string.Empty;
                 string section = string.Empty;
                 string subSection = string.Empty;

                 if (this.STD_FORM_QUESTION != null)
                 {
                     sectionId = STD_FORM_QUESTION.STD_FORM_SECTION.BRP_FORM_SECTION_ID.ToString();
                     section = STD_FORM_QUESTION.STD_FORM_SECTION.MENU_ITEM_NAME;
                     subSectionId = STD_FORM_QUESTION.STD_FORM_SUB_SECTION.BRP_FORM_SUB_SECTION_ID.ToString();
                     subSection = STD_FORM_QUESTION.STD_FORM_SUB_SECTION.MENU_ITEM_NAME;
                 }

                 return string.IsNullOrEmpty(subSection) ? sectionId + " " + section : sectionId + "." + subSectionId + " " + section + " > " + subSection;
             }
         }
         public int SectionId
         {
             get
             {
                 int sectionId = 0;

                 if (this.STD_FORM_QUESTION != null)
                 {
                     sectionId = STD_FORM_QUESTION.STD_FORM_SECTION_ID;
                 }

                 return sectionId;
             }
         }


         public int SubSectionId
         {
             get
             {
                 int subsectionId = 0;

                 if (this.STD_FORM_QUESTION != null)
                 {
                     subsectionId = STD_FORM_QUESTION.STD_FORM_SUB_SECTION_ID;
                 }

                 return subsectionId;
             }
         }

         public string StdFormQuestionUniqueId
         {
             get
             {
                 string FormQuestionUniqueId = string.Empty;

                 if (this.STD_FORM_QUESTION != null)
                 {
                     //Change questionId "4.1.ZZ" For Places you Have Lived to 4.1
                         if (STD_FORM_QUESTION.FORM_QUESTION_UNIQUE_ID == "4.1.ZZ")
                         {
                             FormQuestionUniqueId = "4.1";
                         }
                         else
                         {
                             FormQuestionUniqueId = STD_FORM_QUESTION.FORM_QUESTION_UNIQUE_ID;
                         }
                    
                 }

                 return FormQuestionUniqueId;
             }
         }
         //used for Text Pdf on TIU Note
         public string SectionDescription
         {
             get
             {
                 string sectionId = string.Empty;
                 string section = string.Empty;
                

                 if (this.STD_FORM_QUESTION != null)
                 {
                     sectionId = STD_FORM_QUESTION.STD_FORM_SECTION.BRP_FORM_SECTION_ID.ToString();
                     section = STD_FORM_QUESTION.STD_FORM_SECTION.TITLE;
                     
                 }

                 return sectionId + ". " + section;
             }
         }
         //used for Text Pdf on TIU Note
         public string SubSectionDescription
         {
             get
             {
                 string sectionId = string.Empty;
                 string subSectionId = string.Empty;
                 string section = string.Empty;
                 string subSection = string.Empty;

                 if (this.STD_FORM_QUESTION != null)
                 {
                     sectionId = STD_FORM_QUESTION.STD_FORM_SECTION.BRP_FORM_SECTION_ID.ToString();
                     //section = STD_FORM_QUESTION.STD_FORM_SECTION.TITLE;
                     subSectionId = STD_FORM_QUESTION.STD_FORM_SUB_SECTION.BRP_FORM_SUB_SECTION_ID.ToString();
                     subSection = STD_FORM_QUESTION.STD_FORM_SUB_SECTION.TITLE;
                 }

                 return string.IsNullOrEmpty(subSection) ? sectionId + " " + section : "   " + sectionId + "." + subSectionId + ". " + subSection;
             }
         }
    }
}

