﻿function DisplayWarningMessage(message1, message2, message3, message4, message5, message6) {
    message = message1;
    if (message2.toString().length > 0) {
        message = message + "\n" + message2;
    }
    if (message3.toString().length > 0) {
        message = message + "\n" + message3;
    }
    if (message4.toString().length > 0) {
        message = message + "\n" + message4;
    }
    if (message5.toString().length > 0) {
        message = message + "\n" + message5;
    }
    if (message6.toString().length > 0) {
        message = message + "\n" + message6;
    }

    return confirm(message);
}

// Copy values from TextBox, DropDownList, or RadioButtonList
// to HiddenField so that we can set enableviewstate=false for all controls.
function SetBaseControlTextValue(baseControl, hiddenFieldID) {
    var hiddenFieldControl = document.getElementById(hiddenFieldID);
    if (hiddenFieldControl != null) {
        hiddenFieldControl.value = baseControl.value;
    }
}

// This function is used by a Custom Validator to check
// if the selected value of a drop down list value is > 0
// Returns true if the drop down list value is > 0
// Returns false otherwise
function ValidateDropDown(sender, args) {
    args.IsValid = true;
    var dropDown = document.getElementById("ctl00_ContentPlaceHolder_VAMCFAcilityNamesListBox");
    var dropDownId = dropDown.value;
    
    if (dropDownId == null || dropDownId <= 0) {
        args.IsValid = false;
    }
}

//  The maxlength attribute is not working for textbox in multiline mode
//  This function handles the maxlength for multilined textbox
function MultiLineTextBoxMaxLength(text, long) {
    var maxlength = new Number(long); // Change number to your max length. 
    if (text.value.length > maxlength) {
        text.value = text.value.substring(0, maxlength);
    }
}

//Select and add all items in source listbox to destination listbox
function ListboxAddAll(sourceID, destinationID, hiddenFieldID) {
    var listbox = document.getElementById(sourceID);
    for (var count = 0; count < listbox.options.length; count++) {
        listbox.options[count].selected = true;
    }
    ListboxAdd(sourceID, destinationID, hiddenFieldID);
}

// Add items selected in source listbox to destination listbox
function ListboxAdd(sourceID, destinationID, hiddenFieldID) {
    var source = document.getElementById(sourceID);
    var destination = document.getElementById(destinationID);

    for (var count = 0; count < source.options.length; count++) {
        if (source.options[count].selected == true) {
            var option = source.options[count];

            var foundInDestination = false;
            for (var index = 0; index < destination.options.length; index++) {
                if (destination.options[index].value == option.value) {
                    foundInDestination = true;
                }
            }

            if (!foundInDestination) {
                var newOption = document.createElement("option");
                newOption.value = option.value;
                newOption.text = option.text;
                if (option.text.length * 8 > destination.clientWidth) {
                    newOption.title = option.text;
                }
                newOption.selected = true;

                try {
                    destination.add(newOption, null); //Standard
                } catch (error) {
                    destination.add(newOption); // IE only
                }
            }
            source.options[count].selected = false;
        }
    }
    PopulateHiddenField(destination, hiddenFieldID);
}

// Remove selected items in destination listbox
function ListboxRemove(destinationID, hiddenFieldID) {
    var destination = document.getElementById(destinationID);

    for (var count = 0; count < destination.options.length; count++) {

        if (destination.options[count].selected == true) {
            try {
                destination.remove(count, null); //Standard
            } catch (error) {
                destination.remove(count); // IE only
            }
            count--;
        }
        else {
            destination.options[count].selected = true;
        }
    }
    PopulateHiddenField(destination, hiddenFieldID);
}

// Remove all items in destination listbox
function ListboxClearAll(destinationID, hiddenFieldID) {
    var destination = document.getElementById(destinationID);

    for (var count = 0; count < destination.options.length; count++) {
        try {
            destination.remove(count, null); //Standard
        } catch (error) {
            destination.remove(count); // IE only
        }
        count--;
    }

    PopulateHiddenField(destination, hiddenFieldID);
}

// Populate the hidden Field with the detination list box values
function PopulateHiddenField(destinationListBox, hiddenFieldID) {
    var HiddenFieldListBoxValue = document.getElementById(hiddenFieldID);
    var text = "";

    if (HiddenFieldListBoxValue != null) {
        for (var count = 0; count < destinationListBox.options.length; count++) {
            var option = destinationListBox.options[count];
            //            text = text + "|" + option.value + "~" + option.text;
            //text = text + "," + option.value;
            text = text == "" ? option.value : text + "," + option.value;
        }
        HiddenFieldListBoxValue.value = text;
    }
}

//EditEmailTemplates.aspx
function textboxMultilineMaxNumber(txt, maxLen) {
    try {
        if (txt.value.length > (maxLen - 1)) return false;
    } catch (e) {
    }
}

// Enable a required validator if a source control has a selected text
function EnableDisableRequiredValidator(sourceControlId, targetControlId) {
    var sourceControl = document.getElementById(sourceControlId);
    if (sourceControl != null)
    {
        if (sourceControl.value.length > 0 && sourceControl.value != "0") {
            EnableValidator(targetControlId, true);
        }
        else {
            EnableValidator(targetControlId, false);
        }
    }
}


// enable or disable one required validator
function EnableValidator(id, enable) {
    var requiredValidator;
    requiredValidator = document.getElementById(id);
    if (requiredValidator != null) {
        if (enable) {
            requiredValidator.enabled = true;
            ValidatorUpdateDisplay(requiredValidator);
        }
        else {
            ValidatorEnable(requiredValidator, enable);
        }
    }
}

