﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="UserControlReportSearchCriteria.ascx.cs" Inherits="controls_UserControlReportSearchCriteria" %>
<%@ Register src="BaseControlLabel.ascx" tagname="BaseControlLabel" tagprefix="UserControl" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<asp:Panel ID="PanelReportSearchCriteria" runat="server" GroupingText=" Saved Report Search Criteria " >
    <asp:GridView 
        ID="GridViewReportSearchCriteria" 
        runat="server" 
        AutoGenerateColumns="False"
        DataSourceID="DataSourceReportSearchCriteria"
        EnableModelValidation="True"
        Caption="Saved Report Search Criteria" 
        OnRowCommand="GridViewReportSearchCriteria_RowCommand" 
        DataKeyNames="REPORT_SEARCH_CRITERIA_ID">
    <EmptyDataTemplate>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp No saved search criteria found for this report. &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</EmptyDataTemplate>
    <Columns>
        <asp:TemplateField HeaderText="ID" AccessibleHeaderText="ID" Visible="false" >
           <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelRegistrantReportSearchCriteriaId" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("REPORT_SEARCH_CRITERIA_ID")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        
        <asp:TemplateField HeaderText="Search Criteria Name">
           <HeaderStyle HorizontalAlign="Center" />
           <ItemTemplate>
                <asp:Label ID="LabelReportSearchCriteriaName" SkinID="DataLabel" runat="server" Text='<%# Helpers.AhobprEval(Eval("SEARCH_CRITERIA_NAME"))  %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

        <asp:TemplateField HeaderText="Search Criteria" >
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelReportSearchCriteria" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("SEARCH_CRITERIA_DESCRIPTION")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

        
        <asp:TemplateField HeaderText="Saved Date Time">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelSavedDateTime" runat="server" SkinID="DataLabel" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("CREATED")))%>'></asp:Label>
            </ItemTemplate>
            </asp:TemplateField>

             <asp:TemplateField HeaderText=" Delete " >
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                   <asp:Button ID="ButtonDelete" runat="server"
                        Text="  Delete  "
                        Enabled="true" Visible="true"
                        OnClientClick="return confirm('Are you sure you want to delete this report search criteria? Click cancel if you do not want to delete.');"
                        ToolTip='<%# string.Format("Delete search criteria - {0}.", AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem,"SEARCH_CRITERIA_NAME")))) %>' 
                        CommandName="REMOVE" 
                        CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("REPORT_SEARCH_CRITERIA_ID"))) %>' 
                        CausesValidation="false"/>
                </ItemTemplate>
            </asp:TemplateField>

             <asp:TemplateField HeaderText=" Select ">
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>                
                   <asp:Button ID="ButtonSelect" runat="server"
                        Text="  Select  "
                        Enabled="true" Visible="true"
                        ToolTip='<%# string.Format("Select search criteria - {0}.", AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem,"SEARCH_CRITERIA_NAME")))) %>' 
                        CommandName="SELECT" 
                        CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("REPORT_SEARCH_CRITERIA_ID"))) %>' 
                        CausesValidation="false"/>
                </ItemTemplate>
            </asp:TemplateField>

     </Columns>
</asp:GridView>
    <asp:ObjectDataSource 
        ID="DataSourceReportSearchCriteria" runat="server" 
            SelectMethod="SelectReportSearchCriteria" 
            TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRReportManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="HiddenFieldUserName" Name="userName" PropertyName="Value" Type="String" />
            <asp:ControlParameter ControlID="HiddenFieldReportName" Name="reportName" PropertyName="Value" Type="String" />
      </SelectParameters>
    </asp:ObjectDataSource>
</asp:Panel>
<asp:HiddenField ID="HiddenFieldUserName" runat="server" />
<asp:HiddenField ID="HiddenFieldReportName" runat="server" />
