﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.ViaEmrServiceReference;

public partial class controls_UserControlRegistrant : System.Web.UI.UserControl
{
    private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    private List<STD_GUI_CONTROL_AHOBPR> _dbAhopbrControls = null;
    private AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();
    //AHOBPRQuestionnaireManager _questionManager = new AHOBPRQuestionnaireManager();
    AHOBPRFileManager _fileManager = new AHOBPRFileManager();
    private SessionFacade userSession;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (HttpContext.Current.Session != null && HttpContext.Current.Session["UserSession"] != null)
            userSession = HttpContext.Current.Session["UserSession"] as SessionFacade;
        else
            userSession = new SessionFacade();

        LoadBaseControls();
        LoadControlsFromObject(RegistrantId);

        if (!string.IsNullOrEmpty(userSession.DUZ)
            && userSession.NoteSentToCprs == "no"
            && !string.IsNullOrEmpty(userSession.NoteContent))
        {
            UserAccountManager currentUser = (UserAccountManager)HttpContext.Current.User;
            if (currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleRegistryManagerCode))
                || currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleAdvancedUserCode))
                || currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleCareTeamCode))
                )
            {
                ButtonSendtoCprs.Visible = true;
            }
            else
            {
                // Do not display the button for Help Desk role only users
                ButtonSendtoCprs.Visible = false;
            }
        }
        else
        {
            ButtonSendtoCprs.Visible = false;
        }

        HyperLinkRegistrantInfo.Visible = (HttpContext.Current.Request.Url.PathAndQuery.Contains("RegistrantInformation.aspx") == false);
    }

    public void LoadControlsFromObject(int registrantId)
    {
        if (registrantId > 0)
        {
            REGISTRANT registrant = _registrantManager.GetRegistrantById(registrantId);
            if (registrant != null)
            {
                BaseControlLabelName.Text = registrant.Name;
                //add leading zeros to date
                BaseControlLabelDob.Text = registrant.BIRTH_DATE.HasValue ? Convert.ToDateTime(registrant.BIRTH_DATE).ToString("MM/dd/yyyy") : string.Empty;
                BaseControlLabelGender.Text = registrant.GENDER;
                BaseControlLabelDutyStatus.Text = registrant.STD_SERVICE_STATUS.SERVICE_STATUS;
                BaseControlLabelLast4ssn.Text = string.IsNullOrEmpty(registrant.Snum) ? string.Empty : registrant.Snum.Length > 4 ? registrant.Snum.Substring(registrant.Snum.Length - 4) : string.Empty;
                BaseControlLabelRegistryStatus.Text = registrant.STD_REGISTRANT_STATUS.REGISTRANT_STATUS;
                BaseControlLabelEmail.Text = registrant.Email;
                BaseControlLabelPhone.Text = registrant.Phone;
                BaseControlLabelID.Text = registrant.REGISTRANT_ID.ToString();
                //add leading zeros to date
                if (!string.IsNullOrEmpty(registrant.QuestionnaireCompletionDateTime))
                {
                    BaseControlLabelQuestionnaireCompletionDate.Text = Convert.ToDateTime(registrant.QuestionnaireCompletionDateTime).ToString("MM/dd/yyyy h:mm:ss tt");
                }
                else
                {
                    BaseControlLabelQuestionnaireCompletionDate.Text = string.Empty;
                }
                BaseControlLabelAddress.Text = registrant.Address;
                BaseControlLabelHealthConcern.Text = registrant.ReportsHealthConcerns;
                BaseControlLabelRequestToBeSeen.Text = registrant.RequestToBeSeen;
                BaseControlLabelLastOutreach.Text = registrant.LastAdminFlag;
                BaseControlLabelSubpopulationFlags.Text = registrant.SubpopulationFlags;
                HiddenFieldUserId.Value = registrant.USER_ID;
                byte[] pdf = _fileManager.GetFile(registrant.USER_ID, AHOBPRGlobal.FileTypePdf);
                ButtonPDF.Visible = (pdf != null 
                                        && !string.IsNullOrEmpty(registrant.QuestionnaireCompletionDateTime) 
                                        && registrant.STD_REGISTRANT_STATUS_ID.ToString() == AHOBPRGlobal.RegistryStatusParticipant);
                // Hide the PDF button for help desk role user
                UserAccountManager currentUser = (UserAccountManager)HttpContext.Current.User;
                if (currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleHelpDeskCode))
                    && !currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleRegistryManagerCode)) 
                    && !currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleAdvancedUserCode))
                    && !currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleCareTeamCode)))
                {
                    ButtonPDF.Visible = false;
                }
            }
        }
    }

    protected void ButtonSendtoCprs_Click(object sender, EventArgs e)
    {
        if (HttpContext.Current.Session != null && HttpContext.Current.Session["UserSession"] != null)
            userSession = HttpContext.Current.Session["UserSession"] as SessionFacade;
        else
            userSession = new SessionFacade();

        string ahobprNoteTitle = Helpers.GetConfigEntry("AhobprNoteTitle");
        string noteContent = userSession.NoteContent;
        //string noteContent = string.Empty;
        //SecureStringWrapper secNoteContent = Session["NoteContent"] as SecureStringWrapper;
        //if (secNoteContent != null)
        //    noteContent = secNoteContent.SecureString.ToString();

        //Add to Audit Log
        UserAccountManager user = (UserAccountManager)HttpContext.Current.User;
        Helpers.AddActivityToAuditLog(user.UserId.ToString(), ahobprNoteTitle,
            RegistrantId.ToString(), AuditLogType.ProgressNoteSent, null);

        ViaManager viaManager = new ViaManager(Helpers.GetConfigEntry("ViaAppId"), Helpers.GetConfigEntry("ViaAppToken"), Helpers.GetConfigEntry("ViaAppToken2"));
        string ahobprNoteIen = viaManager.getNoteTitleIenFromVIA(userSession.PersonsTo, ahobprNoteTitle);
        
        string messageToUser = string.Empty;
        if (string.IsNullOrEmpty(ahobprNoteIen))
        {
            AHOBPRShared sharedManager = new AHOBPRShared();
            messageToUser = "The AHOBPR note title cannot be found in VistA.";
            sharedManager.LogErrorMessage("VIA writeNote", "QuestionnaireSummary.aspx Send Questionnaire to CPRS", messageToUser);
        }
        else
        {
            bool result = viaManager.WriteNote(ahobprNoteIen, noteContent, userSession.PersonsTo, Helpers.GetStringFromSessionVariable(Session["registrantId"]));
            if (result)
            {
                userSession.NoteSentToCprs = "yes";
                ButtonSendtoCprs.Visible = false;
                messageToUser = "Sent successful";

                //set Admin Flag
                AHOBPRRegistrantManager registrantManager = new AHOBPRRegistrantManager();
                string adminFlag = "Progress Note Sent to CPRS";
                registrantManager.AddAdminTrackingFlagToRegistrantForSentMessage(RegistrantId, adminFlag);
            }
            else
            {
                messageToUser = "Sent failed";
            }
        }
        Alert.Show(messageToUser);
    }

    public void LoadUserControl(int registrantId)
    {
        RegistrantId = registrantId;
    }

    public int RegistrantId { get; set; }

    private void LoadBaseControls()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_REGISTRANT_USER_CONTROL"))
        {
            Control userControl = PanelRegistrantInfo.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                if (dbItem.BASE_CONTROL_TYPE == (int)AhobprBaseControlType.Label)
                {
                    controls_BaseControlLabel baseControl = (controls_BaseControlLabel)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, true);
                }
            }
        }
    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="controlCategory"></param>
    /// <returns></returns>
    private List<STD_GUI_CONTROL_AHOBPR> GetGuiControls(string controlCategory)
    {
        if (userSession.GuiControlsRegistrantUserControl == null)
        {
            _dbAhopbrControls = _baseControlManager.SelectGuiControlList(controlCategory).ToList<STD_GUI_CONTROL_AHOBPR>();
            userSession.GuiControlsRegistrantUserControl = _dbAhopbrControls;
        }
        else
        {
            _dbAhopbrControls = userSession.GuiControlsRegistrantUserControl;
        }

        return _dbAhopbrControls;
    }

    protected void ButtonPDF_Click(object sender, EventArgs e)
    {
        Response.Clear();
        Response.ContentType = "application/pdf";
        Response.AppendHeader("Content-Disposition", "inline;filename=data.pdf");
        Response.BufferOutput = true;
        byte[] pdf = _fileManager.GetFile(HiddenFieldUserId.Value, AHOBPRGlobal.FileTypePdf);
        Response.AddHeader("Content-Length", pdf.Length.ToString());
        Response.BinaryWrite(pdf);
        Response.End();
    }
}
