﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class controls_UserControlFacilityDropdownLists : System.Web.UI.UserControl
{
    private AHOBPRShared _sharedManager = new AHOBPRShared();

    protected void Page_Load(object sender, EventArgs e)
    {
        //Reset the dropdownlist value with the hidden field value
        if (!string.IsNullOrEmpty(HiddenFieldMainFacility.Value) && HiddenFieldMainFacility.Value != "0")
        {
            MainFacilityId = HiddenFieldMainFacility.Value;
        }
        if (!string.IsNullOrEmpty(HiddenFieldSubFacility.Value) && HiddenFieldSubFacility.Value != "0")
        {
            SubFacilityId = HiddenFieldSubFacility.Value;
        }
    }

    public void LoadControlsFromObject()
    {
        PopulateVisnDropDownList();
    }

    private void PopulateVisnDropDownList()
    {
        if (DropDownListVisn.Items.Count == 1)
        {
            DropDownListMainFacility.Enabled = false;
            DropDownListSubFacility.Enabled = false;
            AHOBPRBaseControlManager manager = new AHOBPRBaseControlManager();
            List<VIEW_FACILITY_LOOKUP> lookupList = manager.SelectFacilityLookupList("Visn");

            DropDownListVisn.DataSource = lookupList;
            DropDownListVisn.DataValueField = "ID";
            DropDownListVisn.DataTextField = "NAME";
            DropDownListVisn.DataBind();
            AddAttributesToVisn();
            AddAttributesToMainFacility();
            AddAttributesToSubFacility();
        }
    }


    private void PopulateMainFacilityDropDownList(string visnId)
    {
        if (!string.IsNullOrEmpty(visnId))
        {
                DropDownListMainFacility.Enabled = true;
                DropDownListSubFacility.Enabled = false;
                AHOBPRBaseControlManager manager = new AHOBPRBaseControlManager();
                List<VIEW_FACILITY_LOOKUP> lookupList = manager.GetFacilityListByParentId("MainFacility", Helpers.getIntFromString(visnId));
                DropDownListMainFacility.Items.Clear();
                DropDownListMainFacility.Items.Add(new ListItem(" ", "0"));
                DropDownListMainFacility.DataSource = lookupList;
                DropDownListMainFacility.DataValueField = "ID";
                DropDownListMainFacility.DataTextField = "NAME";
                DropDownListMainFacility.DataBind();
                AddAttributesToMainFacility();
                AddAttributesToSubFacility();
        }
    }

    private void PopulateSubFacilityDropDownList(string mainFacilityId)
    {
        if (!string.IsNullOrEmpty(mainFacilityId))
        {
                DropDownListSubFacility.Enabled = true;
                AHOBPRBaseControlManager manager = new AHOBPRBaseControlManager();
                List<VIEW_FACILITY_LOOKUP> lookupList = manager.GetFacilityListByParentId("Facility", Helpers.getIntFromString(mainFacilityId));

                DropDownListSubFacility.Items.Clear();
                DropDownListSubFacility.Items.Add(new ListItem(" ", "0"));
                DropDownListSubFacility.DataSource = lookupList;
                DropDownListSubFacility.DataValueField = "ID";
                DropDownListSubFacility.DataTextField = "NAME";
                DropDownListSubFacility.DataBind();
                AddAttributesToSubFacility();
        }
    }

    private void AddAttributesToVisn()
    {
        if (DropDownListVisn.Attributes["onchange"] == null)
        {
            DropDownListVisn.Attributes.Add("onchange",
                "SetBaseControlTextValue(this, '" + HiddenFieldVisn.ClientID + "')");
        }
    }
    private void AddAttributesToMainFacility()
    {
        if (DropDownListMainFacility.Attributes["onchange"] == null)
        {
            DropDownListMainFacility.Attributes.Add("onchange",
                "SetBaseControlTextValue(this, '" + HiddenFieldMainFacility.ClientID + "')");
        }
    }
    private void AddAttributesToSubFacility()
    {
        if (DropDownListSubFacility.Attributes["onchange"] == null)
        {
            DropDownListSubFacility.Attributes.Add("onchange",
                "SetBaseControlTextValue(this, '" + HiddenFieldSubFacility.ClientID + "')");
        }
    }

    public string VISN
    {
        get
        {            
            if (HiddenFieldVisn.Value.Length == 1)
            {
                return "V0" + HiddenFieldVisn.Value;
            }
            else if (HiddenFieldVisn.Value.Length > 1)
            {
                return "V" + HiddenFieldVisn.Value;
            }
            else
            {
                return HiddenFieldVisn.Value;
            }
        }

    }

    public string VisnId
    {
        get
        {
            return HiddenFieldVisn.Value;
        }
        set
        {
            DropDownListVisn.SelectedIndex = -1;
            HiddenFieldVisn.Value = value;
            PopulateVisnDropDownList();
            foreach (ListItem item in DropDownListVisn.Items)
            {
                if (item.Value == value.Trim())
                {
                    DropDownListVisn.Visible = true;
                    DropDownListVisn.Enabled = true;
                    item.Selected = true;
                    break;
                }
            }

        }
    }


    public string MainFacilityId
    {
        get
        {
            return HiddenFieldMainFacility.Value;
        }
        set
        {
            if (!string.IsNullOrEmpty(HiddenFieldVisn.Value) && HiddenFieldVisn.Value != "0"
                && !string.IsNullOrEmpty(value.Trim()) && value.Trim() != "0")
            {
                DropDownListMainFacility.SelectedIndex = -1;
                HiddenFieldMainFacility.Value = value;
                PopulateMainFacilityDropDownList(HiddenFieldVisn.Value);
                foreach (ListItem item in DropDownListMainFacility.Items)
                {
                    if (item.Value == value.Trim())
                    {
                        DropDownListMainFacility.Visible = true;
                        DropDownListMainFacility.Enabled = true;
                        item.Selected = true;
                        break;
                    }
                }

            }

        }
    }

    public string FacilityPanelName
    {
        get
        {
            string result = string.Empty;

            result = PanelFacility.GroupingText;

            return result;
        }
        set
        {
            PanelFacility.GroupingText = value;
        }
    }

    public string FacilityPanelToolTip
    {
        get
        {
            string result = string.Empty;

            result = PanelFacility.ToolTip;

            return result;
        }
        set
        {
            PanelFacility.ToolTip = value;

        }
    }
    public string MainFacilityDescription
    {
        get
        {
            string description = string.Empty; 
            if (!string.IsNullOrEmpty(HiddenFieldMainFacility.Value) && (HiddenFieldMainFacility.Value != "0"))
            {
                description = _sharedManager.GetFacilityDescription(Convert.ToInt32(HiddenFieldMainFacility.Value)); 
                
            }
            return description;
        }
    }

    public bool ClosestFacility
    {
        set
        {
            HiddenFieldClosestFacility.Value = value.ToString();
            if (value)
            {
                PanelFacility.GroupingText = "Closest Facility";
                RequiredFieldValidatorMainFacility.Visible = true;
            }
        }
    }

    public string SubFacilityId
    {
        get
        {
            return HiddenFieldSubFacility.Value;
        }
        set
        {
            if (!string.IsNullOrEmpty(HiddenFieldMainFacility.Value) && HiddenFieldMainFacility.Value != "0"
                && !string.IsNullOrEmpty(value.Trim()) && value.Trim() != "0")
            {
                DropDownListSubFacility.SelectedIndex = -1;
                HiddenFieldSubFacility.Value = value;
                PopulateSubFacilityDropDownList(HiddenFieldMainFacility.Value);
                foreach (ListItem item in DropDownListSubFacility.Items)
                {
                    if (item.Value == value.Trim())
                    {
                        DropDownListSubFacility.Visible = true;
                        DropDownListSubFacility.Enabled = true;
                        item.Selected = true;
                        break;
                    }
                }
            }
          
        }
    }

    public string SubFacilityDescription
    {
        get
        {
            string description = string.Empty;
            if (!string.IsNullOrEmpty(HiddenFieldSubFacility.Value))
            {
                foreach (ListItem item in DropDownListSubFacility.Items)
                {
                    if (item.Value == HiddenFieldSubFacility.Value.Trim())
                    {
                        description = item.Text;
                        break;
                    }
                }
            }
            return description;
        }
    }

    public string FacilityId
    {
        get
        {  
            string result = string.Empty;
            if (!string.IsNullOrEmpty(SubFacilityId) && SubFacilityId != "0")
            {
                result = SubFacilityId;
            }
            else if (!string.IsNullOrEmpty(MainFacilityId) && MainFacilityId != "0")
            {
                result = MainFacilityId;
            }

            return result;
        }
    }

    public string LocationKey
    {
        get
        {
            string result = null;
            
            if ((!string.IsNullOrEmpty(HiddenFieldSubFacility.Value)) && (HiddenFieldSubFacility.Value != "0"))
                {
                    result = HiddenFieldSubFacility.Value;
                }
            else if ((!string.IsNullOrEmpty(HiddenFieldMainFacility.Value))&& (HiddenFieldMainFacility.Value != "0"))
                {
                    result = HiddenFieldMainFacility.Value;
                }
            else if ((!string.IsNullOrEmpty(HiddenFieldVisn.Value)) && (HiddenFieldVisn.Value != "0"))
             {
                 if (HiddenFieldVisn.Value.Length == 1)
                 {
                     result = "V0" + HiddenFieldVisn.Value;
                 }
                 else if (HiddenFieldVisn.Value.Length > 1)
                 {
                     result = "V" + HiddenFieldVisn.Value;
                 }
                 else
                 {
                     result = HiddenFieldVisn.Value;
                 }
             }
            
             return result;
         }
        //set
        //{

        //}
           
   }
    

    public string LocationType
    {
        get
        {
            string result = null;

            if ((!string.IsNullOrEmpty(HiddenFieldSubFacility.Value)) && (HiddenFieldSubFacility.Value != "0"))
            {
                result = "Institution";
            }
            else if ((!string.IsNullOrEmpty(HiddenFieldMainFacility.Value)) && (HiddenFieldMainFacility.Value != "0"))
            {
                result = "Base";
            }
            else if ((!string.IsNullOrEmpty(HiddenFieldVisn.Value)) && (HiddenFieldVisn.Value != "0"))
            {
                result = "VISN";
            }

            return result;
        }
        //set
        //{
        //    HiddenFieldLocationType.Value = value;
        //}
    }

    public void Reset()
    {
        DropDownListMainFacility.SelectedIndex = -1;
        DropDownListVisn.SelectedIndex = -1;
        HiddenFieldMainFacility.Value = string.Empty;
        HiddenFieldSubFacility.Value = string.Empty;
        HiddenFieldVisn.Value = string.Empty;
    }

}
