﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="UserControlAllDeployments.ascx.cs" Inherits="controls_UserControlAllDeployments" %>
<%@ Register src="BaseControlLabel.ascx" tagname="BaseControlLabel" tagprefix="UserControl" %>
<asp:Panel ID="PanelDeploymentIndicators" runat="server" GroupingText=" Deployment Indicators " >
    <asp:Label SkinID="DataLabel" ID="LabelforLabelPre911" runat="server" 
    AssociatedControlID="LabelPre911">Pre 9/11 Deployment (Gulf War):&nbsp&nbsp</asp:Label>
    <asp:Label SkinID="DataLabel" ID="LabelPre911" runat="server"></asp:Label>
    <br />
    <asp:Label SkinID="DataLabel" ID="LabelforLabelPost911" runat="server" 
    AssociatedControlID="LabelPost911">Post 9/11 Deployment (OIF, OEF, OND):&nbsp&nbsp</asp:Label>
    <asp:Label SkinID="DataLabel" ID="LabelPost911" runat="server"></asp:Label>
</asp:Panel>
<br />
<asp:Panel ID="PanelDeploymentHistory" runat="server" GroupingText=" Deployment History " role="heading" aria-level="2">
    <table>
        <tr>
            <td>
                <asp:Label SkinID="DataLabel" ID="LabelforDropDownListLocation" runat="server" 
                    AssociatedControlID="DropDownListLocation" >Location:</asp:Label>
                <br />
                <asp:DropDownList ID="DropDownListLocation" runat="server" AppendDataBoundItems="true">
                <asp:ListItem Value="All">All</asp:ListItem>
                </asp:DropDownList>
            </td>
            <td>
                &nbsp&nbsp&nbsp&nbsp
            </td>
             <td>
                <asp:Label SkinID="DataLabel" ID="LabelforDropDownListStage" runat="server" 
                    AssociatedControlID="DropDownListStage" >Stage:</asp:Label>
                <br />
                <asp:DropDownList ID="DropDownListStage" runat="server" AppendDataBoundItems="true" >
                <asp:ListItem Value="All">All</asp:ListItem>
                </asp:DropDownList>
            </td>
            <td>
                &nbsp&nbsp&nbsp&nbsp
            </td>
           <td>
                <asp:Label SkinID="DataLabel" ID="LabelforDropDownListSource" runat="server" 
                    AssociatedControlID="DropDownListSource" >Data Source:</asp:Label>
                <br />
                <asp:DropDownList ID="DropDownListSource" runat="server" AppendDataBoundItems="true" >
                <asp:ListItem Value="All">All</asp:ListItem>
                </asp:DropDownList>
            </td>
            <td>
                &nbsp&nbsp&nbsp&nbsp
            </td>
            <td>
                <br />
                <asp:Button ID="ButtonFilter" runat="server" onclick="ButtonFilter_Click" Text="Filter" />
                &nbsp&nbsp&nbsp&nbsp
                <asp:Button ID="ButtonClear" runat="server" Text=" Clear " onclick="ButtonClear_Click" CausesValidation="false" />
            </td>
        </tr>
    </table>
    <asp:GridView 
        ID="GridViewDeploymentHistory"
        runat="server"
        Caption="Deployment History"  
        AutoGenerateColumns="False"
        EnableModelValidation="True"
        DataKeyNames="REGISTRANT_DEPLOYMENT_ID">
    <EmptyDataTemplate>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp No deployment history found. &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</EmptyDataTemplate>
    <Columns>
        <asp:TemplateField HeaderText="ID" AccessibleHeaderText="ID" Visible="false" >
           <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelDeploymentId" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("REGISTRANT_DEPLOYMENT_ID")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        
         <asp:TemplateField HeaderText="Begin" SortExpression="DEPLOYMENT_START_DATE">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelBegin" runat="server" SkinID="DataLabel" Text='<%# Convert.ToDateTime(Helpers.AhobprEval(Eval("DeploymentStartDate"))).ToString("MM/dd/yyyy") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        
        <asp:TemplateField HeaderText="End" SortExpression="DEPLOYMENT_END_DATE">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelEnd" runat="server" SkinID="DataLabel" Text='<%# Convert.ToDateTime(Helpers.AhobprEval(Eval("DeploymentEndDate"))).ToString("MM/dd/yyyy") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        
        <asp:TemplateField HeaderText="Conflict" SortExpression="DUTY_PROJECT_CODE">
           <HeaderStyle HorizontalAlign="Center" />
           <ItemTemplate>
                <asp:Label ID="LabelConflict" SkinID="DataLabel" runat="server" Text='<%# Helpers.AhobprEval(Eval("DUTY_PROJECT_CODE"))  %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

        <asp:TemplateField HeaderText="Location" SortExpression="DEPLOYMENT_COUNTRY">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelLocation" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("DEPLOYMENT_COUNTRY")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

        
        <asp:TemplateField HeaderText="Branch" SortExpression="STD_BRANCH_OF_SERVICE.BRANCH_OF_SERVICE">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelBranch" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("STD_BRANCH_OF_SERVICE.BRANCH_OF_SERVICE")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

        <asp:TemplateField HeaderText="Unit Component" SortExpression="DEPLOYMENT_UIC">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelUnitComponent" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("UnitComponent")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        
         <asp:TemplateField HeaderText="Rank" SortExpression="MILITARY_RANK">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelRank" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("MILITARY_RANK")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        
         <asp:TemplateField HeaderText="MOS" SortExpression="STD_SERVICE_OCCUPATION_ID">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelMOS" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("ServiceOccupation")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
              
               
        <asp:TemplateField HeaderText="Data Source" >
            <HeaderStyle HorizontalAlign="Center" />
            <ItemStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelDataSource" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("DataSource")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        
         <asp:TemplateField HeaderText="Deployment Stage" >
            <HeaderStyle HorizontalAlign="Center" />
            <ItemStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelDeploymentStage" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("DeploymentStage")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        
       <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" ValidationGroup="SearchRegistrant"
           ItemStyle-VerticalAlign="Middle" ItemStyle-HorizontalAlign="Center" AccessibleHeaderText = "Select" Visible="false"  />
    </Columns>
</asp:GridView>
</asp:Panel>
<%--    <asp:ObjectDataSource 
        ID="DataSourceDeploymentHistory" runat="server" 
            SelectMethod="SelectRegistrantDeploymentHistory"
            SelectCountMethod="DeploymentCount"
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True" 
            TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRRegistrantManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="HiddenFieldRegistrantId" Name="registrantId" PropertyName="Value" Type="String" />
            <asp:Parameter Name="sort" Type="String" />
            <asp:Parameter Name="startRow" Type="Int32" />
            <asp:Parameter Name="maxRows" Type="Int32" />
      </SelectParameters>
    </asp:ObjectDataSource>--%>
<asp:HiddenField ID="HiddenFieldRegistrantId" runat="server" />
