﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class controls_UserControlAdminFlagFilter : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CompareValidatorTextBoxFromDate.ValueToCompare = DateTime.Now.ToShortDateString();
        CompareValidatorTextBoxToDate.ValueToCompare = DateTime.Now.ToShortDateString();
        if (!IsPostBack)
        {
            LoadControlsFromObject(string.Empty);
        }
    }
 
    public void LoadControlsFromObject(string validationGroup)
    {
        PopulateAdminFlagDropDownList();
        LoadControlsFromObject("Admin Flag Entered Date", false, "Admin Flag Entered Date", validationGroup);
    }

    public string AdminFlagId
    {
        get
        {
            return HiddenFieldAdminFlag.Value;
        }
        set
        {
            DropDownListAdminFlag.SelectedIndex = -1;
            HiddenFieldAdminFlag.Value = value;
            PopulateAdminFlagDropDownList();
            foreach (ListItem item in DropDownListAdminFlag.Items)
            {
                if (item.Value == value.Trim())
                {
                    item.Selected = true;
                    break;
                }
            }
        }
    }

    public string AdminFlagEnteredDateFrom
    {
        get
        {
            return FromDateValue;
        }
        set
        {
            FromDateValue = value;
        }
    }

 
    public string AdminFlagEnteredDateTo
    {
        get
        {
            return ToDateValue;
        }
        set
        {
            ToDateValue = value;
        }
    }

    public string AdminFlagDescription
    {
        get
        {
            string description = string.Empty;
            if (!string.IsNullOrEmpty(HiddenFieldAdminFlag.Value))
            {
                foreach (ListItem item in DropDownListAdminFlag.Items)
                {
                    if (item.Value == HiddenFieldAdminFlag.Value.Trim())
                    {
                        description = item.Text;
                        break;
                    }
                }
            }
            return description;
        }

    }

    private void PopulateAdminFlagDropDownList()
    {
        if (DropDownListAdminFlag.Items.Count == 1)
        {
            AHOBPRBaseControlManager manager = new AHOBPRBaseControlManager();
            List<AHOBPR_VIEW_LOOKUP> lookupList = manager.SelectLookupList("ADMIN_FLAG_ALL");

            DropDownListAdminFlag.DataSource = lookupList;
            DropDownListAdminFlag.DataValueField = "ID";
            DropDownListAdminFlag.DataTextField = "Name";
            DropDownListAdminFlag.DataBind();
            AddAttributesToAdminFlag();
        }
    }

    private void AddAttributesToAdminFlag()
    {
        if (DropDownListAdminFlag.Attributes["onchange"] == null)
        {
            DropDownListAdminFlag.Attributes.Add("onchange",
                "SetBaseControlTextValue(this, '" + HiddenFieldAdminFlag.ClientID + "')");
        }
    }

    public bool ValidateCustomValidator()
    {
        return this.ValidateCustomValidator2();
    }

    public string FromDateValue
    {
        get
        {
            return TextBoxFromDate.Text;
        }
        set
        {
            TextBoxFromDate.Text = value;
        }
    }

    public string FromDateLabel
    {
       set
        {
            LabelforTextBoxFromDate.Text = value;
        }
    }

    public string ToDateLabel
    {
        set
        {
            LabelforTextBoxToDate.Text = value;
        }
    }


    public string ToDateValue
    {
        get
        {
            return TextBoxToDate.Text;
        }
        set
        {
            TextBoxToDate.Text = value;
        }
    }

    public void LoadControlsFromObject(string dateDescription, bool required, string toolTip, string validationGroup)
    {
        if (!string.IsNullOrEmpty(dateDescription))
        {
            PanelDateRange.GroupingText = dateDescription + "&nbsp&nbsp";
        }
        RequiredFieldValidatorTextBoxFromDate.Enabled = required;
        RequiredFieldValidatorTextBoxFromDate.Visible = required;
        RequiredFieldValidatorTextBoxToDate.Enabled = required;
        RequiredFieldValidatorTextBoxToDate.Visible = required;
        if (!string.IsNullOrEmpty(toolTip))
        {
            PanelDateRange.ToolTip = toolTip;
        }
        if (!string.IsNullOrEmpty(validationGroup))
        {
            RequiredFieldValidatorTextBoxFromDate.ValidationGroup = validationGroup;
            RequiredFieldValidatorTextBoxToDate.ValidationGroup = validationGroup;
            CustomValidatorFromToDate.ValidationGroup = validationGroup;
            CompareValidatorTextBoxFromDate.ValidationGroup = validationGroup;
            CompareValidatorTextBoxToDate.ValidationGroup = validationGroup;
        }
    }


    public bool ValidateCustomValidator2()
    {
         CustomValidatorFromToDate.IsValid = true;
        
        //Verify a 4-digit year has been entered and valid date
        if (!string.IsNullOrEmpty(TextBoxFromDate.Text))
        {
            string fromDate = TextBoxFromDate.Text.Split('/').Last();
            //count slashes
            var slashCount = TextBoxFromDate.Text.Count(x => x == '/');

            //Verify a 4-digit year has been entered and valid date
            if (TextBoxFromDate.Text.Length < 6)
            {
                CustomValidatorFromToDate.IsValid = false;
                CustomValidatorFromToDate.ErrorMessage = "Please enter a valid From Date (mm/dd/yyyy).";
                TextBoxFromDate.Focus();
            }
            else if (slashCount != 2)
            {
                CustomValidatorFromToDate.IsValid = false;
                CustomValidatorFromToDate.ErrorMessage = "Please enter a valid From Date (mm/dd/yyyy).";
            }
            else if (fromDate.Length < 4)
            {
                CustomValidatorFromToDate.IsValid = false;
                CustomValidatorFromToDate.ErrorMessage = "Please enter a 4-digit year for From Date.";
            }
            if (CustomValidatorFromToDate.IsValid == false)
            {
                TextBoxFromDate.Focus();
            }
        }

        if (!string.IsNullOrEmpty(TextBoxToDate.Text) && CustomValidatorFromToDate.IsValid)
        {
            string ToDate = TextBoxToDate.Text.Split('/').Last();
            //count slashes
            var slashCount = TextBoxToDate.Text.Count(x => x == '/');

            //Verify a 4-digit year has been entered and valid date
            if (TextBoxToDate.Text.Length < 6)
            {
                CustomValidatorFromToDate.IsValid = false;
                CustomValidatorFromToDate.ErrorMessage = "Please enter a valid To Date (mm/dd/yyyy).";
            }
            else if (slashCount != 2)
            {
                CustomValidatorFromToDate.IsValid = false;
                CustomValidatorFromToDate.ErrorMessage = "Please enter a valid To Date (mm/dd/yyyy).";
            }
            else if (ToDate.Length < 4)
            {
                CustomValidatorFromToDate.IsValid = false;
                CustomValidatorFromToDate.ErrorMessage = "Please enter a 4-digit year for To Date.";
            }

            if (CustomValidatorFromToDate.IsValid == false)
            {
                TextBoxToDate.Focus();
            }
        }

        // Validate that ToDate is greater than FromDate when both value is entered    
        if (!string.IsNullOrEmpty(TextBoxFromDate.Text) && !string.IsNullOrEmpty(TextBoxToDate.Text) && CustomValidatorFromToDate.IsValid)
        {
            if (Helpers.GetDateFromString(TextBoxFromDate.Text) > Helpers.GetDateFromString(TextBoxToDate.Text))
            {
                CustomValidatorFromToDate.ErrorMessage = "To Date must be greater than or equal to From Date.";
                CustomValidatorFromToDate.IsValid = false;
            }
        }

        return CustomValidatorFromToDate.IsValid;
    }


}