﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class controls_BaseControlRadioButtonList : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }
    public string Text
    {
        get
        {
            return HiddenFieldID.Value;
        }
        set
        {
            if (!string.IsNullOrEmpty(value))
            {
                HiddenFieldID.Value = value;
                foreach (ListItem radioListItem in RadioButtonListID.Items)
                {
                    if (radioListItem.Value == value.Trim())
                    {
                        radioListItem.Selected = true;
                        break;
                    }
                }
            }
        }
    }

    public string Description
    {
        get
        {
            string results = string.Empty;

            foreach (ListItem radioListItem in RadioButtonListID.Items)
            {
                if (radioListItem.Value == HiddenFieldID.Value.Trim())
                {
                    results = radioListItem.Text;
                    break;
                }
            }

            return results;
        }
    }

    public string LabelText
    {
        get
        {
            return LabelforLabelID.Text;
        }
        set
        {
            LabelforLabelID.Text = value;
        }
    }

    public bool Enabled
    {
        set
        {
            this.RadioButtonListID.Enabled = value;
        }
    }

    public string Tooltip
    {
        set
        {
            LabelforLabelID.ToolTip = value;
            RadioButtonListID.ToolTip = value;
        }
    }

    public bool IncludeLabel
    {
        set
        {
            LabelforLabelID.Visible = value;
        }
    }

    public string LookUpCategory
    {
        set
        {
            if (!string.IsNullOrEmpty(value))
            {
                AHOBPRBaseControlManager manager = new AHOBPRBaseControlManager();
                List<AHOBPR_VIEW_LOOKUP> lookupList = manager.SelectLookupList(value);

                RadioButtonListID.DataSource = lookupList;
                RadioButtonListID.DataValueField = "ID";
                RadioButtonListID.DataTextField = "NAME";
                RadioButtonListID.DataBind();
                AddAttributes();
            }
        }
    }


    public void LoadControlsFromObject(string text, string labelText, string tooltip, bool includeLabel, string lookupCategory)
    {
        if (!string.IsNullOrEmpty(tooltip))
        {
            Tooltip = tooltip;
        }
        if (!string.IsNullOrEmpty(labelText))
        {
            LabelText = labelText;
        }

        IncludeLabel = includeLabel;
        LookUpCategory = lookupCategory;
        if (!string.IsNullOrEmpty(text))
        {
            Text = text;
        }
    }

    private void AddAttributes()
    {
        foreach (ListItem radioButton in RadioButtonListID.Items)
        {
            if (radioButton.Attributes["onclick"] == null)
            {
                radioButton.Attributes.Add("onclick",
                    "SetBaseControlTextValue(this, '" + HiddenFieldID.ClientID + "')");
            }
        }
    }
}
