﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR; 

public partial class ToolQuestionGroupList : BasePage
{
    private AHOBPRToolManager _toolManager = new AHOBPRToolManager();

    protected void Page_Load(object sender, EventArgs e)
    {
    }
    public override string MenuItemName()
    {
        return "Question Group List";
    }
    public override string AppObjectCode()
    {
        return "AHOBPR TOOL";
    }
    public override string TopMenuName()
    {
        return "Tool";
    }
    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        TextBoxKeyWords.Text = "";
        DropDownListStatus.SelectedIndex = -1;
        HiddenFieldClearFlag.Value = "1";
    }

    protected void ButtonSearch_Click(object sender, EventArgs e)
    {
        GridViewQuestionGroups.DataBind();
        HiddenFieldClearFlag.Value = "0";
    }

    private void UpdateJsonFormSystemWide(string formId)
    {
        TOOL_FORM form = _toolManager.GetFormById(Helpers.getIntFromString(formId));
        if (form != null)
        {
            if (form.SYSTEM_WIDE_FLAG)
            {
                ServiceCaller.UpdateFollowupFormJsonSystemWide(formId);
            }
        }
    }
    protected void GridViewQuestionGroups_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        try
        {
            int formId = Convert.ToInt32(e.CommandArgument);

            switch (e.CommandName)
            {
                case "Edit":
                    Response.Redirect("ToolQuestionGroupEdit.aspx?id={0}", formId);
                    break;
                case "Preview":
                    Response.Redirect("ToolQuestionGroupPreview.aspx?id={0}", formId);
                    break;
                case "DELETE_FLAG":
                    if (_toolManager.RemoveForm(formId))
                    {
                        GridViewQuestionGroups.DataBind();
                        Alert.ShowDeleteSuccessful();
                    }
                    else
                    {
                        Alert.ShowSaveFailed();
                    }

                    break;
                case "UPDATE_FLAG":
                    if (_toolManager.ActivateDeactivateForm(formId))
                    {
                        UpdateJsonFormSystemWide(formId.ToString());
                        GridViewQuestionGroups.DataBind();
                        Alert.ShowSaveSuccess();
                    }
                    else
                    {
                        Alert.ShowSaveFailed();
                    }
                    break;
            }
        }
        catch
        { 
            //do nothing.
            // this is for sorting only.
        }

        GridViewQuestionGroups.SelectedIndex = -1;
    }

    protected void GridViewQuestionGroups_RowDataBound(Object sender, GridViewRowEventArgs e)
    {
    }

    protected void gridViewPageSizeDdlChanged(Object sender, EventArgs e)
    {

        GridViewQuestionGroups.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);

    }

}
