﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="ToolQuestionGroupEdit.aspx.cs" Inherits="ToolQuestionGroupEdit" %>
<%@ Register src="controls/BaseControlCheckBox.ascx" tagname="BaseControlCheckBox" tagprefix="UserControl" %>
<%@ Register src="controls/BaseControlTextBox.ascx" tagname="BaseControlTextBox" tagprefix="UserControl" %>
<%@ Register src="controls/BaseControlRadioButtonListTextValue.ascx" tagname="BaseControlRadioButtonList" tagprefix="UserControl" %>
<%@ Register src="controls/UserControlToolQuestionPreview.ascx" tagname="UserControlToolQuestionPreview" tagprefix="UserControl" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">

</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
     <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="<H1>Follow-up Question Tool >  Edit Question Group</H1>"/>
    </div> 
   <asp:LinkButton ID="HyperLinkQuestionGroupList" runat="server" PostBackUrl="~/ToolQuestionGroupList.aspx" Text="Go to Question Group List" />
   &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
   <asp:HyperLink ID="HyperLinkAddQuestionGroupEdit" runat="server" NavigateUrl="~/ToolQuestionGroupEdit.aspx?id=0">Add New Question Group</asp:HyperLink>
   &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
   <asp:LinkButton ID="LinkButtonAddQuestion" runat="server" PostBackUrl="~/ToolQuestionEdit.aspx?id=0" Text="Add New Question" />
   &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
   <asp:LinkButton ID="HyperLinkQuestionList" runat="server" PostBackUrl="~/ToolQuestionList.aspx" Text="Go to Question List" />
   &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
   <asp:LinkButton ID="LinkButtonQuestionGroupPreview" runat="server" PostBackUrl="~/ToolQuestionGroupPreview.aspx?id=0" 
   Text="Preview Question Group" Visible="false" />
    <br /><br />
    <asp:Panel ID="PanelEditQuestionGroup" runat="server" GroupingText="Manage Question Group&nbsp;&nbsp;" Width="100%">
    <table>
        <tr>
        <td><UserControl:BaseControlTextBox ID="BaseControlTextboxFormName" runat="server" /></td>
        <td>&nbsp&nbsp&nbsp&nbsp</td>
        <td><asp:CheckBox ID="CheckboxSystemWideFlag" runat="server" Text="System Wide" ToolTip="Filter by System Wide Flag"/></td>
        </tr>
        <tr>
        <td colspan="3"><UserControl:BaseControlTextBox ID="BaseControlTextboxFormTitle" runat="server" /></td>
        </tr>
        <tr>
        <td colspan="3">
           <asp:Button ID="ButtonSaveQuestionGroup" runat="server" 
                Text="Save Question Group" ValidationGroup="SaveQuestionGroup" 
                onclick="ButtonSaveQuestionGroup_Click" />
            &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
             <asp:Button ID="ButtonSubmitQuestionGroup" runat="server" 
                Text="Submit Question Group" ValidationGroup="SubmitQuestionGroup" 
                OnClientClick="return confirm('No more updates will be allowed after submit. Click cancel if you are not ready to submit.');"
                onclick="ButtonSubmitQuestionGroup_Click" /> &nbsp&nbsp&nbsp&nbsp   
            <asp:CustomValidator ID="CustomValidatorSubmitQuestionGroup" runat="server" 
                ErrorMessage="There are some issues in the question group." 
                ValidationGroup="SubmitQuestionGroup" ForeColor="DarkRed"></asp:CustomValidator>   
        </td>
        </tr>

    </table>
    </asp:Panel>  
    <asp:Panel ID="PanelEditFormQuestion" runat="server" GroupingText="Manage Questions&nbsp;&nbsp;" Width="100%">
       <table>
        <tr>
            <td>
                <asp:Label SkinID="DataLabel" ID="LabelForTextBoxKeyWords" runat="server" Text="Filter By Key Words:"
                    AssociatedControlID="TextBoxKeyWords" ToolTip="Filter By Key Words" />
                <br />
                <asp:TextBox ID="TextBoxKeyWords" runat="server" Width="250" ToolTip="Filter By Key Words"></asp:TextBox>
                 &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                 
            </td>
            <td>
                <asp:Label SkinID="DataLabel" ID="LabelForDropDownListQuestionType" runat="server" Text="Filter By Type:"
                    AssociatedControlID="DropDownListQuestionType" ToolTip="Filter by Question Type" />
                <br />
                <asp:DropDownList runat='server' ID='DropDownListQuestionType' ToolTip='Filter by Question Type'>
                    <asp:ListItem Value='' Text='All' />
                    <asp:ListItem Value='multipleChoice' Text='Dropdown List - Mutiple Choice' />
                    <asp:ListItem Value='multiSelect' Text='Checkboxes - Mutliple Select' />
                    <asp:ListItem Value='text' Text='Radio Buttons with Free Text' />
                    <asp:ListItem Value='number' Text='Radio Buttons with Numeric Value' />
                </asp:DropDownList>
                &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
            </td>
            <td>
                <br />
                <asp:Button ID="ButtonSearch" runat="server" Text=" Filter " OnClick="ButtonSearch_Click" />
                &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick="ButtonClear_Click" />
                
            </td>
         </tr>
    </table>
        <asp:Panel runat='server' ID='PanelSearResults'  >
            <div style="text-align: right;" runat="server" id="pageSizeDiv2">
                    <asp:Label SkinID="DataLabel" ID="Label1" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl2"  Visible="true" ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl2" AutoPostBack="true" Visible="true" CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged2">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
        </div>
            <asp:GridView 
                ID="GridViewQuestions" 
                runat="server" 
                OnRowCommand = "GridViewQuestions_RowCommand"
                AutoGenerateColumns="False" Width="100%"
                DataSourceID="DataSourceFilterQuestions"
                AllowPaging="True" 
                AllowSorting="True" 
                Visible="true" 
                Caption="Add Questions to Group" 
                EnableModelValidation="True"
                DataKeyNames="TOOL_QUESTION_ID" >
                 <EmptyDataTemplate>
                    &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                    No Questions Found. &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</EmptyDataTemplate>
                  <Columns>
                     <asp:TemplateField HeaderText="Add to Group" SortExpression="" AccessibleHeaderText='Add to Group'>
                        <ItemStyle HorizontalAlign="Center" />
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            <asp:LinkButton runat='server' ID='LinkButtonEdit' CommandName='AddToGroup' 
                            CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TOOL_QUESTION_ID"))) %>' Text="Add to Group" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Preview" SortExpression="" AccessibleHeaderText='Preview'>
                        <ItemStyle HorizontalAlign="Center" />
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            <asp:LinkButton runat='server' ID='LinkButtonPreview' CommandName='Preview' CommandArgument='<%# Helpers.AhobprEval(Eval("TOOL_QUESTION_ID")) %>' Text="Preview Question" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Question ID" SortExpression="TOOL_QUESTION_ID">
                        <ItemStyle HorizontalAlign="Center" />
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle></ItemStyle>
                        <ItemTemplate>
                            <asp:Label ID="LabelQuestionID" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("TOOL_QUESTION_ID")) %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Question Text" SortExpression="TEXT">
                        <ItemStyle HorizontalAlign="Left" />
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle ></ItemStyle>
                        <ItemTemplate>
                            <asp:Label ID="LabelQuestionText" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("TEXT")) %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Key Words" SortExpression="KEY_WORDS">
                        <ItemStyle HorizontalAlign="Left" />
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle ></ItemStyle>
                        <ItemTemplate>
                            <asp:Label ID="LabelKeyWords" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("KEY_WORDS")) %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Type" SortExpression="TYPE">
                        <ItemStyle HorizontalAlign="Left" />
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle ></ItemStyle>
                        <ItemTemplate>
                            <asp:Label ID="LabelType" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("TYPE")) %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Min Value" SortExpression="MIN">
                        <ItemStyle HorizontalAlign="Left" />
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle ></ItemStyle>
                        <ItemTemplate>
                            <asp:Label ID="LabelMin" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("MIN")) %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Max Value" SortExpression="MAX">
                        <ItemStyle HorizontalAlign="Left" />
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle></ItemStyle>
                        <ItemTemplate>
                            <asp:Label ID="LabelMax" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("MAX")) %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
                <FooterStyle HorizontalAlign='Right' BackColor='White' />
            </asp:GridView>
       </asp:Panel>
    <br />
      <asp:Panel runat='server' ID='PanelFormQuestions'  > 
        <asp:Label ID = "LabelFormQuestion" Text = "Questions included in the group:" SkinID="DataLabel"
                            runat = "server" Font-Bold="true" ></asp:Label> 
          <div style="text-align: right;" runat="server" id="pageSizeDiv">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl"  Visible="true" ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true" Visible="true" CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
        </div>
        <asp:GridView 
        ID="GridViewFormQuestions" 
        runat="server" 
        OnRowCommand = "GridViewFormQuestions_RowCommand"
        AutoGenerateColumns="False" Width="100%"
        AllowPaging="True" 
        AllowSorting="True" 
        Visible="true" 
        Caption="The questions in the group" 
        EnableModelValidation="True"
        DataKeyNames="TOOL_QUESTION_ID"
        OnPageIndexChanging="GridViewFormQuestions_PageIndexChanging" >
         <EmptyDataTemplate>
            &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
            No Questions Found. &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</EmptyDataTemplate>
          <Columns>
             <asp:TemplateField HeaderText="Remove from Group" SortExpression="" AccessibleHeaderText='Remove from Group'>
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:LinkButton runat='server' ID='LinkButtonRemove' CommandName='RemoveFromGroup' 
                    CommandArgument='<%# Helpers.AhobprEval(Eval("TOOL_QUESTION_ID")) %>' Text="Remove from Group" />
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Preview"  AccessibleHeaderText='Preview'>
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:LinkButton runat='server' ID='LinkButtonPreview' CommandName='Preview' CommandArgument='<%# Helpers.AhobprEval(Eval("TOOL_QUESTION_ID")) %>' Text="Preview Question" />
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Question ID" >
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle></ItemStyle>
                <ItemTemplate>
                    <asp:Label ID="LabelQuestionID" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("TOOL_QUESTION_ID")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Question Text" >
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle ></ItemStyle>
                <ItemTemplate>
                    <asp:Label ID="LabelQuestionText" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("TEXT")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Type" >
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle ></ItemStyle>
                <ItemTemplate>
                    <asp:Label ID="LabelType" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("TYPE")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Min Value" >
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle ></ItemStyle>
                <ItemTemplate>
                    <asp:Label ID="LabelMin" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("MIN")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Max Value" >
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle></ItemStyle>
                <ItemTemplate>
                    <asp:Label ID="LabelMax" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("MAX")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
        <FooterStyle HorizontalAlign='Right' BackColor='White' />
    </asp:GridView>
    </asp:Panel>
   </asp:Panel>  
    <br />
   <asp:LinkButton ID="HyperLinkQuestionGroupListBottom" runat="server" PostBackUrl="~/ToolQuestionGroupList.aspx" Text="Go to Question Group List" />
   &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
   <asp:HyperLink ID="HyperLinkAddQuestionGroupEditBottom" runat="server" NavigateUrl="~/ToolQuestionGroupEdit.aspx?id=0">Add New Question Group</asp:HyperLink>
   &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
   <asp:LinkButton ID="LinkButtonAddQuestionBottom" runat="server" PostBackUrl="~/ToolQuestionEdit.aspx?id=0" Text="Add New Question" />
   &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
   <asp:LinkButton ID="HyperLinkQuestionListBottom" runat="server" PostBackUrl="~/ToolQuestionList.aspx" Text="Go to Question List" />
   &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
   <asp:LinkButton ID="LinkButtonQuestionGroupPreviewBottom" runat="server" PostBackUrl="~/ToolQuestionGroupPreview.aspx?id=0" 
    Visible="false" Text="Preview Question Group" />

    <asp:HiddenField ID="HiddenFieldFormId" runat="server" />
    <asp:HiddenField ID="HiddenFieldSystemWide" runat="server" />
    <asp:ObjectDataSource 
            ID="DataSourceFilterQuestions" runat="server" 
                SelectMethod="SearchQuestions" 
                SelectCountMethod="SearchQuestionsCount"
                StartRowIndexParameterName="startRow" 
                MaximumRowsParameterName="maxRows" 
                SortParameterName="sort"
                EnablePaging="True"  
                TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRToolManager">
            <SelectParameters>
                <asp:ControlParameter ControlID="TextBoxKeyWords" Name="keyWords" PropertyName="Text" Type="String" />
                <asp:ControlParameter ControlID="DropDownListQuestionType" Name="type" PropertyName="SelectedValue" Type="String" />
                <asp:Parameter Name="status" Type="String" DefaultValue="2" />
                <asp:Parameter Name="sort" Type="String" />
                <asp:Parameter Name="startRow" Type="Int32" />
                <asp:Parameter Name="maxRows" Type="Int32" />
           </SelectParameters>
    </asp:ObjectDataSource>    

</asp:Content>

