<%@ Page Title="Registrants" EnableEventValidation="false" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="SubpopulationFlag.aspx.cs" Inherits="SubpopulationFlag" %>
<%@ Register src="controls/UserControlRegistrant.ascx" tagname="UserControlRegistrant" tagprefix="UserControl" %>
<%@ Register src="controls/BaseControlListBox.ascx" tagname="BaseControlListBox" tagprefix="UserControl" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
     <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="<H1>Registrants > Registrant > Subpopulation Flags</H1>"/>
    </div>   
    <UserControl:UserControlRegistrant ID="UserControlRegistrant" runat="server" /> 
    <br />
    <asp:Panel ID="PanelSubpopulationFlags" runat="server" GroupingText=" Subpopulation Flags " >
    <asp:GridView ID = "GridViewSubpopulationFlags" 
        DataSourceID="ObjectDataSourceSubpopulationFlags" 
        ShowFooter = "True" 
        AutoGenerateColumns = "False" 
        runat ="server"
        Caption="Subpopulation Flags"    
        OnPreRender="GridViewSubpopulationFlags_PreRender"
        DataKeyNames = "REGISTRANT_REGISTRY_FLAG_ID" 
        OnRowCommand="GridViewSubpopulationFlags_RowCommand" 
        EmptyDataText="No Subpopulation Flags Available">
        <EmptyDataTemplate>
            <asp:Label ID="LabelforDropdownListSubpopulationFlagsEmpty" 
                        AssociatedControlID="DropdownListSubpopulationFlagsEmpty" SkinID="DataLabel"
                        runat="server" Text="Subpopulation Flag: &nbsp&nbsp&nbsp&nbsp"></asp:Label>  
             <asp:DropdownList ID="DropdownListSubpopulationFlagsEmpty" runat="server" 
                        ToolTip="Select Subpopulation Flag" DataSourceID="ObjectDataSourceSubpopulationFlagsLookupList"
                        DataTextField="NAME" DataValueField="ID">
             </asp:DropdownList> &nbsp&nbsp&nbsp&nbsp
            <asp:Button ID="ButtonEmptyAddCommand" runat="server" 
                Text="  Add  " 
                ToolTip="Add Subpopulation Flag" 
                CommandName="EMPTYADD" 
                CausesValidation="true" ValidationGroup = "RegistryFlagGroup" />
             
        </EmptyDataTemplate>
        <Columns>
          <asp:TemplateField HeaderText = "Subpopulation Flag" >
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID = "LabelSubpopulationFlag" runat = "server" SkinID="DataLabel" Text = '<%# Helpers.AhobprEval(Eval("STD_REGISTRY_FLAG.REGISTRY_FLAG_NAME")) %>'/>
                </ItemTemplate>
                <FooterTemplate>                                                                      
                    <asp:Label ID = "LabelforDropdownListSubpopulationFlags" Text = "Subpopulation Flag:<br />" SkinID="DataLabel"
                    runat = "server" AssociatedControlID="DropdownListSubpopulationFlags"  Font-Size="X-Small"></asp:Label> 
                    <asp:DropdownList ID="DropdownListSubpopulationFlags" runat="server" 
                        ToolTip="Select Subpopulation Flag" DataSourceID="ObjectDataSourceSubpopulationFlagsLookupList"
                        DataTextField="NAME" DataValueField="ID">
                    </asp:DropdownList>                </FooterTemplate> 
           </asp:TemplateField>
           <asp:TemplateField HeaderText = "Created Date Time">
               <HeaderStyle HorizontalAlign="Center" />
               <ItemTemplate>
                    <asp:Label ID = "LabelFlagCreationDate" runat = "server" SkinID="DataLabel" Text = '<%# Helpers.AhobprEval(Eval("CREATED")) %>'/>
                </ItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText = "Created By User" >
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID = "LabelFlagCreatedBy" runat = "server" SkinID="DataLabel" Text = '<%# Helpers.AhobprEval(Eval("CREATEDBY")) %>'/>
                </ItemTemplate>
             </asp:TemplateField>
            <asp:TemplateField HeaderText = "Flag Status"  SortExpression="ACTIVE_FLAG">
                <ItemStyle HorizontalAlign="Center" />
                <FooterStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID = "LabelActiveFlag" runat = "server" SkinID="DataLabel" Text = '<%# Convert.ToBoolean(Eval("STD_REGISTRY_FLAG.ACTIVE_FLAG")) ? "Active" : "Inactive" %>'/>
                </ItemTemplate>
                <FooterTemplate>
                    <br />
                    <asp:Label ID = "LabelActiveFlag" runat = "server" SkinID="DataLabel" Text = "Active" />
              </FooterTemplate>
            </asp:TemplateField>
            <asp:TemplateField >
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <FooterStyle HorizontalAlign="Center" />
                <ItemTemplate>
                   <asp:Button ID="ButtonDelete" runat="server"
                        Text="  Remove  "
                        Enabled = "true"
                        OnClientClick="return confirm('Are you sure you want to remove this Supopulation Flag? Click cancel if you do not want to remove.');"
                        ToolTip='<%# string.Format("Remove {0} from registrant subpopulation flag list", AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem,"STD_REGISTRY_FLAG.REGISTRY_FLAG_NAME")))) %>' 
                        CommandName="DELETE_FLAG" 
                        CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("REGISTRANT_REGISTRY_FLAG_ID"))) %>' 
                        CausesValidation="false"/>
                </ItemTemplate>
                <FooterTemplate>
                   <br />
                   <asp:Button Text="  Add  " ToolTip="Add Subpopulation Flag" CommandName="ADD" CausesValidation="true" runat="server" ID="ButtonAddCommand" 
                   ValidationGroup = "RegistryFlagGroup"  />&nbsp;
                </FooterTemplate>
            </asp:TemplateField>
        </Columns>
    </asp:GridView>
    <asp:ObjectDataSource ID="ObjectDataSourceSubpopulationFlags" runat="server" 
        SelectMethod="SelectRegistrantSubpopulationFlags" 
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRRegistrantManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="HiddenFieldRegistrantId" Name="registrantId" PropertyName="Value" Type="String" />
    </SelectParameters>
    </asp:ObjectDataSource>

     <asp:ObjectDataSource ID="ObjectDataSourceSubpopulationFlagsLookupList" runat="server" 
            SelectMethod="SelectLookupList" TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRBaseControlManager" >
        <SelectParameters>
            <asp:Parameter Name="lookupCategory" Type="String" DefaultValue="SUBPOPULATION_FLAG_ACTIVE" />
        </SelectParameters>
    </asp:ObjectDataSource>
    </asp:Panel>
    
    <asp:HiddenField ID="HiddenFieldRegistrantId" runat="server" />
</asp:Content>

