﻿<%@ Page Title="" Language="C#" EnableEventValidation="false" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="ReportFollowupQuestions.aspx.cs" Inherits="ReportFollowupQuestions" %>

<%@ Register Assembly="Microsoft.ReportViewer.WebForms, Version=11.0.0.0, Culture=neutral, PublicKeyToken=89845dcd8080cc91"
    Namespace="Microsoft.Reporting.WebForms" TagPrefix="rsweb" %>
<%@ Register Src="controls/BaseControlListBox.ascx" TagName="BaseControlListBox" TagPrefix="UC" %>
<%@ Register Src="controls/BaseControlDropDownList.ascx" TagName="BaseControlDropDownList"
    TagPrefix="UserControl" %>
<%@ Register Src="controls/BaseControlRadioButtonList.ascx" TagName="BaseControlRadioButtonList"
    TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlReportLocation.ascx" TagName="UserControlReportLocation"
    TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlFromToDate.ascx" TagName="UserControlFromToDate"
    TagPrefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID="LabelBreadCrumb" runat="server" Text="<H1>Reporting > Follow-up Questions Report</H1>" />
    </div>
    <br />
    <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
    <asp:Panel ID="PanelReportFollowupQuestions" runat="server" GroupingText=" Selection Criteria (Please select at least one)" Width="100%">
        <div class="excludeSaveWarnings">
            <table>
                <tr>
                    <td>
                        <asp:Panel ID="PanelQuestions" runat="server" GroupingText="Follow-up Questions Completion"
                            ToolTip="Follow-up Questions Completion is an indication of questions completed. The Selection Criteria allows the user to filter by All, Not Competed and Completed (with a date range) questions.">
                            <asp:RadioButtonList ID="RadioButtonQuestionsCompletion" runat="server" RepeatDirection="Horizontal"
                                ToolTip="Follow Questions Completion Status" AutoPostBack="true" OnSelectedIndexChanged="RadioButtonQuestionsCompletion_SelectedIndexChanged">
                                <asp:ListItem Selected="True">All</asp:ListItem>
                                <asp:ListItem>Completed</asp:ListItem>
                                <asp:ListItem>Not Completed</asp:ListItem>
                            </asp:RadioButtonList>
                        </asp:Panel>
                    </td>
                </tr>
                <tr>
                    <td>
                        <UserControl:UserControlFromToDate ID="UserControlDateRange" Visible="false" runat="server" />
                    </td>
                </tr>
                <tr>
                    <td>
                        <UC:BaseControlListBox ID="BaseControlListBoxQuestionGroup" runat="server" LocationFriendlyName="Question Group"  />
                    </td>


                </tr>
            </table>
            <asp:Panel ID="PanelButtons" runat="server" Width="100%" Visible="true">
                <table>
                    <tr>
                        <td>
                            <asp:Button runat="server" ID="ButtonRunReport" Text="Run Report" OnClick="ButtonRunReport_Click"
                                Width="120px" ValidationGroup="QuestionGroup" />
                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                            <asp:Button ID="ButtonPrintReport" runat="server" Text="Print/Export Report" Width="150px"
                                ValidationGroup="QuestionGroup" OnClick="ButtonPrintReport_Click" Style="margin-left: 0px; margin-top: 8px" />
                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp
                            <asp:Button runat="server" ID="ButtonClear" Text="Clear" Width="120px" OnClick="ButtonClear_Click" />
                            
                        </td>
                    </tr>
                </table>
            </asp:Panel>
        </div>
    </asp:Panel>
    <asp:Panel ID="PanelReportViewer" runat="server">
        <rsweb:ReportViewer ID="ReportViewerReport" runat="server" Width="100%" ProcessingMode="Remote"
            Height="700px">
        </rsweb:ReportViewer>
    </asp:Panel>
    <asp:Panel ID="PanelFollowupQuestions" runat="server" Visible="false" GroupingText=" Report Results ">
        <asp:Label runat="server" ID="LabelNumberOfResultsFound" Font-Bold="true"></asp:Label>
        <div style="text-align: right;" runat="server" id="pageSizeDiv">
            <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                AssociatedControlID="gridViewPageSizeDdl" Visible="false" ToolTip="Items per page" />

            <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true" Visible="false" CausesValidation="false" ToolTip="Items per page"
                OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                <asp:ListItem Text="10" Value="10"></asp:ListItem>
                <asp:ListItem Text="25" Value="25"></asp:ListItem>
                <asp:ListItem Text="50" Value="50"></asp:ListItem>
                <asp:ListItem Text="100" Value="100"></asp:ListItem>
            </asp:DropDownList>
        </div>
        <asp:GridView ID="GridViewFollowupQuestions" runat="server" DataSourceID="DataSourceFollowupQuestions"
            AutoGenerateColumns="False" PageSize="20" Width="100%" AllowPaging="True" AllowSorting="True"
            Caption="To sort please click table headings"
            OnRowCommand="GridViewFollowupQuestions_RowCommand" DataKeyNames="REGISTRANT_ID" PagerSettings-Mode="Numeric"
            OnPageIndexChanging="gridView_PageIndexChanging">
            <EmptyDataTemplate>
                No match found. Please verify the information you entered in the search criteria.
            </EmptyDataTemplate>
            <Columns>
                <asp:TemplateField Visible="false" HeaderText="ID" SortExpression="REGISTRANT_ID"
                    ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:LinkButton ID="LinkButtonRegistrantID" runat="server" CommandArgument='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID"))  %>'
                            CommandName="Details" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID")) %>'>
                        </asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Registrant Name" SortExpression="Name">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:LinkButton ID="LinkButtonRegistrantName" runat="server" CommandArgument='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID"))  %>'
                            CommandName="Details" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Name")) %>'>
                        </asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Last 4 of SSN" SortExpression="Last4SSN">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="Label4SSN" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Last4SSN")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Question Group Name" SortExpression="QuestionsGroupName">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelQuestionsGroupName" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("QuestionsGroupName")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Sent Date" SortExpression="SentDate">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelSendDate" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("SentDate")).Length > 0 ? Convert.ToDateTime(Helpers.AhobprEval(Eval("SentDate"))).ToString("MM/dd/yyyy") : string.Empty %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Follow-up Questions<br />Completed Date" SortExpression="QuestionsCompleteDate">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelQuestionCompleteDate" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("QuestionsCompleteDate")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
            <HeaderStyle HorizontalAlign="Left" />
        </asp:GridView>
    </asp:Panel>
    <asp:ObjectDataSource ID="DataSourceFollowupQuestions" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetFollowupQuestions" EnablePaging="true" StartRowIndexParameterName="startRowIndex"
        MaximumRowsParameterName="maximumRows" SortParameterName="SortExpression" SelectCountMethod="GetFollowupQuestionsCount"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRReportManager"
        OnSelected="DataSourceFollowupQuestions_Selected">
        <SelectParameters>
            <asp:ControlParameter ControlID="UserControlDateRange" Name="fromDateText" PropertyName="FromDateValue"
                Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRange" Name="toDateText" PropertyName="ToDateValue"
                Type="String" />
            <asp:ControlParameter ControlID="RadioButtonQuestionsCompletion" Name="questionsCompletion" PropertyName="Text"
                Type="String" />
            <asp:ControlParameter ControlID="BaseControlListBoxQuestionGroup" Name="questionGroup" PropertyName="Text"
                Type="string" />

            <asp:Parameter Name="totalRecords" Type="Int32" Direction="Output" />
        </SelectParameters>
    </asp:ObjectDataSource>

</asp:Content>
