﻿<%@ Page Title="" EnableEventValidation="false" Language="C#" MasterPageFile="~/Registry.master"
    AutoEventWireup="true" CodeFile="ReportAdHoc.aspx.cs" Inherits="ReportAdHoc" %>

<%@ Register Assembly="Microsoft.ReportViewer.WebForms, Version=11.0.0.0, Culture=neutral, PublicKeyToken=89845dcd8080cc91"
    Namespace="Microsoft.Reporting.WebForms" TagPrefix="rsweb" %>
<%@ Register Src="controls/BaseControlListBox.ascx" TagName="BaseControlListBox"
    TagPrefix="UserControl" %>
<%@ Register Src="controls/BaseControlDropDownList.ascx" TagName="BaseControlDropDownList"
    TagPrefix="UserControl" %>
<%@ Register Src="controls/BaseControlRadioButtonList.ascx" TagName="BaseControlRadioButtonList"
    TagPrefix="UserControl" %>
<%@ Register Src="controls/BaseControlTextBox.ascx" TagName="BaseControlTextBox"
    TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlReportLocation.ascx" TagName="UserControlReportLocation"
    TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlAdminFlagFilter.ascx" TagName="UserControlAdminFlagFilter"
    TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlFacilityDropdownLists.ascx" TagName="UserControlFacilityDropdownLists"
    TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlFromToDate.ascx" TagName="UserControlFromToDate"
    TagPrefix="UserControl" %>
<%@ Register Src="controls/BaseControlListBox.ascx" TagName="BaseControlListBox" TagPrefix="UC" %>
<%@ Register Src="controls/UserControlDutyStatusUpdate.ascx" TagName="UserControlDutyStatusUpdate"
    TagPrefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">

    <script type="text/javascript">
        $(document).ready(function() {
            $("#<%= DropDownListQuestion.ClientID %>").change(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });

            $('#<%= BaseControlDropDownListSubpopulationFlag.ClientID + "_DropDownListID" %>').change(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });

            $('#<%= UserControlAdminFlagFilter.ClientID + "_DropDownListAdminFlag" %>').change(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });

            $('#<%= UserControlReportLocationAssigned.ClientID + "_RadioButtonListLocation_0" %>').click(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });
            $('#<%= UserControlReportLocationAssigned.ClientID + "_RadioButtonListLocation_1" %>').click(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });
            $('#<%= UserControlReportLocationAssigned.ClientID + "_RadioButtonListLocation_2" %>').click(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });

            $('#<%= UserControlReportLocationEvaluation.ClientID + "_RadioButtonListLocation_0" %>').click(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });
            $('#<%= UserControlReportLocationEvaluation.ClientID + "_RadioButtonListLocation_1" %>').click(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });
            $('#<%= UserControlReportLocationEvaluation.ClientID + "_RadioButtonListLocation_2" %>').click(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });

            $('#<%= RadioButtonListHealthConcerns.ClientID %>').click(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });
            $('#<%= RadioButtonListHealthConcerns.ClientID %>').click(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });
            $('#<%= RadioButtonListHealthConcerns.ClientID %>').click(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });

            $('#<%= PanelRadioButtonRequestToBeSeen.ClientID %>').click(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });
            $('#<%= PanelRadioButtonRequestToBeSeen.ClientID %>').click(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });
            $('#<%= PanelRadioButtonRequestToBeSeen.ClientID %>').click(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });

            $('.textInput').change(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelAdHocReport.ClientID %>').hide();
            });
        });
    </script>

    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID="LabelBreadCrumb" runat="server" Text="<H1>Reporting > Ad Hoc Report by Individual</H1>" />
    </div>
    <br />
    <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
    <asp:Panel ID="PanelSelectParameters" runat="server" GroupingText=" Select the Data Elements for Ad Hoc Report - Step 1 of 2 (Please select at least one)">
        <asp:LinkButton ID="LinkButtonReportSearchCriteria" runat="server">Click here to load or delete saved search criteria</asp:LinkButton>
        <table cellspacing="8">
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxRegistrantStatus" runat="server" Text="Registrant Status" alt="Registrant Status is the status of the registrant’s questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses."
                        ToolTip="Registrant Status is the status of the registrant’s questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses." />
                </td>
                <td>
                    <asp:CheckBox ID="CheckBoxDutyStatus" runat="server" Text="Duty Status (Active Duty, Guard/Reserve, Retiree, Separated, or Unknown)" alt="Duty Status is the military standing of the registrant: Active Duty, Guard/Reserve, Retiree, Separated, or Unknown. The Selection Criteria allows the user to filter with one or more statuses."
                        ToolTip="Duty Status is the military standing of the registrant: Active Duty, Guard/Reserve, Retiree, Separated, or Unknown. The Selection Criteria allows the user to filter with one or more statuses." />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxLocation" runat="server" Text="Location (VISN or Facility)" alt="Location has two filter options: the Facility that a registrant is (1) assigned or (2) had their AHOBPR Evaluation as reported in CDW. The Selection Criteria allows the user to filter with all locations, one VISN, one Main Facility, or one Sub-Facility, or Registrants who are has no location reported."
                        ToolTip="Location has two filter options: the Facility that a registrant is (1) assigned or (2) had their AHOBPR Evaluation as reported in CDW. The Selection Criteria allows the user to filter with all locations, one VISN, one Main Facility, or one Sub-Facility, or Registrants who are has no location reported." />
                </td>
                <td>
                    <asp:CheckBox ID="CheckBoxHealthConcerns" runat="server" Text="Health Concerns? Yes/No (Yes=any positive response to Q3.A-3.K)" alt="Health Concerns is any positive response to Q3.A–3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers."
                        ToolTip="Health Concerns is any positive response to Q3.A–3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers." />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxHealthFactor" runat="server" Text="Health Factor" alt="Health Factors are entered into the CPRS Template by a Health Care Provider during the Clinical Exposure Evaluation.  This data will only be available for registrants in Participant status and have had a Clinical Exposure Evaluation.  The Selection Criteria allows the user to filter with one or more health factors." ToolTip="Health Factors are entered into the CPRS Template by a Health Care Provider during the Clinical Exposure Evaluation.  This data will only be available for registrants in Participant status and have had a Clinical Exposure Evaluation.  The Selection Criteria allows the user to filter with one or more health factors." />
                </td>
                <td>
                    <asp:CheckBox ID="CheckBoxRequestToBeSeen" runat="server" Text="Request to be seen? Yes/No (Yes=any positive response to Q7.B)" alt="Request to be Seen is a positive response to Q7.B by the registrant.  This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, yes answers, or no answers."
                        ToolTip="Request to be Seen is a positive response to Q7.B by the registrant.  This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, yes answers, or no answers." />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxSubpopulationFlag" runat="server" Text="Subpopulation Flag"
                        ToolTip="Subpopulation Flag is a flag on the registrant record set by a Clinical Portal user.  The Selection Criteria allows the user to filter with one subpopulation flag." />
                    <br />
                    <br />
                    <asp:CheckBox ID="CheckBoxAdminFlag" runat="server" Text="Admin Flag" ToolTip="Admin Flag is a flag on the registrant record set by a Clinical Portal user.  A registrant record could have more than one of the same Admin Flag.  The Selection Criteria allows the user to filter with one Admin Flag and a date range the flag was set." />
                </td>
                <td>
                    <asp:Panel ID="PanelDeploymentCountry" runat="server" GroupingText="Deployment Country"
                        ToolTip="Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by all deployments or deployments that have exposure responses.  The data for deployments that have exposure responses will only be available for registrants in Participant status.">
                        <asp:RadioButtonList ID="RadioButtonListDeploymentCountry" runat="server" RepeatDirection="Horizontal"
                            ToolTip="Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by all deployments or deployments that have exposure responses.  The data for deployments that have exposure responses will only be available for registrants in Participant status.">
                            <asp:ListItem Selected="True">None</asp:ListItem>
                            <asp:ListItem>All Deployments</asp:ListItem>
                            <asp:ListItem>Deployments With Exposure Responses</asp:ListItem>
                        </asp:RadioButtonList>
                    </asp:Panel>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxQuestion" runat="server" Text="Response to specific question"
                        ToolTip="Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses." />
                    <br />
                    <br />
                </td>
                <td>
                    <asp:Panel ID="PanelFormStartEndDate" runat="server" GroupingText="Date Range for Questionnaire"
                        ToolTip="Date Range for Questionnaire is the Start Date or Completed Date for a registrants questionnaire. The Selection Criteria allows the user to filter by a date range for Start Date, Completed Date, or no date range. ">
                        <asp:RadioButtonList ID="RadioButtonListStartEndDate" runat="server" RepeatDirection="Horizontal"
                            ToolTip="Date Range for Questionnaire is the Start Date or Completed Date for a registrants questionnaire. The Selection Criteria allows the user to filter by a date range for Start Date, Completed Date, or no date range. ">
                            <asp:ListItem Selected="True">None</asp:ListItem>
                            <asp:ListItem>Questionnaire Start Date</asp:ListItem>
                            <asp:ListItem>Questionnaire Completed Date</asp:ListItem>
                        </asp:RadioButtonList>
                    </asp:Panel>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxDeathFlag" runat="server" Text="Death Flag" ToolTip="Death Flag is set when a Registrant is deceased. The Selection Criteria allows the user to exclude registrants that are deceased." />
                </td>
                <td>
                    <asp:CheckBox ID="CheckBoxRace" runat="server" Text="Race" ToolTip="Race is the hereditary group to which the registrant identifies with. The Selection Criteria allows the user to filter by one Race." />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxGender" runat="server" Text="Gender" ToolTip="Gender is the sex of the registrant. The Selection Criteria allows the user to filter by one Gender." />
                </td>
                <td>
                    <asp:CheckBox ID="CheckBoxEthnicity" runat="server" Text=" Ethnicity" ToolTip=" Ethnicity is the ethnic affiliation of the Registrant. The Selection Criteria allows the user to filter by one Ethnicity." />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxEnrollmentStatus" runat="server" Text="Health Care (VA Care) Enrollment Status"
                        ToolTip="Health Care Enrollment Status is the Registrant’s status in VA Care. The Selection Criteria allows the user to filter by one Health Care Enrolment Status." />
                </td>
                 <td>
                    <asp:CheckBox ID="CheckBoxEvaluation" runat="server" Text=" AHOBPR Evaluation" ToolTip=" AHOBPR Evaluation is the Registrant’s in-person evaluation status. The Selection Criteria allows the user to filter by if the Registrant has had an in-person evaluation or not." />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxDateRangeCurrentStatus" runat="server" Text="Date Range for Registrant Current Status"
                        ToolTip="Date Range for Registrant Current Status is the date of the current status.  The Selection Criteria allows the user to filter by a date range for the current status or all statuses within the date range." />
                </td>
                  <td>
                    <asp:CheckBox ID="CheckBoxClosestFacility" runat="server" Text="Closest Facility" ToolTip=" Closest Facility is the registrant’s closest VA medical facility. The Selection Criteria allows the user to filter by registrants' closest facility." />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxSeparationType" runat="server" Text="Separation Type" Visible="false" ToolTip="Separation Type is reason for the Registrants most recent separation.  The Selection Criteria allows the user to filter by one Separation Type." />
                </td>
                <td>
                    <asp:CheckBox ID="CheckBoxSeparationDate" runat="server" Text="Separation Date" Visible="false" ToolTip="Separation date is the date of the Registrants most recent separation. The Selection Criteria allows the user to filter for a separation date within a date range." />
                </td>
            </tr>
            <tr>
                  <td>
                    <asp:CheckBox ID="CheckBoxState" runat="server" Text="Registrant Address State" ToolTip="State is the state from the current addresses a Registrant has in AHOBPR.  The Selection Criteria allows a user to filter with one or more states." />
                </td>
                 <td>
                    <asp:CheckBox ID="CheckBoxContactPreference" runat="server" Text="Contact Preference" ToolTip="Contact Preference is for the preferred method of being contacted. The Selection Criteria allows a user to filter by a contact preference." />
                </td>
            </tr>
             <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxEmail" runat="server" Text="Email" ToolTip="Registrant Email is the email the registrant entered into contact information. The Selection Criteria allows a user to filter by registrants with or without email addresses." />
                </td>
                <td>
                    <asp:CheckBox ID="CheckBoxDeploymentIndicators" runat="server" Text="Deployment Indicators" ToolTip="Post 9/11 indicates that an individual deployed to a combat theatre in support of a Post 9/11 overseas contingency operation. Pre 9/11 indicates that an individual was known to have deployed at least once to theater during the GW I era that ended with 9/11. The Selection Criteria allows a user to filter y a deployment indicator." />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxDeploymentStage" runat="server" Text="Deployment Stage" ToolTip="Deployment Stage indicated if a deployment has been reviewed. The Selection Criteria allows a user to filter by Registrants that have at least one deployment in the Stage selected." />
                </td>
                <td>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <asp:Button runat="server" ID="ButtonNext" Text=" Go to Step 2 " OnClick="ButtonNext_Click"
                        ValidationGroup="SelectDataElements" />                    
                    <asp:CustomValidator ID="CustomValidatorSelectDataElements" runat="server" SetFocusOnError="true"
                        ErrorMessage="Please select at least one data element." ValidationGroup="SelectDataElements"
                        ForeColor="DarkRed"></asp:CustomValidator>
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp
                    <asp:Button runat="server" ID="ButtonClearSelection" Text="Clear" Width="120px" OnClick="ButtonClearSelection_Click" />
                </td>
            </tr>
        </table>
    </asp:Panel>
    <asp:Panel ID="PanelParameterAdHocReport" runat="server" GroupingText=" Selection Criteria - Step 2 of 2 (Please select at least one)">
        <asp:LinkButton ID="LinkButtonReportSearchCriteriaStep2" runat="server">Click here to load or delete saved search criteria</asp:LinkButton>
        <br />
        <asp:Panel ID="PanelLocation" runat="server" GroupingText="Assigned Location" Width="200"
            ToolTip="Assigned Location is a VISN or Facility that a registrant is assigned to as reported in CDW. The Selection Criteria allows the user to filter with all locations, one VISN, Main Facility, or one Sub-Facility, or Registrants who are not assigned.">
            <asp:RadioButtonList ID="RadioButtonListLocation" runat="server" RepeatDirection="Horizontal"
                RepeatLayout="Table" ToolTip="Location is a VISN or Facility that a registrant is assigned to as reported in CDW. The Selection Criteria allows the user to filter on all VISNs or all Facilities.">
                <asp:ListItem Text="VISN" Selected="True" />
                <asp:ListItem Text="Facility" />
            </asp:RadioButtonList>
        </asp:Panel>
        <UserControl:UserControlReportLocation ID="UserControlReportLocationAssigned" runat="server" />
        <UserControl:UserControlReportLocation ID="UserControlReportLocationEvaluation" runat="server" />
        <asp:Panel ID="PanelClosestFacility" runat="server">
            <UserControl:UserControlFacilityDropdownLists ID="UserControlFacilityDropdownLists" runat="server" ClosestFacility="true" />
        </asp:Panel>        
        <asp:Panel ID="PanelQuestion" runat="server" ToolTip="Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.">
            <asp:Label SkinID="DataLabel" ID="LabelForDropDownListQuestion" runat="server" Text="Questions:"
                AssociatedControlID="DropDownListQuestion" ToolTip="Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses." />
            <asp:DropDownList runat="server" ID="DropDownListQuestion" Width="900" AutoPostBack="true"
                EnableClientScript="true" ToolTip="Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses."
                OnSelectedIndexChanged="QuestionDropDownList_SelectedIndexChanged" />
            <br />
            <UserControl:BaseControlListBox ID="BaseControlListBoxAnswer" runat="server" Visible="false"
                Tooltip="Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses." />
        </asp:Panel>
        <asp:Panel ID="PanelQuestionnaireDate" runat="server">
            <UserControl:UserControlFromToDate ID="UserControlDateRangeFormStartDate" runat="server" />
            <UserControl:UserControlFromToDate ID="UserControlDateRangeFormToDate" runat="server" />
        </asp:Panel>
        <UserControl:BaseControlDropDownList ID="BaseControlDropDownListSubpopulationFlag"
            runat="server" />
        <UserControl:UserControlAdminFlagFilter ID="UserControlAdminFlagFilter" runat="server" />
        <asp:Panel ID="PanelHealthConcerns" runat="server">
            <table cellspacing="6">
                <tr>
                    <td>
                        <asp:Panel ID="PanelRadioButtonHealthConcerns" runat="server" GroupingText="Health Concerns? Yes/No (Yes=any positive response to Q3.A-3.K)"
                            ToolTip="Health Concerns is any positive response to Q3.A–3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers.">
                            <asp:RadioButtonList ID="RadioButtonListHealthConcerns" runat="server" RepeatDirection="Horizontal"
                                RepeatLayout="Table" ToolTip="Health Concerns is any positive response to Q3.A–3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers.">
                                <asp:ListItem Text="All" Selected="True" />
                                <asp:ListItem Text="Yes" />
                                <asp:ListItem Text="No" />
                            </asp:RadioButtonList>
                        </asp:Panel>
                    </td>
                    <td>
                        <asp:Panel ID="PanelRadioButtonRequestToBeSeen" runat="server" GroupingText="Request to be seen? Yes/No (Yes=any positive response to Q7.B)"
                            ToolTip="Request to be Seen is a positive response to Q7.B by the registrant.  This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, yes answers, or no answers.">
                            <asp:RadioButtonList ID="RadioButtonListRequestToBeSeen" runat="server" RepeatDirection="Horizontal"
                                RepeatLayout="Table" ToolTip="Request to be Seen is a positive response to Q7.B by the registrant.  This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, yes answers, or no answers.">
                                <asp:ListItem Text="All" Selected="True" />
                                <asp:ListItem Text="Yes" />
                                <asp:ListItem Text="No" />
                            </asp:RadioButtonList>
                        </asp:Panel>
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="PanelStatus" runat="server">
            <table cellspacing="6">
                <tr>
                    <td>
                        <UserControl:BaseControlListBox ID="BaseControlListBoxStatus" runat="server" />
                    </td>
                     <td>
                        <UserControl:UserControlDutyStatusUpdate ID="UserControlDutyStatusUpdate" runat="server" />
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="PanelState" runat="server">
            <table cellspacing="6">
                <tr>
                    <td>
                        <UserControl:BaseControlListBox ID="BaseControlListBoxState" runat="server" />
                    </td>
                </tr>
            </table>
        </asp:Panel>
         <asp:Panel ID="PanelContactPreference" runat="server">
            <table cellspacing="6">
                <tr>
                    <td>
                        <UserControl:BaseControlDropDownList ID="BaseControlDropDownListContactPreference" runat="server" />
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="PanelEmail" runat="server">
            <table cellspacing="6">
                <tr>
                    <td>
                        <asp:Panel ID="PanelRadioButtonEmail" runat="server" GroupingText="Email? Yes/No (Yes=Registrants with an Email address)"
                            ToolTip="Registrant Email is the email the registrant entered into contact information. The Selection Criteria allows a user to filter by registrants with or without email addresses.">
                            <asp:RadioButtonList ID="RadioButtonListEmail" runat="server" RepeatDirection="Horizontal"
                                RepeatLayout="Table" ToolTip="Radio button for if the Registrant has a Email address.">
                                <asp:ListItem Text="All" Selected="True" />
                                <asp:ListItem Text="Yes" />
                                <asp:ListItem Text="No" />
                            </asp:RadioButtonList>
                        </asp:Panel>
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="PanelDeploymentIndicators" runat="server">
            <table cellspacing="6">
                <tr>
                    <td>
                        <asp:Panel ID="PanelRadioButtonDeploymentIndicators" runat="server" GroupingText="Deployment Indicators"
                            ToolTip="Post 9/11 indicates that an individual deployed to a combat theater in support of a Post 9/11 overseas contingency operation. Pre 9/11 indicates that an individual was known to have deployed at least once to theater during the GW I era that ended with 9/11. The Selection Criteria allows a user to filter by one deployment indicator.">
                            <asp:RadioButtonList ID="RadioButtonListDeploymentIndicators" runat="server" RepeatDirection="Horizontal"
                                RepeatLayout="Table" ToolTip="Radio button for if the Registrant has a email address.">
                                <asp:ListItem Text="All" Selected="True" />
                                <asp:ListItem Text="Pre 9/11 Deployment (Gulf War)" Value ="Pre 911"/>
                                <asp:ListItem Text="Post 9/11 Deployment (OIF, OEF, OND)" Value ="Post 911" />
                            </asp:RadioButtonList>
                        </asp:Panel>
                    </td>
                </tr>
            </table>
        </asp:Panel>
         <asp:Panel ID="PanelDeploymentStage" runat="server">
            <table cellspacing="6">
                <tr>
                    <td>
                        <UserControl:BaseControlDropDownList ID="BaseControlDropDownListDeploymentStage" runat="server" />
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="PanelHealthFactorDeployment" runat="server">
            <UserControl:BaseControlDropDownList ID="BaseControlDropDownListDeploymentCountryAll"
                runat="server" />
            <UserControl:BaseControlDropDownList ID="BaseControlDropDownListDeploymentCountryExposure"
                runat="server" />
            <UserControl:BaseControlListBox ID="BaseControlListBoxHealthFactor" runat="server" />
            <asp:Panel ID="PanelRadioButtonEvaluation" runat="server" GroupingText="AHOBPR Evaluation? Yes/No (Yes=Registrants with an AHOBPR Evaluation)"
                            ToolTip="AHOBPR Evaluation is the Registrant’s in-person evaluation status. The Selection Criteria allows the user to filter by if the Registrant has had an in-person evaluation or not">
                            <asp:RadioButtonList ID="RadioButtonListEvaluation" runat="server" RepeatDirection="Horizontal"
                                RepeatLayout="Table" ToolTip="AHOBPR Evaluation.">
                                <asp:ListItem Text="All" Selected="True" />
                                <asp:ListItem Text="Yes" />
                                <asp:ListItem Text="No" />
                            </asp:RadioButtonList>
            </asp:Panel>
                    
        </asp:Panel>
        <asp:Panel ID="PanelDemographicData" runat="server">
            <table cellspacing="6">
                <tr>
                    <td>
                        <UserControl:BaseControlDropDownList ID="BaseControlDropDownListRace" runat="server" />
                    </td>
                    <td>
                        <UserControl:BaseControlDropDownList ID="BaseControlDropDownListGender" runat="server" />
                    </td>
                </tr>
            </table>
            <table cellspacing="6">
                <tr>
                    <td>
                        <UserControl:BaseControlDropDownList ID="BaseControlDropDownListSeparationType" runat="server" />
                    </td>
                    <td>
                        <UserControl:BaseControlDropDownList ID="BaseControlDropDownListEthnicity" runat="server" />
                    </td>
                </tr>
            </table>
            <asp:Panel ID="PanelSeparation" runat="server" GroupingText="Separation Date">
                <table>
                    <tr>
                        <td>
                            <UserControl:UserControlFromToDate ID="UserControlDateRangeSeparation" runat="server" />
                        </td>
                    </tr>
                </table>
            </asp:Panel>
            <table cellspacing="6">
                <tr>
                    <td>
                        <UserControl:UserControlFromToDate ID="UserControlCurrentStatusFromToDate" runat="server" />
                    </td>
                </tr>
            </table>
            <table cellspacing="6">
                <tr>
                <td>
                        <asp:Panel ID="PanelDeathFlag" runat="server" GroupingText="Death Flag"
                            ToolTip=" Death Flag is set when a Registrant is deceased. The Selection Criteria allows the user to exclude registrants that are deceased.">
                            <asp:RadioButtonList ID="RadioButtonListDeathFlag" runat="server" RepeatDirection="Horizontal"
                                RepeatLayout="Table" ToolTip="Death Flag is set when a Registrant is deceased. The Selection Criteria allows the user to exclude registrants that are deceased.">
                                <asp:ListItem Text="All" Selected="True"  Value="N" />
                                <asp:ListItem Text="Exclude All Registrants with Death Flag" Value="Y" />
                            </asp:RadioButtonList>
                        </asp:Panel>
                    </td>
                    <td>
                        <UserControl:BaseControlDropDownList ID="BaseControlDropDownListEnrollmentStatus"  runat="server" />
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:CustomValidator ID="CustomValidatorStep2" runat="server" SetFocusOnError="true"
            ErrorMessage="Please select at least one search criteria.<br />" ValidationGroup="OnRunReport"
            ForeColor="DarkRed"></asp:CustomValidator>
        <asp:Panel ID="PanelButtons" runat="server" Width="100%" Visible="true">
            <table>
                <tr>
                    <td>
                        <asp:Button runat="server" ID="ButtonRunReport" Text="Run Report" OnClick="ButtonRunReport_Click"
                            Width="120px" ValidationGroup="OnRunReport" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <asp:Button ID="ButtonPrintReport" runat="server" Text="Print/Export Report" Width="150px"
                            ValidationGroup="OnRunReport" OnClick="ButtonPrintReport_Click" Style="margin-left: 0px;
                            margin-top: 8px" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <UserControl:BaseControlTextBox ID="BaseControlTextBoxSearchCriteriaName" runat="server"
                            Visible="false" />
                        <asp:Button ID="ButtonSaveSearchCriteria" runat="server" Text="Save Search Criteria"
                            Width="200px" ValidationGroup="OnSaveSearchCriteria" OnClick="ButtonSaveSearchCriteria_Click"
                            Style="margin-left: 0px; margin-top: 8px" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp
                        <asp:Button runat="server" ID="ButtonClear" Text="Clear" Width="120px" OnClick="ButtonClear_Click" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp
                        <asp:Button runat="server" ID="ButtonBack" Text="Back to Step 1" OnClick="ButtonBack_Click" />
                    </td>
                </tr>
            </table>
        </asp:Panel>
    </asp:Panel>
    <asp:Panel ID="PanelReportViewer" runat="server">
        <rsweb:ReportViewer ID="ReportViewerReport" runat="server" Width="100%" ProcessingMode="Remote"
            Height="700px">
        </rsweb:ReportViewer>
    </asp:Panel>
    <asp:Panel ID="PanelAdHocReport" runat="server" GroupingText=" Report Results ">
        <center>
            <asp:Label ID="LabelReportCriteria" runat="server" Text="" Font-Bold="true" Font-Size="Large"></asp:Label></center>
        <asp:Label runat="server" ID="LabelNumberOfResultsFound" Font-Bold="true"></asp:Label>
        <div style="text-align: right;" runat="server" id="pageSizeDiv">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl"   ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true"  CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
        </div>
        <asp:GridView ID="GridViewAdHocReport" runat="server" DataSourceID="DataSourceAdHoc"
            AutoGenerateColumns="False" PageSize="20" Width="100%" AllowPaging="True" AllowSorting="True"
            OnRowCommand="GridViewAdHocReport_RowCommand" DataKeyNames="REGISTRANT_ID" Caption="To sort please click table headings"
             PagerSettings-Mode="Numeric"
            OnPageIndexChanging="gridView_PageIndexChanging">
            <EmptyDataTemplate>
                No match found. Please verify the information you entered in the search criteria.</EmptyDataTemplate>
            <Columns>
                <asp:TemplateField Visible="false" HeaderText="ID" SortExpression="REGISTRANT_ID">
                    <ItemTemplate>
                        <asp:LinkButton ID="LinkButtonRegistrantID" runat="server" CommandArgument='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID"))   %>'
                            CommandName="Details" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID"))  %>'>
                        </asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Registrant Name" SortExpression="Name">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:LinkButton ID="LinkButtonRegistrantName" runat="server" CommandArgument='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID"))   %>'
                            CommandName="Details" SkinID="DataLabel" ToolTip="Registrant Name" Text='<%# Helpers.AhobprEval(Eval("Name"))  %>'>
                        </asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Date of Birth" SortExpression="BirthDate">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelDOB" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("BirthDateDisplay")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Registrant Status" SortExpression="Status">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelStatus" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Status")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Duty Status" SortExpression="DutyStatus">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelDutyStatus" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("DutyStatus")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Questionnaire<br />Start Date" SortExpression="QuestionStartDate">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelQuestionStartDate" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("QuestionStartDateDisplay")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Questionnaire<br />Completed Date" SortExpression="QuestionCompleteDate">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelQuestionCompleteDate" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("QuestionCompleteDateDisplay")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Answer" SortExpression="Answer">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelAnswer" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Answer")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Health Concerns?" SortExpression="HealthConcerns">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelHealthConcerns" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("HealthConcerns")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Request to be Seen?" SortExpression="RequestBeSeen"
                    ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelRequestBeSeen" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("RequestBeSeen")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Subpopulation Flag" SortExpression="SubpopulationFlag">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelSubpopulationFlag" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("SubpopulationFlag")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Admin Flag" SortExpression="AdminFlag">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelAdminFlag" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("AdminFlag")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Deployment Country" SortExpression="DeploymentCountry">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelDeploymentCountry" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("DeploymentCountry")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <br />
        <center>
            <asp:Button runat="server" ID="ButtonBackToSummary" Text="Back to Summary Report"
                OnClick="ButtonBackToSummary_Click" />
        </center>
    </asp:Panel>
    <asp:ObjectDataSource ID="DataSourceAdHoc" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetAdHocData" EnablePaging="true" StartRowIndexParameterName="startRowIndex"
        MaximumRowsParameterName="maximumRows" SortParameterName="SortExpression" SelectCountMethod="GetAdHocCount"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRReportManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="BaseControlListBoxStatus" Name="status" PropertyName="Text"
                Type="String" />
            <asp:ControlParameter ControlID="UserControlDutyStatusUpdate" Name="dutyStatus"
                PropertyName="DutyStatus" Type="String" />
            <asp:ControlParameter ControlID="UserControlDutyStatusUpdate" Name="dutyStatusAtFirstLogin"
                PropertyName="DutyStatusCurrent" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormStartDate" Name="formStartFromDateText"
                PropertyName="FromDateValue" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormStartDate" Name="formStartToDateText"
                PropertyName="ToDateValue" Type="String" />
            <asp:ControlParameter ControlID="BaseControlListBoxHealthFactor" Name="healthFactor"
                PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormToDate" Name="formCompletionFromDateText"
                PropertyName="FromDateValue" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormToDate" Name="formCompletionToDateText"
                PropertyName="ToDateValue" Type="String" />
            <asp:ControlParameter ControlID="HiddenFieldQuestion" Name="questionNumber" PropertyName="Value"
                Type="String" />
            <asp:ControlParameter ControlID="BaseControlListBoxAnswer" Name="answer" PropertyName="Text"
                Type="String" />
            <asp:ControlParameter ControlID="RadioButtonListHealthConcerns" Name="healthConcerns"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="RadioButtonListRequestToBeSeen" Name="requestToBeSeen"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="UserControlReportLocationAssigned" Name="assignedLocationType"
                PropertyName="LocationType" Type="String" />
            <asp:ControlParameter ControlID="UserControlReportLocationAssigned" Name="assignedLocationKey"
                PropertyName="LocationKey" Type="String" />
            <asp:ControlParameter ControlID="UserControlReportLocationEvaluation" Name="evaluatedLocationType"
                PropertyName="LocationType" Type="String" />
            <asp:ControlParameter ControlID="UserControlReportLocationEvaluation" Name="evaluatedLocationKey"
                PropertyName="LocationKey" Type="String" />
            <asp:ControlParameter ControlID="BaseControlDropDownListSubpopulationFlag" Name="subpopulationFlag"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlag" PropertyName="AdminFlagId"
                Type="string" />
            <asp:ControlParameter ControlID="BaseControlDropDownListDeploymentCountryAll" Name="deploymentAll"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="BaseControlDropDownListDeploymentCountryExposure"
                Name="deploymentExposure" PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlagFromDateText"
                PropertyName="AdminFlagEnteredDateFrom" Type="string" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlagToDateText"
                PropertyName="AdminFlagEnteredDateTo" Type="string" />
            <asp:ControlParameter ControlID="RadioButtonListDeathFlag" Name="excludeDead"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="BaseControlDropDownListGender" Name="gender"
                PropertyName="Text" Type="string" />
           <asp:ControlParameter ControlID="BaseControlDropDownListRace" Name="race"
                PropertyName="Text" Type="string" />
           <asp:ControlParameter ControlID="BaseControlDropDownListEthnicity" Name="ethnicity"
                PropertyName="Text" Type="string" />
           <asp:ControlParameter ControlID="BaseControlDropDownListSeparationType" Name="separationType"
                PropertyName="Text" Type="int32" />
           <asp:ControlParameter ControlID="UserControlDateRangeSeparation" Name="separationFromDateText"
                PropertyName="FromDateValue" Type="String" />
           <asp:ControlParameter ControlID="UserControlDateRangeSeparation" Name="separationToDateText"
                PropertyName="ToDateValue" Type="String" />    
           <asp:ControlParameter ControlID="BaseControlDropDownListEnrollmentStatus" Name="enrollmentStatus"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="RadioButtonListEvaluation" Name="evaluation"
                PropertyName="Text" Type="string" /> 
            <asp:ControlParameter ControlID="UserControlCurrentStatusFromToDate" Name="StatusFromDateText"
                PropertyName="FromDateValue" Type="String" />
            <asp:ControlParameter ControlID="UserControlCurrentStatusFromToDate" Name="StatusToDateText"
                PropertyName="ToDateValue" Type="String" />
            <asp:ControlParameter ControlID="UserControlFacilityDropdownLists" Name="closestFacilityId"
                PropertyName="FacilityId" Type="String" /> 
            <asp:ControlParameter ControlID="BaseControlDropDownListDeploymentStage" Name="DeploymentVerificationState" 
                PropertyName="DescriptionText" Type="String" />    
            <asp:ControlParameter ControlID="RadioButtonListDeploymentIndicators" Name="DeploymentEraIndicator" 
                PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="RadioButtonListEmail" Name="email" 
                PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="BaseControlDropDownListContactPreference" Name="contactPreference" 
                PropertyName="DescriptionText" Type="String" />
            <asp:ControlParameter ControlID="BaseControlListBoxState" Name="stateAbbvs" 
                PropertyName="Text" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:Panel ID="PanelAdHocReportByLocation" runat="server" GroupingText=" Report Results ">
        <div style="text-align: right; width: 350px;" runat="server" id="Div1">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPagebyLoc" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdlbyLoc"   ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdlbyLoc" AutoPostBack="true"  CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
            </div>
        <asp:GridView ID="GridViewAdHocByLocation" runat="server" DataSourceID="DataSourceAdHocByLocation"
            AutoGenerateColumns="False" PageSize="20" AllowPaging="True" AllowSorting="True"
            OnRowCommand="GridViewAdHocByLocation_RowCommand" DataKeyNames="LocationId" Caption="To sort please click table headings"
            Width="350px"
            PagerSettings-Mode="Numeric"
            OnPageIndexChanging="gridView_PageIndexChanging">
            <EmptyDataTemplate>
                No match found. Please verify the information you entered in the search criteria.</EmptyDataTemplate>
            <Columns>
                <asp:TemplateField HeaderText="LocationId" SortExpression="LocationId" Visible="false">
                    <ItemTemplate>
                        <asp:Label ID="LabelLocationId" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("LocationId")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Location (VISN/Facility)" SortExpression="Location">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelLocation" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Location")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Total Registrants" SortExpression="TotalRegistrants">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:LinkButton ID="LinkButtonTotalRegistrants" runat="server" CommandName="Details"
                            SkinID="DataLabel" ToolTip="Total Registrants" Text='<%# Helpers.AhobprEval(Eval("TotalRegistrants")) %>'>
                        </asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </asp:Panel>
    <asp:ObjectDataSource ID="DataSourceAdHocByLocation" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetAdHocByLocation" EnablePaging="true" StartRowIndexParameterName="startRowIndex"
        MaximumRowsParameterName="maximumRows" SortParameterName="SortExpression" SelectCountMethod="GetAdHocByLocationCount"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRReportManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="BaseControlListBoxStatus" Name="status" PropertyName="Text"
                Type="String" />
            <asp:ControlParameter ControlID="UserControlDutyStatusUpdate" Name="dutyStatus"
                PropertyName="DutyStatus" Type="String" />
            <asp:ControlParameter ControlID="UserControlDutyStatusUpdate" Name="dutyStatusAtFirstLogin"
                PropertyName="DutyStatusCurrent" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormStartDate" Name="formStartFromDate"
                PropertyName="FromDateValue" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormStartDate" Name="formStartToDate"
                PropertyName="ToDateValue" Type="String" />
            <asp:ControlParameter ControlID="BaseControlListBoxHealthFactor" Name="healthFactor"
                PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormToDate" Name="formCompletionFromDate"
                PropertyName="FromDateValue" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormToDate" Name="formCompletionToDate"
                PropertyName="ToDateValue" Type="String" />
            <asp:ControlParameter ControlID="HiddenFieldQuestion" Name="questionNumber" PropertyName="Value"
                Type="String" />
            <asp:ControlParameter ControlID="BaseControlListBoxAnswer" Name="answer" PropertyName="Text"
                Type="String" />
            <asp:ControlParameter ControlID="RadioButtonListHealthConcerns" Name="healthConcerns"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="RadioButtonListRequestToBeSeen" Name="requestBeSeen"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="RadioButtonListLocation" Name="groupBy" PropertyName="Text"
                Type="string" />
            <asp:ControlParameter ControlID="BaseControlDropDownListSubpopulationFlag" Name="subpopulationFlag"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlag" PropertyName="AdminFlagId"
                Type="string" />
            <asp:ControlParameter ControlID="BaseControlDropDownListDeploymentCountryAll" Name="deploymentAll"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="BaseControlDropDownListDeploymentCountryExposure"
                Name="deploymentExposure" PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlagFromDate"
                PropertyName="AdminFlagEnteredDateFrom" Type="string" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlagToDate"
                PropertyName="AdminFlagEnteredDateTo" Type="string" />
            <asp:ControlParameter ControlID="RadioButtonListDeathFlag" Name="excludeDead"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="BaseControlDropDownListGender" Name="gender"
                PropertyName="Text" Type="string" />
           <asp:ControlParameter ControlID="BaseControlDropDownListRace" Name="race"
                PropertyName="Text" Type="string" />
           <asp:ControlParameter ControlID="BaseControlDropDownListEthnicity" Name="ethnicity"
                PropertyName="Text" Type="string" />
           <asp:ControlParameter ControlID="BaseControlDropDownListSeparationType" Name="separationType"
                PropertyName="Text" Type="int32" />
           <asp:ControlParameter ControlID="UserControlDateRangeSeparation" Name="separationFromDateText"
                PropertyName="FromDateValue" Type="String" />
           <asp:ControlParameter ControlID="UserControlDateRangeSeparation" Name="separationToDateText"
                PropertyName="ToDateValue" Type="String" />    
           <asp:ControlParameter ControlID="BaseControlDropDownListEnrollmentStatus" Name="enrollmentStatus"
                PropertyName="Text" Type="string" />
           <asp:ControlParameter ControlID="RadioButtonListEvaluation" Name="evaluation"
                PropertyName="Text" Type="string" /> 
           <asp:ControlParameter ControlID="UserControlCurrentStatusFromToDate" Name="StatusFromDateText"
                PropertyName="FromDateValue" Type="String" />
            <asp:ControlParameter ControlID="UserControlCurrentStatusFromToDate" Name="StatusToDateText"
                PropertyName="ToDateValue" Type="String" />
            <asp:ControlParameter ControlID="BaseControlDropDownListDeploymentStage" Name="DeploymentVerificationState" 
                PropertyName="DescriptionText" Type="String" />    
            <asp:ControlParameter ControlID="RadioButtonListDeploymentIndicators" Name="DeploymentEraIndicator" 
                PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="RadioButtonListEmail" Name="email" 
                PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="BaseControlDropDownListContactPreference" Name="contactPreference" 
                PropertyName="DescriptionText" Type="String" />
            <asp:ControlParameter ControlID="BaseControlListBoxState" Name="stateAbbvs" 
                PropertyName="Text" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="DataSourceAdhocByLocationDrillDown" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetAdHocData" EnablePaging="true" StartRowIndexParameterName="startRowIndex"
        MaximumRowsParameterName="maximumRows" SortParameterName="SortExpression" SelectCountMethod="GetAdHocCount"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRReportManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="BaseControlListBoxStatus" Name="status" PropertyName="Text"
                Type="String" />
            <asp:ControlParameter ControlID="UserControlDutyStatusUpdate" Name="dutyStatus"
                PropertyName="DutyStatus" Type="String" />
            <asp:ControlParameter ControlID="UserControlDutyStatusUpdate" Name="dutyStatusAtFirstLogin"
                PropertyName="DutyStatusCurrent" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormStartDate" Name="formStartFromDateText"
                PropertyName="FromDateValue" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormStartDate" Name="formStartToDateText"
                PropertyName="ToDateValue" Type="String" />
            <asp:ControlParameter ControlID="BaseControlListBoxHealthFactor" Name="healthFactor"
                PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormToDate" Name="formCompletionFromDateText"
                PropertyName="FromDateValue" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormToDate" Name="formCompletionToDateText"
                PropertyName="ToDateValue" Type="String" />
            <asp:ControlParameter ControlID="HiddenFieldQuestion" Name="questionNumber" PropertyName="Value"
                Type="String" />
            <asp:ControlParameter ControlID="BaseControlListBoxAnswer" Name="answer" PropertyName="Text"
                Type="String" />
            <asp:ControlParameter ControlID="RadioButtonListHealthConcerns" Name="healthConcerns"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="RadioButtonListRequestToBeSeen" Name="requestToBeSeen"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="HiddenAssignedLocationType" Name="assignedLocationType"
                Type="String" />
            <asp:ControlParameter ControlID="HiddenAssignedLocationKey" Name="assignedLocationKey"
                Type="String" />
            <asp:ControlParameter ControlID="UserControlReportLocationEvaluation" Name="evaluatedLocationType"
                PropertyName="LocationType" Type="String" />
            <asp:ControlParameter ControlID="UserControlReportLocationEvaluation" Name="evaluatedLocationKey"
                PropertyName="LocationKey" Type="String" />
            <asp:ControlParameter ControlID="BaseControlDropDownListSubpopulationFlag" Name="subpopulationFlag"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlag" PropertyName="AdminFlagId"
                Type="string" />
            <asp:ControlParameter ControlID="BaseControlDropDownListDeploymentCountryAll" Name="deploymentAll"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="BaseControlDropDownListDeploymentCountryExposure"
                Name="deploymentExposure" PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlagFromDateText"
                PropertyName="AdminFlagEnteredDateFrom" Type="string" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlagToDateText"
                PropertyName="AdminFlagEnteredDateTo" Type="string" />
            <asp:ControlParameter ControlID="RadioButtonListDeathFlag" Name="excludeDead"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="BaseControlDropDownListGender" Name="gender"
                PropertyName="Text" Type="string" />
           <asp:ControlParameter ControlID="BaseControlDropDownListRace" Name="race"
                PropertyName="Text" Type="string" />
           <asp:ControlParameter ControlID="BaseControlDropDownListEthnicity" Name="ethnicity"
                PropertyName="Text" Type="string" />
           <asp:ControlParameter ControlID="BaseControlDropDownListSeparationType" Name="separationType"
                PropertyName="Text" Type="int32" />
           <asp:ControlParameter ControlID="UserControlDateRangeSeparation" Name="separationFromDateText"
                PropertyName="FromDateValue" Type="String" />
           <asp:ControlParameter ControlID="UserControlDateRangeSeparation" Name="separationToDateText"
                PropertyName="ToDateValue" Type="String" />    
           <asp:ControlParameter ControlID="BaseControlDropDownListEnrollmentStatus" Name="enrollmentStatus"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="RadioButtonListEvaluation" Name="evaluation"
                PropertyName="Text" Type="string" />  
             <asp:ControlParameter ControlID="UserControlCurrentStatusFromToDate" Name="StatusFromDateText"
                PropertyName="FromDateValue" Type="String" />
            <asp:ControlParameter ControlID="UserControlCurrentStatusFromToDate" Name="StatusToDateText"
                PropertyName="ToDateValue" Type="String" />        
            <asp:ControlParameter ControlID="UserControlFacilityDropdownLists" Name="closestFacilityId"
                PropertyName="FacilityId" Type="String" />
            <asp:ControlParameter ControlID="BaseControlDropDownListDeploymentStage" Name="DeploymentVerificationState" 
                PropertyName="DescriptionText" Type="String" />    
            <asp:ControlParameter ControlID="RadioButtonListDeploymentIndicators" Name="DeploymentEraIndicator" 
                PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="RadioButtonListEmail" Name="email" 
                PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="BaseControlDropDownListContactPreference" Name="contactPreference" 
                PropertyName="DescriptionText" Type="String" />
            <asp:ControlParameter ControlID="BaseControlListBoxState" Name="stateAbbvs" 
                PropertyName="Text" Type="String" />     
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:HiddenField ID="HiddenFieldQuestion" runat="server" />
    <asp:HiddenField ID="HiddenFieldFacility" runat="server" Value="0" />
    <asp:HiddenField ID="HiddenFieldVisn" runat="server" />
    <asp:HiddenField ID="HiddenFieldLocation" runat="server" />
    <asp:HiddenField ID="HiddenAssignedLocationType" runat="server" />
    <asp:HiddenField ID="HiddenAssignedLocationKey" runat="server" />
</asp:Content>
