﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web.Security;
using System.Web.UI.WebControls.WebParts;
using System.Text;
using System.IO;
using System.Reflection;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class QuestionnaireSection : BasePage
{
    private AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();

    protected void Page_Load(object sender, EventArgs e)
    {
        int registrantId = Request.QueryString["id"] == null ? UserSession.RegistrantId : Helpers.getIntFromString(Request.QueryString["id"]);
        UserSession.RegistrantId = registrantId;
        int sectionId = Request.QueryString["sectionId"] == null ? 0 : Helpers.getIntFromString(Request.QueryString["sectionId"]);
        int subSectionId = Request.QueryString["subSectionId"] == null ? 0 : Helpers.getIntFromString(Request.QueryString["subSectionId"]);
        UserControlRegistrant.LoadUserControl(registrantId);
        UserControlQuestionnaire.LoadControlsFromObject(registrantId, QuestionnaireDisplayType.Section, sectionId, subSectionId);
        AHOBPRQuestionnaireManager manager = new AHOBPRQuestionnaireManager();
        var sectionDescription = manager.GetSectionAndSubSectionDescription(registrantId, sectionId, subSectionId);
        string registrantName = _registrantManager.SelectRegistrantNameById(registrantId);
        LabelBreadCrumb.Text = "<H1>Registrants > Registrant: " + registrantName + " > Questionnaire by Section > " + sectionDescription + "</H1>";
        LabelQuestionnaireVersion.Text = "Questionnaire Version: " + UserControlQuestionnaire.QuestionnaireVersion;
    }

    public override string TopMenuName()
    {
        return "Registrants";
    }

    public override string MenuItemName()
    {
        return "Section";
    }

    public override string AppObjectCode()
    {
        return "AHOBPR QUESTIONNAIRE SECTION";
    }

    protected override void OnUnload(EventArgs e)
    {
        var master = (this.Master as RegistryMaster);
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        base.OnUnload(e);
    }

}