﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web.Security;
using System.Web.UI.WebControls.WebParts;
using System.Text;
using System.IO;
using System.Reflection;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using System.Collections.Specialized;

public partial class NameUpdate : BasePage
{
    private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    private List<STD_GUI_CONTROL_AHOBPR> _dbAhopbrControls = null;
    private AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();
    private AHOBPREmailService _emailService = new AHOBPREmailService();

    protected void Page_Load(object sender, EventArgs e)
    {
        int registrantId = Request.QueryString["id"] == null ? UserSession.RegistrantId : Helpers.getIntFromString(Request.QueryString["id"].ToString());
        UserSession.RegistrantId = registrantId;
        LoadBaseControls();
        LoadControlsFromObject(registrantId);
        var master = (this.Master as RegistryMaster);
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
    }

    public override string TopMenuName()
    {
        return "Registrants";
    }

    public override string MenuItemName()
    {
        return "Non-Verified Names";
    }

    public override string AppObjectCode()
    {
        return "AHOBPR NAME UPDATE";
    }

    private void LoadControlsFromObject(int registrantId)
    {
        HiddenFieldRegistrantId.Value = registrantId.ToString();
        UserControlRegistrant.LoadUserControl(registrantId);
        UserControlDeploymentHistory.LoadUserControl(registrantId);
        string registrantName = _registrantManager.SelectRegistrantNameById(registrantId);
        REGISTRANT registrant = _registrantManager.GetRegistrantByIdLight(registrantId);
        LabelBreadCrumb.Text = "<H1>Update Non-Verified Names > Registrant: " + registrantName + "</H1>";
        if (!IsPostBack)
        {
            BaseControlTextBoxLastName.Text = registrant.LAST_NAME;
            BaseControlTextBoxFirstName.Text = registrant.FIRST_NAME;
            BaseControlTextBoxMiddleName.Text = registrant.MIDDLE_NAME;
        }
    }

    private void LoadBaseControls()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_NAME_UPDATE"))
        {
            Control userControl = PanelNameUpdate.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                if (dbItem.BASE_CONTROL_TYPE == (int)AhobprBaseControlType.TextBox)
                {
                    controls_BaseControlTextBox baseControl = (controls_BaseControlTextBox)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                        dbItem.INCLUDE_LABEL, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH,
                        dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.VALIDATION_REGULAR_EXPRESSION,
                        dbItem.REQUIRED);
                }
            }
        }
    }

    private List<STD_GUI_CONTROL_AHOBPR> GetGuiControls(string controlCategory)
    {
        if (UserSession.GuiControlsNameUpdate == null)
        {
            _dbAhopbrControls = _baseControlManager.SelectGuiControlList(controlCategory).ToList<STD_GUI_CONTROL_AHOBPR>();
            UserSession.GuiControlsNameUpdate = _dbAhopbrControls;
        }
        else
        {
            _dbAhopbrControls = UserSession.GuiControlsNameUpdate;
        }

        return _dbAhopbrControls;
    }

    protected void ButtonBackToSearch_Click(object sender, EventArgs e)
    {
        Response.Redirect("NameUpdateSearchRegistrant.aspx");
    }


    protected void ButtonUpdateName_Click(object sender, EventArgs e)
    {
        //TLB: RTC 487861 - Added validation, at a minimum last name and first name are required
        if (string.IsNullOrEmpty(BaseControlTextBoxLastName.Text.Trim()) || string.IsNullOrEmpty(BaseControlTextBoxFirstName.Text.Trim()))
        {
            Alert.Show("Correct Last Name and First Name values are required");
            return;
        }

        int registrantId = UserSession.RegistrantId;

        //Add to Audit Log
        UserAccountManager user = (UserAccountManager)HttpContext.Current.User;
        Helpers.AddActivityToAuditLog(user.UserId.ToString(), AHOBPRGlobal.AdminFlagNameVerified,
            registrantId.ToString(), AuditLogType.RegistrantNameVerified, null);

        REGISTRANT registrant = _registrantManager.GetRegistrantByIdForNameChange(registrantId);
        if (registrant != null)
        {
            registrant.SetAsChangeTrackingRoot();
            registrant.SetAsUpdateOnSubmit();
            registrant.LAST_NAME = BaseControlTextBoxLastName.Text;
            registrant.FIRST_NAME = BaseControlTextBoxFirstName.Text;
            registrant.MIDDLE_NAME = BaseControlTextBoxMiddleName.Text;

            // Update the names in contact info
            if (registrant.REGISTRANT_CONTACT_INFO != null)
            {
                //TLB: RTC 487861 - Added Change Tracking to REGISTRANT_CONTACT_INFO object
                registrant.REGISTRANT_CONTACT_INFO.SetAsChangeTrackingRoot();
                registrant.REGISTRANT_CONTACT_INFO.SetAsUpdateOnSubmit();
                registrant.REGISTRANT_CONTACT_INFO.LAST_NAME_CONFIRMED = BaseControlTextBoxLastName.Text;
                registrant.REGISTRANT_CONTACT_INFO.FIRST_NAME_CONFIRMED = BaseControlTextBoxFirstName.Text;
                registrant.REGISTRANT_CONTACT_INFO.MIDDLE_NAME_CONFIRMED = BaseControlTextBoxMiddleName.Text;
            }

            // update the edipi mismatched flag and edipi verified date
            if (registrant.REGISTRANT_RECORD_INFO != null)
            {
                //TLB: RTC 487861 - Added Change Tracking to REGISTRANT_RECORD_INFO object
                registrant.REGISTRANT_RECORD_INFO.EDIPI_MISMATCHED_FLAG = false;
                registrant.REGISTRANT_RECORD_INFO.EDIPI_VERIFIED_DATE = null;
                registrant.REGISTRANT_RECORD_INFO.SetAsChangeTrackingRoot();
                registrant.REGISTRANT_RECORD_INFO.SetAsUpdateOnSubmit();
            }

            int saveStatus = _registrantManager.UpdateRegistrant(registrant);

            if (saveStatus == 1)
            {
                //Add admin flag for the user
               saveStatus = _registrantManager.AddAdminTrackingFlagToRegistrantByName(registrant.REGISTRANT_ID, AHOBPRGlobal.AdminFlagNameVerified);
                //Call a service to update the JSON with the new name:
                string serviceResponse = ServiceCaller.UpdateJsonRegistrantName(
                    registrant.USER_ID, BaseControlTextBoxLastName.Text, BaseControlTextBoxFirstName.Text, BaseControlTextBoxMiddleName.Text);

                //create message json
                AHOBPREmailTemplateManager templateManager = new AHOBPREmailTemplateManager();
                int emailTemplateId = templateManager.GetTemplateIdByTitle(AHOBPRGlobal.EmailTemplateNameUpdate);
                //Check for an emailTemplateId > 0 and don't 
                //fail this process because of a missing template
                ServiceCaller.CreateMessageJson(registrantId.ToString(), emailTemplateId.ToString());

                //send email to registrant of name update if they have a email address in the system
                StringCollection registrantEmailList = _emailService.GetEmailListForRegistrant(registrantId);
                if (registrantEmailList.Count != 0)
                {
                    Boolean emailSent = SendEmailToRegistrantForNameUpdate(registrantId, registrantEmailList, emailTemplateId);
                    //Check added in case a new status is added to the change status options and there is no email Template for the new option.
                    //The current options for the change status are Eligible and Review Not Eligible. 
                    if (emailSent)
                    {
                        Alert.ShowSaveSuccessEmailSent();
                    }
                    else 
                    { 
                        Alert.ShowSaveSuccess(); 
                    }
                }
                else
                {
                    Alert.ShowSaveSuccessNoEmailSent();
                }

                // reload the registant info panel and disable the name update panel
                UserControlRegistrant.LoadControlsFromObject(registrantId);
                PanelNameUpdate.Enabled = false;
            }
            else
            {
                Alert.ShowSaveFailed();
            }        
        }

    }

    private Boolean SendEmailToRegistrantForNameUpdate(int registrantId, StringCollection registrantEmailList, int emailTemplateId)
    {
        Boolean emailSent = false;

        if (emailTemplateId != 0)
        {
            //check email template to see which message type to send email/notification
            int sendMessageType = _emailService.GetMessageType(emailTemplateId);
            _emailService.SendEmailToRegistrant(registrantId, emailTemplateId, registrantEmailList, sendMessageType);
            emailSent = true;            
        }

        return emailSent;
    }

}