﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManager;
using AntiXssEnc = Microsoft.Security.Application;

public partial class MyEmailTemplates : BasePage
{
    //private AHOBPREmailTemplateManager _emailServiceTemplate = new AHOBPREmailTemplateManager();

    public override string MenuItemName()
    {
        return "My Message Templates";
    }
    public override string AppObjectCode()
    {
        return "AHOBPR MY TEMPLATES";
    }
    public override string TopMenuName()
    {
        return "Registrants";
    }


    protected void CopyCommand(object sender, CommandEventArgs e)
    {
        Response.Redirect("~/MyEmailTemplateEdit.aspx?action=copy&id=" + e.CommandArgument, false);
        Context.ApplicationInstance.CompleteRequest();
    }

    protected void EditCommand(object sender, CommandEventArgs e)
    {
        Response.Redirect("~/MyEmailTemplateEdit.aspx?action=edit&id=" + e.CommandArgument, false);
        Context.ApplicationInstance.CompleteRequest();
    }

    protected void PreviewCommand(object sender, CommandEventArgs e)
    {
        Response.Redirect("~/MyEmailTemplateEdit.aspx?action=preview&id=" + e.CommandArgument, false);
        Context.ApplicationInstance.CompleteRequest();
    }



    protected void Page_Load(object sender, EventArgs e)
    {
        UserAccountManager user = (UserAccountManager)HttpContext.Current.User;
        HiddenFieldUserName.Value = user.UserName;
    }

    protected void GridViewAvailableTemplates_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if ((e.Row.RowType != DataControlRowType.DataRow))
        {
            return;
        }

        EMAIL_TEMPLATE emailitem = (EMAIL_TEMPLATE)e.Row.DataItem;

        Label lblsubject = (Label)e.Row.FindControl("lblsubject");
        lblsubject.Text = AntiXssEnc.Encoder.HtmlEncode(Server.HtmlDecode(emailitem.SUBJECT));

        LinkButton linkButtonTitle = (LinkButton)e.Row.FindControl("LinkButtonTitle");
        linkButtonTitle.Text = AntiXssEnc.Encoder.HtmlEncode(Server.HtmlDecode(emailitem.TITLE));     
    }

    protected void GridViewMyTemplates_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if ((e.Row.RowType != DataControlRowType.DataRow))
        {
            return;
        }

        EMAIL_TEMPLATE emailitem = (EMAIL_TEMPLATE)e.Row.DataItem;

        Label lblsubject = (Label)e.Row.FindControl("lblsubject");
        lblsubject.Text = AntiXssEnc.Encoder.HtmlEncode(Server.HtmlDecode(emailitem.SUBJECT));

        LinkButton linkButtonTitle = (LinkButton)e.Row.FindControl("LinkButtonTitle");
        linkButtonTitle.Text = AntiXssEnc.Encoder.HtmlEncode(Server.HtmlDecode(emailitem.TITLE));

    }

    protected void gridViewMyTempPageSizeDdlChanged(Object sender, EventArgs e)
    {

        GridViewMyTemplates.PageSize = int.Parse(gridViewPageSizeDdl1.SelectedValue);

    }

    protected void gridViewMyTemp_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewMyTemplates.PageIndex = e.NewPageIndex;

    }

    protected void gridViewPageSizeDdlChanged(Object sender, EventArgs e)
    {

        GridViewAvailableTemplates.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);

    }

    protected void gridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewAvailableTemplates.PageIndex = e.NewPageIndex;

    }
}
