﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true"
    CodeFile="ManageEmailTemplate.aspx.cs" Inherits="ManageEmailTemplate" %>

<%@ Register Assembly="Microsoft.ReportViewer.WebForms, Version=11.0.0.0, Culture=neutral, PublicKeyToken=89845dcd8080cc91"
    Namespace="Microsoft.Reporting.WebForms" TagPrefix="rsweb" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID="LabelBreadCrumb" runat="server" Text="<H1>Administration > Registry Messages</H1>" />
    </div>
    <div>
        <table>
            <tr>
                <td colspan="3">
                    <br />
                    <asp:Button ID="btnAdd" runat="server" SkinID="normalButton" Text="Add New Message Template"
                        OnClick="btnAdd_Click" />
                </td>
            </tr>
        </table>
        <hr />
        <asp:Panel ID="PanelRegistryMessages" runat="server" GroupingText="Manage Registry Messages&nbsp;&nbsp;"
            Width="100%">
            <table>
                <tr>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelForTextBoxKeyWords" runat="server" Text="Filter By Key Words:"
                            AssociatedControlID="TextBoxKeyWords" ToolTip="Filter By Key Words" /> 
                        <br />  
                        <asp:TextBox ID="TextBoxKeyWords" runat="server" Width="300" ToolTip="Filter By Key Words"></asp:TextBox>  
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp                  
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelForDropDownListStatus" runat="server" Text="Filter By Status:"
                            AssociatedControlID="DropDownListStatus" ToolTip="Filter by Status" /> &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <br />
                         <asp:DropDownList runat='server' ID='DropDownListStatus' ToolTip='Filter by Status'>
                            <asp:ListItem Text='All' />
                            <asp:ListItem Text='Active' />
                            <asp:ListItem Text='Inactive' />
                        </asp:DropDownList>
                     </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelforDropDownListType" runat="server" Text="Filter By Type:"
                            AssociatedControlID="DropDownListType" ToolTip="Filter by Type" /> &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <br />
                         <asp:DropDownList runat='server' ID='DropDownListType' ToolTip='Filter by Type'>
                            <asp:ListItem Text='All' />
                            <asp:ListItem Text='Email Only' />
                            <asp:ListItem Text='Notification Only' />
                            <asp:ListItem Text='Both Email and Notification' />
                        </asp:DropDownList>                    
                    </td>
                 </tr>
                <tr><td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td></tr>
                <tr>
                    <td>
                         <asp:CheckBox ID="CheckBoxAvailableToAdvancedUsers" runat="server" Text="Available to Advanced Users" AutoPostBack="true" 
                ToolTip="Include Message Templates Available to Advanced Users" /> 
                    </td>
                    <td>
                         <asp:CheckBox ID="CheckBoxCreatedByAdvancedUsers" runat="server" Text="Created by Advanced Users" AutoPostBack="true" 
                ToolTip="Include Message Templates Created by Advanced Users" /> 
                    </td>
                    <td>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <asp:Button ID="ButtonSearch" runat="server" Text=" Filter " OnClick="ButtonSearch_Click" />
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick="ButtonClear_Click" />
                    </td>
                </tr>
            </table>           
            <div style="text-align: right;" width="100%" runat="server" id="pageSizeDiv">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl"   ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true"  CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
            </div>
            <asp:GridView ID="GridViewTemplates" runat="server" AutoGenerateColumns="False" Width="100%"
                OnRowDataBound="GridViewTemplates_RowDataBound" OnRowEditing="GridViewTemplates_RowEditing" DataSourceID="dataTemplates" 
                AllowSorting="True" DataKeyNames="TEMPLATE_ID" AllowPaging="True" Caption="Message Templates"  PagerSettings-Mode="Numeric"
                OnPageIndexChanging="gridView_PageIndexChanging">
                <Columns>
                    <asp:BoundField DataField="TEMPLATE_ID" HeaderText="ID" SortExpression="TEMPLATE_ID" />
                    <asp:TemplateField HeaderText="Title">
                        <ItemTemplate>
                            <asp:Label ID="lbltitle" runat="server"></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Subject">
                        <ItemTemplate>
                            <asp:Label ID="lblsubject" runat="server"></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Status" SortExpression="Active">
                         <HeaderStyle HorizontalAlign="Center" />
                         <ItemStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            <asp:Label ID="LabelActive" runat="server" SkinID="DataLabel" Text='<%# Convert.ToBoolean(Eval("Active")) ? "Active" : "Inactive" %>'
                                />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Email" SortExpression="EMAIL">
                          <HeaderStyle HorizontalAlign="Center" />
                         <ItemStyle HorizontalAlign="Center" />
                       <ItemTemplate>
                            <asp:Label ID="LabelEmail" runat="server" SkinID="DataLabel" Text='<%# Convert.ToBoolean(Eval("EMAIL")) ? "Yes" : "No" %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Notification" SortExpression="NOTIFICATION">
                          <HeaderStyle HorizontalAlign="Center" />
                         <ItemStyle HorizontalAlign="Center" />
                       <ItemTemplate>
                            <asp:Label ID="LabelNotification" runat="server" SkinID="DataLabel" Text='<%# Convert.ToBoolean(Eval("NOTIFICATION")) ? "Yes" : "No" %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                     <asp:TemplateField HeaderText="Available to<br />Advanced Users" SortExpression="ADVANCED_USER_FLAG">
                         <HeaderStyle HorizontalAlign="Center" />
                         <ItemStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            <asp:Label ID="LabelAdvanceUsers" runat="server" SkinID="DataLabel" Text='<%# Convert.ToBoolean(Eval("ADVANCED_USER_FLAG")) ? "Yes" : "No" %>'
                                />
                        </ItemTemplate>
                    </asp:TemplateField>
                     <asp:TemplateField HeaderText="Created by<br />Advanced Users" SortExpression="CREATEDBY_ADVANCED_USER_FLAG">
                         <HeaderStyle HorizontalAlign="Center" />
                         <ItemStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            <asp:Label ID="LabelByAdvancedUsers" runat="server" SkinID="DataLabel" Text='<%# Convert.ToBoolean(Eval("CREATEDBY_ADVANCED_USER_FLAG")) ? "Yes" : "No" %>'
                                />

                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Action" ShowHeader="True">
                        <ItemStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            <asp:LinkButton ID="LinkButton1" runat="server" CausesValidation="False" CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TEMPLATE_ID"))) %>'
                                CommandName="Edit" OnCommand="EmailCommand" Text="Edit"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </asp:Panel>
    </div>
    <asp:ObjectDataSource ID="dataTemplates" runat="server" TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPREmailTemplateManager"
        SelectMethod="GetEmailTemplatesForRegistrants" EnablePaging="True"  SelectCountMethod="GetTemplateCount"
        SortParameterName="SortExpression" StartRowIndexParameterName="startRowIndex" MaximumRowsParameterName="maximumRows" >
   <SelectParameters>
        <asp:ControlParameter ControlID="TextBoxKeyWords" Name="keyWords" PropertyName="Text" Type="String" />
        <asp:ControlParameter ControlID="DropDownListStatus" Name="status" PropertyName="SelectedValue" Type="String" />
        <asp:ControlParameter ControlID="DropDownListType" Name="type" PropertyName="SelectedValue" Type="String" />
        <asp:ControlParameter ControlID="CheckBoxAvailableToAdvancedUsers" Name="availableToAdvancedUsers" PropertyName="Checked" Type="Boolean" />
        <asp:ControlParameter ControlID="CheckBoxCreatedByAdvancedUsers" Name="createdByAdvancedUsers" PropertyName="Checked" Type="Boolean" />
    </SelectParameters>

    </asp:ObjectDataSource>
</asp:Content>
