﻿<%@ Application Language="C#" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="VeteransAffairs.Registries.BusinessManager" %>
<%@ Import Namespace="VeteransAffairs.Registries.BusinessAHOBPR" %>
<%@ Import Namespace="VeteransAffairs.Registries.BusinessManagerAHOBPR" %>
<%@ Import Namespace="System.Web.Configuration" %>
   
<script runat="server">      
    //void Application_Start(object sender, EventArgs e) 
    //{
    //    // Code that runs on application startup
    //}

    //void Application_End(object sender, EventArgs e)
    //{
    //    //  Code that runs on application shutdown
    //}

    void Application_Error(object sender, EventArgs e)
    {
        Exception ex = Server.GetLastError().GetBaseException();
        (new VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRShared()).LogErrorMessage
            ("Global Exception",
            ex.Source,
            ex.Message + "\r\n" + ex.StackTrace);
    }

    //void Session_Start(object sender, EventArgs e)
    //{
    //    // Code that runs when a new session is started
    //}

    //void Session_End(object sender, EventArgs e)
    //{
    //    // Code that runs when a session ends. 
    //    // Note: The Session_End event is raised only when the sessionstate mode
    //    // is set to InProc in the Web.config file. If session mode is set to StateServer 
    //    // or SQLServer, the event is not raised.
    //}

    //void WindowsAuthentication_OnAuthenticate(object Source, WindowsAuthenticationEventArgs e)
    //{
    //    //Note that since IIS has already performed 
    //    //authentication, the provided identity is used.

    //}

    //void Application_AuthenticateRequest(object sender, EventArgs e)
    //{
    //}

    void Application_PostAuthenticateRequest(object sender, EventArgs e)
    {
        if (HttpContext.Current.Request.Url.PathAndQuery.IndexOf(".aspx") > 0)
        {
            if (!HttpContext.Current.Request.Url.PathAndQuery.ToLower().Contains("/login.aspx") &&
                !HttpContext.Current.Request.Url.PathAndQuery.ToLower().Contains("/createaccount.aspx"))
            {
                if (System.Threading.Thread.CurrentPrincipal == null ||
                    HttpContext.Current.User == null ||
                    !(HttpContext.Current.User is VeteransAffairs.Registries.BusinessManager.UserAccountManager))
                {
                    if (Request.Cookies["CurrentUser"] != null &&
                        Request.Cookies["CurrentUser"].Value != HttpContext.Current.User.GetCurrentUserNameWithoutDomain())
                    {
                        BadLogin();
                    }

                    else
                    {
                        string userId = HttpContext.Current.User.GetCurrentUserNameWithoutDomain();
                        string Registry = Helpers.GetConfigEntry("Registry");
                        UserAccountManager mainUser = new UserAccountManager(userId, Registry);

                        HttpContext.Current.User = mainUser;
                        System.Threading.Thread.CurrentPrincipal = mainUser;
                        try
                        {
                            AHOBPRUserManager userManager = new AHOBPRUserManager();
                            VeteransAffairs.Registries.BusinessAHOBPR.AHOBPR_USER ahobprUser =
                                userManager.GetUser(mainUser.UserId);
                            if (ahobprUser.IsValid() != AhobprExtensions.LoginResults.Valid)
                            {
                                BadLogin();
                            }
                        }
                        catch (Exception)
                        {
                            BadLogin();
                        }
                    }
                }
            }
        }
    }

    private void BadLogin()
    {
        HttpCookie newCookie = new HttpCookie("CurrentUser", "x");
        newCookie.Expires = DateTime.Now.AddMinutes(30);
        Response.Cookies.Add(newCookie);

        Response.Write("<script>onload=new function(){window.location='Login.aspx';}<" + "/script>");
        Response.End();
    }

    void Application_BeginRequest(object sender, EventArgs e)
    {
        string originalPath = Request.Url.ToString();

        if (originalPath.EndsWith("/Referrals.aspx", StringComparison.CurrentCultureIgnoreCase))
        {
            HttpContext.Current.RewritePath("~/Referrals.aspx?statusId=4", true);
            Response.Redirect("~/Referrals.aspx?statusId=4");
        }
    }
</script>
