﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManager;
using AntiXssEnc = Microsoft.Security.Application;

public partial class EditEmailTemplates : BasePage
{
    private AHOBPREmailTemplateManager _emailServiceTemplate = new AHOBPREmailTemplateManager();
   

    public override string MenuItemName()
    {
        return "Registry Messages";
    }
    public override string AppObjectCode()
    {
        return "AHOBPR REGISTRY MESSAGES";
    }
    public override string TopMenuName()
    {
        return "Administration";
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if ((!Page.IsPostBack))
        {
            SetControls();
        }
    }

    /// <summary>
    /// This subroutine called on page load to fill web controls from database and 
    /// displays appropriate buttons based on query string status.
    /// </summary>
    /// <remarks></remarks>
    public void SetControls()
    {
        int id = 0;
        if ((Request.QueryString["id"] == null))
        {
            ShowButton(btnAdd);
            LabelCreatedBy.Visible = false;
            LabelCreatedOn.Visible = false;
            LabelUpdatedBy.Visible = false;
            LabelUpdatedOn.Visible = false;
            LabelBreadCrumb.Text = "<H1>Administration > Registry Messages > Add Message Template</H1>";
        }
        else
        {
            id = Convert.ToInt32(Request.QueryString["id"]);
            LoadEmailTemplateInfo(id);
            ShowButton(btnUpdate);
            
        }
    }

    /// <summary>
    /// Called by: SetControls
    /// Description: 
    /// </summary>
    /// <param name="id"></param>
    /// <remarks></remarks>
    public void LoadEmailTemplateInfo(int id)
    {
        EMAIL_TEMPLATE email = _emailServiceTemplate.GetById(id);

        TextBoxSubject.Text = Server.HtmlDecode(email.SUBJECT);
        TextBoxTitle.Text = Server.HtmlDecode(email.TITLE);
        TextBoxBody.Text = Server.HtmlDecode(email.BODY.Replace("Hello {REGISTRANTNAME},", string.Empty));
        CheckBoxActive.Checked = email.ACTIVE;
        TextBoxContactInfo.Text = Server.HtmlDecode(email.CONTACT_INFO);
        TextBoxSalutation.Text = Server.HtmlDecode(string.IsNullOrEmpty(email.SALUTATION) ? "Hello {REGISTRANTNAME}," : email.SALUTATION);
        CheckBoxAdvancedUsers.Checked = email.ADVANCED_USER_FLAG;
        chkEmail.Checked = email.EMAIL;
        chkNotification.Checked = email.NOTIFICATION;
        LabelTextCreatedBy.Text = Server.HtmlDecode(email.CREATEDBY);
        LabelTextCreatedOn.Text = email.CREATED.ToShortDateString();
        LabelTextUpdatedBy.Text = Server.HtmlDecode(email.UPDATEDBY);
        LabelTextUpdatedOn.Text = email.UPDATED.ToShortDateString();
    }

    public void ShowButton(Button btn)
    {
        btnAdd.Visible = false;
        btnUpdate.Visible = false;
        btn.Visible = true;
    }

    /// <summary>
    /// Description: fills EmailTemplate class from web controls and then pass the class to UpdateEmailTemplateInfo subroutine
    /// </summary>
    /// <remarks></remarks>
    public void FillEmailTemplateClass()
    {
        EMAIL_TEMPLATE email = default(EMAIL_TEMPLATE);

        if (((Request.QueryString["id"] != null)))
        {
            email = _emailServiceTemplate.GetById(Convert.ToInt32(Request.QueryString["id"]));
            email.BODY = Server.HtmlEncode(TextBoxBody.Text.ToString());
        }
        else
        {
            email = new EMAIL_TEMPLATE();
            //add header for name to template
            email.BODY = Server.HtmlEncode(TextBoxBody.Text.ToString()); 
        }

        email.SUBJECT = Server.HtmlEncode(TextBoxSubject.Text.ToString());
        email.TITLE = Server.HtmlEncode(TextBoxTitle.Text.ToString());
       // email.BODY = Server.HtmlEncode(TextBoxBody.Text.ToString());
        email.ACTIVE = CheckBoxActive.Checked;
        email.ACTIVE = CheckBoxActive.Checked;
        email.CONTACT_INFO = Server.HtmlEncode(TextBoxContactInfo.Text);
        email.SALUTATION = Server.HtmlEncode(TextBoxSalutation.Text);
        email.ADVANCED_USER_FLAG = CheckBoxAdvancedUsers.Checked;

        email.UPDATED = System.DateTime.Now;
        email.EMAIL = chkEmail.Checked;
        email.NOTIFICATION = chkNotification.Checked;
        email.USER_FLAG = false;

        _emailServiceTemplate.SaveOrUpdate(email);
        //clear view to run again to get new template
        AHOBPRGlobal.ViewLookupAll = null;

        //Add to Audit Log
        UserAccountManager user = (UserAccountManager)HttpContext.Current.User;
        string message = email.TITLE;
        Helpers.AddActivityToAuditLog(user.UserId.ToString(), message,
            string.Empty, AuditLogType.MessageTemplateAddedEdited, null);


        Response.Redirect("~/ManageEmailTemplate.aspx", false);
        Context.ApplicationInstance.CompleteRequest();
    }

    /// <summary>
    /// Called by: btnAdd_click event
    /// Description: adds and/or updates email template info to database through EmailTemplate class
    /// </summary>
    /// <param name="email"></param>
    /// <remarks></remarks>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            FillEmailTemplateClass();
        }

    }

    protected void ButtonPreview_Click(object sender, EventArgs e)
    {
        LabelSubjectPreview.Text = AntiXssEnc.Encoder.HtmlEncode(TextBoxSubject.Text);
        string body = TextBoxSalutation.Text.Replace("\r\n", "<br />") + "<br /><br />"
                                + TextBoxBody.Text.Replace("\r\n", "<br />") + "<br /><br />"
                                + TextBoxContactInfo.Text.Replace("\r\n", "<br />");
        LabelBodyPreview.Text = AntiXssEnc.Encoder.HtmlEncode(body.Replace("<br /><br /><br /><br />", "<br /><br />").Replace("  ", "&nbsp;&nbsp;"));
        PanelEditTemplate.Visible = false;
        PanelPreviewTemplate.Visible = true;
        ButtonEditTemplate.Visible = true;
    }

    protected void ButtonEditTemplate_Click(object sender, EventArgs e)
    {
        PanelPreviewTemplate.Visible = false;
        ButtonEditTemplate.Visible = false;
        PanelEditTemplate.Visible = true;
    }
 

    protected void btnCancel_Click(object sender, EventArgs e)
    {
        RedirectPage();
    }

    public void RedirectPage()
    {
        Response.Redirect("~/ManageEmailTemplate.aspx", false);
        Context.ApplicationInstance.CompleteRequest();
    }
    
}
