﻿<%@ Page Title= "Clinical User Ad Hoc Report"  Language="C#" EnableEventValidation="false" MasterPageFile="~/Registry.master"AutoEventWireup="true" CodeFile="ClinicalUserAdHocReport.aspx.cs" Inherits="ClinicalUserAdHocReport" %>
<%@ Register src="controls/BaseControlTextBox.ascx" tagname="BaseControlTextBox" tagprefix="UserControl" %>
<%@ Register Assembly="Microsoft.ReportViewer.WebForms, Version=11.0.0.0, Culture=neutral, PublicKeyToken=89845dcd8080cc91"
    Namespace="Microsoft.Reporting.WebForms" TagPrefix="rsweb" %>
<%@ Register Src="controls/BaseControlDropDownList.ascx" TagName="BaseControlDropDownList" TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlFromToDate.ascx" TagName="UserControlFromToDate" TagPrefix="UserControl" %>
<%@ Register Src="controls/BaseControlListBox.ascx" TagName="BaseControlListBox" TagPrefix="UC" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="<H1>Administration > Clinical User Ad Hoc Report</H1>"/>
    </div><br /> 
     <asp:Panel ID="MainPanel" runat="server" GroupingText="Selection Criteria (Please select at least one)">
        <asp:Panel ID="PanelSearchCriteriaAction" runat="server" GroupingText="Action Search Criteria">
        <table>
            <tr>
                <td><UserControl:BaseControlDropDownList ID="BaseControlDropDownListActionType" runat="server" /></td>
                <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
                <td><UserControl:UserControlFromToDate ID="UserControlDateRangeActionDate" runat="server" /></td>
            </tr>
        </table>
        </asp:Panel>
        <table>
            <tr>
                <td><UserControl:BaseControlDropDownList ID="BaseControlDropDownListRole" runat="server" /></td>
               <td style="align-content: initial"><UserControl:BaseControlDropDownList ID="BaseControlDropDownListStatus" runat="server" /></td>
                <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
                <td colspan="2"><UC:BaseControlListBox ID="BaseControlListBoxPrimaryJob" runat="server" /></td>
            </tr>
            <tr>
                <td colspan="2"><UC:BaseControlListBox ID="BaseControlListBoxWorkLocation" runat="server" /></td>
                <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
                <td colspan="2"><UC:BaseControlListBox ID="BaseControlListBoxSecondaryJob" runat="server" /></td>
            </tr>
             <tr>
                 <td>
                     <UserControl:BaseControlDropDownList ID="BaseControlDropDownListChangeStatusState" runat="server" />
                 </td>
                 <td colspan="2">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
                 <td colspan="2">
                     <UserControl:BaseControlTextBox ID="BaseControlTextBoxJobTitle" runat="server" />
                 </td>
             </tr>
        </table>
        <asp:CustomValidator ID="CustomValidatorSearchCriteria" runat="server" ErrorMessage="Please enter at least one of the following fields: Action Type, Date Range, Role, Status, Primary Job, Secondary Job, Work Location, Change Status State, and Job Title."
    ValidationGroup="OnRunReport" ForeColor="DarkRed"></asp:CustomValidator>
   <br />
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        <asp:Panel ID="PanelButtons" runat="server" Width="100%" Visible="true">
            <table>
                <tr>
                    <td>
                        <asp:Button runat="server" ID="ButtonRunReport" Text="Run Report" OnClick="ButtonRunReport_Click"
                            Width="120px" ValidationGroup="OnRunReport" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <asp:Button runat="server" ID="ButtonClear" Text="Clear" Width="120px" OnClick="ButtonClear_Click"/>
                    </td>
                </tr>
            </table>
        </asp:Panel>
    </asp:Panel>
         <br />
        <asp:Panel ID="PanelClinicalUserAdHocReport" runat="server" Visible="false" GroupingText=" Clinical User Ad-Hoc Report Results ">
        <asp:Label runat="server" ID="LabelNumberOfResultsFound" Font-Bold="true"></asp:Label>
        <div style="text-align: right;" runat="server" id="pageSizeDiv">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl"  Visible="false" ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true" Visible="false" CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
        </div>
        <asp:GridView ID="GridViewClinicalUserAdHocReport" runat="server" DataSourceID="DataSourceClinicalUserAdHocReport"
            AutoGenerateColumns="False" PageSize="20" Width="100%" AllowPaging="True" AllowSorting="True"
            Caption="To sort please click table headings"
            OnRowCommand="GridViewClinicalUserAdHocReport_RowCommand" PagerSettings-Mode="Numeric"
            OnPageIndexChanging="gridView_PageIndexChanging">
            <EmptyDataTemplate>
                No match found. Please verify the information you entered in the search criteria.</EmptyDataTemplate>
            <Columns>
                <asp:TemplateField HeaderText="Last Name" SortExpression="LAST_NAME">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelLastName" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("LAST_NAME")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="First Name" SortExpression="FIRST_NAME"
                    ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelFirstName" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("FIRST_NAME")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Roles" SortExpression="ROLES" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelRoles" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("ROLES")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Primary Job" SortExpression="PRIMARY_JOB" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelPrimaryJob" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("PRIMARY_JOB")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Job Title" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelJobTitle" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("JOB_TITLE")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Status" SortExpression="STATUS" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelStatus" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Status")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Work Location" SortExpression="WORK_LOCATION" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelWorkLocation" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("WORK_LOCATION")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                 <asp:TemplateField HeaderText="Change Status States" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelChangeStatusStates" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("STATES")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
            <HeaderStyle HorizontalAlign="Left" />
        </asp:GridView>
    </asp:Panel>
        <br />
        <asp:ObjectDataSource ID="DataSourceClinicalUserAdHocReport" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetClinicalUserAdHocReport" EnablePaging="true" StartRowIndexParameterName="startRowIndex"
        MaximumRowsParameterName="maximumRows" SortParameterName="SortExpression" SelectCountMethod="GetClinicalUserAdHocReportCount"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRReportManager"
        onselected="DataSourceClinicalUserAdHocReport_Selected">
        <SelectParameters>
            <asp:ControlParameter ControlID="BaseControlDropDownListActionType" Name="actionTypeId" PropertyName="Text"
                Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeActionDate" Name="fromDateText" PropertyName="FromDateValue"
                Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeActionDate" Name="toDateText" PropertyName="ToDateValue"
                Type="String" />
             <asp:ControlParameter ControlID="BaseControlDropDownListRole" Name="userRoleId" PropertyName="Text" Type="String" />  
            <asp:ControlParameter ControlID="BaseControlDropDownListStatus" Name="StatusId" PropertyName="Text" Type="String" />    
            <asp:ControlParameter ControlID="BaseControlListBoxPrimaryJob" Name="PrimaryJob" PropertyName="Text"
                Type="String" /> 
            <asp:ControlParameter ControlID="BaseControlListBoxWorkLocation" Name="WorkLocation" PropertyName="Text"
                Type="String" /> 
             <asp:ControlParameter ControlID="BaseControlListBoxSecondaryJob" Name="SecondaryJob" PropertyName="Text"
                Type="String" /> 
            <asp:ControlParameter ControlID="BaseControlDropDownListChangeStatusState" Name="ChangeStatusState"
                PropertyName="Text" Type="String" /> 
            <asp:ControlParameter ControlID="BaseControlTextBoxJobTitle" Name="JobTitle"
                PropertyName="Text" Type="String" />   
            <asp:Parameter Name="totalRecords" Type="Int32" Direction="Output" />       
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:HiddenField runat="server" ID="HiddenFieldSort" />
</asp:Content>