﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Services;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR;

/// <summary>
/// Get a collection list for the child dropdownlist based on the value selected from the parent dropdownlist.
/// </summary>
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
[System.Web.Script.Services.ScriptService]
public class FillDropDownList : System.Web.Services.WebService
{
    [WebMethod]
    public List<KeyValuePair<int, string>> GetLookupListByParentId(int parentId, string category)
    {
        AHOBPRBaseControlManager lookupManager = new AHOBPRBaseControlManager();
        List<KeyValuePair<int, string>> results = new List<KeyValuePair<int, string>>();
        foreach (VIEW_FACILITY_LOOKUP item in lookupManager.GetFacilityListByParentId(category, parentId))
        {
            results.Add(new KeyValuePair<int, string>(item.ID, item.NAME));
        }

        return results;
    }
}
