/* 
Author: L. Mansfield
Date: 9-14-2017
Description: Drop new tables: STD_DEPLOYMENT_STAGE, STD_RETIREMENT_TERMINATION_REASON, STD_RETIREMENT_TYPE, REGISTRANT_RETIREMENT,
			and USER_STATES_FILTER.
			Revert existing tables: REGISTRANT and REGISTRANT_DEPLOYMENT to their previous state
*/


:setvar DatabaseName "REGISTRYHRE"
:setvar MajorReleaseNumber "4" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "8"
:setvar ScriptName "1_ROLLBACK.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Rollback of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following two lines:
*/
SET NOEXEC OFF; 
SET NOCOUNT OFF;
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO
USE $(DatabaseName)
GO

IF NOT EXISTS ( select * from [dbo].[DatabaseChangeLog]
				where [MajorReleaseNumber]	= '$(MajorReleaseNumber)'
				  and [MinorReleaseNumber]	= '$(MinorReleaseNumber)'
				  and [PointReleaseNumber]	= '$(PointReleaseNumber)'
				  and [TargetRegistry]		= 'AHOBPR'
			  )
BEGIN
   RAISERROR('!!!!The target version to rollback was not found in the DatabaseChangeLog.  The rollback will not execute.'
              ,11
              ,1);
END
GO
---------------------------------------------------------------------------------------------------------
PRINT '$(ScriptName) script started...';
PRINT GETDATE();
GO
---------------------------------------------------------------------------------------------------------


-- Remove FK from REGISTRANT_DEPLOYMENT Table
IF (OBJECT_ID('[FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE]', 'F') IS NOT NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE';
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] DROP CONSTRAINT FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE;
END
GO
IF (OBJECT_ID('[FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE]', 'D') IS NOT NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE';
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] DROP CONSTRAINT FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE;
END
GO
IF (OBJECT_ID('[FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE]', 'C') IS NOT  NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE';
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] DROP CONSTRAINT FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE;
END
GO
IF EXISTS (SELECT *  FROM  [sys].[default_constraints] 
		   WHERE  object_id = OBJECT_ID(N'ahobpr.DF_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE') )
BEGIN
	ALTER 
		TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] 
		DROP CONSTRAINT [DF_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE];
END
IF (OBJECT_ID('ahobpr.[FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE]', 'F') IS NOT NULL)
BEGIN
	Print N'Trying to drop foreign key FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE';
	ALTER 
		TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT]  
		DROP  CONSTRAINT [FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE];
END
-- Remove the STD_DEPLOYMENT_STAGE_ID Column
IF EXISTS (SELECT * FROM  sys.columns WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_DEPLOYMENT]') AND name = 'STD_DEPLOYMENT_STAGE_ID')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] DROP COLUMN  STD_DEPLOYMENT_STAGE_ID;
END
GO
-- Drop the STD_DEPLOYMENT_STAGE table
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_DEPLOYMENT_STAGE]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[STD_DEPLOYMENT_STAGE];
END
GO
--Remove REGISTRANT_RETIREMENT table
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_RETIREMENT]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[REGISTRANT_RETIREMENT];
END
-- Remove STD_RETIREMENT_TERMINATION_REASON Table
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_RETIREMENT_TERMINATION_REASON]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[STD_RETIREMENT_TERMINATION_REASON];
END
-- Remove STD_RETIREMENT_TYPE table 
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_RETIREMENT_TYPE]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[STD_RETIREMENT_TYPE];
END

-- Remove USER_STATES_FILTER Table
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[USER_STATES_FILTER]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[USER_STATES_FILTER];
END
-- Remove Columns from REGISTRANT
IF EXISTS (SELECT * FROM sys.columns WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT]') AND name = 'PRE_911_DEPLOYMENT')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT] DROP COLUMN [PRE_911_DEPLOYMENT]  ;
END
IF EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT]') AND name = 'POST_911_DEPLOYMENT')
BEGIN
    ALTER TABLE [AHOBPR].[REGISTRANT] DROP COLUMN [POST_911_DEPLOYMENT] ;
END
-- Removing AHOBPR_CHANGE_STATUS_REGISTRANT_SEARCH from STD_GUI_CONTROLS

DELETE FROM [dbo].[STD_GUI_CONTROLS] WHERE [STD_REGISTRY_ID] IN
        (SELECT ID FROM [dbo].[STD_REGISTRY] where [CODE] = 'AHOBPR')
    AND 
        [CATEGORY] = N'AHOBPR_CHANGE_STATUS_REGISTRANT_SEARCH'
    AND 
        [USER_CONTROL_ID] = 'BaseControlTextStatesFilter';

-- Removing AHOBPR_MYACCOUNT_ACCOUNTINFORMATION from STD_GUI_CONTROLS

DELETE FROM [dbo].[STD_GUI_CONTROLS]
    WHERE [STD_REGISTRY_ID] IN
        (SELECT ID FROM [dbo].[STD_REGISTRY] where [CODE] = 'AHOBPR')
    AND 
        [CATEGORY] = N'AHOBPR_MYACCOUNT_ACCOUNTINFORMATION'
    AND 
        [USER_CONTROL_ID] = 'UserControlListBoxState';

        
DECLARE  @RegistryId int

BEGIN
	SELECT @RegistryId = ID FROM [dbo].[STD_REGISTRY] where [CODE] = N'AHOBPR';
	-- Delete the previously inserted AHOBPR GUI control entries...
	DELETE FROM [dbo].[STD_GUI_CONTROLS] 
	WHERE [STD_REGISTRY_ID] = @RegistryId 
		and CATEGORY = 'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL' 
		AND [USER_CONTROL_ID] IN ('BaseControlLabelDeathDate', 'BaseControlLabelRetirementType', 'BaseControlLabelRetirementDate');
END

;WITH  MasterData
AS    ( 
        SELECT [CODE],  [DESCRIPTION]
        FROM    (VALUES             
( '1A', N'North Atlantic Ocean'),
( '1B', N'Bay of Biscay'),
( '1C', N'Bristol Channel'),
( '1D', N'Denmark Strait'),
( '1E', N'English Channel'),
( '1F', N'Bay of Fundy'),
( '1G', N'Gulf of Guinea'),
( '1H', N'Hudson Bay'),
( '1J', N'Panama Canal'),
( '1K', N'Inner Seas (west coast of Scotland)'),
( '1L', N'Labrador Sea'),
( '1M', N'Gulf of Mexico'),
( '1N', N'North Sea'),
( '1P', N'Baffin Bay'),
( '1Q', N'St. Georges Channel'),
( '1R', N'Irish Sea'),
( '1S', N'Skagerrak'),
( '1T', N'Gulf of St. Lawrence'),
( '1U', N'Hudson Strait'),
( '1V', N'Davis Strait'),
( '1X', N'Caribbean Sea'),
( '2A', N'South Atlantic Ocean'),
( '2D', N'Drake Passage'),
( '2J', N'Gulf of San Jorge'),
( '2M', N'Gulf of San Matias'),
( '2R', N'Rio de la Plata'),
( '2S', N'Scotia Sea'),
( '2W', N'Weddell Sea'),
( '3A', N'North Pacific Ocean'),
( '3B', N'Gulf of Sakhalin'),
( '3C', N'Celebes Sea'),
( '3D', N'Gulf of Tatary'),
( '3E', N'East China Sea'),
( '3F', N'Formosa Strait'),
( '3G', N'Gulf of Tonkin'),
( '3H', N'Halmahera Sea'),
( '3I', N'Luzon Strait'),
( '3J', N'Sea of Japan'),
( '3K', N'Shelekova Gulf'),
( '3L', N'Gulf of California'),
( '3M', N'Molucca Sea'),
( '3N', N'Inland Sea'),
( '3P', N'Philippine Sea'),
( '3Q', N'Sea of Okhotsk'),
( '3R', N'Korea Bay'),
( '3S', N'Sulu Sea'),
( '3T', N'Gulf of Siam'),
( '3U', N'South China Sea'),
( '3V', N'Gulf of Tomini'),
( '3X', N'Gulf of Chihli'),
( '3Y', N'Yellow Sea'),
( '3Z', N'Singapore Strait'),
( '4A', N'South Pacific Ocean'),
( '4B', N'Banda Sea'),
( '4C', N'Coral Sea'),
( '4D', N'Amundsen Sea'),
( '4E', N'Gulf of Bone'),
( '4F', N'Flores Sea'),
( '4G', N'Bellingshausen Sea'),
( '4J', N'Java Sea'),
( '4K', N'Bismarck Sea'),
( '4L', N'Bali Sea'),
( '4M', N'Makassar Strait'),
( '4P', N'Gulf of Carpentaria'),
( '4Q', N'Ceram Sea'),
( '4R', N'Ross Sea'),
( '4S', N'Solomon Sea'),
( '4T', N'Tasman Sea'),
( '4U', N'Arafura Sea'),
( '5A', N'Arctic Ocean'),
( '5B', N'Barents Sea'),
( '5C', N'Chukchi Sea'),
( '5D', N'Bering Sea'),
( '5E', N'Coastal waters of SE Alaska and British Columbia'),
( '5F', N'Gulf of Alaska'),
( '5G', N'Greenland Sea'),
( '5K', N'Kara Sea'),
( '5L', N'Lincoln Sea'),
( '5N', N'Norwegian Sea'),
( '5P', N'Laptev Sea'),
( '5R', N'Bering Strait'),
( '5S', N'East Siberian Sea'),
( '5T', N'Northwest Passage'),
( '5U', N'Beaufort Sea'),
( '5W', N'White Sea'),
( '5Y', N'Gulf of Anadyr'),
( '6A', N'Indian Ocean'),
( '6B', N'Bay of Bengal'),
( '6C', N'Malacca Strait'),
( '6D', N'Gulf of Aden'),
( '6E', N'Red Sea'),
( '6F', N'Bass Strait'),
( '6G', N'Great Australian Bight'),
( '6L', N'Laccadive Sea'),
( '6M', N'Gulf of Oman'),
( '6N', N'Andaman Sea'),
( '6P', N'Persian Gulf'),
( '6Q', N'Gulf of Aqaba'),
( '6R', N'Arabian Sea'),
( '6S', N'Savu Sea'),
( '6T', N'Timor Sea'),
( '6U', N'Suez Canal'),
( '6W', N'Gulf of Suez'),
( '6Z', N'Mozambique Channel'),
( '7B', N'Baltic Sea'),
( '7F', N'Gulf of Finland'),
( '7H', N'Gulf of Riga'),
( '7K', N'Kattegat'),
( '7T', N'Gulf of Bothnia'),
( '8B', N'Black Sea'),
( '8C', N'Caspian Sea'),
( '8D', N'Adriatic Sea'),
( '8E', N'Eastern Mediterranean Sea'),
( '8G', N'Aegean Sea'),
( '8J', N'Balearic Sea'),
( '8L', N'Ligurian Sea'),
( '8M', N'Sea of Marmara'),
( '8N', N'Ionian Sea'),
( '8P', N'Bosporus'),
( '8R', N'Aral Sea'),
( '8S', N'Strait of Gibraltar'),
( '8T', N'Tyrrhenian Sea'),
( '8U', N'Dardanelles'),
( '8W', N'Western Mediterranean Sea'),
( '8X', N'Gulf of Lion'),
( '8Y', N'Alboran Sea'),
( '8Z', N'Sea of Azov'),
( '9E', N'Lake Erie'),
( '9H', N'Lake Huron'),
( '9L', N'St. Lawrence Seaway'),
( '9M', N'Lake Michigan'),
( '9N', N'Lake Ontario'),
( '9S', N'Lake Superior'))
AS MasterRecord(CODE, DESCRIPTION)
)
MERGE
  INTO [AHOBPR].[STD_COUNTRY] AS Tgt
  USING MasterData AS Src
  ON    Tgt.[CODE] = Src.CODE
 WHEN  NOT MATCHED
 THEN  INSERT
        ([CODE],  [DESCRIPTION]) 
        VALUES
        (Src.CODE, Src.DESCRIPTION)
 WHEN MATCHED 
 THEN UPDATE SET Tgt.[CODE] = Src.CODE,
                 Tgt.DESCRIPTION = Src.DESCRIPTION;

GO

--

/* 
Author: L. Mansfield
Date: 9-14-2017
Description: Reset STD_APPAGE and STD_ROLE_PERMISSIONS based on Roles
*/

DECLARE @PageId INT, @AdminRoleId INT, @AdvancedUserRoleId INT, @CareTeamRoleId INT, @RegistryId INT, @HelpDeskRoleId INT;
DECLARE @UserName VARCHAR(10) = 'AHOBPR DBA';
DECLARE @Today DateTime2 = GETDATE();

SET @RegistryId  = (SELECT ID FROM [dbo].[STD_REGISTRY] where [CODE] = N'AHOBPR');

-- Load STD_ROLE
WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES  
               (N'AHOBPR_REGISTRY_MANAGER', N'AHOBPR Registry Manager', N'AHOBPR Registry Manager who is a super user of the registry', 1, 1),
               (N'AHOBPR_ADVANCED_USER', N'AHOBPR Advanced User', N'AHOBPR Advanced User', 2, 0),
               (N'AHOBPR_CARE_TEAM',    N'AHOBPR Care Team',    N'AHOBPR Care Team', 3, 0),
			   (N'AHOBPR_HELP_DESK',    N'AHOBPR Help Desk',    N'AHOBPR Help Desk', 4, 0))
       AS MasterRecord(CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER, SUPER_USER_FLAG)
       )
MERGE
  INTO  [dbo].[STD_ROLE] AS Tgt
  USING MasterData AS Src
  ON    Tgt.[CODE] = Src.CODE
 WHEN  NOT MATCHED
 THEN  INSERT
        ([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [PARENT_ROLE_ID], [STD_REGISTRY_ID], [SUPER_USER_FLAG]) 
        VALUES
        (Src.CODE, Src.NAME, Src.DESCRIPTION_TEXT, Src.SORT_ORDER, 0, NULL,  @UserName, @UserName, @Today,@Today, NULL, @RegistryId, Src.SUPER_USER_FLAG)
 WHEN MATCHED 
 THEN UPDATE SET Tgt.[NAME] = Src.Name,
                 Tgt.DESCRIPTION_TEXT = Src.DESCRIPTION_TEXT,
                 Tgt.SORT_ORDER = Src.SORT_ORDER,
                 Tgt.SUPER_USER_FLAG = Src.SUPER_USER_FLAG,
                 Tgt.STD_REGISTRY_ID = @RegistryId;

-- Load STD_APPPAGE
WITH  MasterData
AS    ( 
        SELECT *
        FROM   ( VALUES  
				('AHOBPR ADMIN EDIT USERS','AHOBPR ADMIN EDIT USERS','AHOBPR Admin Edit Users',1),
				('AHOBPR ADMIN LIST USERS','AHOBPR ADMIN LIST USERS','AHOBPR Admin List Users',1),
				('AHOBPR ADMIN TRACKING','AHOBPR ADMIN TRACKING','AHOBPR ADMIN TRACKING',1),
				('AHOBPR ADMIN USER ROLE','AHOBPR ADMIN USER ROLE','AHOBPR Admin User Role',1),
				('AHOBPR CHANGE STATUS','AHOBPR CHANGE STATUS','AHOBPR CHANGE STATUS',1),
				('AHOBPR QUESTIONNAIRE FULL','AHOBPR QUESTIONNAIRE FULL','AHOBPR QUESTIONNAIRE FULL',1),
				('AHOBPR QUESTIONNAIRE SECTION','AHOBPR QUESTIONNAIRE SECTION','AHOBPR QUESTIONNAIRE SECTION',1),
				('AHOBPR QUESTIONNAIRE SUMMARY','AHOBPR QUESTIONNAIRE SUMMARY','AHOBPR QUESTIONNAIRE SUMMARY',1),
				('AHOBPR REGISTRANT SEARCH','AHOBPR REGISTRANT SEARCH','AHOBPR REGISTRANT SEARCH',1),
				('AHOBPR REGISTRANTS','AHOBPR REGISTRANTS','AHOBPR REGISTRANTS',1),
				('AHOBPR REGISTRY FLAG','AHOBPR REGISTRY FLAG','AHOBPR Registry Flag will be used to flag registrants',1),
				('AHOBPR Report Ad Hoc','AHOBPR Report Ad Hoc','AHOBPR Report Ad Hoc',1),
				('AHOBPR REPORT AGING','AHOBPR REPORT AGING','AHOBPR REPORT AGING',1),
				('AHOBPR Report Selected Questionnaire','AHOBPR Report Selected Questionnaire','AHOBPR Report Selected Questionnaire',1),
				('AHOBPR Report Status by Location','AHOBPR Report Status by Location','AHOBPR Report Status by Location',1),
				('AHOBPR SUBPOPULATION FLAG','AHOBPR SUBPOPULATION FLAG','AHOBPR SUBPOPULATION FLAG',1),
				('AHOBPR STATUS HISTORY','AHOBPR STATUS HISTORY', 'AHOBPR STATUS HISTORY',1),
				('AHOBPR REPORT PARTICIPATION','AHOBPR REPORT PARTICIPATION','AHOBPR REPORT PARTICIPATION',1),
				('AHOBPR REPORT CONTACT INFORMATION','AHOBPR REPORT CONTACT INFORMATION','AHOBPR REPORT CONTACT INFORMATION',1),
				('AHOBPR REPORT AD HOC BY LOCATION','AHOBPR REPORT AD HOC BY LOCATION','AHOBPR REPORT AD HOC BY LOCATION',1),
				('AHOBPR REPORT ELIGIBILITY REVIEW','AHOBPR REPORT ELIGIBILITY REVIEW','AHOBPR REPORT ELIGIBILITY REVIEW',1),
				('AHOBPR REGISTRANT INFORMATION','AHOBPR REGISTRANT INFORMATION','AHOBPR REGISTRANT INFORMATION',1),
				('AHOBPR REGISTRY MESSAGES','AHOBPR REGISTRY MESSAGES','AHOBPR REGISTRY MESSAGES',1),
				('AHOBPR ADMIN EDIT TEMPLATE','AHOBPR ADMIN EDIT TEMPLATE','AHOBPR ADMIN EDIT TEMPLATE',1),
				('AHOBPR SEND MESSAGE','AHOBPR SEND MESSAGE','AHOBPR SEND MESSAGE',1),
				('AHOBPR TOOL','AHOBPR TOOL','AHOBPR TOOL',1),
				('AHOBPR ADMIN ADD FLAGS','AHOBPR ADMIN ADD FLAGS','AHOBPR ADMIN ADD FLAGS',1),
				('AHOBPR MY TEMPLATES','AHOBPR MY TEMPLATES','AHOBPR MY TEMPLATES',1),
				('AHOBPR REPORT FOLLOW-UP QUESTIONS','AHOBPR REPORT FOLLOW-UP QUESTIONS','AHOBPR REPORT FOLLOW-UP QUESTIONS',1),
				('AHOBPR MY ACCOUNT','AHOBPR MY ACCOUNT','AHOBPR MY ACCOUNT',1),
				('AHOBPR NAME UPDATE','AHOBPR NAME UPDATE','AHOBPR NAME UPDATE',1),
                ('ERROR PAGE','ERROR PAGE','ERROR PAGE',1),
				('AHOBPR TIMEOUT','AHOBPR TIMEOUT','AHOBPR TIMEOUT',1),
				('AHOBPR SYSTEM CHECK','AHOBPR SYSTEM CHECK','AHOBPR SYSTEM CHECK',1),
				('AHOBPR ERROR PAGE','AHOBPR ERROR PAGE','AHOBPR ERROR PAGE',1),
				('AHOBPR DEPLOYMENT HISTORY','AHOBPR DEPLOYMENT HISTORY','AHOBPR DEPLOYMENT HISTORY',1))
   AS MasterRecord(CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER)
       )
MERGE
  INTO  [dbo].STD_APPPAGE AS Tgt
  USING MasterData AS Src
  ON    Tgt.[CODE] = Src.CODE
 WHEN  NOT MATCHED
 THEN  INSERT
        ([CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
        VALUES
        (Src.CODE, Src.NAME, Src.DESCRIPTION_TEXT, Src.SORT_ORDER, 0, NULL,  @UserName, @UserName, @Today,@Today);

-- Load ROLE_PERMISSIONS
SET @AdminRoleId 		= (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_REGISTRY_MANAGER'); --100
SET @AdvancedUserRoleId = (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_ADVANCED_USER'); --101
SET @CareTeamRoleId     = (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_CARE_TEAM');--102
SET @HelpDeskRoleId     = (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_HELP_DESK');

DELETE FROM [dbo].ROLE_PERMISSIONS WHERE STD_ROLE_ID IN(@AdminRoleId, @AdvancedUserRoleId, @CareTeamRoleId, @HelpDeskRoleId);


WITH  MasterData
AS    ( 
        SELECT *
        FROM   ( VALUES  
        -- Admin User Role
				(AHOBPR.GetAppPageId('AHOBPR ADMIN EDIT USERS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN LIST USERS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN USER ROLE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR CHANGE STATUS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE FULL'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SECTION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SUMMARY'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANTS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRY FLAG'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Ad Hoc'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AGING'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Selected Questionnaire'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Status by Location'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT PARTICIPATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT CONTACT INFORMATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AD HOC BY LOCATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT ELIGIBILITY REVIEW'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT FOLLOW-UP QUESTIONS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRY MESSAGES'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN EDIT TEMPLATE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SEND MESSAGE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TOOL'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN ADD FLAGS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR NAME UPDATE'),@AdminRoleId),				
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@AdminRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@AdminRoleId),					
        	-- Advanced User Role
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR CHANGE STATUS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE FULL'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SECTION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SUMMARY'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANTS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Ad Hoc'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AGING'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Selected Questionnaire'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Status by Location'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT PARTICIPATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT CONTACT INFORMATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AD HOC BY LOCATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT FOLLOW-UP QUESTIONS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN ADD FLAGS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY TEMPLATES'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@AdvancedUserRoleId),				
		-- Care Team User Role
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE FULL'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SECTION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SUMMARY'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANTS'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Ad Hoc'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AGING'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Selected Questionnaire'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Status by Location'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT CONTACT INFORMATION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AD HOC BY LOCATION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@CareTeamRoleId),				
		-- Help Desk User Role
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR NAME UPDATE'),@HelpDeskRoleId),				
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@HelpDeskRoleId)		
				)
   AS MasterRecord(AppPageId, RoleId)
       )
MERGE
  INTO  [dbo].ROLE_PERMISSIONS AS Tgt
  USING MasterData AS Src
  ON    Tgt.[STD_APPPAGE_ID] = Src.AppPageId
  AND   Tgt.STD_ROLE_ID = Src.RoleId
 WHEN  NOT MATCHED
 THEN  INSERT
	   ([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
	VALUES(Src.RoleId, Src.AppPageId, @UserName, @UserName, @Today,@Today, 1, 1, 1);

GO
--

/* 
Author: L. Mansfield
Date: 9-14-2017
Description: Drop existing SP_UserAuditLog and revert to previous version
*/
-- Delete Installed Procedure
IF EXISTS (select * from dbo.sysobjects where id = object_id(N'AHOBPR.SP_UserAuditLog') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [AHOBPR].[SP_UserAuditLog];
GO

-- Install Previous Script
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;
GO
--
-- Last Modified Build 3.0.16
--
CREATE PROCEDURE [AHOBPR].[SP_UserAuditLog]
  @userId 			int = NULL,
  @actionTypeId 	varchar(30) = NULL, -- Action Type ID
  @fromDateText 	varchar(100) = NULL,
  @toDateText 		varchar(100) = NULL,
  @lastName 		varchar(30) = NULL, -- User last name
  @firstName 		varchar(30) = NULL, -- User first name
  @userRoleId 		varchar(30) = NULL -- User role ID
AS

BEGIN
 DECLARE @fromDate 	DATETIME2(0) = NULL,
         @toDate 	DATETIME2(0) = NULL

 --Temp table for holding the AUDIT_LOG 
  CREATE TABLE #AUDIT_LOG
  ( 	
	  [TYPE_ID] 				[tinyint] NOT NULL,
	  [USER_ID] 				[int] NULL,
	  [REGISTRANT_ID] 			[int] NULL,
	  [NUMBER_OF_REGISTRANTS] 	[int] NULL,
	  [MESSAGE] 				[varchar](1000) NULL,
	  [CREATED] 				[datetime] NOT NULL
	 );

  INSERT INTO #AUDIT_LOG
    SELECT [TYPE_ID], [USER_ID],[REGISTRANT_ID],[NUMBER_OF_REGISTRANTS],[MESSAGE],[CREATED] 
	  FROM AHOBPR.AUDIT_LOG
	  WHERE USER_ID IS NOT NULL;

  -- Convert date parameters      
  SET @fromDate = dbo.CleanDate(@fromDateText);
  SET @toDate = dbo.AddMaxTime(dbo.CleanDate(@toDateText));

 IF @fromDate IS NOT NULL 
	  DELETE FROM #AUDIT_LOG WHERE CREATED < @fromDate

 IF @toDate IS NOT NULL 
	  DELETE FROM #AUDIT_LOG WHERE CREATED > @toDate
  
 IF @actionTypeId IS NOT NULL AND @actionTypeId != ''
	  DELETE FROM #AUDIT_LOG WHERE TYPE_ID <> @actionTypeId

 IF @userId IS NOT NULL AND @userId != 0
	  DELETE FROM #AUDIT_LOG WHERE USER_ID <> @userId

  IF @userRoleId IS NOT NULL AND @userRoleId != ''
	  DELETE FROM #AUDIT_LOG 
	    WHERE USER_ID NOT IN (SELECT A.USER_ID FROM DBO.USER_ROLES A,  #AUDIT_LOG B 
													  WHERE A.STD_ROLE_ID = @userRoleId AND A.USER_ID = B.USER_ID);
                                  
  IF @lastName IS NOT NULL AND @lastName != ''
	  DELETE FROM #AUDIT_LOG 
	    WHERE USER_ID NOT IN (SELECT A.USER_ID FROM DBO.USERS A,  #AUDIT_LOG B 
													  WHERE A.USER_ID = B.USER_ID AND A.LAST_NAME LIKE '%' + @lastName + '%');
  IF @firstName IS NOT NULL AND @firstName != ''
	  DELETE FROM #AUDIT_LOG 
	    WHERE USER_ID NOT IN (SELECT A.USER_ID FROM DBO.USERS A,  #AUDIT_LOG B 
													  WHERE A.USER_ID = B.USER_ID AND A.FIRST_NAME LIKE '%' + @firstName + '%');

  SELECT  A.CREATED, 
          B.DESCRIPTION AS ACTION_TYPE, 
          CASE  WHEN A.TYPE_ID = 2 OR A.TYPE_ID = 12 OR A.TYPE_ID = 13 
                THEN CASE WHEN C.LAST_NAME IS NULL THEN ''
					                ELSE ISNULL(C.LAST_NAME, '') + ', ' + ISNULL(C.FIRST_NAME, '') + ' ' + ISNULL(C.MIDDLE_NAME, '')
					                END
				        WHEN A.TYPE_ID = 11  THEN ''
	                    ELSE A.MESSAGE 
	              END AS DETAILS, 
          REPLACE(CAST(ISNULL(A.NUMBER_OF_REGISTRANTS, 0) AS varchar(10)), '0', '') AS NUM_REGISTRANTS,
		  D.FULL_NAME, A.USER_ID
  FROM #AUDIT_LOG A 
	LEFT OUTER JOIN [AHOBPR].[AUDIT_LOG_TYPE] B ON A.TYPE_ID = B.TYPE_ID
	LEFT OUTER JOIN [AHOBPR].[REGISTRANT] C ON A.REGISTRANT_ID = C.REGISTRANT_ID
	LEFT OUTER JOIN DBO.USERS D ON A.USER_ID = D.USER_ID;         		
END
-- EXECUTE AHOBPR.SP_UserAuditLog @userId = 115, @actionTypeId = NULL, @fromDateText = NULL, @toDateText = NULL
-- EXECUTE AHOBPR.SP_UserAuditLog @userId = 1, @actionTypeId = '1', @fromDateText = NULL, @toDateText = NULL
-- EXECUTE AHOBPR.SP_UserAuditLog @userId = 1, @actionTypeId = '1', @fromDateText = NULL, @toDateText = '1/1/2016'
-- EXECUTE AHOBPR.SP_UserAuditLog @userId = 1, @actionTypeId = '1', @fromDateText = '5/3/2016', @toDateText = NULL
-- EXECUTE AHOBPR.SP_UserAuditLog @userId = NULL, @actionTypeId = NULL, @fromDateText = '5/1/2016', @toDateText = '5/4/2016'
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;
GO



---------------------------------------------------------------------------------------------------------
print N'Rollback complete.';
print 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------
go


delete
	from  [dbo].[DatabaseChangeLog]
	where [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
	  and [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
	  and [PointReleaseNumber]  = '$(PointReleaseNumber)'
	  and TargetRegistry        = 'AHOBPR';
   
go
select * from [dbo].[DatabaseChangeLog]
where TargetRegistry        = 'AHOBPR'
  and [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  and [PointReleaseNumber] = '$(PointReleaseNumber)';  