﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Linq;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System.Data;
using System.Reflection;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public enum ParticipationReportDataType
    {
        ParticipantStatus = 0,
        HealthConcern = 1,
        NoHealthConcern = 2,
        Veteran = 3,
        ActiveDuty = 4,
        Retiree = 5,
        IrapAfter911 = 6,
        AfghanistanAfter911 = 7,
        AsiaBefore911 = 8,
        SouthwestAsiaAfter911 = 9,
        RequestToBeSeen = 10,
        NoRequestToBeSeen = 11,
        UnknownRequestToBeSeen = 12,
        MedianTimeCompleteForm = 13,
        DjiboutiAfter911 = 14
    }

    public class AHOBPRReportManager : AHOBPRBaseBO
    {

        private AHOBPRShared _sharedManager = new AHOBPRShared();
        //private AHOBPRLookUpManager _lookupManager = new AHOBPRLookUpManager();
        
        public class DictionaryDTO
        {
            public int Key { get; set; }
            public string Value { get; set; }
        }

        public class UniqueQuestionIdDTO
        {
            public string Key { get; set; }
            public string Value { get; set; }
        }

        private int totalCount = 0;

        #region Methods for Status by location report

        public string GetStateParameterList()
        {
            string result = string.Empty;

            AHOBPRBaseControlManager manager = new AHOBPRBaseControlManager();
            List<AHOBPR_VIEW_LOOKUP> state_list = manager.SelectLookupList("STD_STATE");

            List<string> stateList = (from v in state_list
                                      select v.ID.ToString()).ToList();

            result = string.Join(",", stateList.ToArray());

            return result;

        }

        public string GetStatusParameterList()
        {
            string result = string.Empty;

            AHOBPRBaseControlManager manager = new AHOBPRBaseControlManager();
            List<AHOBPR_VIEW_LOOKUP> status_list = manager.SelectLookupList("REGISTRY_STATUS");

            List<string> statusList = (from v in status_list
                                      select v.ID.ToString()).ToList();

            result = string.Join(",", statusList.ToArray());

            return result;

        }

        public string GetDutyStatusParameterList()
        {
            string result = string.Empty;

            AHOBPRBaseControlManager manager = new AHOBPRBaseControlManager();
            List<AHOBPR_VIEW_LOOKUP> status_list = manager.SelectLookupList("STD_SERVICE_STATUS");

            List<string> statusList = (from v in status_list
                                       select v.ID.ToString()).ToList();

            result = string.Join(",", statusList.ToArray());

            return result;

        }

        public string GetAnswerParameterList(string question)
        {
            string result = string.Empty;

            AHOBPRBaseControlManager manager = new AHOBPRBaseControlManager();
            List<AHOBPR_VIEW_LOOKUP> answer_list = GetAnswers(question);
            //var answer_list = GetAnswers(question);

            List<string> answerList = (from v in answer_list
                                       select v.ID.ToString()).ToList();

            result = string.Join(",", answerList.ToArray());

            return result;

        }

        public IList<SP_ReportStatusByLocationResult> GetStatusByLocation(string state, string status, string AssignedLocationType, string AssignedLocationKey, string EvaluationLocationType, string EvaluationLocationKey, string closestFacilityId,
                                                                          string totalRecords, string SortExpression, int maximumRows, int startRowIndex) 
        {
            const string gridDefaultSort = @"Name";

            if (string.IsNullOrEmpty(SortExpression))
            {
                SortExpression = string.Format("{0}", gridDefaultSort);
            }

            using (AHOBPRLinqDataContext _dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;
                IQueryable<SP_ReportStatusByLocationResult> mainQueryGridView;

                //call stored procedure
                var results = _dbAhopbr.SP_ReportStatusByLocation(state, status, AssignedLocationType, AssignedLocationKey, EvaluationLocationType, EvaluationLocationKey, closestFacilityId).ToList();

                mainQueryGridView = results.AsQueryable();


                //sort
                totalCount = mainQueryGridView.Count();

                return (mainQueryGridView).SortAndPage(SortExpression, maximumRows, startRowIndex).ToList<SP_ReportStatusByLocationResult>();
            }
        }


        public int GetStatusByLocationCount(string State, string Status, string AssignedLocationType, string AssignedLocationKey, string EvaluationLocationType, string EvaluationLocationKey, string closestFacilityId, string totalRecords)
        {
            return totalCount;
        }
                       

     #endregion

        #region Methods for AD Hoc report

        public IList<SP_ReportAdHocByIndividualResult> GetAdHocData(string status, string dutyStatus,
                string formStartFromDateText, string formStartToDateText, string healthFactor,
                string formCompletionFromDateText, string formCompletionToDateText, string questionNumber,
                string answer, string healthConcerns, string requestToBeSeen, string assignedLocationType, string assignedLocationKey,
                string evaluatedLocationType, string evaluatedLocationKey,   
                string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
                string adminFlagFromDateText, string adminFlagToDateText, string excludeDead, string gender, string race,
                string ethnicity, int separationType, string separationFromDateText, string separationToDateText, string enrollmentStatus,
                string evaluation, string StatusFromDateText, string StatusToDateText, string closestFacilityId, 
                string sortExpression, int maximumRows, int startRowIndex)
        {
            const string gridDefaultSort = @"Name";

            if (string.IsNullOrEmpty(sortExpression))
            {
                sortExpression = string.Format("{0}", gridDefaultSort);
            }

            IQueryable<SP_ReportAdHocByIndividualResult> mainQueryGridView;
            

            using (_dbAhopbr = GetDataContext())
            {
               _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;
                //call stored procedure
                var results = _dbAhopbr.SP_ReportAdHocByIndividual(status, dutyStatus,
                    formStartFromDateText, formStartToDateText, healthFactor,
                    formCompletionFromDateText, formCompletionToDateText, questionNumber,
                    answer, healthConcerns, requestToBeSeen, assignedLocationType, assignedLocationKey, evaluatedLocationType, evaluatedLocationKey,
                    subpopulationFlag, adminFlag, deploymentAll, deploymentExposure,
                    adminFlagFromDateText, adminFlagToDateText, excludeDead, gender, race,
                    ethnicity, separationType, separationFromDateText, separationToDateText, enrollmentStatus, evaluation, StatusFromDateText, 
                    StatusToDateText, closestFacilityId).ToList();

                mainQueryGridView = results.AsQueryable();
                //sort
                totalCount = mainQueryGridView.Count();
            }

            return (mainQueryGridView).SortAndPage(sortExpression, maximumRows, startRowIndex).ToList<SP_ReportAdHocByIndividualResult>();

        }

        public IList<SP_ReportAdHocByLocationResult> GetAdHocByLocation(string status, string dutyStatus,
            string formStartFromDate, string formStartToDate, string healthFactor,
            string formCompletionFromDate, string formCompletionToDate, string questionNumber,
            string answer, string healthConcerns, string requestBeSeen, string groupBy,
            string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
            string adminFlagFromDate, string adminFlagToDate, string excludeDead,  string gender, string race,
            string ethnicity, int separationType, string separationFromDateText, string separationToDateText, string enrollmentStatus,
            string evaluation, string StatusFromDateText, string StatusToDateText,  string sortExpression, int maximumRows, int startRowIndex)
        {
            const string gridDefaultSort = @"Location";

            if (string.IsNullOrEmpty(sortExpression))
            {
                sortExpression = string.Format("{0}", gridDefaultSort);
            }
                        

            IQueryable<SP_ReportAdHocByLocationResult> mainQueryGridView;
            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;
                //call stored procedure
                var results = _dbAhopbr.SP_ReportAdHocByLocation(status, dutyStatus,
                    formStartFromDate, formStartToDate, healthFactor,
                    formCompletionFromDate, formCompletionToDate, questionNumber,
                    answer, healthConcerns, requestBeSeen, groupBy,
                    subpopulationFlag, adminFlag, deploymentAll, deploymentExposure,
                    adminFlagFromDate, adminFlagToDate, excludeDead, gender, race,
                    ethnicity, separationType, separationFromDateText, separationToDateText, enrollmentStatus, evaluation, StatusFromDateText, 
                    StatusToDateText).ToList();

                mainQueryGridView = results.AsQueryable();
                //sort
                totalCount = mainQueryGridView.Count();
            }

            return (mainQueryGridView).SortAndPage(sortExpression, maximumRows, startRowIndex).ToList<SP_ReportAdHocByLocationResult>();

        }

        public int GetAdHocByLocationCount(string status, string dutyStatus,
            string formStartFromDate, string formStartToDate, string healthFactor,
            string formCompletionFromDate, string formCompletionToDate, string questionNumber,
            string answer, string healthConcerns, string requestBeSeen, string groupBy,
            string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
            string adminFlagFromDate, string adminFlagToDate, string excludeDead, string gender, string race,
            string ethnicity, int separationType, string separationFromDateText, string separationToDateText, string enrollmentStatus, string evaluation,
            string StatusFromDateText, string StatusToDateText)
        {
            return totalCount;
        }

        public int GetAdHocCount(string status, string dutyStatus,
                string formStartFromDateText, string formStartToDateText, string healthFactor,
                string formCompletionFromDateText, string formCompletionToDateText, string questionNumber,
                string answer, string healthConcerns, string requestToBeSeen, string assignedLocationType, string assignedLocationKey,
                string evaluatedLocationType, string evaluatedLocationKey,
                string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
                string adminFlagFromDateText, string adminFlagToDateText, string excludeDead, string gender, string race,
                string ethnicity, int separationType, string separationFromDateText, string separationToDateText, string enrollmentStatus, string evaluation,
                string StatusFromDateText, string StatusToDateText, string closestFacilityId)
        {
            return totalCount;
        }

        public int GetAdHocByIndividualCount(string status, string dutyStatus,
                string formStartFromDateText, string formStartToDateText, string healthFactor,
                string formCompletionFromDateText, string formCompletionToDateText, string questionNumber,
                string answer, string healthConcerns, string requestToBeSeen, string AssignedLocationType, string AssignedLocationKey,
                string EvaluatedLocationType, string EvaluatedLocationKey,
                string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
                string adminFlagFromDateText, string adminFlagToDateText, string excludeDead, string gender, string race,
                string ethnicity, int separationType, string separationFromDateText, string separationToDateText, string enrollmentStatus, string evaluation,
                string StatusFromDateText, string StatusToDateText, string closestFacilityId)
        {

            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;

                //call stored procedure
               return _dbAhopbr.SP_ReportAdHocByIndividual(status, dutyStatus,
                    formStartFromDateText, formStartToDateText, healthFactor,
                    formCompletionFromDateText, formCompletionToDateText, questionNumber,
                    answer, healthConcerns, requestToBeSeen, AssignedLocationType, AssignedLocationKey,
                    EvaluatedLocationType, EvaluatedLocationKey,
                    subpopulationFlag, adminFlag, deploymentAll, deploymentExposure,
                    adminFlagFromDateText, adminFlagToDateText, excludeDead, gender, race,
                    ethnicity, separationType, separationFromDateText, separationToDateText, enrollmentStatus, evaluation, 
                    StatusFromDateText, StatusToDateText, closestFacilityId).Count();
           }
        }


        public IList<UniqueQuestionIdDTO> GetQuestions()
        {
            AHOBPRLinqDataContext db = GetDataContext();

            IList<UniqueQuestionIdDTO> QuestionNumbers = (from list in db.STD_FORM_QUESTIONs
                                            where list.FORM_QUESTION_UNIQUE_ID != "1.A"
                                                && list.STD_FORM.FOLLOWUP_FLAG == false
                                            orderby list.STD_FORM_QUESTION_ID
                                            select new UniqueQuestionIdDTO
                                            {
                                                Key = list.FORM_QUESTION_UNIQUE_ID,
                                                Value = list.FORM_QUESTION_UNIQUE_ID + " " + list.SHORT_TEXT
                                            }).Distinct()
                                             .ToList<UniqueQuestionIdDTO>();

            return QuestionNumbers;
        }

        public List<AHOBPR_VIEW_LOOKUP> GetAnswers(string questionNumber)
        {
            AHOBPRLinqDataContext db = GetDataContext();

            //Because there are multiple questionnaire forms, for the answer drop down list only select the first answerId so there 
            //will not be duplicate answers in the drop down list
            int question = (from list in db.STD_FORM_QUESTIONs
                            join STD_Form_Answer in db.STD_FORM_ANSWERs on list.STD_FORM_QUESTION_ID equals STD_Form_Answer.STD_FORM_QUESTION_ID
                            where (list.FORM_QUESTION_UNIQUE_ID == questionNumber)
                            select list.STD_FORM_QUESTION_ID).FirstOrDefault<int>();




            List<AHOBPR_VIEW_LOOKUP> QuestionAnswers = (from list in db.STD_FORM_ANSWERs
                                                        where (list.STD_FORM_QUESTION_ID == question) 
                                                            && (list.TEXT.Trim() != "" && list.TEXT != null)
                                                       select new AHOBPR_VIEW_LOOKUP
                                                        {
                                                            LOOKUP_TYPE = "STD_FORM_ANSWER",
                                                            ID = list.STD_FORM_ANSWER_ID,
                                                            CODE = list.TEXT,
                                                            NAME = list.TEXT,
                                                            PARENT_ID = 0,
                                                            SORT_ORDER = 1,
                                                        })

                                             .ToList<AHOBPR_VIEW_LOOKUP>();


            return QuestionAnswers;


        }

        public IDictionary<int, string> GetFlags()
        {
            AHOBPRLinqDataContext db = GetDataContext();
           
            IList<DictionaryDTO> flags = (from list in db.STD_REGISTRY_FLAGs
                                          where (list.ACTIVE_FLAG == true)
                                                   select new DictionaryDTO
                                                    {
                                                        Key = list.STD_REGISTRY_FLAG_ID,
                                                        Value = list.REGISTRY_FLAG_NAME
                                                    })
                                             .ToList<DictionaryDTO>();

            return flags.ToDictionary(ws => ws.Key, ws => ws.Value);


        }

        #endregion

        #region Methods for Adhoc Report Search Criteria

        /// <summary>
        /// 
        /// </summary>
        /// <param name="userName"></param>
        /// <param name="reportName"></param>
        /// <returns></returns>
        public List<REPORT_SEARCH_CRITERIA> SelectReportSearchCriteria(string userName, string reportName)
        {
            List<REPORT_SEARCH_CRITERIA> searchCriteria = new List<REPORT_SEARCH_CRITERIA>();

            using (_dbAhopbr = GetDataContext())
            {
                searchCriteria = (from e in _dbAhopbr.REPORT_SEARCH_CRITERIAs
                                  where e.REPORT_NAME == reportName
                                    && e.CREATEDBY == userName
                                  orderby e.CREATED descending
                                  select e).ToList();

            }
            return searchCriteria;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="userName"></param>
        /// <param name="reportName"></param>
        /// <returns></returns>
        public int SelectReportSearchCriteriaCount(string userName, string reportName)
        {
            return SelectReportSearchCriteria(userName, reportName).Count;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="searchCriteriaId"></param>
        /// <returns></returns>
        public string GetSearchCriteriaById(string searchCriteriaId)
        {
            string result = string.Empty;

            if (!string.IsNullOrEmpty(searchCriteriaId))
            {
                using (_dbAhopbr = GetDataContext())
                {
                    result = (from e in _dbAhopbr.REPORT_SEARCH_CRITERIAs
                              where e.REPORT_SEARCH_CRITERIA_ID == Convert.ToInt32(searchCriteriaId)
                              select e.SEARCH_CRITERIA).FirstOrDefault().ToString();

                }
            }

            return result;
        }


        /// <summary>
        /// Save search criteria
        /// </summary>
        /// <param name="reportName"></param>
        /// <param name="searchCriteriaName"></param>
        /// <param name="searchCriteria"></param>
        /// <returns></returns>
        public int SaveSearchCriteria(string reportName, string searchCriteriaName, string searchCriteria, string searchCriteriaDescription)
        {
            int returnStatus = 0;

            if (string.IsNullOrEmpty(reportName) || string.IsNullOrEmpty(searchCriteriaName)
                    || string.IsNullOrEmpty(searchCriteria) || string.IsNullOrEmpty(searchCriteriaDescription))
            {
                return returnStatus;
            }

            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.DeferredLoadingEnabled = false;

                //check if subpopulation flag exists
                REPORT_SEARCH_CRITERIA reportSearchCriteria = (from e in _dbAhopbr.REPORT_SEARCH_CRITERIAs
                                                               where e.REPORT_NAME == reportName
                                                                    && e.SEARCH_CRITERIA_NAME == searchCriteriaName
                                                                select e).FirstOrDefault();


                if (reportSearchCriteria == null)
                {
                    reportSearchCriteria = new REPORT_SEARCH_CRITERIA();

                    reportSearchCriteria.REPORT_NAME = reportName;
                    reportSearchCriteria.SEARCH_CRITERIA_NAME = searchCriteriaName;
                    reportSearchCriteria.SEARCH_CRITERIA = searchCriteria;
                    reportSearchCriteria.SEARCH_CRITERIA_DESCRIPTION = searchCriteriaDescription;

                    _dbAhopbr.REPORT_SEARCH_CRITERIAs.InsertOnSubmit(reportSearchCriteria);

                    try
                    {
                        _dbAhopbr.SubmitChanges(ConflictMode.ContinueOnConflict);

                        returnStatus = 1;
                    }
                    catch (System.Data.SqlClient.SqlException ex)
                    {
                        _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                        returnStatus = -1;
                    }
                    catch (ChangeConflictException e)
                    {
                        _dbAhopbr.ChangeConflicts.ResolveAll(RefreshMode.KeepCurrentValues);

                        try
                        {
                            _dbAhopbr.SubmitChanges(ConflictMode.FailOnFirstConflict);

                            returnStatus = 1;
                        }
                        catch (Exception ex)
                        {
                            _sharedManager.LogErrorMessage("Database Update", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                            returnStatus = -1;
                        }
                    }
                    catch
                    {
                        returnStatus = 0;
                    }
                }
                else
                {
                    returnStatus = 2;
                }
            }
            return returnStatus;
        }

        #endregion

        #region method for RemoveReportSearchCriteria

        /// <summary>
        /// 
        /// </summary>
        /// <param name="searchCriteriaId"></param>
        /// <returns></returns>
        public bool RemoveReportSearchCriteria(int searchCriteriaId)
        {
            bool returnStatus = false;
            using (_dbAhopbr = GetDataContext())
            {
                REPORT_SEARCH_CRITERIA searchCriteria = (from e in _dbAhopbr.REPORT_SEARCH_CRITERIAs
                                                         where e.REPORT_SEARCH_CRITERIA_ID == searchCriteriaId
                                                           select e).FirstOrDefault();

                _dbAhopbr.REPORT_SEARCH_CRITERIAs.DeleteOnSubmit(searchCriteria);

                try
                {
                    _dbAhopbr.SubmitChanges(ConflictMode.ContinueOnConflict);
                    returnStatus = true;
                }
                catch (System.Data.SqlClient.SqlException ex)
                {
                    _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                    returnStatus = false;
                }
                catch (ChangeConflictException)
                {
                    _dbAhopbr.ChangeConflicts.ResolveAll(RefreshMode.KeepChanges);
                    returnStatus = false;
                }
                catch (Exception ex)
                {
                    _sharedManager.LogErrorMessage("Database Update", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                    returnStatus = false;
                }
            }

            return returnStatus;
        }

        #endregion

        #region methods for  Report Search Criteria
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public List<VIEW_AVAILABLE_VISN> SelectVisn()
        {
            using (_dbAhopbr = GetDataContext())
            {
                if (AHOBPRGlobal.VisnAll == null)
                {
                    AHOBPRGlobal.VisnAll = (from e in _dbAhopbr.VIEW_AVAILABLE_VISNs
                                            orderby e.VisnID 
                                            select e).ToList();
                }

                List<VIEW_AVAILABLE_VISN> entities = AHOBPRGlobal.VisnAll;

                return entities;

            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public List<viewFacilitiesByVisn> SelectFacility()
        {
            using (_dbAhopbr = GetDataContext())
            {
                if (AHOBPRGlobal.FacilitiesByVisnAll == null)
                {
                    AHOBPRGlobal.FacilitiesByVisnAll = (from e in _dbAhopbr.viewFacilitiesByVisns
                                            where e.Name != null
                                            orderby e.Name
                                            select e).ToList();
                }

                List<viewFacilitiesByVisn> entities = AHOBPRGlobal.FacilitiesByVisnAll;

                return entities;

            }
        }

       #endregion

        #region Methods for Participation report

        /// <summary>
        /// Run participation report
        /// </summary>
        /// <param name="fromDate"></param>
        /// <param name="toDate"></param>
        /// <param name="facilityId"></param>
        /// <param name="visnId"></param>
        /// <returns></returns>
        public List<SP_ReportParticipation> GetParticipationReport(DateTime fromDate, DateTime toDate, string AssignedLocationType, string AssignedLocationKey, string EvaluationLocationType, string EvaluationLocationKey, string closestFacilityId)
        {
            List<SP_ReportParticipation> results = new List<SP_ReportParticipation>();
            
            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;
                results = _dbAhopbr.SP_ReportParticipation(fromDate, toDate, AssignedLocationType, AssignedLocationKey, EvaluationLocationType, EvaluationLocationKey, closestFacilityId).ToList();
            }
            return results;

        }

        public IList<SP_ReportParticipantDetails> GetParticipationDetailsReport(DateTime fromDate, DateTime toDate, string AssignedLocationType, string AssignedLocationKey, string EvaluationLocationType, string EvaluationLocationKey, string closestFacilityId, string dataTypeCriteria, string SortExpression, int maximumRows, int startRowIndex)
        {
            const string gridDefaultSort = @"Name";
            if (string.IsNullOrEmpty(SortExpression))
            {
                SortExpression = string.Format("{0}", gridDefaultSort);
            }

            IQueryable<SP_ReportParticipantDetails> mainQueryGridView = null;

            string registrantStatus = string.Empty;
            string serviceStatus = string.Empty;
            string requestSeen = string.Empty;
            string healthConcern = string.Empty;
            string deploymentGroup = string.Empty;

            if (dataTypeCriteria == ParticipationReportDataType.ParticipantStatus.ToString())
            {
                registrantStatus = "Participant";
            }
            else if (dataTypeCriteria == ParticipationReportDataType.ActiveDuty.ToString())
            {
                serviceStatus = "Active Duty";
            }
            else if (dataTypeCriteria == ParticipationReportDataType.Veteran.ToString())
            {
                serviceStatus = "Veteran";
            }
            else if (dataTypeCriteria == ParticipationReportDataType.Retiree.ToString())
            {
                serviceStatus = "Retiree";
            }
            else if (dataTypeCriteria == ParticipationReportDataType.AfghanistanAfter911.ToString())
            {
                deploymentGroup = "Afgh911";
            }
            else if (dataTypeCriteria == ParticipationReportDataType.IrapAfter911.ToString())
            {
                deploymentGroup = "Iraq911";
            }
            else if (dataTypeCriteria == ParticipationReportDataType.AsiaBefore911.ToString())
            {
                deploymentGroup = "Pre911";
            }
            else if (dataTypeCriteria == ParticipationReportDataType.SouthwestAsiaAfter911.ToString())
            {
                deploymentGroup = "SouthwestAsiaAfter911";
            }
            else if (dataTypeCriteria == ParticipationReportDataType.DjiboutiAfter911.ToString())
            {
                deploymentGroup = "DjiboutiAfter911";
            }
            else if (dataTypeCriteria == ParticipationReportDataType.HealthConcern.ToString())
            {
                healthConcern = "Yes";
            }
            else if (dataTypeCriteria == ParticipationReportDataType.NoHealthConcern.ToString())
            {
                healthConcern = "No";
            }
            else if (dataTypeCriteria == ParticipationReportDataType.RequestToBeSeen.ToString())
            {
                requestSeen = "Yes";
            }
            else if (dataTypeCriteria == ParticipationReportDataType.NoRequestToBeSeen.ToString())
            {
                requestSeen = "No";
            }
            else if (dataTypeCriteria == ParticipationReportDataType.UnknownRequestToBeSeen.ToString())
            {
                requestSeen = "Unknown";
            }

            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;
                var results = _dbAhopbr.SP_ReportRegistrantDetails(fromDate, toDate, registrantStatus,
                    serviceStatus, requestSeen, healthConcern, deploymentGroup, AssignedLocationType, AssignedLocationKey, EvaluationLocationType, EvaluationLocationKey, closestFacilityId).ToList();
                mainQueryGridView = results.AsQueryable();

                totalCount = mainQueryGridView.Count();

            }
            return (mainQueryGridView).SortAndPage(SortExpression, maximumRows, startRowIndex).ToList<SP_ReportParticipantDetails>();
        }

        public int GetParticipationDetailsReportCount(DateTime fromDate, DateTime toDate, string AssignedLocationType, string AssignedLocationKey, string EvaluationLocationType, string EvaluationLocationKey, string closestFacilityId, string dataTypeCriteria)
        {
            return totalCount;
        }


        #endregion

        #region Methods for Aging report
        public IList<SP_ReportRegistrantStatusAgingResult> GeAgingReport(DateTime asOfDate, string dutyStatus, string AssignedLocationType, string AssignedLocationKey, string EvaluationLocationType, string EvaluationLocationKey, string closestFacilityId)
        {
            IQueryable<SP_ReportRegistrantStatusAgingResult> mainQueryGridView = null;

            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;
                var results = _dbAhopbr.SP_ReportRegistrantStatusAging(asOfDate, dutyStatus, AssignedLocationType, AssignedLocationKey, EvaluationLocationType, EvaluationLocationKey, closestFacilityId).ToList();
                mainQueryGridView = results.AsQueryable();

                totalCount = mainQueryGridView.Count();
            }
            return (mainQueryGridView).ToList<SP_ReportRegistrantStatusAgingResult>();
        }

        public int GetAgingReportReportCount(DateTime fromDate, DateTime toDate, string AssignedLocationType, string AssignedLocationKey, string EvaluationLocationType, string EvaluationLocationKey, string closestFacilityId, string dataTypeCriteria)
        {
            return totalCount;
        }
        #endregion

        #region Methods for Contact Information report

        public IList<SP_ReportRegistrantContactResult> GetRegistrantAddress(string status, string state,
                string formStartFromDateText, string formStartToDateText, string healthFactor,
                string formCompletionFromDateText, string formCompletionToDateText, string questionNumber,
                string answer, string healthConcerns, string requestToBeSeen, string assignedLocationType, string assignedLocationKey,
                string evaluatedLocationType, string evaluatedLocationKey,
                string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
                string adminFlagFromDateText, string adminFlagToDateText, string excludeDead, string contactPreference, string lastName,
                string last4SSN, int separationType, string separationFromDateText, string separationToDateText, string dob,
                string email, string evaluation, string excludeAdminFlag, string closestFacilityId, string totalRecords, string SortExpression, int maximumRows, int startRowIndex)
        {
            const string gridDefaultSort = @"LAST_NAME";

            if (string.IsNullOrEmpty(SortExpression))
            {
                SortExpression = string.Format("{0}", gridDefaultSort);
            }

            using (AHOBPRLinqDataContext db = GetDataContext())
            {
                IQueryable<SP_ReportRegistrantContactResult> mainQueryGridView;

                //call stored procedure
                var results = db.SP_ReportRegistrantContact(status, state,
                    formStartFromDateText, formStartToDateText, healthFactor,
                    formCompletionFromDateText, formCompletionToDateText, questionNumber,
                    answer, healthConcerns, requestToBeSeen, assignedLocationType, assignedLocationKey, evaluatedLocationType, evaluatedLocationKey,
                    subpopulationFlag, adminFlag, deploymentAll, deploymentExposure,
                    adminFlagFromDateText, adminFlagToDateText, excludeDead, contactPreference, lastName,
                    last4SSN, separationType, separationFromDateText, separationToDateText, dob, email, evaluation, excludeAdminFlag, closestFacilityId).ToList();

                mainQueryGridView = results.AsQueryable();


                //sort
                totalCount = mainQueryGridView.Count();

                return (mainQueryGridView).SortAndPage(SortExpression, maximumRows, startRowIndex).ToList<SP_ReportRegistrantContactResult>();
            }
        }


        public int GetRegistrantAddressCount(string status, string state,
                string formStartFromDateText, string formStartToDateText, string healthFactor,
                string formCompletionFromDateText, string formCompletionToDateText, string questionNumber,
                string answer, string healthConcerns, string requestToBeSeen, string assignedLocationType, string assignedLocationKey,
                string evaluatedLocationType, string evaluatedLocationKey,
                string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
                string adminFlagFromDateText, string adminFlagToDateText, string excludeDead, string contactPreference, string lastName,
                string last4SSN, int separationType, string separationFromDateText, string separationToDateText, string dob,
                string email, string evaluation, string excludeAdminFlag, string closestFacilityId, string totalRecords)
        {
            return totalCount;
        }


        public int GetRegistrantAddressGVCount(string status, string state,
               string formStartFromDateText, string formStartToDateText, string healthFactor,
               string formCompletionFromDateText, string formCompletionToDateText, string questionNumber,
               string answer, string healthConcerns, string requestToBeSeen, string AssignedLocationType, string AssignedLocationKey,
               string EvaluatedLocationType, string EvaluatedLocationKey,
               string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
               string adminFlagFromDateText, string adminFlagToDateText, string excludeDead, string contactPreference, string lastName,
               string last4SSN, int separationType, string separationFromDateText, string separationToDateText, string dob,
               string email, string evaluation, string excludeAdminFlag, string closestFacilityId)
        {

            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;

                //call stored procedure
                return _dbAhopbr.SP_ReportRegistrantContact(status, state,
                     formStartFromDateText, formStartToDateText, healthFactor,
                     formCompletionFromDateText, formCompletionToDateText, questionNumber,
                     answer, healthConcerns, requestToBeSeen, AssignedLocationType, AssignedLocationKey,
                     EvaluatedLocationType, EvaluatedLocationKey,
                     subpopulationFlag, adminFlag, deploymentAll, deploymentExposure,
                     adminFlagFromDateText, adminFlagToDateText, excludeDead, contactPreference, lastName,
                     last4SSN, separationType, separationFromDateText, separationToDateText, dob, email, evaluation, excludeAdminFlag, closestFacilityId).Count();
            }
        }


        #endregion


        #region Methods for Eligibility Review Report

        public IList<SP_ReportEligibilityResult> GetEligibilityReviewReport(string registrantStatus, string adminFlagId, string adminFromDateText, string adminToDateText,
                                                       string sortExpression, int maximumRows, int startRowIndex)
        {
            const string gridDefaultSort = @"LAST_NAME";

            if (string.IsNullOrEmpty(sortExpression))
            {
                sortExpression = string.Format("{0}", gridDefaultSort);
            }

            using (AHOBPRLinqDataContext db = GetDataContext())
            {
                IQueryable<SP_ReportEligibilityResult> mainQueryGridView;

                //call stored procedure
                var results = db.SP_ReportEligibility(registrantStatus, adminFlagId, adminFromDateText, adminToDateText).ToList();

                mainQueryGridView = results.AsQueryable();


                //sort
                totalCount = mainQueryGridView.Count();

                return (mainQueryGridView).SortAndPage(sortExpression, maximumRows, startRowIndex).ToList<SP_ReportEligibilityResult>();
            }
        }


        public int GetEligibilityReviewReportCount(string registrantStatus, string adminFlagId, string adminFromDateText, string adminToDateText)
        {
            return totalCount;
        }

        public int GetEligibilityReviewReportResultTotal(string registrantStatus, string adminFlagId, string adminFromDateText, string adminToDateText)
        {
            using (AHOBPRLinqDataContext db = GetDataContext())
            {
                //call stored procedure
                return db.SP_ReportEligibility(registrantStatus, adminFlagId, adminFromDateText, adminToDateText).Count();
            }
        }

        #endregion

        #region Contact History
        public IList<SP_ReportContactHistoryResult> GetContactHistory(int registrantId, string SortExpression, int maximumRows, int startRowIndex) 
        {
            const string gridDefaultSort = @"UpdatedDate";

            if (string.IsNullOrEmpty(SortExpression))
            {
                SortExpression = string.Format("{0}", gridDefaultSort);
            }

            using (AHOBPRLinqDataContext db = GetDataContext())
            {
                IQueryable<SP_ReportContactHistoryResult> mainQueryGridView;

                //call stored procedure
                var results = db.SP_ReportContactHistory(registrantId).ToList();

                mainQueryGridView = results.AsQueryable();


                //sort
                totalCount = mainQueryGridView.Count();

                return (mainQueryGridView).SortAndPage(SortExpression, maximumRows, startRowIndex).ToList<SP_ReportContactHistoryResult>();
            }
        }

        public int GetContactHistoryCount(int registrantId)
        {
            return totalCount;
        }

        #endregion

        #region Methods for Send Message

        public IList<SP_GetRegistrantSendMessageResult> GetRegistrantsSendMessage(string status, string state,
                string formStartFromDateText, string formStartToDateText, string healthFactor,
                string formCompletionFromDateText, string formCompletionToDateText, string questionNumber,
                string answer, string healthConcerns, string requestToBeSeen, string assignedLocationType, string assignedLocationKey,
                string evaluatedLocationType, string evaluatedLocationKey,
                string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
                string adminFlagFromDateText, string adminFlagToDateText, string excludeDead, string contactPreference, string lastName,
                string last4SSN, int separationType, string separationFromDateText, string separationToDateText, string dob,
                string email, string evaluation, string excludeAdminFlag, string closestFacilityId, string sortExpression, int maximumRows, int startRowIndex)
        {
           IQueryable<SP_GetRegistrantSendMessageResult> mainQueryGridView;

           const string gridDefaultSort = @"Name";

           if (string.IsNullOrEmpty(sortExpression))
           {
               sortExpression = string.Format("{0}", gridDefaultSort);
           }

            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;
                //call stored procedure
                var results = _dbAhopbr.SP_GetRegistrantSendMessage(status, state,
                    formStartFromDateText, formStartToDateText, healthFactor,
                    formCompletionFromDateText, formCompletionToDateText, questionNumber,
                    answer, healthConcerns, requestToBeSeen, assignedLocationType, assignedLocationKey, evaluatedLocationType, evaluatedLocationKey,
                    subpopulationFlag, adminFlag, deploymentAll, deploymentExposure,
                    adminFlagFromDateText, adminFlagToDateText, excludeDead, contactPreference, lastName,
                    last4SSN, separationType, separationFromDateText, separationToDateText, dob, email, evaluation, excludeAdminFlag, closestFacilityId).ToList();

                mainQueryGridView = results.AsQueryable();
                //sort
                totalCount = mainQueryGridView.Count();
            }

            return (mainQueryGridView).SortAndPage(sortExpression, maximumRows, startRowIndex).ToList<SP_GetRegistrantSendMessageResult>();

        }

        public IList<SP_GetRegistrantSendQuestionsResult> GetRegistrantsSendQuestions(string status, 
        string formStartFromDateText, string formStartToDateText, 
        string formCompletionFromDateText, string formCompletionToDateText, string questionNumber,
        string answer, string healthConcerns,  
        string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
        string adminFlagFromDateText, string adminFlagToDateText, string excludeAdminFlag,
        string lastName, string last4SSN, string dob, string closestFacilityId, string sortExpression, int maximumRows, int startRowIndex)
        {
            const string gridDefaultSort = @"Name";

            if (string.IsNullOrEmpty(sortExpression))
            {
                sortExpression = string.Format("{0}", gridDefaultSort);
            }

            IQueryable<SP_GetRegistrantSendQuestionsResult> mainQueryGridView;

            //set status to '7' to only send followup questions to Participants
            //and excludeDead to 'Y' not to send followup questions to decreased
            string excludeDead = "Y";
            status = "7";

            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;
                //call stored procedure
                var results = _dbAhopbr.SP_GetRegistrantSendQuestions(status, 
                    formStartFromDateText, formStartToDateText, 
                    formCompletionFromDateText, formCompletionToDateText, questionNumber,
                    answer, healthConcerns, 
                    subpopulationFlag, adminFlag, deploymentAll, deploymentExposure,
                    adminFlagFromDateText, adminFlagToDateText, excludeDead, excludeAdminFlag, lastName, last4SSN, dob, closestFacilityId).ToList();

                mainQueryGridView = results.AsQueryable();
                //sort
                totalCount = mainQueryGridView.Count();
            }

            return (mainQueryGridView).SortAndPage(sortExpression, maximumRows, startRowIndex).ToList<SP_GetRegistrantSendQuestionsResult>();

        }

        public int GetSendMessageCount(string status, string state,
                string formStartFromDateText, string formStartToDateText, string healthFactor,
                string formCompletionFromDateText, string formCompletionToDateText, string questionNumber,
                string answer, string healthConcerns, string requestToBeSeen, string assignedLocationType, string assignedLocationKey,
                string evaluatedLocationType, string evaluatedLocationKey,
                string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
                string adminFlagFromDateText, string adminFlagToDateText, string excludeDead, string contactPreference, string lastName,
                string last4SSN, int separationType, string separationFromDateText, string separationToDateText, string dob,
                string email, string evaluation, string excludeAdminFlag, string closestFacilityId)
        {
            return totalCount;
        }

        public int GetSendMessageGVCount(string status, string state,
               string formStartFromDateText, string formStartToDateText, string healthFactor,
               string formCompletionFromDateText, string formCompletionToDateText, string questionNumber,
               string answer, string healthConcerns, string requestToBeSeen, string AssignedLocationType, string AssignedLocationKey,
               string EvaluatedLocationType, string EvaluatedLocationKey,
               string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
               string adminFlagFromDateText, string adminFlagToDateText, string excludeDead, string contactPreference, string lastName,
               string last4SSN, int separationType, string separationFromDateText, string separationToDateText, string dob,
               string email, string evaluation, string excludeAdminFlag, string closestFacilityId)
        {

            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;

                //call stored procedure
                return _dbAhopbr.SP_GetRegistrantSendMessage(status, state,
                     formStartFromDateText, formStartToDateText, healthFactor,
                     formCompletionFromDateText, formCompletionToDateText, questionNumber,
                     answer, healthConcerns, requestToBeSeen, AssignedLocationType, AssignedLocationKey,
                     EvaluatedLocationType, EvaluatedLocationKey,
                     subpopulationFlag, adminFlag, deploymentAll, deploymentExposure,
                     adminFlagFromDateText, adminFlagToDateText, excludeDead, contactPreference, lastName,
                     last4SSN, separationType, separationFromDateText, separationToDateText, dob, email, evaluation, excludeAdminFlag, closestFacilityId).Count();
            }
        }

        public int GetSendQuestionsCount(string status, 
               string formStartFromDateText, string formStartToDateText, 
               string formCompletionFromDateText, string formCompletionToDateText, string questionNumber,
               string answer, string healthConcerns, 
               string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
               string adminFlagFromDateText, string adminFlagToDateText, string excludeAdminFlag,
               string lastName, string last4SSN, string dob, string closestFacilityId)
        {

            using (_dbAhopbr = GetDataContext())
            {
                //set status to '7' to only send followup questions to Participants
                //and excludeDead to 'Y' not to send followup questions to decreased
                string excludeDead = "Y";
                status = "7";

                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;

                //call stored procedure
                return _dbAhopbr.SP_GetRegistrantSendQuestions(status,
                    formStartFromDateText, formStartToDateText,
                    formCompletionFromDateText, formCompletionToDateText, questionNumber,
                    answer, healthConcerns,
                    subpopulationFlag, adminFlag, deploymentAll, deploymentExposure,
                    adminFlagFromDateText, adminFlagToDateText, excludeDead, excludeAdminFlag,
                    lastName, last4SSN, dob, closestFacilityId).Count();
            }
        }

        #endregion

        #region Methods for Add Flag

        public IList<SP_GetRegistrantAddFlagResult> GetRegistrantAddFlag(string status, string state,
                string formStartFromDateText, string formStartToDateText, string healthFactor,
                string formCompletionFromDateText, string formCompletionToDateText, 
                string healthConcerns, string requestToBeSeen, string assignedLocationType, string assignedLocationKey,
                string evaluatedLocationType, string evaluatedLocationKey,
                string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
                string adminFlagFromDateText, string adminFlagToDateText, string excludeDead, 
                int separationType, string separationFromDateText, string separationToDateText, string excludeAdminFlag,
                string deploymentStartFromDateText, string deploymentStartToDateText, string deploymentCompletionFromDateText, string deploymentCompletionToDateText, string sortExpression, int maximumRows, int startRowIndex)
        {
            IQueryable<SP_GetRegistrantAddFlagResult> mainQueryGridView;

            const string gridDefaultSort = @"Name";

            if (string.IsNullOrEmpty(sortExpression))
            {
                sortExpression = string.Format("{0}", gridDefaultSort);
            }

            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;
                //call stored procedure
                var results = _dbAhopbr.SP_GetRegistrantAddFlag(status, state,
                    formStartFromDateText, formStartToDateText, healthFactor,
                    formCompletionFromDateText, formCompletionToDateText,
                   healthConcerns, requestToBeSeen, assignedLocationType, assignedLocationKey, evaluatedLocationType, evaluatedLocationKey,
                    subpopulationFlag, adminFlag, deploymentAll, deploymentExposure,
                    adminFlagFromDateText, adminFlagToDateText, excludeDead, 
                    separationType, separationFromDateText, separationToDateText, excludeAdminFlag,
                    deploymentStartFromDateText, deploymentStartToDateText, deploymentCompletionFromDateText, deploymentCompletionToDateText).ToList();

                mainQueryGridView = results.AsQueryable();
                //sort
                totalCount = mainQueryGridView.Count();
            }

            return (mainQueryGridView).SortAndPage(sortExpression, maximumRows, startRowIndex).ToList<SP_GetRegistrantAddFlagResult>();

        }


        public int GetAddFlagCount(string status, string state,
                string formStartFromDateText, string formStartToDateText, string healthFactor,
                string formCompletionFromDateText, string formCompletionToDateText,
                string healthConcerns, string requestToBeSeen, string assignedLocationType, string assignedLocationKey,
                string evaluatedLocationType, string evaluatedLocationKey,
                string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
                string adminFlagFromDateText, string adminFlagToDateText, string excludeDead,
                int separationType, string separationFromDateText, string separationToDateText, string excludeAdminFlag,
                string deploymentStartFromDateText, string deploymentStartToDateText, string deploymentCompletionFromDateText, string deploymentCompletionToDateText)
        {
            return totalCount;
        }

        public int GetAddFlagGVCount(string status, string state,
               string formStartFromDateText, string formStartToDateText, string healthFactor,
               string formCompletionFromDateText, string formCompletionToDateText, 
               string healthConcerns, string requestToBeSeen, string AssignedLocationType, string AssignedLocationKey,
               string EvaluatedLocationType, string EvaluatedLocationKey,
               string subpopulationFlag, string adminFlag, string deploymentAll, string deploymentExposure,
               string adminFlagFromDateText, string adminFlagToDateText, string excludeDead, 
               int separationType, string separationFromDateText, string separationToDateText, string excludeAdminFlag,
               string deploymentStartFromDateText, string deploymentStartToDateText, string deploymentCompletionFromDateText, string deploymentCompletionToDateText)
        {

            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;

                //call stored procedure
                return _dbAhopbr.SP_GetRegistrantAddFlag(status, state,
                     formStartFromDateText, formStartToDateText, healthFactor,
                     formCompletionFromDateText, formCompletionToDateText, 
                     healthConcerns, requestToBeSeen, AssignedLocationType, AssignedLocationKey,
                     EvaluatedLocationType, EvaluatedLocationKey,
                     subpopulationFlag, adminFlag, deploymentAll, deploymentExposure,
                     adminFlagFromDateText, adminFlagToDateText, excludeDead, 
                     separationType, separationFromDateText, separationToDateText, excludeAdminFlag,
                     deploymentStartFromDateText, deploymentStartToDateText, deploymentCompletionFromDateText, deploymentCompletionToDateText).Count();
            }
        }

       

        #endregion

        #region Methods for Report Followup Questions

        public IList<SP_ReportFollowupQuestionsResult> GetFollowupQuestions(string fromDateText, string toDateText, string questionsCompletion, string questionGroup, string totalRecords, string SortExpression, int maximumRows, int startRowIndex)
        {
            const string gridDefaultSort = @"Name";

            if (string.IsNullOrEmpty(SortExpression))
            {
                SortExpression = string.Format("{0}", gridDefaultSort);
            }

            using (AHOBPRLinqDataContext _dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;
                IQueryable<SP_ReportFollowupQuestionsResult> mainQueryGridView;

                //call stored procedure
                var results = _dbAhopbr.SP_ReportFollowupQuestions(fromDateText, toDateText, questionsCompletion, questionGroup).ToList();

                mainQueryGridView = results.AsQueryable();


                //sort
                totalCount = mainQueryGridView.Count();

                return (mainQueryGridView).SortAndPage(SortExpression, maximumRows, startRowIndex).ToList<SP_ReportFollowupQuestionsResult>();
            }
        }


        public int GetFollowupQuestionsCount(string fromDateText, string toDateText, string questionsCompletion, string questionGroup,  string totalRecords)
        {
            return totalCount;
        }

        #endregion

        #region Methods for Clinical User Ad-Hoc Report

        public IList<SP_ClinicalUserAdHocReportResult> GetClinicalUserAdHocReport(string actionTypeId, string fromDateText, string toDateText, string userRoleId, string statusId, string primaryJob, string workLocation, string secondaryJob, string changeStatusState, string jobTitle,
                                                                          string totalRecords, string SortExpression, int maximumRows, int startRowIndex)
        {
            const string gridDefaultSort = @"Last_Name";

            if (string.IsNullOrEmpty(SortExpression))
            {
                SortExpression = string.Format("{0}", gridDefaultSort);
            }

            using (AHOBPRLinqDataContext _dbAhopbr = GetDataContext())
            {
                _dbAhopbr.CommandTimeout = AHOBPRGlobal.TimeOutForReports;
                IQueryable<SP_ClinicalUserAdHocReportResult> mainQueryGridView;

                //call stored procedure
                var results = _dbAhopbr.SP_ClinicalUserAdHocReport(actionTypeId, fromDateText, toDateText, userRoleId, statusId, primaryJob, workLocation, secondaryJob, changeStatusState, jobTitle).ToList();

                mainQueryGridView = results.AsQueryable();


                //sort
                totalCount = mainQueryGridView.Count();

                return (mainQueryGridView).SortAndPage(SortExpression, maximumRows, startRowIndex).ToList<SP_ClinicalUserAdHocReportResult>();
            }
        }


        public int GetClinicalUserAdHocReportCount(string actionTypeId, string fromDateText, string toDateText, string userRoleId, string StatusId, string PrimaryJob, string WorkLocation, string SecondaryJob, string ChangeStatusState, string JobTitle,
                                                                          string totalRecords)
        {
            return totalCount;
        }

        #endregion

    }

}
