﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using AntiXssEnc = Microsoft.Security.Application;

public partial class controls_UserControlReportSearchCriteria : System.Web.UI.UserControl
{
    private AHOBPRReportManager _reportManager = new AHOBPRReportManager();

    protected void Page_Load(object sender, EventArgs e)
    {
    }


    public void LoadUserControl(string reportName)
    {
        UserAccountManager currentUser = (UserAccountManager)HttpContext.Current.User;
        HiddenFieldUserName.Value = currentUser.Identity.Name;

        HiddenFieldReportName.Value = reportName;
    }

    protected void GridViewReportSearchCriteria_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        int searchCriteriaId = Convert.ToInt32(e.CommandArgument);

        switch (e.CommandName)
        {
            case "SELECT":
                string rString = "ReportAdHoc.aspx?id=" + searchCriteriaId;

                if (Request.QueryString["reportType"].ToString() == "Individual")
                    rString += "&reportType=Individual";
                else if (Request.QueryString["reportType"].ToString() == "Aggregate")
                    rString += "&reportType=Aggregate";

                Response.Redirect(rString);

                break;

            case "REMOVE":
                if (_reportManager.RemoveReportSearchCriteria(searchCriteriaId))
                {
                    GridViewReportSearchCriteria.DataBind();
                    //Alert.ShowSaveSuccess();
                    Alert.ShowDeleteSuccessful();
                }
                else
                {
                    Alert.ShowSaveFailed();
                }
                break;
        }
    }

}
