﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="UserControlRegistrantInformation.ascx.cs"
    Inherits="controls_RegistrantInformation" %>
<%@ Register Src="BaseControlLabel.ascx" TagName="BaseControlLabel" TagPrefix="UserControl" %>
<script type = "text/javascript">
    $(document).ready(function() {

    if ($('#<%= CheckBoxContactInformationHistory.ClientID %>').is(':checked')) {
        $('#<%= PanelContactHistory.ClientID %>').show();
    }
    else {
        $('#<%= PanelContactHistory.ClientID %>').hide();
    }

    $('#<%= CheckBoxContactInformationHistory.ClientID %>').change(function() {
        if (this.checked) {
            $('#<%= PanelContactHistory.ClientID %>').show();
        }
        else {
            $('#<%= PanelContactHistory.ClientID %>').hide();
           
        }
    });
});
</script>
<br />
<asp:Panel ID="PanelRegistrantDemographics" runat="server" GroupingText=" Registrant Demographics " role="heading" aria-level="3">
    <table>
        <tr>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelRace" runat="server" />
            </td>
            <td>
                &nbsp&nbsp&nbsp&nbsp&nbsp
            </td>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelMaritalStatus" runat="server" />
            </td>
        </tr>
        <tr>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelEthnicity" runat="server" />
            </td>
            <td>
                &nbsp&nbsp&nbsp&nbsp&nbsp
            </td>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelEducationLevel" runat="server" />
            </td>
        </tr>
        <tr>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelVitalStatus" runat="server" />
            </td>
            <td>
                &nbsp&nbsp&nbsp&nbsp&nbsp
            </td>
             <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelDeathDate" runat="server" />
            </td>
        </tr>
        <tr>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelCurrentBranchOfSvc" runat="server" />
            </td>
            <td>
                &nbsp&nbsp&nbsp&nbsp&nbsp
            </td>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelBranchSvcFirstLogin" runat="server" />
            </td>
        </tr>
        <tr>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelDutyStatus" runat="server" />
            </td>
            <td>
                &nbsp&nbsp&nbsp&nbsp&nbsp
            </td>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelDutyStatusFirstLogin" runat="server" />
            </td>
        </tr> 
    </table>
</asp:Panel>
<br />
<asp:Panel ID="PanelSeparationInfo" runat="server" GroupingText=" Separation Information ">
    <table>
         <tr>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelCharOfService" runat="server" />
            </td>
            <td>
                &nbsp&nbsp&nbsp&nbsp&nbsp
            </td>
            <td>
                &nbsp&nbsp&nbsp&nbsp&nbsp
            </td>           
        </tr>
        <tr>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelRetirementType" runat="server" />
            </td>
            <td>
                &nbsp&nbsp&nbsp&nbsp&nbsp
            </td>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelRetirementDate" runat="server" />
            </td>
        </tr>

    </table>
</asp:Panel>
<br />
<asp:Panel ID="PanelCurrentContactInfo" runat="server" GroupingText=" Current Contact Information ">
    <table>
        <tr>
            <td colspan="5">
                <UserControl:BaseControlLabel ID="BaseControlLabelContactPreferance" runat="server" />
            </td>
        </tr>
        <tr>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelPhone" runat="server" />
            </td>
            <td>
                &nbsp&nbsp&nbsp&nbsp&nbsp
            </td>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelMobile" runat="server" />
            </td>
            <td>
                &nbsp&nbsp&nbsp&nbsp&nbsp
            </td>
            <td>
                <UserControl:BaseControlLabel ID="BaseControlLabelEmail" runat="server" />
            </td>
        </tr>
        <tr>
            <td colspan="5">
                <UserControl:BaseControlLabel ID="BaseControlLabelAddress" runat="server" />
            </td>
        </tr>
    </table>
</asp:Panel>
<br />
<asp:CheckBox ID="CheckBoxContactInformationHistory" runat="server" Text="View Contact Information History" Font-Bold="true" Checked="false" 
     ToolTip="Select this checkbox to show Contact Information History" />
<asp:Panel ID="PanelContactHistory" runat="server" GroupingText=" Contact Information History ">
    <asp:GridView ID="GridViewContactHistory" runat="server" DataSourceID="DataSourceContactHistory"
        AutoGenerateColumns="False" PageSize="20" AllowPaging="True" AllowSorting="True"
        Caption="To sort please click table headings" >
        <Columns>
            <asp:TemplateField HeaderText="Date Entered" SortExpression="UpdatedDate">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelDateEntered" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("UpdatedDate")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Address 1" SortExpression="Street1">
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelStreet1" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Street1")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Address 2" SortExpression="Street2">
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelStreet2" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Street2")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="City" SortExpression="City">
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelCity" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("City")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="State" SortExpression="State">
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelState" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("State")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Zip" SortExpression="Zip">
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelZip" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Zip")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Country" SortExpression="Country">
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelCountry" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Country")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Phone Number" SortExpression="PhoneNumber">
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelPHONE_NUMBER_Main" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("PhoneNumber")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Mobile Phone" SortExpression="MobileNumber">
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelPHONE_NUMBER_Mobile" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("MobileNumber")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Email Address" SortExpression="Email">
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelEMAIL" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Email")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
    </asp:GridView>
    <asp:ObjectDataSource ID="DataSourceContactHistory" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetContactHistory" EnablePaging="true" StartRowIndexParameterName="startRowIndex"
        MaximumRowsParameterName="maximumRows" SortParameterName="SortExpression" SelectCountMethod="GetContactHistoryCount"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRReportManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="HiddenFieldRegistrantId" Name="registrantId" PropertyName="Value"
                Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Panel>
<asp:HiddenField ID="HiddenFieldRegistrantId" runat="server" />
