﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="UserControlQuestionnaire.ascx.cs" Inherits="controls_UserControlQuestionnaire" %>
<%@ Register src="BaseControlLabel.ascx" tagname="BaseControlLabel" tagprefix="UserControl" %>
<%@ Register src="UserControlDeploymentHistory.ascx" tagname="UserControlDeploymentHistory" tagprefix="UserControl" %>
<%@ Register src="UserControlDeploymentExposure.ascx" tagname="UserControlDeploymentExposure" tagprefix="UserControl" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<asp:Panel ID="PanelQuestionnaire" runat="server" GroupingText=" Questionnaire Responses " role="heading" aria-level="3">
    <asp:GridView 
        ID="GridViewQuestionnaire" 
        runat="server" 
        DataSourceID="QuestionnaireDataSource"
        AutoGenerateColumns="False" Width="100%"
        AllowPaging="True" 
        AllowSorting="True" 
        Caption="To sort please click table headings" 
        EnableModelValidation="True"
        DataKeyNames="FORM_RESPONSE_QUESTION_ID">
    <EmptyDataTemplate>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;No questionnaire responses found.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</EmptyDataTemplate>
    <Columns>
        <asp:BoundField DataField="FORM_RESPONSE_QUESTION_ID" HeaderText="Form Response Detail ID" Visible="false" />
       
      <asp:TemplateField HeaderText="Question ID" SortExpression="STD_FORM_QUESTION_ID">
            <ItemStyle HorizontalAlign="Left" />
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:HyperLink ID="HyperLinkSection" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Helpers.AhobprEval(Eval("StdFormQuestionUniqueId")))) %>' 
                    NavigateUrl='<%# "../QuestionnaireSection.aspx?sectionId=" + AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("SectionId"))) + "&subSectionId=" + AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("SubSectionId"))) %>'></asp:HyperLink>
            </ItemTemplate>
      </asp:TemplateField>

       <asp:TemplateField HeaderText="Question ID" SortExpression="STD_FORM_QUESTION_ID">
          <HeaderStyle HorizontalAlign="Center"  />
          <ItemStyle HorizontalAlign="Left" />
          <ItemTemplate>
                <asp:Label ID="LabelQuestionId" SkinID="DataLabel" runat="server" Text='<%# Helpers.AhobprEval(Eval("StdFormQuestionUniqueId")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

        <asp:TemplateField HeaderText="Question" >
          <HeaderStyle HorizontalAlign="Center" />
          <ItemStyle HorizontalAlign="Left" />
          <ItemTemplate>
                <asp:Label ID="LabelQuestion" SkinID="DataLabel" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_FORM_QUESTION.TEXT"))) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

      <asp:TemplateField HeaderText="Answer(s)" >
            <ItemStyle HorizontalAlign="Left" />
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelAnswers" runat="server" SkinID="DataLabel" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("Answers"))) %>'></asp:Label>
            </ItemTemplate>
      </asp:TemplateField>
      
     </Columns>
</asp:GridView>
    <UserControl:UserControlDeploymentHistory ID="UserControlDeploymentHistory" runat="server" NavigationSource="Questionnaire" />  
    <asp:Repeater ID="RepeaterDeploymentExposure" runat="server" DataSourceID="ObjectDataSourceDeploymentExposure">
         <ItemTemplate>
            <table width="100%">
            <tr>
            <td>
                <UserControl:UserControlDeploymentExposure ID="UserControlDeploymentExposure" runat="server"
                 RegistrantId='<%# Helpers.AhobprEval(Eval("RegistrantId")) %>' DeploymentId='<%# Helpers.AhobprEval(Eval("DeploymentId")) %>'
                  SectionId ='<%# Helpers.AhobprEval(Eval("SectionId")) %>' SubSectionId='<%# Helpers.AhobprEval(Eval("SubsectionId")) %>' />
            </td>
            </tr>
            </table>
            <br />
         </ItemTemplate>
    </asp:Repeater>

</asp:Panel>

<asp:ObjectDataSource 
    ID="QuestionnaireDataSource" runat="server" 
        SelectMethod="GetFormResponses" 
        SelectCountMethod="GetFormResponsesCount"
        StartRowIndexParameterName="startRow" 
        MaximumRowsParameterName="maxRows" 
        SortParameterName="sort"
        EnablePaging="True"  
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRQuestionnaireManager">
    <SelectParameters>
        <asp:ControlParameter ControlID="HiddenFieldRegistrantId" Name="registrantId" PropertyName="Value" Type="string" />
        <asp:ControlParameter ControlID="HiddenFieldDisplayType" Name="displayType" PropertyName="Value" Type="String" />
        <asp:ControlParameter ControlID="HiddenFieldSectionId" Name="sectionId" PropertyName="Value" Type="String" />
        <asp:ControlParameter ControlID="HiddenFieldSubSection" Name="subSectionId" PropertyName="Value" Type="String" />
        <asp:Parameter Name="sort" Type="String" />
        <asp:Parameter Name="startRow" Type="Int32" />
        <asp:Parameter Name="maxRows" Type="Int32" />
   </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource 
    ID="ObjectDataSourceQuestionnaireNoPaging" runat="server" 
        SelectMethod="GetFormResponsesNoPaging" 
        SortParameterName="sort"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRQuestionnaireManager">
    <SelectParameters>
        <asp:ControlParameter ControlID="HiddenFieldRegistrantId" Name="registrantId" PropertyName="Value" Type="string" />
        <asp:ControlParameter ControlID="HiddenFieldDisplayType" Name="displayType" PropertyName="Value" Type="String" />
        <asp:ControlParameter ControlID="HiddenFieldSectionId" Name="sectionId" PropertyName="Value" Type="String" />
        <asp:ControlParameter ControlID="HiddenFieldSubSection" Name="subSectionId" PropertyName="Value" Type="String" />
        <asp:Parameter Name="sort" Type="String" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource 
    ID="ObjectDataSourceDeploymentExposure" runat="server" 
        SelectMethod="GetDeploymentExposureList" 
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRQuestionnaireManager">
    <SelectParameters>
        <asp:ControlParameter ControlID="HiddenFieldRegistrantId" Name="registrantId" PropertyName="Value" Type="string" />
        <asp:ControlParameter ControlID="HiddenFieldSectionId" Name="sectionId" PropertyName="Value" Type="String" />
        <asp:ControlParameter ControlID="HiddenFieldSubSection" Name="subSectionId" PropertyName="Value" Type="String" />
    </SelectParameters>
</asp:ObjectDataSource>


<asp:HiddenField ID="HiddenFieldRegistrantId" runat="server" />
<asp:HiddenField ID="HiddenFieldDisplayType" runat="server" />
<asp:HiddenField ID="HiddenFieldSectionId" runat="server" />
<asp:HiddenField ID="HiddenFieldSubSection" runat="server" />

