﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="UserControlDeploymentExposure.ascx.cs" Inherits="controls_UserControlDeploymentExposure" %>
<%@ Register src="BaseControlLabel.ascx" tagname="BaseControlLabel" tagprefix="UserControl" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<script type = "text/javascript">
    $(document).ready(function() {

    if ($('#<%= CheckBoxDeployment.ClientID %>').is(':checked')) {
        $('#<%= GridViewQuestionnaire.ClientID %>').show();
    }
    else {
        $('#<%= GridViewQuestionnaire.ClientID %>').hide();
    }

    $('#<%= CheckBoxDeployment.ClientID %>').change(function() {
        if (this.checked) {
            $('#<%= GridViewQuestionnaire.ClientID %>').show();
        }
        else {
            $('#<%= GridViewQuestionnaire.ClientID %>').hide();
        }
    });
});
</script>

<asp:Panel ID="PanelDeploymentExposure" runat="server" role="heading" aria-level="3" >
    <asp:ObjectDataSource 
        ID="ObjectDataSourceFormResponsesDeploymentExposure" runat="server" 
            SelectMethod="GetFormResponsesDeploymentExposure" 
            SortParameterName="sort"
            TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRQuestionnaireManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="HiddenFieldRegistrantId" Name="registrantId" PropertyName="Value" Type="string" />
            <asp:ControlParameter ControlID="HiddenFieldDeploymentId" Name="deploymentId" PropertyName="Value" Type="String" />
            <asp:ControlParameter ControlID="HiddenFieldSectionId" Name="sectionId" PropertyName="Value" Type="String" />
            <asp:ControlParameter ControlID="HiddenFieldSubSection" Name="subSectionId" PropertyName="Value" Type="String" />
            <asp:Parameter Name="sort" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:CheckBox ID="CheckBoxDeployment" runat="server" Text="" Font-Bold="true"  />
    <asp:GridView 
        ID="GridViewQuestionnaire" 
        runat="server" 
        DataSourceID="ObjectDataSourceFormResponsesDeploymentExposure"
        AutoGenerateColumns="False" Width="100%"
        EnableModelValidation="True"
        Caption="Deployment Exposures" 
        DataKeyNames="FORM_RESPONSE_QUESTION_ID">
    <EmptyDataTemplate>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;No questionnaire responses found.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</EmptyDataTemplate>
    <Columns>
        <asp:BoundField DataField="FORM_RESPONSE_QUESTION_ID" HeaderText="Form Response Detail ID" Visible="false" />
       
       <asp:TemplateField HeaderText="Question ID" SortExpression="STD_FORM_QUESTION_ID">
          <HeaderStyle HorizontalAlign="Center"  />
          <ItemStyle HorizontalAlign="Left" />
          <ItemTemplate>
                <asp:Label ID="LabelQuestionId" SkinID="DataLabel" runat="server" Text='<%# Helpers.AhobprEval(Eval("STD_FORM_QUESTION.FORM_QUESTION_UNIQUE_ID")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

        <asp:TemplateField HeaderText="Question" >
          <HeaderStyle HorizontalAlign="Center" />
          <ItemStyle HorizontalAlign="Left" />
          <ItemTemplate>
                <asp:Label ID="LabelQuestion" SkinID="DataLabel" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_FORM_QUESTION.TEXT"))) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

      <asp:TemplateField HeaderText="Answer(s)" >
            <ItemStyle HorizontalAlign="Left" />
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelAnswers" runat="server" SkinID="DataLabel" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("Answers"))) %>'></asp:Label>
            </ItemTemplate>
      </asp:TemplateField>
      
     </Columns>
</asp:GridView>
</asp:Panel>
<asp:HiddenField ID="HiddenFieldRegistrantId" runat="server" />
<asp:HiddenField ID="HiddenFieldDeploymentId" runat="server" />
<asp:HiddenField ID="HiddenFieldSectionId" runat="server" />
<asp:HiddenField ID="HiddenFieldSubSection" runat="server" />
