﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class controls_UserControlDate : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CompareValidatorTextBoxDOB.ValueToCompare = DateTime.Now.ToShortDateString();
    }
    public string Text
    {
        get
        {
            return TextBoxDOB.Text;
        }
        set
        {
            TextBoxDOB.Text = value;
        }
    }

    public string LabelText
    {
        get
        {
            return LabelforTextBoxDOB.Text;
        }
        set
        {
            LabelforTextBoxDOB.Text = value;
        }
    }

     public string Tooltip
    {
        set
        {
            LabelforTextBoxDOB.ToolTip = value;
            TextBoxDOB.ToolTip = value;
        }
    }

    public bool IncludeLabel
    {
        set
        {
            LabelforTextBoxDOB.Visible = value;
        }
    }

  

    /// <summary>
    /// Set validation group
    /// </summary>
    public string ValidationGroup
    {
        set
        {
            if (!string.IsNullOrEmpty(value))
            {
                CompareValidatorTextBoxDOB.ValidationGroup = value;
                CustomValidatorBirthDate.ValidationGroup = value;
            }
        }
    }

    public bool ValidateCustomValidator()
    {
        CustomValidatorBirthDate.IsValid = true;

        //Verify a 4-digit year has been entered and valid date
        if (!string.IsNullOrEmpty(TextBoxDOB.Text))
        {
            string dobYear = TextBoxDOB.Text.Split('/').Last();
            //count slashes
            var slashCount = TextBoxDOB.Text.Count(x => x == '/');

            //Verify a 4-digit year has been entered and valid date
            if (TextBoxDOB.Text.Length < 6)
            {
                CustomValidatorBirthDate.IsValid = false;
                CustomValidatorBirthDate.ErrorMessage = "Please enter a valid Birth Date (mm/dd/yyyy).";
            }
            else if (slashCount != 2)
            {
                CustomValidatorBirthDate.IsValid = false;
                CustomValidatorBirthDate.ErrorMessage = "Please enter a valid Birth Date (mm/dd/yyyy).";
            }
            else if (dobYear.Length < 4)
            {
                CustomValidatorBirthDate.IsValid = false;
                CustomValidatorBirthDate.ErrorMessage = "Please enter a 4-digit year for Birth Date.";
            }
            if (CustomValidatorBirthDate.IsValid == false)
            {
                TextBoxDOB.Focus();
            }
        }

        return CustomValidatorBirthDate.IsValid;
    }



    public void LoadControlsFromObject(string text, string labelText, string tooltip, string validationGroup)
    {
        if (!string.IsNullOrEmpty(tooltip))
        {
            Tooltip = tooltip;
        }
        if (!string.IsNullOrEmpty(text))
        {
            Text = text;
        }
        if (!string.IsNullOrEmpty(labelText))
        {
            LabelText = labelText;
        }

        ValidationGroup = validationGroup;

    }
}
