﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.ComponentModel;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;
using System.Collections.Specialized;
using System.Text;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.BusinessManager.Utilities;

public partial class controls_BaseControlListBox : System.Web.UI.UserControl
{
    private AHOBPRBaseControlManager _manager = new AHOBPRBaseControlManager();
    private AHOBPRReportManager _reportManager = new AHOBPRReportManager();
    private SessionListBox sessionListBox;

    public event PropertyChangedEventHandler PropertyChanged;

    protected virtual void SendPropertyChanged(String propertyName)
    {
        if ((this.PropertyChanged != null))
        {
            this.PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
        }
    }
    
    protected void Page_Load(object sender, EventArgs e)
    {
        Page.PreRender += new EventHandler(Page_PreRender);

    }

    void Page_PreRender(object sender, EventArgs e)
    {
        Text = Text;
        ListBoxID.Visible = true;
        ListBoxID.Enabled = EnableControl;
        LinkClearAll.Visible = true;
        LinkClearAll.Enabled = EnableControl;
        LinkAdd.Visible = true;
        LinkAdd.Enabled = EnableControl;
        LinkAddAll.Enabled = EnableControl;
        LinkAddAll.Visible = true;
        LinkRemove.Visible = true;
        LinkRemove.Enabled = EnableControl;
        ListBoxSource.Visible = true;
        ListBoxSource.Enabled = EnableControl;
        AddAttributesForListBoxLinks();
    }

    public string LabelText
    {
        get
        {
            return ListBoxID.Text;
        }
        set
        {
            ListBoxID.Text = value;
        }
    }

    public bool IncludeLabel
    {
        set
        {
            LabelforListBoxSource.Visible = value;
            LabelForListBoxID.Visible = value;
        }
    }

    public System.Nullable<int> DateElementWidth
    {
        set
        {
            if (value != null)
            {
                ListBoxID.Width = new Unit((int)value);
                ListBoxSource.Width = new Unit((int)value);
            }
        }
    }

    /// <summary>
    /// Set Required validator
    /// </summary>
    public bool IsRequired
    {
        set
        {
            if (value)
            {
                RequiredFieldValidatorID.Visible = true;
                RequiredFieldValidatorID.Enabled = true;
            }
            else
            {
                RequiredFieldValidatorID.Visible = false;
                RequiredFieldValidatorID.Enabled = false;
            }
        }
    }

    /// <summary>
    /// Text property
    /// </summary>
    public string Text 
    {
        get
        {
            return HiddenFieldID.Value;
        }
        set
        {
            HiddenFieldID.Value = value;
        }
    }


    public void ResetControl()
    {
        HiddenFieldID.Value = string.Empty;
        DataElementValue = new List<KeyValuePair<string, string>>();
    }

    /// <summary>
    /// Tooltip Property
    /// </summary>
    public string Tooltip
    {
        get
        {
            return ListBoxID.ToolTip;
        }
        set
        {
            if (!string.IsNullOrEmpty(value))
            {
                ListBoxID.ToolTip = value + " (Hold \"Ctrl\" key and select for multiple items)";
                ListBoxSource.ToolTip = value + " (Hold \"Ctrl\" key and select for multiple items)";
                LinkAdd.ToolTip = "Add " + LabelforListBoxSource.Text.Replace(":<br />", string.Empty);
                LinkAddAll.ToolTip = "Add All " + LabelforListBoxSource.Text.Replace(":<br />", string.Empty);
                LinkRemove.ToolTip = "Remove " + LabelforListBoxSource.Text.Replace(":<br />", string.Empty);
                LinkClearAll.ToolTip = "Clear All " + LabelforListBoxSource.Text.Replace(":<br />", string.Empty);
                LabelforListBoxSource.ToolTip = value;
                LabelforListBoxSource.ToolTip = value;
            }
        }
    }

    public string LocationFriendlyName {get;set;}

    /// <summary>
    /// BaseControl width property
    /// </summary>
    public int BaseControlWidth
    {
        get
        {
            return Convert.ToInt32(ListBoxID.Width.Value);
        }
        set
        {
            ListBoxSource.Width = new Unit(value);
            ListBoxID.Width = new Unit(value);
        }
    }

    /// <summary>
    /// Show tooltip for long text in listbox
    /// Calculation is based on estimate of 1 character for 8 pixels
    /// </summary>
    /// <param name="listBoxControl"></param>
    private void ShowTooltipForLongText(ListBox listBoxControl)
    {
        if (listBoxControl.Width.Value > 0 && listBoxControl.Items.Count > 0)
        {
            foreach (ListItem item in listBoxControl.Items)
            {
                if (item.Text.Length * 8 > listBoxControl.Width.Value)
                {
                    item.Attributes.Add("Title", item.Text);
                }
            }
        }
    }

    public SessionListBox SessionListBox
    {
        get 
        {
            if (sessionListBox == null)
                sessionListBox = new SessionListBox();

            return sessionListBox; 
        }
        set 
        { 
            sessionListBox = value;
            this.SendPropertyChanged("SessionListBox");
        }
    }

    public List<AHOBPR_VIEW_LOOKUP> LookupList
    {
        get
        {
            //return (List<AHOBPR_VIEW_LOOKUP>)Session["LookupList" + ClientID];
            return SessionListBox.LookupList;
        }
        set
        {
            if (value != null)
            {
                if (value.Count > 0)
                {
                    //Session["LookupList" + ClientID] = value;
                    SessionListBox.LookupList = value;
                    ListItem newEmptyItem = new ListItem();
                    newEmptyItem.Text = string.Empty;
                    newEmptyItem.Value = "0";
                    ListBoxSource.Items.Clear();
                    ListBoxSource.DataSource = value;
                    ListBoxSource.DataTextField = "NAME";
                    ListBoxSource.DataValueField = "ID";
                    //if (Session["LookupCategory" + ClientID] != null)
                    if (!string.IsNullOrEmpty(SessionListBox.LookupCategory))
                    {
                        //if (Session["LookupCategory" + ClientID].ToString() == "STD_STATE")
                        if (SessionListBox.LookupCategory == "STD_STATE")
                        {
                            ListBoxSource.DataValueField = "NAME";
                        }
                    }
                    
                    ListBoxSource.DataBind();
                    ListBoxID.Width = ListBoxSource.Width;
                    ShowTooltipForLongText(ListBoxSource);
                    ShowTooltipForLongText(ListBoxID);
                }
            }
        }
    }

    /// <summary>
    /// Populate lookup values
    /// </summary>
    /// <param name="LookupCategory"></param>
    /// <returns></returns>
    public int LoadControlsFromObject(string LookupCategory, string text, string labelText, string tooltip, bool includeLabel, 
        System.Nullable<int> dataElementWidth, string validationGroup, bool isRequired)
    {
        //Session["LookupCategory" + ClientID] = LookupCategory;
        SessionListBox.LookupCategory = LookupCategory;

        if (!string.IsNullOrEmpty(LookupCategory))
        {
            //if (Session["LookupList_" + LookupCategory] == null)
            if (SessionListBox.LookupListLookupCategory == null)
            {
                Trace.Warn("SelectLookupList", "Call database - " + LookupCategory);

                LookupList = _manager.SelectLookupList(LookupCategory).ToList<AHOBPR_VIEW_LOOKUP>();
                //Session["LookupList_" + LookupCategory] = LookupList;
                SessionListBox.LookupListLookupCategory = LookupList;
            }
            else
            {
                Trace.Write("SelectLookupList", "Get from session - " + LookupCategory);

                //LookupList = (List<AHOBPR_VIEW_LOOKUP>)Session["LookupList_" + LookupCategory];
                LookupList = SessionListBox.LookupListLookupCategory;
            }
        }

        RequiredFieldValidatorID.ErrorMessage = LocationFriendlyName + " is required.";
        RequiredFieldValidatorID.Enabled = true;
        if (!string.IsNullOrEmpty(text))
        {
            Text = text;
        }
        if (!string.IsNullOrEmpty(labelText))
        {
            //LabelText = labelText;
            LabelforListBoxSource.Text = labelText;
            LabelForListBoxID.Text = "Selected " + labelText;
        }
        if (!string.IsNullOrEmpty(tooltip))
        {
            Tooltip = tooltip;
        }

        IncludeLabel = includeLabel;
        DateElementWidth = dataElementWidth;
        ValidationGroup = validationGroup;
        IsRequired = isRequired;
        return 0;
    }

    /// <summary>
    /// Overload to method to include the question number for the Ad Hoc report
    /// </summary>
    /// <param name="LookupCategory"></param>
    /// <returns></returns>
    public int LoadControlsFromObject(string LookupCategory, string text, string labelText, string tooltip, bool includeLabel,
        System.Nullable<int> dataElementWidth, string validationGroup, bool isRequired, string question)
    {
        //Session["LookupCategory" + ClientID] = LookupCategory;
        SessionListBox.LookupCategory = LookupCategory;

        LookupList = _reportManager.GetAnswers(question);
        //Session["LookupList_" + LookupCategory] = LookupList;
        SessionListBox.LookupListLookupCategory = LookupList;


        RequiredFieldValidatorID.ErrorMessage = LocationFriendlyName + " is required.";
        RequiredFieldValidatorID.Enabled = true;
        if (!string.IsNullOrEmpty(text))
        {
            Text = text;
        }
        if (!string.IsNullOrEmpty(labelText))
        {
            //LabelText = labelText;
            LabelforListBoxSource.Text = labelText;
            LabelForListBoxID.Text = "Selected " + labelText;
        }
        if (!string.IsNullOrEmpty(tooltip))
        {
            Tooltip = tooltip;
        }

        IncludeLabel = includeLabel;
        DateElementWidth = dataElementWidth;
        ValidationGroup = validationGroup;
        IsRequired = isRequired;
        return 0;
    }


    private void AddAttributesForListBoxLinks()
    {
        LinkAdd.Attributes.Add("onclick", "ListboxAdd('" + ListBoxSource.ClientID + "', '" + ListBoxID.ClientID + "', '" + HiddenFieldID.ClientID + "')");
        LinkAddAll.Attributes.Add("onclick", "ListboxAddAll('" + ListBoxSource.ClientID + "', '" + ListBoxID.ClientID + "', '" + HiddenFieldID.ClientID + "')");
        LinkRemove.Attributes.Add("onclick", "ListboxRemove('" + ListBoxID.ClientID + "', '" + HiddenFieldID.ClientID + "')");
        LinkClearAll.Attributes.Add("onclick", "ListboxClearAll('" + ListBoxID.ClientID + "', '" + HiddenFieldID.ClientID + "')");

        LinkAdd.Attributes.Add("href", "#" + ListBoxSource.ClientID);
        LinkAddAll.Attributes.Add("href", "#" + ListBoxSource.ClientID);
        LinkRemove.Attributes.Add("href", "#" + ListBoxSource.ClientID);
        LinkClearAll.Attributes.Add("href", "#" + ListBoxSource.ClientID);
    }

    /// <summary>
    /// Enable/Disable the control
    /// </summary>
    public bool EnableControl
    {
        get
        {
            bool results = true;

            if (SessionListBox.EnableControl != null)
            {
                results = SessionListBox.EnableControl;
            }

            return results;
        }
        set
        {
            SessionListBox.EnableControl = value;
        }
    }

    /// <summary>
    /// Set validation group
    /// </summary>
    public string ValidationGroup
    {
        set
        {
            if (!string.IsNullOrEmpty(value))
            {
                RequiredFieldValidatorID.ValidationGroup = value;
            }
        }
    }
    /// <summary>
    /// Get or set data element value list
    /// </summary>
    public List<KeyValuePair<string, string>> DataElementValue
    {
        get
        {
            return GetListBoxValues(HiddenFieldID.Value);
        }
        set
        {
            if (value != null)
            {
                if (value.Count > 0)
                {
                    HiddenFieldID.Value = string.Empty;
                    ListBoxID.Items.Clear();
                    foreach (KeyValuePair<string, string> item in value)
                    {
                        foreach (ListItem listBoxItem in ListBoxSource.Items)
                        {
                            if (listBoxItem.Value == item.Key)
                            {
                                ListBoxID.Items.Add(listBoxItem);
                                HiddenFieldID.Value = string.IsNullOrEmpty(HiddenFieldID.Value) ? listBoxItem.Value : HiddenFieldID.Value + "," + listBoxItem.Value;
                                break;
                            }
                        }
                    }
                    SetListBoxSelectedItems();
                }
                else
                {
                    ListBoxID.Items.Clear();
                }
            }
        }
    }


    /// <summary>
    /// Convert a concatenated string to a list of KeyValuePair<int, string>
    /// </summary>
    /// <param name="text"></param>
    /// <returns></returns>
    private List<KeyValuePair<string, string>> GetListBoxValues(string text)
    {
        List<KeyValuePair<string, string>> dataElementValues = new List<KeyValuePair<string, string>>();
        if (!string.IsNullOrEmpty(text))
        {
            char[] splitter = { ',' };
            string[] values = text.Split(splitter);

            foreach (string item in values)
            {
                if (!string.IsNullOrEmpty(item) && item != "0")
                {
                    dataElementValues.Add(new KeyValuePair<string, string>(item, ListBoxSource.Items.FindByValue(item).Text));
                }
            }
        }

        return dataElementValues;
    }

 
    /// <summary>
    /// Select all items in the target listbox.  
    /// If nothing is selected, the required validator will popup error message.
    /// </summary>
    private void SetListBoxSelectedItems()
    {
        foreach (ListItem item in ListBoxID.Items)
        {
            if (!item.Selected)
            {
                ListBoxID.Items.FindByValue(item.Value).Selected = true;
            }
        }
    }

 }
