﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class ToolQuestionPreview : BasePage
{

    private AHOBPRToolManager _toolManager = new AHOBPRToolManager();

    protected void Page_Load(object sender, EventArgs e)
    {
        int questionId = Request.QueryString["id"] == null ? 0 : Helpers.getIntFromString(Request.QueryString["id"].ToString());
        HiddenFieldQuestionId.Value = questionId.ToString();
        LoadControlsFromObject(questionId);

        string formId = UserSession.FormId;
        if (!string.IsNullOrEmpty(formId))
        {
            LinkButtonQuestionGroupEdit.PostBackUrl = "~/ToolQuestionGroupEdit.aspx?id=" + formId;
            LinkButtonQuestionGroupEditBottom.PostBackUrl = "~/ToolQuestionGroupEdit.aspx?id=" + formId;
            LinkButtonQuestionGroupEdit.Visible = true;
            LinkButtonQuestionGroupEditBottom.Visible = true;
        }
        else
        {
            LinkButtonQuestionGroupEdit.Visible = false;
            LinkButtonQuestionGroupEditBottom.Visible = false;
        }
    }

    public void LoadControlsFromObject(int questionId)
    {
        if (questionId > 0)
        {
            TOOL_QUESTION question = _toolManager.GetQuestionById(questionId);
            if (question != null)
            {
                UserControlToolQuestionPreview.LoadUserControl(questionId);
                UserControlToolQuestionPreview.LoadControlsFromObject(questionId);
                PanelPreview.Visible = true;
            }
        }
        else
        {
            PanelPreview.Visible = false;
        }

    }
    public override string TopMenuName()
    {
        return "Tool";
    }

    public override string MenuItemName()
    {
        return "Question List";
    }

    public override string AppObjectCode()
    {
        return "AHOBPR TOOL";
    }

}
