﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.BusinessManager;

public partial class ToolQuestionGroupEdit : BasePage
{

    private AHOBPRToolManager _toolManager = new AHOBPRToolManager();
    //private AHOBPRShared _sharedManager = new AHOBPRShared();
    private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    private List<STD_GUI_CONTROL_AHOBPR> _dbAhopbrControls = null;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            int formId = Request.QueryString["id"] == null ? 0 : Helpers.getIntFromString(Request.QueryString["id"].ToString());
            HiddenFieldFormId.Value = formId.ToString();
            LabelBreadCrumb.Text = formId == 0 ? "<H1>Follow-up Question Tool >  Add Question Group</H1>" : "<H1>Follow-up Question Tool >  Edit Question Group</H1>";
            LoadBaseControls();
            LoadControlsFromObject(formId);
            if (formId == 0)
            {
                ButtonSubmitQuestionGroup.Enabled = false;
            }
        }

                
    }


    private bool ValidateQuestionGroup(string formId)
    {
        bool result = true;
        string prefix = "Failed to submit question group. ";

        TOOL_FORM form = _toolManager.GetFormById(Helpers.getIntFromString(formId));
        if (form != null)
        {
            if (form.TOOL_FORM_QUESTIONs.Count == 0)
            {
                CustomValidatorSubmitQuestionGroup.ErrorMessage = prefix + "At least one question is required in the group.";
                result = false;
            }
        }

        return result;
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        TextBoxKeyWords.Text = "";
        DropDownListQuestionType.SelectedIndex = -1;
    }

    protected void ButtonSearch_Click(object sender, EventArgs e)
    {
        GridViewQuestions.DataBind();
    }


    protected void GridViewFormQuestions_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        try
        {
            int questionId = Convert.ToInt32(e.CommandArgument);

            switch (e.CommandName)
            {
                case "RemoveFromGroup":
                    if (_toolManager.RemoveQuestionFromForm(questionId, Helpers.getIntFromString(HiddenFieldFormId.Value)))
                    {
                        LoadBaseControls();
                        LoadControlsFromObject(Helpers.getIntFromString(HiddenFieldFormId.Value));
                        Alert.ShowDeleteSuccessful();
                    }
                    else
                    {
                        LoadBaseControls();
                        Alert.ShowSaveFailed();
                    }
                    break;
                case "Preview":
                    Response.Redirect("ToolQuestionPreview.aspx?id=" + questionId.ToString());
                    break;

            }
        }
        catch
        {
            //do nothing.
            // this is for sorting only.
        }

        GridViewFormQuestions.SelectedIndex = -1;
       
    }

    protected void GridViewQuestions_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        int saveStatus = 0;
        try
        {
            int questionId = Convert.ToInt32(e.CommandArgument);

            switch (e.CommandName)
            {
                case "AddToGroup":
                    saveStatus = _toolManager.AddQuestionToForm(questionId, Helpers.getIntFromString(HiddenFieldFormId.Value));
                    if (saveStatus == 2)
                    {
                        Alert.Show("This question already exists in the group!");
                    }
                    else if (saveStatus == 1)
                    {
                        LoadBaseControls();
                        LoadControlsFromObject(Helpers.getIntFromString(HiddenFieldFormId.Value));
                        Alert.ShowSaveSuccess();
                    }
                    else
                    {
                        LoadBaseControls();
                        Alert.ShowSaveFailed();
                    }
                    break;
                case "Preview":
                    Response.Redirect("ToolQuestionPreview.aspx?id=" + questionId.ToString());
                    break;

            }
        }
        catch
        {
            //do nothing.
            // this is for sorting only.
        }

        GridViewQuestions.SelectedIndex = -1;
    }

    protected void ButtonSubmitQuestionGroup_Click(object sender, EventArgs e)
    {
        CustomValidatorSubmitQuestionGroup.IsValid = true;
        SaveQuestionGroup();

        // Validate that at least one value was entered    
        if (ValidateQuestionGroup(HiddenFieldFormId.Value) == false)
        {
            CustomValidatorSubmitQuestionGroup.IsValid = false;
        }
        else
        {
            //submit the question            
            try
            {
                int formId = Helpers.getIntFromString(HiddenFieldFormId.Value);
                //Add to Audit Log
                UserAccountManager user = (UserAccountManager)HttpContext.Current.User;
                string message = BaseControlTextboxFormName.Text;
                Helpers.AddActivityToAuditLog(user.UserId.ToString(), message,
                    string.Empty, AuditLogType.NewFollowupQuestionGroupSubmitted, null);

                int saveStatus = _toolManager.SubmitFollowUpFormToStdTables(formId);
                if (saveStatus == 1)
                {
                    //clear view to run again to get newly added group in application dropdown displays
                    AHOBPRGlobal.ViewLookupAll = null;

                    if (ServiceCaller.CreateFollowupFormJson(formId.ToString(), HiddenFieldSystemWide.Value))
                    {
                        TOOL_FORM form = SubmitQuestionGroupAsComplete();
                        if (form.TOOL_FORM_ID > 0)
                        {
                            ButtonSaveQuestionGroup.Enabled = false;
                            ButtonSubmitQuestionGroup.Enabled = false;
                            PanelEditFormQuestion.Enabled = false;
                            Alert.ShowSaveSuccess();
                            UserSession.FormId = string.Empty;
                        }
                        else
                        {
                            Alert.ShowSaveFailed();
                        }
                    }
                    else
                    {
                         Alert.ShowSaveFailed();
                    }
                }
                else
                {
                    Alert.ShowSaveFailed();
                }
            }
            catch
            {
                Alert.ShowSaveFailed();
            }
        }
    }

    private TOOL_FORM SaveQuestionGroup()
    {
        int formId = Helpers.getIntFromString(HiddenFieldFormId.Value);
        TOOL_FORM form = _toolManager.GetFormById(formId);
        if (form == null)
        {
            form = new TOOL_FORM();
        }
        if (form != null)
        {
            form.SetAsChangeTrackingRoot();
            if (form.TOOL_FORM_ID == 0)
            {
                form.SetAsInsertOnSubmit();
            }
            else
            {
                form.SetAsUpdateOnSubmit();
            }

            form.NAME = BaseControlTextboxFormName.Text;
            form.TITLE = BaseControlTextboxFormTitle.Text;
            form.SYSTEM_WIDE_FLAG = CheckboxSystemWideFlag.Checked;
            HiddenFieldSystemWide.Value = CheckboxSystemWideFlag.Checked ? "yes" : "no";
            form.EDITABLE_FLAG = true;
            form.ACTIVE_FLAG = false;

            try
            {
                form = _toolManager.SaveForm(form);

                if (form.TOOL_FORM_ID > 0)
                {
                    HiddenFieldFormId.Value = form.TOOL_FORM_ID.ToString();
                    LoadBaseControls();
                    LoadControlsFromObject(form.TOOL_FORM_ID);
                }
                else
                {
                    LoadBaseControls();
                }
            }
            catch
            {
                LoadBaseControls();
            }
        }

        return form;

    }


    private TOOL_FORM SubmitQuestionGroupAsComplete()
    {
        int formId = Helpers.getIntFromString(HiddenFieldFormId.Value);
        TOOL_FORM form = _toolManager.GetFormById(formId);
        if (form != null)
        {
            form.SetAsChangeTrackingRoot();
            form.SetAsUpdateOnSubmit();

            form.EDITABLE_FLAG = false;
            form.ACTIVE_FLAG = true;

            try
            {
                form = _toolManager.SaveForm(form);

                if (form.TOOL_FORM_ID > 0)
                {
                    HiddenFieldFormId.Value = form.TOOL_FORM_ID.ToString();
                    LoadBaseControls();
                    LoadControlsFromObject(form.TOOL_FORM_ID);
                }
                else
                {
                    LoadBaseControls();
                }
            }
            catch
            {
                LoadBaseControls();
            }
        }

        return form;

    }


   
    public void LoadControlsFromObject(int formId)
    {
        if (formId > 0)
        {
            UserSession.FormId = formId.ToString();
            TOOL_FORM form = _toolManager.GetFormById(formId);
            if (form != null)
            {
                BaseControlTextboxFormName.Text = form.NAME;
                BaseControlTextboxFormTitle.Text = form.TITLE;
                CheckboxSystemWideFlag.Checked = form.SYSTEM_WIDE_FLAG;
                HiddenFieldSystemWide.Value = form.SYSTEM_WIDE_FLAG ? "yes" : "no";
                PanelEditFormQuestion.Visible = true;
                PanelFormQuestions.Visible = (form.TOOL_FORM_QUESTIONs.Count > 0);
                GridViewFormQuestions.DataSource = _toolManager.GetQuestionsByFormId(Helpers.getIntFromString(HiddenFieldFormId.Value));
                GridViewFormQuestions.DataBind();
                LinkButtonQuestionGroupPreview.PostBackUrl = "~/ToolQuestionGroupPreview.aspx?id=" + form.TOOL_FORM_ID.ToString();
                LinkButtonQuestionGroupPreview.Visible = (form.TOOL_FORM_QUESTIONs.Count > 0);
                LinkButtonQuestionGroupPreviewBottom.PostBackUrl = "~/ToolQuestionGroupPreview.aspx?id=" + form.TOOL_FORM_ID.ToString();
                LinkButtonQuestionGroupPreviewBottom.Visible = (form.TOOL_FORM_QUESTIONs.Count > 0);
            }
        }
        else
        {
            UserSession.FormId = string.Empty;
            PanelEditFormQuestion.Visible = false;
            LinkButtonQuestionGroupPreview.Visible = false;
            LinkButtonQuestionGroupPreviewBottom.Visible = false;
        }

    }

    private void LoadBaseControls()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_TOOL_QUESTION_GROUP"))
        {
            Control userControl = this.PanelEditQuestionGroup.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                if (dbItem.BASE_CONTROL_TYPE == (int)AhobprBaseControlType.TextBox)
                {
                    controls_BaseControlTextBox baseControl = (controls_BaseControlTextBox)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                        true, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH,
                        dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.VALIDATION_REGULAR_EXPRESSION,
                        dbItem.REQUIRED);
                }
                else if (dbItem.BASE_CONTROL_TYPE == (int)AhobprBaseControlType.CheckBox)
                {
                    controls_BaseControlCheckBox baseControl = (controls_BaseControlCheckBox)userControl;
                    baseControl.LoadControlsFromObject(false, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, true);
                }
            }
        }


    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="controlCategory"></param>
    /// <returns></returns>
    private List<STD_GUI_CONTROL_AHOBPR> GetGuiControls(string controlCategory)
    {
        if (UserSession.GuiControlsToolEditQuestionGroup == null)
        {
            _dbAhopbrControls = _baseControlManager.SelectGuiControlList(controlCategory).ToList<STD_GUI_CONTROL_AHOBPR>();
            UserSession.GuiControlsToolEditQuestionGroup = _dbAhopbrControls;
        }
        else
        {
            _dbAhopbrControls = UserSession.GuiControlsToolEditQuestionGroup;
        }

        return _dbAhopbrControls;
    }


    public override string TopMenuName()
    {
        return "Tool";
    }

    public override string MenuItemName()
    {
        return "Question Group List";
    }

    public override string AppObjectCode()
    {
        return "AHOBPR TOOL";
    }

    protected void ButtonSaveQuestionGroup_Click(object sender, EventArgs e)
    {
        try
        {
            TOOL_FORM form = SaveQuestionGroup();
            if (form.TOOL_FORM_ID > 0)
            {
                ButtonSubmitQuestionGroup.Enabled = true;
                Alert.ShowSaveSuccess();
            }
            else
            {
                Alert.ShowSaveFailed();
            }
        }
        catch
        {
            Alert.ShowSaveFailed();
        }

    }

    protected void GridViewFormQuestions_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewFormQuestions.PageIndex = e.NewPageIndex;
        int formId = Convert.ToInt32(HiddenFieldFormId.Value);
        
        if (formId != 0)
        {
            LoadControlsFromObject(formId);
        }

    }

    protected void gridViewPageSizeDdlChanged(Object sender, EventArgs e)
    {

        GridViewFormQuestions.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);
        int formId = Convert.ToInt32(HiddenFieldFormId.Value);
        
        if (formId != 0)
        {
            LoadControlsFromObject(formId);
        }

    }

    protected void gridViewPageSizeDdlChanged2(Object sender, EventArgs e)
    {

        GridViewQuestions.PageSize = int.Parse(gridViewPageSizeDdl2.SelectedValue);

    }
    
}
