﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web.Security;
using System.Web.UI.WebControls.WebParts;
using System.Text;
using System.IO;
using System.Reflection;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class SubpopulationFlag : BasePage
{
    private AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();

    protected void Page_Load(object sender, EventArgs e)
    {
        int registrantId = Request.QueryString["id"] == null ? UserSession.RegistrantId : Helpers.getIntFromString(Request.QueryString["id"].ToString());
        UserSession.RegistrantId = registrantId;
        LoadControlsFromObject(registrantId);
        var master = (this.Master as RegistryMaster);
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
    }

    public override string TopMenuName()
    {
        return "Registrants";
    }

    public override string MenuItemName()
    {
        return "Subpopulation Flags";
    }

    public override string AppObjectCode()
    {
        return "AHOBPR SUBPOPULATION FLAG";
    }

    private void LoadControlsFromObject(int registrantId)
    {
        HiddenFieldRegistrantId.Value = registrantId.ToString();
        UserControlRegistrant.LoadUserControl(registrantId);
        string registrantName = _registrantManager.SelectRegistrantNameById(registrantId);
        LabelBreadCrumb.Text = "<H1>Registrants > Registrant: " + registrantName + " > Subpopulation Flags</H1>";
        PanelSubpopulationFlags.GroupingText = " Subpopulation Flags for " + registrantName;
    }

    protected void GridViewSubpopulationFlags_PreRender(object sender, EventArgs e)
    {
        HookOnFocus(GridViewSubpopulationFlags);

    }
    protected void GridViewSubpopulationFlags_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        UserAccountManager user = (UserAccountManager)HttpContext.Current.User;
        DropDownList dropdownListSubpopulationFlags = null;
        int saveStatus = 0;

        switch (e.CommandName)
        {
            case "ADD":
                dropdownListSubpopulationFlags = GridViewSubpopulationFlags.FooterRow.FindControl("DropdownListSubpopulationFlags") as DropDownList;
                break;

            case "EMPTYADD":
                dropdownListSubpopulationFlags = GridViewSubpopulationFlags.Controls[0].Controls[0].FindControl("DropdownListSubpopulationFlagsEmpty") as DropDownList;
                break;

            case "DELETE_FLAG":

                int registrantFlagId = Convert.ToInt32(e.CommandArgument);
                //Add to Audit Log
                string message = _registrantManager.GetRegistryFlagNameByRegistrantFlagId(registrantFlagId) + ": Removed from Registrant";
                Helpers.AddActivityToAuditLog(user.UserId.ToString(), message, UserSession.RegistrantId.ToString(), AuditLogType.SubpopulationFlagSet, null);

                    if (_registrantManager.RemoveRegistryFlagFromRegistrant(registrantFlagId))
                {
                    GridViewSubpopulationFlags.DataBind();
                    UserControlRegistrant.LoadControlsFromObject(UserSession.RegistrantId);
                    Alert.ShowSaveSuccess();
                }
                else
                {
                    Alert.ShowSaveFailed();
                }

                break;
        }

        if (e.CommandName.Contains("ADD"))
        {

            //Add to Audit Log
            string message = "";
            if (dropdownListSubpopulationFlags != null)
            {
                message = dropdownListSubpopulationFlags.SelectedItem.Text;
            }
            Helpers.AddActivityToAuditLog(user.UserId.ToString(), message, UserSession.RegistrantId.ToString(), AuditLogType.SubpopulationFlagSet, null);

            if (dropdownListSubpopulationFlags != null)
            {
                saveStatus = _registrantManager.AddSupopulationFlagToRegistrant(UserSession.RegistrantId, Convert.ToInt32(dropdownListSubpopulationFlags.SelectedValue));
            }
            if (saveStatus == 2)
            {
                Alert.Show("This subpopulation flag already exists!");
            }
            else if (saveStatus == 1)
            {
                GridViewSubpopulationFlags.DataBind();
                UserControlRegistrant.LoadControlsFromObject(UserSession.RegistrantId);
                Alert.ShowSaveSuccess();
            }
            else
            {
                Alert.ShowSaveFailed();
            }
        }
    }
    protected void GridViewSubpopulationFlags_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        var index = Convert.ToInt32(e.RowIndex);
        GridViewSubpopulationFlags.SelectedIndex = index;
        var id = Convert.ToInt32(GridViewSubpopulationFlags.SelectedValue);

        GridViewSubpopulationFlags.SelectedIndex = -1;
        GridViewSubpopulationFlags.Focus();

        Alert.ShowSaveSuccess();
    }

    /// <summary>
    /// This function goes recursively all child controls and sets 
    /// onfocus attribute if the control has one of defined types.
    /// </summary>
    /// <param name="currentControl">the control to hook.</param>
    private void HookOnFocus(Control currentControl)
    {
        //checks if control is one of TextBox, DropDownList, ListBox or Button

        if ((currentControl is TextBox) ||
            (currentControl is DropDownList) ||
            (currentControl is ListBox) ||
            (currentControl is Button) ||
            (currentControl is Table) ||
            (currentControl is GridView))
        {
            WebControl curr = (currentControl as WebControl);
            if (curr != null)
            {
                //adds a script which saves active control on receiving focus 
                //in the hidden field __LASTFOCUS.
                curr.Attributes.Add("onfocus", "try{document.getElementById('__LASTFOCUS').value=this.id; } catch(e) {}");
            }
        }

        //checks if the control has children
        if (currentControl != null && currentControl.HasControls())
            //if yes do them all recursively

            foreach (Control CurrentChildControl in currentControl.Controls)
                HookOnFocus(CurrentChildControl);
    }

}