﻿<%@ Page Title="" EnableEventValidation="false" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="ReportStatusByLocation.aspx.cs" Inherits="ReportStatusByLocation" %>
<%@ Register Assembly="Microsoft.ReportViewer.WebForms, Version=11.0.0.0, Culture=neutral, PublicKeyToken=89845dcd8080cc91"
    Namespace="Microsoft.Reporting.WebForms" TagPrefix="rsweb" %>
<%@ Register Src="controls/BaseControlListBox.ascx" TagName="BaseControlListBox" TagPrefix="UC" %>
<%@ Register Src="controls/BaseControlDropDownList.ascx" TagName="BaseControlDropDownList"
    TagPrefix="UserControl" %>
<%@ Register Src="controls/BaseControlRadioButtonList.ascx" TagName="BaseControlRadioButtonList"
    TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlReportLocation.ascx" TagName="UserControlReportLocation"
    TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlFacilityDropdownLists.ascx" TagName="UserControlFacilityDropdownLists"
    TagPrefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
<script type = "text/javascript">
    $(document).ready(function() {
        $('#<%= UserControlReportLocationAssigned.ClientID + "_RadioButtonListLocation_0" %>').click(function() {
            $('#<%= PanelStatusByLocation.ClientID %>').hide();
            $('#<%= PanelReportViewer.ClientID %>').hide();          
        });
        $('#<%= UserControlReportLocationAssigned.ClientID + "_RadioButtonListLocation_1" %>').click(function() {
            $('#<%= PanelStatusByLocation.ClientID %>').hide();
            $('#<%= PanelReportViewer.ClientID %>').hide();
        });
        $('#<%= UserControlReportLocationAssigned.ClientID + "_RadioButtonListLocation_2" %>').click(function() {
            $('#<%= PanelStatusByLocation.ClientID %>').hide();
            $('#<%= PanelReportViewer.ClientID %>').hide();
        });
    });
</script>
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="<H1>Reporting > Status by Location Report</H1>"/>
    </div>    
    <br />
    <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
    <asp:Panel ID="PanelReportParm" runat="server" GroupingText=" Selection Criteria (Please select at least one)" Width="100%">
        <div class="excludeSaveWarnings">
            <table>
                <tr>
                    <td width="260px">
                        <asp:Label SkinID="DataLabel" ID="LabelAsOfDate" runat="server" Text="As of Date:"
                            Font-Bold="true" AssociatedControlID="TextBoxAsOfDate" ToolTip="As of Date is the end date the report results will be based." >
                        </asp:Label>
                        <br />
                        <asp:TextBox ID="TextBoxAsOfDate" runat="server" Width="90px" Enabled="false" ToolTip="As of Date is the end date the report results will be based." />
                        <br />
                    </td>
                    <td>
                        <UC:BaseControlListBox ID="BaseControlListBoxState" runat="server" />
                    </td>
                    <td>
                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    </td>
                    <td>
                        <UC:BaseControlListBox ID="BaseControlListBoxStatus" runat="server" />
                    </td>
                 </tr>
                 <tr>
                 <td colspan='4'>
                  <UserControl:UserControlReportLocation ID="UserControlReportLocationAssigned" runat="server" />
                 </td>
                 </tr>
                 <tr>
                 <td colspan='4'>
                 <br />
                  <UserControl:UserControlReportLocation ID="UserControlReportLocationEvaluation" runat="server" />
                 </td>
                 </tr>
                <tr>
                 <td colspan='4'>
                 <br />
                  <asp:Panel ID="PanelClosestFacility" runat="server">
                   <UserControl:UserControlFacilityDropdownLists ID="UserControlFacilityDropdownLists" runat="server" ClosestFacility="true" />
                  </asp:Panel>  
                 </td>
                 </tr>
            </table>
           <asp:Panel ID="PanelButtons" runat="server" Width="100%" Visible="true">
                <table>
                    <tr>
                        <td>
                            <asp:Button runat="server" ID="ButtonRunReport" Text="Run Report" OnClick="ButtonRunReport_Click"
                                Width="120px" ValidationGroup="OnRunReport" />
                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                            <asp:Button ID="ButtonPrintReport" runat="server" Text="Print/Export Report" Width="150px"
                                ValidationGroup="OnRunReport" OnClick="ButtonPrintReport_Click" Style="margin-left: 0px;
                                margin-top: 8px" />
                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp
                            <asp:Button runat="server" ID="ButtonClear" Text="Clear" Width="120px" OnClick="ButtonClear_Click"/>
                      </td>
                    </tr>
                </table>
            </asp:Panel>
        </div>
    </asp:Panel>
    <asp:Panel ID="PanelReportViewer" runat="server">
        <rsweb:ReportViewer ID="ReportViewerReport" runat="server" Width="100%" ProcessingMode="Remote"
            Height="700px">
        </rsweb:ReportViewer>
    </asp:Panel>
    <asp:Panel ID="PanelStatusByLocation" runat="server" Visible="false" GroupingText=" Report Results ">
        <asp:Label runat="server" ID="LabelNumberOfResultsFound" Font-Bold="true"></asp:Label>
        <div style="text-align: right;" runat="server" id="pageSizeDiv">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl"  Visible="false" ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true" Visible="false" CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
        </div>
        <asp:GridView ID="GridViewStatusByLocation" runat="server" DataSourceID="DataSourceStatusByLocation"
            AutoGenerateColumns="False" PageSize="20" Width="100%" AllowPaging="True" AllowSorting="True"
            Caption="To sort please click table headings"
            OnRowCommand="GridViewStatusByLocation_RowCommand" DataKeyNames="REGISTRANT_ID" PagerSettings-Mode="Numeric"
            OnPageIndexChanging="gridView_PageIndexChanging">
            <EmptyDataTemplate>
                No match found. Please verify the information you entered in the search criteria.</EmptyDataTemplate>
            <Columns>
                <asp:TemplateField Visible="false" HeaderText="ID" SortExpression="REGISTRANT_ID"
                    ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:LinkButton ID="LinkButtonRegistrantID" runat="server" CommandArgument='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID"))  %>'
                            CommandName="Details" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID")) %>'>
                        </asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Registrant Name" SortExpression="Name">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:LinkButton ID="LinkButtonRegistrantName" runat="server" CommandArgument='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID"))  %>'
                            CommandName="Details" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Name")) %>'>
                        </asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Date of Birth" SortExpression="BirthDate">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelDOB" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("BirthDateDisplay")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Registrant Record Status" SortExpression="Status"
                    ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelStatus" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Status")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="# Days at Status" SortExpression="Days" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelDays" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Days")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="State" SortExpression="State" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelState" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("State")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Assigned VISN" SortExpression="VISN" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelVISN" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("VISN")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Assigned Facility" SortExpression="Facility" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Facility")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
            <HeaderStyle HorizontalAlign="Left" />
        </asp:GridView>
    </asp:Panel>
    <asp:ObjectDataSource ID="DataSourceStatusByLocation" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetStatusByLocation" EnablePaging="true" StartRowIndexParameterName="startRowIndex"
        MaximumRowsParameterName="maximumRows" SortParameterName="SortExpression" SelectCountMethod="GetStatusByLocationCount"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRReportManager"
        onselected="DataSourceStatusByLocation_Selected">
        <SelectParameters>
            <asp:ControlParameter ControlID="BaseControlListBoxState" Name="State" PropertyName="Text"
                Type="String" />
            <asp:ControlParameter ControlID="BaseControlListBoxStatus" Name="Status" PropertyName="Text"
                Type="String" />
            <asp:ControlParameter ControlID="UserControlReportLocationAssigned" Name="AssignedLocationType" PropertyName="LocationType"
                Type="string" />
            <asp:ControlParameter ControlID="UserControlReportLocationAssigned" Name="AssignedLocationKey" PropertyName="LocationKey"
                Type="String" />  
            <asp:ControlParameter ControlID="UserControlReportLocationEvaluation" Name="EvaluationLocationType" PropertyName="LocationType"
                Type="string" />
            <asp:ControlParameter ControlID="UserControlReportLocationEvaluation" Name="EvaluationLocationKey" PropertyName="LocationKey"
                Type="String" />
            <asp:ControlParameter ControlID="UserControlFacilityDropdownLists" Name="closestFacilityId"
                PropertyName="FacilityId" Type="String" />   
            <asp:Parameter Name="totalRecords" Type="Int32" Direction="Output" />       
        </SelectParameters>
    </asp:ObjectDataSource>
    </asp:Content>

