﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

public partial class ReportFollowupQuestions : BasePage
{
    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private List<STD_GUI_CONTROL_AHOBPR> _dbControls = null;
    private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    //private AHOBPRReportManager _reportManager = new AHOBPRReportManager();
    private string _serverReportName = "ReportFollowupQuestion";

    public string ServerReportParameters { get; set; }

    protected void Page_Load(object sender, EventArgs e)
    {
        UserSession.RegistrantId = 0;

        ReportViewerReport.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));

        var master = (this.Master as RegistryMaster);
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }

        if (!IsPostBack)
        {
            ShowFollowupQuestionsReport(false);
            ShowReportViewer(false);
            gridViewPageSizeDdl.Visible = false;
            LabelItemsPerPage.Visible = false;

            UserControlDateRange.LoadControlsFromObject("Follow-Up Questions Completed Date", false, "Follow-Up Questions Completed Date is the date the Follow-up Questions was submitted.  This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter for a Follow-up Questions completed date within a date range.", "QuestionGroup");
        
        }

        LoadBaseControls();
        if (IsPostBack)
        {
            ReloadBaseControlValue();
        }
               
    }

    private void ReloadBaseControlValue()
    {
        BaseControlListBoxQuestionGroup.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxQuestionGroup.Text);
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        Response.Redirect("ReportFollowupQuestions.aspx");
    }

    protected void ButtonPrintReport_Click(object sender, EventArgs e)
    {
        if (UserControlDateRange.ValidateCustomValidator())
        {
            ReportViewerReport.Reset();
            SetReportPath();
            SetReportParameters();

            ReportViewerReport.ProcessingMode = ProcessingMode.Remote;
            ReportViewerReport.Visible = true;
            ReportViewerReport.ServerReport.Refresh();
            ShowReportViewer(true);
        }
        else
        {
            ReportViewerReport.Visible = true;
            ShowReportViewer(true);

        }
    }

    private void SetReportPath()
    {
        ReportViewerReport.ServerReport.ReportPath = _serverReportName;

        var config = RegistriesConfigurations.GetConfig();

        ReportViewerReport.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));

        if (ReportViewerReport.ServerReport.ReportPath.IndexOf(
                Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
        {
            ReportViewerReport.ServerReport.ReportPath =
                Helpers.GetConfigEntry("BaseReportPath") + ReportViewerReport.ServerReport.ReportPath;
        }
    }
    private void SetReportParameters()
    {
        _reportParameters.Clear();

        SetCompletedDateParameter();
        SetQuestionGroupParameter();
        SetQuestionnaireCompletionParameter();

        ReportViewerReport.ServerReport.SetParameters(_reportParameters);
    }

    private void SetQuestionGroupParameter()
    {
        string questionGroup = string.Empty;
        if (!string.IsNullOrEmpty(BaseControlListBoxQuestionGroup.Text))
        {
            questionGroup = BaseControlListBoxQuestionGroup.Text;
            ReportParameter reportParameterState =
                new ReportParameter("questionGroup", questionGroup);
            _reportParameters.Add(reportParameterState);

            ServerReportParameters += Environment.NewLine + " Question Group: " + questionGroup;
        }
    }

    private void SetCompletedDateParameter()
    {
        ReportParameter reportParameterDate = new ReportParameter("fromDateText", UserControlDateRange.FromDateValue);
        _reportParameters.Add(reportParameterDate);

        reportParameterDate = new ReportParameter("toDateText", UserControlDateRange.ToDateValue);
        _reportParameters.Add(reportParameterDate);

    }

    private void SetQuestionnaireCompletionParameter()
    {
        string questionsCompletion = string.Empty;
        if (!string.IsNullOrEmpty(RadioButtonQuestionsCompletion.SelectedValue))
        {
            questionsCompletion = RadioButtonQuestionsCompletion.SelectedValue;
        }
        else
        {
            questionsCompletion = "All";
        }
        ReportParameter reportParameter = new ReportParameter("questionsCompletion", questionsCompletion);
        _reportParameters.Add(reportParameter);

        ServerReportParameters += Environment.NewLine + " Follow-up Questions Completion: " + questionsCompletion;
        
    }

   

    private void LoadBaseControls()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_REPORT_FOLLOWUP_QUESTIONS"))
        {
            Control userControl = PanelReportFollowupQuestions.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                switch (dbItem.BASE_CONTROL_TYPE)
                {
                    case (int)AhobprBaseControlType.ListBox:
                        controls_BaseControlListBox baseControl = (controls_BaseControlListBox)userControl;
                        baseControl.LoadControlsFromObject(dbItem.LOOKUP_LIST_CATEGORY, string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                            dbItem.INCLUDE_LABEL, dbItem.DATA_ELEMENT_WIDTH, dbItem.VALIDATION_GROUP, dbItem.REQUIRED);
                        break;
                    case (int)AhobprBaseControlType.DropDownList:
                        controls_BaseControlDropDownList baseControlDropdown = (controls_BaseControlDropDownList)userControl;

                        baseControlDropdown.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY,
                                                                   dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.REQUIRED);
                        break;
                    case (int)AhobprBaseControlType.RadioButtonList:
                        controls_BaseControlRadioButtonList baseControlRadioButtonList = (controls_BaseControlRadioButtonList)userControl;

                        baseControlRadioButtonList.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY);
                        break;

                }
            }
        }
    }

    private List<STD_GUI_CONTROL_AHOBPR> GetGuiControls(string controlCategory)
    {
        if (UserSession.GuiControlsReportFollowupQuestions == null)
        {
            _dbControls = _baseControlManager.SelectGuiControlList(controlCategory).ToList<STD_GUI_CONTROL_AHOBPR>();
            UserSession.GuiControlsReportFollowupQuestions = _dbControls;
        }
        else
        {
            _dbControls = UserSession.GuiControlsReportFollowupQuestions;
        }

        return _dbControls;
    }


    protected void GridViewFollowupQuestions_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewFollowupQuestions.SelectedIndex = index;
            UserSession.RegistrantId = GridViewFollowupQuestions.SelectedIndex;
            //get Question Group Name
            GridViewRow row = (GridViewRow)(((LinkButton)e.CommandSource).NamingContainer);
            Label questionsGroupName = ((Label)row.FindControl("LabelQuestionsGroupName")); 

            Response.Redirect("QuestionnaireFollowup.aspx?id=" + GridViewFollowupQuestions.SelectedIndex + "&questionsGroupName=" + questionsGroupName.Text); 
            //Response.Redirect("QuestionnaireFollowup.aspx?id=" + GridViewFollowupQuestions.SelectedIndex);
        }
    }

    protected void ButtonRunReport_Click(object sender, EventArgs e)
    {
        if (UserControlDateRange.ValidateCustomValidator())
        {
            ShowReportViewer(false);
            ShowFollowupQuestionsReport(true);
            gridViewPageSizeDdl.Visible = true;
            LabelItemsPerPage.Visible = true;
        }
        else
        {
            ShowReportViewer(false);
            ShowFollowupQuestionsReport(false);
            gridViewPageSizeDdl.Visible = false;
            LabelItemsPerPage.Visible = false;

        }

    }


    private void ShowFollowupQuestionsReport(bool show)
    {
        PanelFollowupQuestions.Visible = show;
        if (show)
        {
            GridViewFollowupQuestions.DataBind();

        }
    }


    private void ShowReportViewer(bool show)
    {
        PanelReportViewer.Visible = show;

        if (show)
        {
            ShowFollowupQuestionsReport(false);
            gridViewPageSizeDdl.Visible = false;
            LabelItemsPerPage.Visible = false;
        }
    }


    public override string TopMenuName()
    {
        return "Reporting";
    }

    public override string AppObjectCode()
    {
        return "AHOBPR REPORT Status By Location";
    }

    public override string MenuItemName()
    {
        return "AHOBPR REPORT Status By Location";
    }

    protected void DataSourceFollowupQuestions_Selected(object sender, ObjectDataSourceStatusEventArgs e) 
    {
        var totalRecordsFound = e.ReturnValue;
        LabelNumberOfResultsFound.Text = "Total Number of Results Found: " + totalRecordsFound.ToString();

    }

    protected void gridViewPageSizeDdlChanged(Object sender, EventArgs e)
    {

        GridViewFollowupQuestions.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);

    }

    protected void gridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewFollowupQuestions.PageIndex = e.NewPageIndex;

    }
    protected void RadioButtonQuestionsCompletion_SelectedIndexChanged(object sender, EventArgs e)
    {
       if (RadioButtonQuestionsCompletion.SelectedValue == "Completed")
         {
            UserControlDateRange.Visible = true;
         }
        else
       {
           UserControlDateRange.Visible = false;
           UserControlDateRange.FromDateValue = string.Empty;
           UserControlDateRange.ToDateValue = string.Empty;
       }
    }
}