﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using AntiXssEnc = Microsoft.Security.Application;

public partial class ReportAdHoc : BasePage
{
    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private List<STD_GUI_CONTROL_AHOBPR> _dbControls = null;
    private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    private AHOBPRReportManager _reportManager = new AHOBPRReportManager();
    //private AHOBPRLookUpManager _lookupManager = new AHOBPRLookUpManager();
    private string _serverReportNameByLocation = "ReportAdHocByLocation";
    private string _serverReportNameByLocationDrillDown = "ReportAdHocByLocationDrillDown";
    private string _serverReportNameByLocationDrillDownNoQuestion = "ReportAdHocByLocationDrillDownNoQuestion";
    private string _serverReportNameByIndividual = "ReportAdHocByIndividual";
    private string _serverReportNameByIndividualNoQuestion = "ReportAdHocByIndividualNoQuestion";
    private string _serverReportName = string.Empty;
    private string _serverReportParameters = string.Empty;

    public string selectedQuestion = null;

    protected void Page_Load(object sender, EventArgs e)
    {

        UserSession.RegistrantId = 0;

        ReportViewerReport.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));

        if (!IsPostBack)
        {
            ShowSelectParameterPanel(true);
            if (Request.QueryString["step"] != null)
            {
                if (Helpers.getIntFromString(Request.QueryString["step"].ToString()) == 2)
                {
                    ShowSelectParameterPanel(false);
                }
            }

            
            if (Request.QueryString["reportType"].ToString() == "Aggregate")
            {
                LabelBreadCrumb.Text = "<H1>Reporting > Ad Hoc Report by Location</H1>";
                CheckBoxLocation.Checked = true;
                CheckBoxLocation.Enabled = false;
                CheckBoxLocation.ToolTip = "Assigned Location is a VISN or Facility that a registrant is assigned to as reported in CDW. The Selection Criteria allows the user to filter with all locations, one VISN, Main Facility, or one Sub-Facility, or Registrants who are not assigned.";
                UserControlReportLocationEvaluation.Visible = false;
                //Closest Facility not use in Adhoc by Loaction report
                CheckBoxClosestFacility.Visible = false;
            }
            else
            {
                LabelBreadCrumb.Text = "<H1>Reporting > Ad Hoc Report by Individual</H1>";
            }

        }
        
        LoadBaseControls();
        UserControlCurrentStatusFromToDate.LoadControlsFromObject("Date Range for Registrant Current Status", false, "Date Range for Registrant Current Status is the date of the current status.  The Selection Criteria allows the user to filter by a date range for the current status or all statuses within the date range.", "OnRunReport");

        Page.PreRender += new EventHandler(Page_PreRender);
        //set Location panel names & ToolTips
        UserControlReportLocationAssigned.LocationPanelName = "  Assigned Location  ";
        UserControlReportLocationEvaluation.LocationPanelName = "  AHOBPR Evaluation Location (Most Recent)  ";
        UserControlReportLocationAssigned.LocationPanelToolTip = "Assigned Location is a VISN or Facility that a registrant is assigned to as reported in CDW. The Selection Criteria allows the user to filter with all locations, one VISN, Main Facility, or one Sub-Facility, or Registrants who are not assigned.";
        UserControlReportLocationEvaluation.LocationPanelToolTip = "AHOBPR Evaluation Location is a VISN or Facility where a registrant had their most recent AHOBPR Evaluation as reported in CDW. The Selection Criteria allows the user to filter with all locations, one VISN, Main Facility, or one Sub-Facility, or Registrants who have not had a AHOBPR Evaluation.";

        UserControlFacilityDropdownLists.FacilityPanelName = "  Closest Facility  ";
        UserControlFacilityDropdownLists.FacilityPanelToolTip = "Closest Facility is a Facility where is closest to registrants. The Selection Criteria allows the user to filter with one Main Facility or one Sub Facility.";
    }

    void Page_PreRender(object sender, EventArgs e)
    {
        if (IsPostBack)
        {
            ReloadBaseControlValue();
        }
        else
        {
            ShowSearchCriteriaLink();
            PrepopulateCriteriaSelection();

            // go to step 2 directly if load from saved search criteria
            string searchCriteriaId = Request.QueryString["id"] == null ? string.Empty : Request.QueryString["id"].ToString();
            if (!string.IsNullOrEmpty(searchCriteriaId))
            {
                string searchCriteriaString = _reportManager.GetSearchCriteriaById(searchCriteriaId);
                if (!string.IsNullOrEmpty(searchCriteriaString))
                {
                    ShowSelectParameterPanel(false);
                    LoadBaseControls();
                    ClearSearchCriteria();
                    ShowAdHocReport(false, false);
                    ShowReportViewer(false);
                    PrepopulateSearchCriteria(true);
                }
            }
        }
    }

    private void ReloadBaseControlValue()
    {
        if (BaseControlListBoxStatus.Visible)
        {
            BaseControlListBoxStatus.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxStatus.Text);
        }
        if (BaseControlListBoxDutyStatus.Visible)
        {
            BaseControlListBoxDutyStatus.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxDutyStatus.Text);
        }
        if (BaseControlListBoxAnswer.Visible)
        {
            BaseControlListBoxAnswer.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxAnswer.Text);
        }
        if (BaseControlListBoxHealthFactor.Visible)
        {
            BaseControlListBoxHealthFactor.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxHealthFactor.Text);
        }
        if (DropDownListQuestion.Visible)
        {
            if (!string.IsNullOrEmpty(HiddenFieldQuestion.Value))
            {
                DropDownListQuestion.SelectedIndex = -1;
                DropDownListQuestion.Items.FindByValue(HiddenFieldQuestion.Value).Selected = true;
            }
        }

    }

    private void ShowSearchCriteriaLink()
    {
        bool showLink = false;
        if (Request.QueryString["step"] == null)
        {
            showLink = true;
        }
        else
        {
            if (Request.QueryString["step"].ToString() == "1")
            {
                showLink = true;
            }
        }

        if (showLink)
        {
            UserAccountManager currentUser = (UserAccountManager)HttpContext.Current.User;
            string userName = currentUser.Identity.Name;
            string reportName = Request.QueryString["reportType"].ToString() == "Aggregate" ? AHOBPRGlobal.ReportSearchCriteriaAdhocReportLocation :  AHOBPRGlobal.ReportSearchCriteriaAdhocReportIndividual;

            bool hasSavedSearchCriteria = _reportManager.SelectReportSearchCriteriaCount(userName, reportName) > 0;

            if (hasSavedSearchCriteria)
            {
                LinkButtonReportSearchCriteria.PostBackUrl = "ReportSearchCriteria.aspx?from=" + reportName + "&reportType=" + Request.QueryString["reportType"].ToString();
                LinkButtonReportSearchCriteria.Visible = true;

                LinkButtonReportSearchCriteriaStep2.PostBackUrl = "ReportSearchCriteria.aspx?from=" + reportName + "&reportType=" + Request.QueryString["reportType"].ToString();
                LinkButtonReportSearchCriteriaStep2.Visible = true;
            }
            else
            {
                LinkButtonReportSearchCriteria.Visible = false;
                LinkButtonReportSearchCriteriaStep2.Visible = false;
            }
        }
    }
    private void PrepopulateCriteriaSelection()
    {
        bool prepopulate = false;
        if (Request.QueryString["step"] == null)
        {
            prepopulate = true;
        }
        else if (Request.QueryString["step"].ToString() == "1")
        {
            prepopulate = true;
        }

        if (prepopulate)
        {
            string searchCriteriaId = Request.QueryString["id"] == null ? string.Empty : Request.QueryString["id"].ToString();

            if (!string.IsNullOrEmpty(searchCriteriaId) && !IsPostBack)
            {
                string searchCriteriaString = _reportManager.GetSearchCriteriaById(searchCriteriaId);
                string questionId = string.Empty;
                if (!string.IsNullOrEmpty(searchCriteriaString))
                {
                    List<string> searchCriteriaList = searchCriteriaString.Split('|').ToList();
                    foreach (string searchCriteria in searchCriteriaList)
                    {
                        KeyValuePair<string, string> criteria = SplitSearchCriteria(searchCriteria);
                        switch (criteria.Key)
                        {
                            case AHOBPRGlobal.ReportSearchCriteriaStatus:
                                CheckBoxRegistrantStatus.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaDutyStatus:
                                CheckBoxDutyStatus.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaFormStartFromDate:
                                RadioButtonListStartEndDate.SelectedIndex = 1;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaFormStartToDate:
                                RadioButtonListStartEndDate.SelectedIndex = 1;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaFormCompletionFromDate:
                                RadioButtonListStartEndDate.SelectedIndex = 2;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaFormCompletionToDate:
                                RadioButtonListStartEndDate.SelectedIndex = 2;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaHealthConcerns:
                                CheckBoxHealthConcerns.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaRequestToBeSeen:
                                CheckBoxRequestToBeSeen.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaQuestion:
                                CheckBoxQuestion.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaAnswer:
                                CheckBoxQuestion.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaAdminFlag:
                                CheckBoxAdminFlag.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaSubpopulationFlag:
                                CheckBoxSubpopulationFlag.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaHealthFactor:
                                CheckBoxHealthFactor.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaAssignedLocationMainFacility:
                                CheckBoxLocation.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaAssignedLocationSubFacility:
                                CheckBoxLocation.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaAssignedLocationVisn:
                                CheckBoxLocation.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaEvaluationLocationMainFacility:
                                CheckBoxLocation.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaEvaluationLocationSubFacility:
                                CheckBoxLocation.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaEvaluationLocationVisn:
                                CheckBoxLocation.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaDeploymentAll:
                                RadioButtonListDeploymentCountry.SelectedIndex = 1;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaDeploymentExposure:
                                RadioButtonListDeploymentCountry.SelectedIndex = 2;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaDeathFlag:
                                CheckBoxDeathFlag.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaGender:
                                CheckBoxGender.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaRace:
                                CheckBoxRace.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaEthnicity:
                                CheckBoxEthnicity.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaSeparationType:
                                CheckBoxSeparationType.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaSeparationDateFromDate:
                                CheckBoxSeparationDate.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaSeparationDateToDate:
                                CheckBoxSeparationDate.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaEnrollmentStatus:
                                CheckBoxEnrollmentStatus.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaEvaluation:
                                CheckBoxEvaluation.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaCurrentStatusFromDate:
                                CheckBoxDateRangeCurrentStatus.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaCurrentStatusToDate:
                                CheckBoxDateRangeCurrentStatus.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaClosestFacilityVisn:
                                CheckBoxClosestFacility.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaClosestFacilityMainFacility:
                                CheckBoxClosestFacility.Checked = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaClosestFacilitySubFacility:
                                CheckBoxClosestFacility.Checked = true;
                                break;
                        }
                    }
                }
            }
        }
   }

    private void PrepopulateSearchCriteria(bool fromStep1)
    {
        if (PanelParameterAdHocReport.Visible)
        {
            string searchCriteriaId = Request.QueryString["id"] == null ? string.Empty : Request.QueryString["id"].ToString();

            if (!string.IsNullOrEmpty(searchCriteriaId) && fromStep1)
            {
                string searchCriteriaString = _reportManager.GetSearchCriteriaById(searchCriteriaId);
                string questionId = string.Empty;
                if (!string.IsNullOrEmpty(searchCriteriaString))
                {
                    List<string> searchCriteriaList = searchCriteriaString.Split('|').ToList();
                    foreach (string searchCriteria in searchCriteriaList)
                    {
                        KeyValuePair<string, string> criteria = SplitSearchCriteria(searchCriteria);
                        switch (criteria.Key)
                        {
                            case AHOBPRGlobal.ReportSearchCriteriaStatus:
                                BaseControlListBoxStatus.DataElementValue = Helpers.ConvertToKeyValuePair(criteria.Value);
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaDutyStatus:
                                BaseControlListBoxDutyStatus.DataElementValue = Helpers.ConvertToKeyValuePair(criteria.Value);
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaFormStartFromDate:
                                UserControlDateRangeFormStartDate.FromDateValue = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaFormStartToDate:
                                UserControlDateRangeFormStartDate.ToDateValue = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaCurrentStatusFromDate:
                                UserControlCurrentStatusFromToDate.FromDateValue = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaCurrentStatusToDate:
                                UserControlCurrentStatusFromToDate.ToDateValue = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaFormCompletionFromDate:
                                UserControlDateRangeFormToDate.FromDateValue = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaFormCompletionToDate:
                                UserControlDateRangeFormToDate.ToDateValue = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaHealthConcerns:
                                RadioButtonListHealthConcerns.Items.FindByValue(criteria.Value).Selected = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaEvaluation:
                                RadioButtonListEvaluation.Items.FindByValue(criteria.Value).Selected = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaRequestToBeSeen:
                                RadioButtonListRequestToBeSeen.Items.FindByValue(criteria.Value).Selected = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaQuestion:
                                DropDownListQuestion.SelectedIndex = -1;
                                DropDownListQuestion.Items.FindByValue(criteria.Value).Selected = true;
                                HiddenFieldQuestion.Value = criteria.Value;
                                questionId = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaAnswer:
                                ShowAnswerControl(true, questionId);
                                BaseControlListBoxAnswer.DataElementValue = Helpers.ConvertToKeyValuePair(criteria.Value);
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaHealthFactor:
                                BaseControlListBoxHealthFactor.DataElementValue = Helpers.ConvertToKeyValuePair(criteria.Value);
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaDeploymentAll:
                                BaseControlDropDownListDeploymentCountryAll.Text = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaDeploymentExposure:
                                BaseControlDropDownListDeploymentCountryExposure.Text = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaAssignedLocationMainFacility:
                                if (Request.QueryString["reportType"].ToString() != "Aggregate")
                                {
                                    UserControlReportLocationAssigned.MainFacilityId = criteria.Value;
                                }
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaAssignedLocationSubFacility:
                                if (Request.QueryString["reportType"].ToString() != "Aggregate")
                                {
                                    UserControlReportLocationAssigned.SubFacilityId = criteria.Value;
                                }
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaAssignedLocationVisn:
                                if (Request.QueryString["reportType"].ToString() != "Aggregate")
                                {
                                    UserControlReportLocationAssigned.VisnId = criteria.Value;
                                }
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaEvaluationLocationMainFacility:
                                if (Request.QueryString["reportType"].ToString() != "Aggregate")
                                {
                                    UserControlReportLocationEvaluation.MainFacilityId = criteria.Value;
                                }
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaEvaluationLocationSubFacility:
                                if (Request.QueryString["reportType"].ToString() != "Aggregate")
                                {
                                    UserControlReportLocationEvaluation.SubFacilityId = criteria.Value;
                                }
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaEvaluationLocationVisn:
                                if (Request.QueryString["reportType"].ToString() != "Aggregate")
                                {
                                    UserControlReportLocationEvaluation.VisnId = criteria.Value;
                                }
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaClosestFacilityVisn:
                                UserControlFacilityDropdownLists.VisnId = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaClosestFacilityMainFacility:
                                UserControlFacilityDropdownLists.MainFacilityId = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaClosestFacilitySubFacility:
                                UserControlFacilityDropdownLists.SubFacilityId = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaSubpopulationFlag:
                                this.BaseControlDropDownListSubpopulationFlag.Text = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaAdminFlag:
                                UserControlAdminFlagFilter.AdminFlagId = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaAdminFlagFromDate:
                                UserControlAdminFlagFilter.AdminFlagEnteredDateFrom = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaAdminFlagToDate:
                                UserControlAdminFlagFilter.AdminFlagEnteredDateTo = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaLocationBy:
                                if (Request.QueryString["reportType"].ToString() == "Aggregate")
                                {
                                    RadioButtonListLocation.SelectedValue = criteria.Value;
                                }
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaDeathFlag:
                                this.RadioButtonListDeathFlag.Items.FindByValue(criteria.Value).Selected = true;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaRace:
                                this.BaseControlDropDownListRace.Text = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaGender:
                                this.BaseControlDropDownListGender.Text = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaSeparationType:
                                this.BaseControlDropDownListSeparationType.Text = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaSeparationDateFromDate:
                                this.UserControlDateRangeSeparation.FromDateValue = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaSeparationDateToDate:
                                this.UserControlDateRangeSeparation.ToDateValue = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaEthnicity:
                                this.BaseControlDropDownListEthnicity.Text = criteria.Value;
                                break;
                            case AHOBPRGlobal.ReportSearchCriteriaEnrollmentStatus:
                                this.BaseControlDropDownListEnrollmentStatus.Text = criteria.Value;
                                break;
                            
                        }
                    }
                }
            }
        }
    }

    private KeyValuePair<string, string> SplitSearchCriteria(string searchCriteria)
    {
        KeyValuePair<string, string> result = new KeyValuePair<string,string>();

        string[] searchCriteriaArray = searchCriteria.Split(':');
        if (searchCriteriaArray.Length > 1)
        {
            result = new KeyValuePair<string,string>(searchCriteriaArray[0].Trim(), searchCriteriaArray[1].Trim());
        }

        return result;
    }

    private string GetValuesFromListBox(controls_BaseControlListBox listboxItem)
    {
        string result = string.Empty;

        foreach (KeyValuePair<string, string> item in listboxItem.DataElementValue)
        {
            if (!string.IsNullOrEmpty(item.Value))
            {
                if (!string.IsNullOrEmpty(result))
                {
                    result = result + ", ";
                }
                result = result + item.Value;
            }
        }

        return result;
    }

    protected void ButtonPrintReport_Click(object sender, EventArgs e)
    {
        if (ValidateCustomValidatorStep2())
        {
            ReportViewerReport.Reset();
            SetReportPath();
            SetReportParameters();

            ReportViewerReport.ProcessingMode = ProcessingMode.Remote;
            ReportViewerReport.Visible = true;
            ReportViewerReport.ServerReport.Refresh();
            ShowReportViewer(true);
        }
    }

    protected void ButtonNext_Click(object sender, EventArgs e)
    {
        CustomValidatorSelectDataElements.IsValid = true;

        // Validate that at least one value was entered    
        bool notValid = (!CheckBoxHealthFactor.Checked && !CheckBoxDutyStatus.Checked
                && !CheckBoxRegistrantStatus.Checked && !CheckBoxHealthConcerns.Checked && !CheckBoxRequestToBeSeen.Checked
                && !CheckBoxSubpopulationFlag.Checked && !CheckBoxAdminFlag.Checked && !CheckBoxQuestion.Checked
                && !CheckBoxRace.Checked && !CheckBoxGender.Checked && !CheckBoxSeparationType.Checked
                && !CheckBoxEthnicity.Checked && !CheckBoxSeparationDate.Checked && !CheckBoxDeathFlag.Checked && !CheckBoxEnrollmentStatus.Checked
                && RadioButtonListDeploymentCountry.SelectedValue == "None" && !CheckBoxDateRangeCurrentStatus.Checked
                && RadioButtonListStartEndDate.SelectedValue == "None" && !CheckBoxEvaluation.Checked
                && !CheckBoxClosestFacility.Checked);

        if (Request.QueryString["reportType"].ToString() != "Aggregate")
        {
            notValid = (notValid && !CheckBoxLocation.Checked);
        }

        if (notValid)
        {
            CustomValidatorSelectDataElements.IsValid = false;
        }
        else
        {
            ShowSelectParameterPanel(false);
            LoadBaseControls();
            ClearInvisibleSearchCriteria();
            ShowAdHocReport(false, false);
            ShowReportViewer(false);
            PrepopulateSearchCriteria(true);
        }

    }

    protected void ButtonBack_Click(object sender, EventArgs e)
    {
        ClearInvisibleSearchCriteria();
        ShowSelectParameterPanel(true);
    }

    protected void ButtonBackToSummary_Click(object sender, EventArgs e)
    {
        LabelBreadCrumb.Text = "<H1>Reporting > Ad Hoc Report by Location</H1>";
        RunReport();
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        ClearSearchCriteria();
        ShowReportViewer(false);
        ShowAdHocReport(false, false);
    }
    protected void ButtonClearSelection_Click(object sender, EventArgs e)
    {
        string rString = "ReportAdHoc.aspx";

        if (Request.QueryString["reportType"].ToString() == "Individual")
            rString += "?reportType=Individual";
        else if (Request.QueryString["reportType"].ToString() == "Aggregate")
            rString += "?reportType=Aggregate";

        Response.Redirect(rString);
    }

    protected void ButtonSaveSearchCriteria_Click(object sender, EventArgs e)
    {
        if (ValidateCustomValidatorStep2())
        {
            if (BaseControlTextBoxSearchCriteriaName.Visible == false)
            {
                BaseControlTextBoxSearchCriteriaName.Visible = true;
            }
            else
            {
                string reportName = Request.QueryString["reportType"].ToString() == "Aggregate" ? AHOBPRGlobal.ReportSearchCriteriaAdhocReportLocation : AHOBPRGlobal.ReportSearchCriteriaAdhocReportIndividual;

                int saveStatus = _reportManager.SaveSearchCriteria(reportName, BaseControlTextBoxSearchCriteriaName.Text,
                                                                    GetSearchCriteria(), GetSearchCriteriaDescription());
                if (saveStatus == 2)
                {
                    Alert.Show("The search criteria name already exists! Please use another search criteria name.");
                }
                else if (saveStatus == 1)
                {
                    Alert.ShowSaveSuccess();
                    BaseControlTextBoxSearchCriteriaName.Text = string.Empty;
                    BaseControlTextBoxSearchCriteriaName.Visible = false;
                    ShowSearchCriteriaLink();
                }
                else
                {
                    Alert.ShowSaveFailed();
                }
            }
        }
    }

    private string GetSearchCriteria()
    {
        string result = string.Empty;

        string criteria = string.Empty;

        if (BaseControlListBoxStatus.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaStatus, BaseControlListBoxStatus.Text);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (BaseControlListBoxDutyStatus.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaDutyStatus, BaseControlListBoxDutyStatus.Text);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (UserControlDateRangeFormStartDate.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaFormStartFromDate, UserControlDateRangeFormStartDate.FromDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaFormStartToDate, UserControlDateRangeFormStartDate.ToDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (UserControlDateRangeFormToDate.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaFormCompletionFromDate, UserControlDateRangeFormToDate.FromDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaFormCompletionToDate, UserControlDateRangeFormToDate.ToDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (UserControlCurrentStatusFromToDate.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaCurrentStatusFromDate, UserControlCurrentStatusFromToDate.FromDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaCurrentStatusToDate, UserControlCurrentStatusFromToDate.ToDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (RadioButtonListHealthConcerns.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaHealthConcerns, RadioButtonListHealthConcerns.SelectedValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (RadioButtonListEvaluation.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaEvaluation, RadioButtonListEvaluation.SelectedValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (RadioButtonListRequestToBeSeen.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaRequestToBeSeen, RadioButtonListRequestToBeSeen.SelectedValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (BaseControlDropDownListSubpopulationFlag.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaSubpopulationFlag, BaseControlDropDownListSubpopulationFlag.Text);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (UserControlAdminFlagFilter.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaAdminFlag, UserControlAdminFlagFilter.AdminFlagId);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaAdminFlagFromDate, UserControlAdminFlagFilter.AdminFlagEnteredDateFrom);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaAdminFlagToDate, UserControlAdminFlagFilter.AdminFlagEnteredDateTo);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (DropDownListQuestion.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaQuestion, DropDownListQuestion.SelectedValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaAnswer, BaseControlListBoxAnswer.Text);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (UserControlReportLocationAssigned.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaAssignedLocationVisn, UserControlReportLocationAssigned.VisnId);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaAssignedLocationMainFacility, UserControlReportLocationAssigned.MainFacilityId);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaAssignedLocationSubFacility, UserControlReportLocationAssigned.SubFacilityId);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (UserControlReportLocationEvaluation.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaEvaluationLocationVisn, UserControlReportLocationEvaluation.VisnId);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaEvaluationLocationMainFacility, UserControlReportLocationEvaluation.MainFacilityId);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaEvaluationLocationSubFacility, UserControlReportLocationEvaluation.SubFacilityId);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (BaseControlListBoxHealthFactor.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaHealthFactor, BaseControlListBoxHealthFactor.Text);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (BaseControlDropDownListDeploymentCountryAll.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaDeploymentAll, BaseControlDropDownListDeploymentCountryAll.Text);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }
        if (BaseControlDropDownListDeploymentCountryExposure.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaDeploymentExposure, BaseControlDropDownListDeploymentCountryExposure.Text);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }

        if (Request.QueryString["reportType"].ToString() == "Aggregate")
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaLocationBy, RadioButtonListLocation.SelectedValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }

        if (BaseControlDropDownListRace.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaRace, BaseControlDropDownListRace.Text);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }

        if (BaseControlDropDownListSeparationType.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaSeparationType, BaseControlDropDownListSeparationType.Text);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }

        if (BaseControlDropDownListEthnicity.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaEthnicity, BaseControlDropDownListEthnicity.Text);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }

        if (BaseControlDropDownListGender.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaGender, BaseControlDropDownListGender.Text);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }

        if (BaseControlDropDownListEnrollmentStatus.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaEnrollmentStatus, BaseControlDropDownListEnrollmentStatus.Text);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }

        if (UserControlDateRangeSeparation.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaSeparationDateFromDate, UserControlDateRangeSeparation.FromDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaSeparationDateToDate, UserControlDateRangeSeparation.ToDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }

        if (RadioButtonListDeathFlag.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaDeathFlag, RadioButtonListDeathFlag.SelectedValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }

        if (UserControlFacilityDropdownLists.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaClosestFacilityVisn, UserControlFacilityDropdownLists.VisnId);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaClosestFacilityMainFacility, UserControlFacilityDropdownLists.MainFacilityId);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaClosestFacilitySubFacility, UserControlFacilityDropdownLists.SubFacilityId);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }

        return result;
    }
    private string GetSearchCriteriaDescription()
    {
        string result = string.Empty;
        string criteria = string.Empty;

        if (BaseControlListBoxStatus.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaStatus, GetValuesFromListBox(BaseControlListBoxStatus));
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }
        if (BaseControlListBoxDutyStatus.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaDutyStatus, GetValuesFromListBox(BaseControlListBoxDutyStatus));
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }
        if (UserControlDateRangeFormStartDate.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaFormStartFromDate, UserControlDateRangeFormStartDate.FromDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaFormStartToDate, UserControlDateRangeFormStartDate.ToDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }
        if (UserControlDateRangeFormToDate.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaFormCompletionFromDate, UserControlDateRangeFormToDate.FromDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaFormCompletionToDate, UserControlDateRangeFormToDate.ToDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }
        if (UserControlCurrentStatusFromToDate.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaCurrentStatusFromDate, UserControlCurrentStatusFromToDate.FromDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaCurrentStatusToDate, UserControlCurrentStatusFromToDate.ToDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }
        if (RadioButtonListHealthConcerns.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaHealthConcerns, RadioButtonListHealthConcerns.SelectedValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }
        if (RadioButtonListEvaluation.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaEvaluation, RadioButtonListEvaluation.SelectedValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }
        if (RadioButtonListRequestToBeSeen.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaRequestToBeSeen, RadioButtonListRequestToBeSeen.SelectedValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }
        if (BaseControlDropDownListSubpopulationFlag.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaSubpopulationFlag, BaseControlDropDownListSubpopulationFlag.DescriptionText);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }
        if (UserControlAdminFlagFilter.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaAdminFlag, UserControlAdminFlagFilter.AdminFlagDescription);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaAdminFlagFromDate, UserControlAdminFlagFilter.AdminFlagEnteredDateFrom);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaAdminFlagToDate, UserControlAdminFlagFilter.AdminFlagEnteredDateTo);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }
        if (DropDownListQuestion.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaQuestion, DropDownListQuestion.SelectedValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaAnswer, GetValuesFromListBox(BaseControlListBoxAnswer));
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }
        if (UserControlReportLocationAssigned.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaAssignedLocationVisn, UserControlReportLocationAssigned.VISN);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaAssignedLocationMainFacility, UserControlReportLocationAssigned.MainFacilityDescription);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaAssignedLocationSubFacility, UserControlReportLocationAssigned.SubFacilityDescription);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
          
        }
        if (UserControlReportLocationEvaluation.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaEvaluationLocationVisn, UserControlReportLocationEvaluation.VISN);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaEvaluationLocationMainFacility, UserControlReportLocationEvaluation.MainFacilityDescription);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaEvaluationLocationSubFacility, UserControlReportLocationEvaluation.SubFacilityDescription);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";

        }
        if (BaseControlListBoxHealthFactor.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaHealthFactor, GetValuesFromListBox(BaseControlListBoxHealthFactor));
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }
        if (BaseControlDropDownListDeploymentCountryAll.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaDeploymentAll, BaseControlDropDownListDeploymentCountryAll.DescriptionText);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }
        if (BaseControlDropDownListDeploymentCountryExposure.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaDeploymentExposure, BaseControlDropDownListDeploymentCountryExposure.DescriptionText);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />"; 
        }

        if (Request.QueryString["reportType"].ToString() == "Aggregate")
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaLocationBy, RadioButtonListLocation.SelectedValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }

        if (RadioButtonListDeathFlag.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaDeathFlag, RadioButtonListDeathFlag.SelectedValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }

        if (BaseControlDropDownListRace.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaRace, BaseControlDropDownListRace.DescriptionText);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }

        if (BaseControlDropDownListGender.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaGender, BaseControlDropDownListGender.DescriptionText);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }

        if (BaseControlDropDownListSeparationType.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaSeparationType, BaseControlDropDownListSeparationType.DescriptionText);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }

        if (BaseControlDropDownListEthnicity.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaEthnicity, BaseControlDropDownListEthnicity.DescriptionText);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }

        if (BaseControlDropDownListEnrollmentStatus.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaEnrollmentStatus, BaseControlDropDownListEnrollmentStatus.DescriptionText);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }

        if (UserControlDateRangeSeparation.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaSeparationDateFromDate, UserControlDateRangeSeparation.FromDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaSeparationDateFromDate, UserControlDateRangeSeparation.ToDateValue);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "<br />";
        }

        if (UserControlFacilityDropdownLists.Visible)
        {
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaClosestFacilityVisn, UserControlFacilityDropdownLists.VISN);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaClosestFacilityMainFacility, UserControlFacilityDropdownLists.MainFacilityDescription);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
            criteria = Helpers.GetReportSearchCriteria(AHOBPRGlobal.ReportSearchCriteriaClosestFacilitySubFacility, UserControlFacilityDropdownLists.SubFacilityDescription);
            result = string.IsNullOrEmpty(criteria) ? result : result + criteria + "|";
        }

        return result;
    }

    private string GetReportName()
    {
        string reportName = string.Empty;

        if (PanelReportViewer.Visible && !string.IsNullOrEmpty(UserSession.LastServerReportNameAdhoc))
        {
            reportName = UserSession.LastServerReportNameAdhoc;
        }
        else
        {

            if (Request.QueryString["reportType"].ToString() == "Aggregate")
            {
                if (GridViewAdHocReport.Visible)
                {
                    if (DropDownListQuestion.Visible && DropDownListQuestion.SelectedIndex > 0)
                    {
                        reportName = _serverReportNameByLocationDrillDown;
                    }
                    else
                    {
                        reportName = _serverReportNameByLocationDrillDownNoQuestion;
                    }
                }
                else
                {
                    reportName = _serverReportNameByLocation;
                }
            }
            else
            {
                if (DropDownListQuestion.Visible && DropDownListQuestion.SelectedIndex > 0)
                {
                    reportName = _serverReportNameByIndividual;
                }
                else
                {
                    reportName = _serverReportNameByIndividualNoQuestion;
                }
            }
        }

        UserSession.LastServerReportNameAdhoc = reportName;

        return reportName;
    }

    private void SetReportPath()
    {
        _serverReportName = GetReportName();
        ReportViewerReport.ServerReport.ReportPath = _serverReportName;

        var config = RegistriesConfigurations.GetConfig();

        ReportViewerReport.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));

        if (ReportViewerReport.ServerReport.ReportPath.IndexOf(
                Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
        {
            ReportViewerReport.ServerReport.ReportPath =
                Helpers.GetConfigEntry("BaseReportPath") + ReportViewerReport.ServerReport.ReportPath;
        }
    }
    private void SetReportParameters()
    {
        _reportParameters.Clear();

        SetStatusParameter();
        SetDutyStatusParameter();
        SetQuestionParameter();
        SetAnswerParameter();
        SetHealthFactorParameter();
        if (Request.QueryString["reportType"].ToString() == "Aggregate")
        {
            SetDrillDownLocationParameter();
        }
        else
        {
            SetLocationParameter();
        }
        SetHealthConcernParameter();
        SetRequestSeenParameter();
        SetSubpopulationFlagParameter(); 
        SetAdminFlagParameter();
        SetDeploymentCountryAllParameter();
        SetDeploymentCountryExposureParameter();
        SetQuestionnaireStartDateParameter();
        SetQuestionnaireCompletionDateParameter();
        SetDeathFlagParameter();
        SetGenderParameter();
        SetRaceParameter();
        SetEthnicityParameter();
        SetSeparationTypeParameter();
        SetEnrollmentStatusParameter();
        SetSeparationFromDateParameter();
        SetSeparationToDateParameter();
        SetEvaluationParameter();
        SetCurrentStatusFromToDateParameter();
        SetClosestFacilityParameter();
        SetGroupByParameter();
        SetFilterParameter();
        SetDetailForParameter();
       

        ReportViewerReport.ServerReport.SetParameters(_reportParameters);
    }

    private void SetFilterParameter()
    {
        ReportParameter reportParameterFilters = new ReportParameter("Filters", FormatReportFilters(_serverReportParameters));
        _reportParameters.Add(reportParameterFilters);
    }

    private string FormatReportFilters(string filters)
    {
        string results = string.Empty;
        string line = string.Empty;
        int maxCharactersPerLine = 130;

        if (_serverReportName == _serverReportNameByLocation)
        {
            maxCharactersPerLine = 130;
        }
        else
        {
            maxCharactersPerLine = 200;
        }

        string[] filterArray = filters.Split('|');

        for (int i = 0; i < filterArray.Length; i++)
        {
            string newLine = string.IsNullOrEmpty(line) ? filterArray[i] : line + "                " + filterArray[i];
            if (newLine.Length > maxCharactersPerLine)
            {
                results = string.IsNullOrEmpty(results) ? line : results + "|" + line;
                line = filterArray[i];
            }
            else
            {
                line = string.IsNullOrEmpty(line) ? filterArray[i]: line + "                " + filterArray[i];
            }
       }
        results = string.IsNullOrEmpty(results) ? line : results + "|" + line;
        return results;
    }

    private void SetGroupByParameter()
    {
        string groupBy = string.Empty;
        if (RadioButtonListLocation.Visible && _serverReportName == _serverReportNameByLocation)
        {
            groupBy = RadioButtonListLocation.SelectedValue;
            ReportParameter reportParameterGroupBy =
               new ReportParameter("groupBy", groupBy);
            _reportParameters.Add(reportParameterGroupBy);
        }
    }

    private void SetStatusParameter()
    {
        string status = string.Empty;
        if (BaseControlListBoxStatus.Visible && !string.IsNullOrEmpty(BaseControlListBoxStatus.Text))
        {
            status = BaseControlListBoxStatus.Text;
            ReportParameter reportParameterStatus =
               new ReportParameter("status", status);
            _reportParameters.Add(reportParameterStatus);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters = "Status: " + GetValuesFromListBox(BaseControlListBoxStatus);
        }
    }

    private void SetDetailForParameter()
    {
        string detailsFor = string.Empty;
        if (_serverReportName == _serverReportNameByLocationDrillDown || _serverReportName == _serverReportNameByLocationDrillDownNoQuestion)
        {
            detailsFor = LabelReportCriteria.Text;
            ReportParameter reportParameter =
               new ReportParameter("DetailsFor", detailsFor);
            _reportParameters.Add(reportParameter);


            reportParameter = new ReportParameter("InstitutionId", HiddenFieldFacility.Value);
            _reportParameters.Add(reportParameter);

            reportParameter = new ReportParameter("VisnId", HiddenFieldVisn.Value);
            _reportParameters.Add(reportParameter);
        }
    }

    private void SetDutyStatusParameter()
    {
        string dutyStatus = string.Empty;
        if (BaseControlListBoxDutyStatus.Visible && !string.IsNullOrEmpty(BaseControlListBoxDutyStatus.Text))
        {
            dutyStatus = BaseControlListBoxDutyStatus.Text;
            ReportParameter reportParameterDutyStatus =
                new ReportParameter("dutyStatus", dutyStatus);
            _reportParameters.Add(reportParameterDutyStatus);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Duty Status: " + GetValuesFromListBox(BaseControlListBoxDutyStatus);
        }
    }

    private void SetClosestFacilityParameter()
    {
        string closestFacilityId = string.Empty;
        if (UserControlFacilityDropdownLists.Visible && !string.IsNullOrEmpty(UserControlFacilityDropdownLists.FacilityId))
        {
            //set facility description 
            string facilityDescription = string.Empty;
            if (!string.IsNullOrEmpty(UserControlFacilityDropdownLists.SubFacilityDescription))
            {
                facilityDescription = UserControlFacilityDropdownLists.SubFacilityDescription;
            }
            else if (!string.IsNullOrEmpty(UserControlFacilityDropdownLists.MainFacilityDescription))
            {
                facilityDescription = UserControlFacilityDropdownLists.MainFacilityDescription;
            }

            closestFacilityId = UserControlFacilityDropdownLists.FacilityId;
            ReportParameter reportParameterClosestFacility =
                new ReportParameter("closestFacilityId", closestFacilityId);
            _reportParameters.Add(reportParameterClosestFacility);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Closest Facility: " + facilityDescription;
        }
    }

    private void SetQuestionParameter()
    {
        string question = string.Empty;
        if (DropDownListQuestion.Visible && DropDownListQuestion.SelectedIndex > 0)
        {
            question = DropDownListQuestion.SelectedValue;
            ReportParameter reportParameter = new ReportParameter("questionNumber", question);
            _reportParameters.Add(reportParameter);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Question: " + DropDownListQuestion.Items.FindByValue(question).Text;
        }
    }

    private void SetAnswerParameter()
    {
        string answer = string.Empty;
        if (BaseControlListBoxAnswer.Visible && !string.IsNullOrEmpty(BaseControlListBoxAnswer.Text))
        {
            answer = BaseControlListBoxAnswer.Text;
            ReportParameter reportParameterAnswer =
               new ReportParameter("answer", answer);
            _reportParameters.Add(reportParameterAnswer);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Answer: " + GetValuesFromListBox(BaseControlListBoxAnswer);
        }
    }

    private void SetHealthFactorParameter()
    {
        string healthFactor = string.Empty;
        if (BaseControlListBoxHealthFactor.Visible && !string.IsNullOrEmpty(BaseControlListBoxHealthFactor.Text))
        {
            healthFactor = BaseControlListBoxHealthFactor.Text;
            ReportParameter reportParameter = new ReportParameter("healthFactor", healthFactor);
            _reportParameters.Add(reportParameter);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Health Factor: " + GetValuesFromListBox(BaseControlListBoxHealthFactor);
        }
    }

    private void SetLocationParameter()
    {
        string location = string.Empty;

        //if (Request.QueryString["reportType"].ToString() == "Aggregate")
        //{
        //    assignedLocationType = HiddenAssignedLocationType.Value;
        //    assignedLocationKey = HiddenAssignedLocationKey.Value;
        //}

        if (UserControlReportLocationAssigned.Visible && !string.IsNullOrEmpty(UserControlReportLocationAssigned.LocationType))
        {
            string assignedLocationType = UserControlReportLocationAssigned.LocationType;
            ReportParameter reportParameter = new ReportParameter("AssignedLocationType", assignedLocationType);
            _reportParameters.Add(reportParameter);

        }

        if (UserControlReportLocationAssigned.Visible && (!string.IsNullOrEmpty(UserControlReportLocationAssigned.FacilityId)
                                                    || !string.IsNullOrEmpty(UserControlReportLocationAssigned.VISN)))
        {
            if (!string.IsNullOrEmpty(UserControlReportLocationAssigned.FacilityId) && (UserControlReportLocationAssigned.FacilityId != "0"))
            {
                location = UserControlReportLocationAssigned.FacilityId;
                ReportParameter reportParameter = new ReportParameter("AssignedLocationKey", location);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
                _serverReportParameters += "Assigned Location: Facility - " + UserControlReportLocationAssigned.FacilityDescription;
            }
            else if (!string.IsNullOrEmpty(UserControlReportLocationAssigned.VISN) && (UserControlReportLocationAssigned.VISN != "0"))
            {

                location = UserControlReportLocationAssigned.VISN;
                ReportParameter reportParameter = new ReportParameter("AssignedLocationKey", location);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";

                if (UserControlReportLocationAssigned.VISN == "NLA")
                {
                    _serverReportParameters += "Location: VISN - No Location Assigned";
                }
                else
                {
                    _serverReportParameters += "Location: VISN - " + UserControlReportLocationAssigned.VISN;
                }
            }
            else
            {
                _serverReportParameters += "Assigned Location: Facility - All" ;
            }

        }

        if (UserControlReportLocationEvaluation.Visible && !string.IsNullOrEmpty(UserControlReportLocationEvaluation.LocationType))
        {
            string evaluationLocationType = UserControlReportLocationEvaluation.LocationType;
            ReportParameter reportParameter = new ReportParameter("EvaluatedLocationType", evaluationLocationType);
            _reportParameters.Add(reportParameter);

        }

        if (UserControlReportLocationEvaluation.Visible && (!string.IsNullOrEmpty(UserControlReportLocationEvaluation.FacilityId)
                                                    || !string.IsNullOrEmpty(UserControlReportLocationEvaluation.VISN)))
        {
            if (!string.IsNullOrEmpty(UserControlReportLocationEvaluation.FacilityId) && (UserControlReportLocationEvaluation.FacilityId != "0"))
            {
                location = UserControlReportLocationEvaluation.FacilityId;
                ReportParameter reportParameter = new ReportParameter("EvaluatedLocationKey", location);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
                _serverReportParameters += "     Evaluation Location: Facility - " + UserControlReportLocationEvaluation.FacilityDescription;
            }
            else if (!string.IsNullOrEmpty(UserControlReportLocationEvaluation.VISN) && (UserControlReportLocationEvaluation.VISN != "0"))
            {

                location = UserControlReportLocationEvaluation.VISN;
                ReportParameter reportParameter = new ReportParameter("EvaluatedLocationKey", location);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";

                if (UserControlReportLocationEvaluation.VISN == "NLA")
                {
                    _serverReportParameters += "     Location: VISN - No Location Evaluation";
                }
                else
                {
                    _serverReportParameters += "     Location: VISN - " + UserControlReportLocationEvaluation.VISN;
                }
            }
            else
            {
                _serverReportParameters += "     Evaluation Location: Facility - All";
            }
        }

    }

    private void SetDrillDownLocationParameter()
    {
        string assignedLocationType = HiddenAssignedLocationType.Value;
        string location = HiddenAssignedLocationKey.Value;
       

        if (!string.IsNullOrEmpty(HiddenAssignedLocationType.Value))
        {
            ReportParameter reportParameter = new ReportParameter("AssignedLocationType", assignedLocationType);
            _reportParameters.Add(reportParameter);

        }

        if (!string.IsNullOrEmpty(HiddenAssignedLocationKey.Value))
        {
            if ((RadioButtonListLocation.SelectedValue == "Facility") && (HiddenAssignedLocationKey.Value != "0"))
            {
                 ReportParameter reportParameter = new ReportParameter("AssignedLocationKey", location);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
                _serverReportParameters += "Assigned Location: Facility - " + UserControlReportLocationAssigned.FacilityDescription;
            }
            else if ((RadioButtonListLocation.SelectedValue == "VISN") && (HiddenAssignedLocationKey.Value != "0"))
            {

                 ReportParameter reportParameter = new ReportParameter("AssignedLocationKey", location);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";

                if (UserControlReportLocationAssigned.VISN == "NLA")
                {
                    _serverReportParameters += "Location: VISN - No Location Assigned";
                }
                else
                {
                    _serverReportParameters += "Location: VISN - " + UserControlReportLocationAssigned.VISN;
                }
            }
            else
            {
                _serverReportParameters += "Assigned Location: Facility - All";
            }

        }
       

    }

    private void SetHealthConcernParameter()
    {
        string healthConcern = string.Empty;
        if (RadioButtonListHealthConcerns.Visible)
        {
            healthConcern = RadioButtonListHealthConcerns.SelectedValue;
        }
        else
        {
            healthConcern = "All";
        }
        ReportParameter reportParameter = new ReportParameter("healthConcerns", healthConcern);
        _reportParameters.Add(reportParameter);

        if (RadioButtonListHealthConcerns.Visible)
        {
            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Health Concern? " + healthConcern;
        }
    }

    private void SetEvaluationParameter()
    {
        string evaluation = string.Empty;
        if (RadioButtonListEvaluation.Visible)
        {
            evaluation = RadioButtonListEvaluation.SelectedValue;
        }
        else
        {
            evaluation = "All";
        }
        ReportParameter reportParameter = new ReportParameter("evaluation", evaluation);
        _reportParameters.Add(reportParameter);

        if (RadioButtonListEvaluation.Visible)
        {
            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Evaluation? " + evaluation;
        }
    }

    private void SetRequestSeenParameter()
    {
        string requestSeen = string.Empty;
        if (RadioButtonListRequestToBeSeen.Visible)
        {
            requestSeen = RadioButtonListRequestToBeSeen.SelectedValue;
        }
        else
        {
            requestSeen = "All";
        }
        ReportParameter reportParameter = new ReportParameter("requestToBeSeen", requestSeen);
        _reportParameters.Add(reportParameter);

        if (RadioButtonListRequestToBeSeen.Visible)
        {
            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Request to be Seen? " + requestSeen;
        }
    }

    private void SetSubpopulationFlagParameter()
    {
        string subpopulationFlag = string.Empty;
        if (BaseControlDropDownListSubpopulationFlag.Visible && !string.IsNullOrEmpty(BaseControlDropDownListSubpopulationFlag.Text))
        {
            subpopulationFlag = BaseControlDropDownListSubpopulationFlag.Text;
            ReportParameter reportParameter = new ReportParameter("subpopulationFlag", subpopulationFlag);
            _reportParameters.Add(reportParameter);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Subpopulation Flag: " + BaseControlDropDownListSubpopulationFlag.DescriptionText;
        }
    }

    private void SetAdminFlagParameter()
    {
        string adminFlag = string.Empty;
        if (UserControlAdminFlagFilter.Visible && !string.IsNullOrEmpty(UserControlAdminFlagFilter.AdminFlagId))
        {
            adminFlag = UserControlAdminFlagFilter.AdminFlagId;
            ReportParameter reportParameter = new ReportParameter("adminFlag", adminFlag);
            _reportParameters.Add(reportParameter);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Admin Flag: " + UserControlAdminFlagFilter.AdminFlagDescription;

            if (!string.IsNullOrEmpty(UserControlAdminFlagFilter.AdminFlagEnteredDateFrom))
            {
                string adminFlagFromDate = UserControlAdminFlagFilter.AdminFlagEnteredDateFrom;
                reportParameter = new ReportParameter("adminFlagFromDateText", adminFlagFromDate);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
                _serverReportParameters += "Admin Flag Entered Date From: " + UserControlAdminFlagFilter.AdminFlagEnteredDateFrom;
            }

            if (!string.IsNullOrEmpty(UserControlAdminFlagFilter.AdminFlagEnteredDateTo))
            {
                string adminFlagToDate = UserControlAdminFlagFilter.AdminFlagEnteredDateTo;
                reportParameter = new ReportParameter("adminFlagToDateText", adminFlagToDate);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
                _serverReportParameters += "Admin Flag Entered Date To: " + UserControlAdminFlagFilter.AdminFlagEnteredDateTo;
            }
        }
 
    }

    private void SetDeploymentCountryAllParameter()
    {
        string deploymentCountryAllFlag = string.Empty;
        if (BaseControlDropDownListDeploymentCountryAll.Visible && !string.IsNullOrEmpty(BaseControlDropDownListDeploymentCountryAll.Text))
        {
            deploymentCountryAllFlag = BaseControlDropDownListDeploymentCountryAll.Text;
            ReportParameter reportParameter = new ReportParameter("deploymentAll", deploymentCountryAllFlag);
            _reportParameters.Add(reportParameter);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Deployment County (All Deployments): " + BaseControlDropDownListDeploymentCountryAll.DescriptionText;
        }
    }

    private void SetDeploymentCountryExposureParameter()
    {
        string deploymentCountryExposureFlag = string.Empty;
        if (BaseControlDropDownListDeploymentCountryExposure.Visible && !string.IsNullOrEmpty(BaseControlDropDownListDeploymentCountryExposure.Text))
        {
            deploymentCountryExposureFlag = BaseControlDropDownListDeploymentCountryExposure.Text;
            ReportParameter reportParameter = new ReportParameter("deploymentExposure", deploymentCountryExposureFlag);
            _reportParameters.Add(reportParameter);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Deployment County (Deployments with Exposure Responses): " + BaseControlDropDownListDeploymentCountryExposure.DescriptionText;
        }
    }

    private void SetQuestionnaireStartDateParameter()
    {
        string date = string.Empty;
        if (UserControlDateRangeFormStartDate.Visible)
        {
            if (!string.IsNullOrEmpty(UserControlDateRangeFormStartDate.FromDateValue))
            {
                date = UserControlDateRangeFormStartDate.FromDateValue;
                ReportParameter reportParameter = new ReportParameter("formStartFromDateText", date);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
                _serverReportParameters += "Questionnaire Start Date From: " + date;
            }

            if (!string.IsNullOrEmpty(UserControlDateRangeFormStartDate.ToDateValue))
            {
                date = UserControlDateRangeFormStartDate.ToDateValue;
                ReportParameter reportParameter = new ReportParameter("formStartToDateText", date);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
                _serverReportParameters += "Questionnaire Start Date To: " + date;
            }
        }
    }

    private void SetQuestionnaireCompletionDateParameter()
    {
        string date = string.Empty;
        if (UserControlDateRangeFormToDate.Visible)
        {
            if (!string.IsNullOrEmpty(UserControlDateRangeFormToDate.FromDateValue))
            {
                date = UserControlDateRangeFormToDate.FromDateValue;
                ReportParameter reportParameter = new ReportParameter("formCompletionFromDateText", date);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
                _serverReportParameters += "Questionnaire Completion Date From: " + date;
            }

            if (!string.IsNullOrEmpty(UserControlDateRangeFormToDate.ToDateValue))
            {
                date = UserControlDateRangeFormToDate.ToDateValue;
                ReportParameter reportParameter = new ReportParameter("formCompletionToDateText", date);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
                _serverReportParameters += "Questionnaire Completion Date To: " + date;
            }
        }
    }

    private void SetCurrentStatusFromToDateParameter()
    {
        string date = string.Empty;
        if (UserControlCurrentStatusFromToDate.Visible)
        {
            if (!string.IsNullOrEmpty(UserControlCurrentStatusFromToDate.FromDateValue))
            {
                date = UserControlCurrentStatusFromToDate.FromDateValue;
                ReportParameter reportParameter = new ReportParameter("StatusFromDateText", date);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
                _serverReportParameters += "Registrant Current Status Date From: " + date;
            }

            if (!string.IsNullOrEmpty(UserControlCurrentStatusFromToDate.ToDateValue))
            {
                date = UserControlCurrentStatusFromToDate.ToDateValue;
                ReportParameter reportParameter = new ReportParameter("StatusToDateText", date);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
                _serverReportParameters += "Registrant Current Status Date To: " + date;
            }
        }
    }

    private void SetDeathFlagParameter()
    {
        string deathFlag = string.Empty;
        if (RadioButtonListDeathFlag.Visible)
        {
            deathFlag = RadioButtonListDeathFlag.SelectedValue;
        }
        else
        {
            deathFlag = "N";
        }
        ReportParameter reportParameter = new ReportParameter("excludeDead", deathFlag);
        _reportParameters.Add(reportParameter);

        if (RadioButtonListDeathFlag.Visible)
        {
            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            string deathFlagDisplayValue;
            if (deathFlag == "N")
            {
                deathFlagDisplayValue = "All";
            }
            else
            {
                deathFlagDisplayValue = "Exclude All Registrants with Death Flag";
            }
            _serverReportParameters += "Death Flag: " + deathFlagDisplayValue;
        }
    }

    private void SetGenderParameter()
    {
        string gender = string.Empty;
        if (BaseControlDropDownListGender.Visible && !string.IsNullOrEmpty(BaseControlDropDownListGender.Text))
        {
            gender = BaseControlDropDownListGender.Text;
            ReportParameter reportParameter = new ReportParameter("gender", gender);
            _reportParameters.Add(reportParameter);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Gender: " + BaseControlDropDownListGender.DescriptionText;
        }
    }

    private void SetRaceParameter()
    {
        string race = string.Empty;
        if (BaseControlDropDownListRace.Visible && !string.IsNullOrEmpty(BaseControlDropDownListRace.Text))
        {
            race = BaseControlDropDownListRace.Text;
            ReportParameter reportParameter = new ReportParameter("race", race);
            _reportParameters.Add(reportParameter);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Race: " + BaseControlDropDownListRace.DescriptionText;
        }
    }

    private void SetEthnicityParameter()
    {
        string ethnicity = string.Empty;
        if (BaseControlDropDownListEthnicity.Visible && !string.IsNullOrEmpty(BaseControlDropDownListEthnicity.Text))
        {
            ethnicity = BaseControlDropDownListEthnicity.Text;
            ReportParameter reportParameter = new ReportParameter("ethnicity", ethnicity);
            _reportParameters.Add(reportParameter);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Ethnicity: " + BaseControlDropDownListEthnicity.DescriptionText;
        }
    }

    private void SetSeparationTypeParameter()
    {
        string separationType = string.Empty;
        if (BaseControlDropDownListSeparationType.Visible && !string.IsNullOrEmpty(BaseControlDropDownListSeparationType.Text))
        {
            separationType = BaseControlDropDownListSeparationType.Text;
            ReportParameter reportParameter = new ReportParameter("separationType", separationType);
            _reportParameters.Add(reportParameter);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Separation Type: " + BaseControlDropDownListSeparationType.DescriptionText;
        }
    }

    private void SetEnrollmentStatusParameter()
    {
        string enrollmentStatus = string.Empty;
        if (BaseControlDropDownListEnrollmentStatus.Visible && !string.IsNullOrEmpty(BaseControlDropDownListEnrollmentStatus.Text))
        {
            enrollmentStatus = BaseControlDropDownListEnrollmentStatus.Text;
            ReportParameter reportParameter = new ReportParameter("enrollmentStatus", enrollmentStatus);
            _reportParameters.Add(reportParameter);

            _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            _serverReportParameters += "Enrollment Status: " + BaseControlDropDownListEnrollmentStatus.DescriptionText;
        }
    }

    private void SetSeparationFromDateParameter()
    {
        string date = string.Empty;
        if (UserControlDateRangeSeparation.Visible)
        {
            if (!string.IsNullOrEmpty(UserControlDateRangeSeparation.FromDateValue))
            {
                date = UserControlDateRangeSeparation.FromDateValue;
                ReportParameter reportParameter = new ReportParameter("separationFromDateText", date);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
                _serverReportParameters += "Separation Start Date From: " + date;
            }

            //if (!string.IsNullOrEmpty(UserControlDateRangeSeparation.ToDateValue))
            //{
            //    date = UserControlDateRangeSeparation.ToDateValue;
            //    ReportParameter reportParameter = new ReportParameter("formStartToDateText", date);
            //    _reportParameters.Add(reportParameter);

            //    _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            //    _serverReportParameters += "Questionnaire Start Date To: " + date;
            //}
        }
    }

    private void SetSeparationToDateParameter()
    {
        string date = string.Empty;
        if (UserControlDateRangeSeparation.Visible)
        {
            if (!string.IsNullOrEmpty(UserControlDateRangeSeparation.ToDateValue))
            {
                date = UserControlDateRangeSeparation.ToDateValue;
                ReportParameter reportParameter = new ReportParameter("separationToDateText", date);
                _reportParameters.Add(reportParameter);

                _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
                _serverReportParameters += "Separation Completion Date To: " + date;
            }

            //if (!string.IsNullOrEmpty(UserControlDateRangeSeparation.ToDateValue))
            //{
            //    date = UserControlDateRangeSeparation.ToDateValue;
            //    ReportParameter reportParameter = new ReportParameter("formStartToDateText", date);
            //    _reportParameters.Add(reportParameter);

            //    _serverReportParameters = string.IsNullOrEmpty(_serverReportParameters) ? _serverReportParameters : _serverReportParameters + "|";
            //    _serverReportParameters += "Questionnaire Start Date To: " + date;
            //}
        }
    }

    private void LoadBaseControls()
    {
        if (DropDownListQuestion.SelectedIndex > 0)
        {
            selectedQuestion = DropDownListQuestion.SelectedValue;
        }

        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_REPORT_ADHOC"))
        {
            Control userControl = PanelParameterAdHocReport.FindControl(dbItem.USER_CONTROL_ID);
            if ((userControl != null) && (dbItem.USER_CONTROL_ID == "BaseControlListBoxAnswer") && (selectedQuestion != null))
            {
                switch (dbItem.BASE_CONTROL_TYPE)
                {
                    case (int)AhobprBaseControlType.ListBox:
                        controls_BaseControlListBox baseControl = (controls_BaseControlListBox)userControl;
                        baseControl.LoadControlsFromObject(dbItem.LOOKUP_LIST_CATEGORY, string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                            dbItem.INCLUDE_LABEL, dbItem.DATA_ELEMENT_WIDTH, dbItem.VALIDATION_GROUP, dbItem.REQUIRED, selectedQuestion);
                        break;

                }
            }
            else if (userControl != null)
            {
                switch (dbItem.BASE_CONTROL_TYPE)
                {
                    case (int)AhobprBaseControlType.ListBox:
                        controls_BaseControlListBox baseControl = (controls_BaseControlListBox)userControl;
                        baseControl.LoadControlsFromObject(dbItem.LOOKUP_LIST_CATEGORY, string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                            dbItem.INCLUDE_LABEL, dbItem.DATA_ELEMENT_WIDTH, dbItem.VALIDATION_GROUP, dbItem.REQUIRED);
                        break;
                    case (int)AhobprBaseControlType.DropDownList:
                        controls_BaseControlDropDownList baseControlDropdown = (controls_BaseControlDropDownList)userControl;

                        baseControlDropdown.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY,
                                                                   dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.REQUIRED);
                        break;
                    case (int)AhobprBaseControlType.RadioButtonList:
                        controls_BaseControlRadioButtonList baseControlRadioButtonList = (controls_BaseControlRadioButtonList)userControl;

                        baseControlRadioButtonList.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY);
                        break;
                    case (int)AhobprBaseControlType.TextBox:
                        controls_BaseControlTextBox baseControlTextBox = (controls_BaseControlTextBox)userControl;

                        baseControlTextBox.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH,
                            dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.VALIDATION_REGULAR_EXPRESSION, dbItem.REQUIRED);
                        break;

                }
            }
        }
    }

    private List<STD_GUI_CONTROL_AHOBPR> GetGuiControls(string controlCategory)
    {
        if (UserSession.GuiControlsReportAdhoc == null)
        {
            _dbControls = _baseControlManager.SelectGuiControlList(controlCategory).ToList<STD_GUI_CONTROL_AHOBPR>();
            UserSession.GuiControlsReportAdhoc = _dbControls;
        }
        else
        {
            _dbControls = UserSession.GuiControlsReportAdhoc;
        }

        return _dbControls;
    }


    protected void ButtonRunReport_Click(object sender, EventArgs e)
    {
        RunReport();
    }

    private void RunReport()
    {
        if (ValidateCustomValidatorStep2())
        {
            ShowReportViewer(false);
            ShowSelectParameterPanel(false);
            ShowAdHocReport(true, false);
        }
    }
    

    private bool ValidateCustomValidatorStep2()
    {
        bool result = true;

        CustomValidatorStep2.IsValid = true;

        // Validate that at least one value was entered    
        if ((string.IsNullOrEmpty(UserControlReportLocationAssigned.FacilityId) || UserControlReportLocationAssigned.FacilityId == "0") && string.IsNullOrEmpty(UserControlReportLocationAssigned.VISN)
                && (string.IsNullOrEmpty(UserControlReportLocationEvaluation.FacilityId) || UserControlReportLocationEvaluation.FacilityId == "0") && string.IsNullOrEmpty(UserControlReportLocationEvaluation.VISN)
                && string.IsNullOrEmpty(UserControlFacilityDropdownLists.FacilityId)
                && string.IsNullOrEmpty(DropDownListQuestion.SelectedValue)
                && string.IsNullOrEmpty(UserControlDateRangeFormStartDate.FromDateValue)
                && string.IsNullOrEmpty(UserControlDateRangeFormStartDate.ToDateValue)
                && string.IsNullOrEmpty(UserControlDateRangeFormToDate.FromDateValue)
                && string.IsNullOrEmpty(UserControlDateRangeFormToDate.ToDateValue)
                && string.IsNullOrEmpty(BaseControlDropDownListSubpopulationFlag.Text)
                && string.IsNullOrEmpty(UserControlAdminFlagFilter.AdminFlagId)
                && RadioButtonListHealthConcerns.SelectedIndex == 0
                && RadioButtonListEvaluation.SelectedIndex == 0
                && RadioButtonListRequestToBeSeen.SelectedIndex == 0
                && string.IsNullOrEmpty(BaseControlListBoxStatus.Text)
                && string.IsNullOrEmpty(BaseControlListBoxDutyStatus.Text)
                && string.IsNullOrEmpty(BaseControlListBoxHealthFactor.Text)
                && string.IsNullOrEmpty(BaseControlDropDownListDeploymentCountryAll.Text)
                && string.IsNullOrEmpty(BaseControlDropDownListDeploymentCountryExposure.Text)
                && string.IsNullOrEmpty(BaseControlDropDownListRace.Text)
                && string.IsNullOrEmpty(BaseControlDropDownListGender.Text)
                && string.IsNullOrEmpty(BaseControlDropDownListEthnicity.Text)
                && string.IsNullOrEmpty(UserControlDateRangeSeparation.ToDateValue)
                && string.IsNullOrEmpty(UserControlDateRangeSeparation.FromDateValue)
                && RadioButtonListDeathFlag.SelectedIndex == 0
                && string.IsNullOrEmpty(BaseControlDropDownListEnrollmentStatus.Text)
                && string.IsNullOrEmpty(BaseControlDropDownListSeparationType.Text)
                && string.IsNullOrEmpty(UserControlCurrentStatusFromToDate.FromDateValue)
                && string.IsNullOrEmpty(UserControlCurrentStatusFromToDate.ToDateValue)

            )
        {
            CustomValidatorStep2.IsValid = false;
            result = false;
            ShowAdHocReport(false, false);
            ShowReportViewer(false);
        }
        else
        {
            if (CheckBoxAdminFlag.Checked)
            {
                if (UserControlAdminFlagFilter.ValidateCustomValidator() == false)
                {
                    result = false;
                }
            }
            if (UserControlDateRangeFormStartDate.Visible)
            {
                if (UserControlDateRangeFormStartDate.ValidateCustomValidator() == false)
                {
                    result = false;
                }
            }
            if (UserControlDateRangeFormToDate.Visible)
            {
                if (UserControlDateRangeFormToDate.ValidateCustomValidator() == false)
                {
                    result = false;
                }
            }
            if (UserControlCurrentStatusFromToDate.Visible)
            {
                if (UserControlCurrentStatusFromToDate.ValidateCustomValidator() == false)
                {
                    result = false;
                }
            }
            if (BaseControlListBoxAnswer.Visible)
            {
                if (string.IsNullOrEmpty(BaseControlListBoxAnswer.Text))
                {
                    CustomValidatorStep2.ErrorMessage = "Please select at least one answer.";
                    CustomValidatorStep2.IsValid = false;
                    result = false;
                }
            }


            if (result == false)
            {
                ShowAdHocReport(false, false);
                ShowReportViewer(false);
            }

        }
        return result;
    }

    private void ShowSelectParameterPanel(bool show)
    {

        PanelSelectParameters.Visible = show;
        PanelParameterAdHocReport.Visible = !show;
        gridViewPageSizeDdl.Visible = false;
        LabelItemsPerPage.Visible = false;
        if (show)
        {
            ShowAdHocReport(false, false);
            ShowReportViewer(false);
        }
        else
        {
            ReportParametersIntialLoad();
        }
       
    }
    private void ShowAdHocReport(bool show, bool drillDown)
    {
        if (drillDown)
        {
            ShowAdHocReportByIndividual(true, true);
            ShowAdhocReportByLocation(false);
        }
        else if (show)
        //if (show)
        {
            if (Request.QueryString["reportType"].ToString() == "Aggregate")
            {
                ShowAdhocReportByLocation(true);
                ShowAdHocReportByIndividual(false, false);
            }
            else
            {
                ShowAdHocReportByIndividual(true, false);
                ShowAdhocReportByLocation(false);
            }
        }
        else
        {
            ShowAdHocReportByIndividual(false, false);
            ShowAdhocReportByLocation(false);
        }

        //if (drillDown)
        //{
        //    ShowAdHocReportByIndividual(true, true);
        //    ShowAdhocReportByLocation(false);
        //}
    }

    private void ShowAdhocReportByLocation(bool show)
    {
        if (show)
        {
            ShowReportViewer(false);
            GridViewAdHocByLocation.DataBind();
            gridViewPageSizeDdlbyLoc.Visible = true;
            LabelItemsPerPagebyLoc.Visible = true;
            gridViewPageSizeDdl.Visible = false;
            LabelItemsPerPage.Visible = false;
        }
        PanelAdHocReportByLocation.Visible = show;
    }

    private void ShowAdHocReportByIndividual(bool show, bool drillDown)
    {
        if (show)
        {
            ShowReportViewer(false);
            gridViewPageSizeDdlbyLoc.Visible = false;
            LabelItemsPerPagebyLoc.Visible = false;
            gridViewPageSizeDdl.Visible = true;
            LabelItemsPerPage.Visible = true;
            //if a question was not selected from the report parameters hide the answer column on the gridview
            if (CheckBoxQuestion.Checked == false)
            {
                GridViewAdHocReport.Columns[7].Visible = false;
            }
            else
            {
                GridViewAdHocReport.Columns[7].Visible = true;
            }
            if (drillDown)
            {
                GridViewAdHocReport.DataSourceID = "DataSourceAdhocByLocationDrillDown";
            }
            else
            {
                GridViewAdHocReport.DataSourceID = "DataSourceAdHoc";
            }

            string assignedLocationType = string.Empty;
            string assignedLocationKey = string.Empty;

            //the drilldown and Adhoc individual reports use different parameters for the assignedLocationType and assignedLocationKey 
            if (drillDown)
            {
                assignedLocationType = HiddenAssignedLocationType.Value;
                assignedLocationKey = HiddenAssignedLocationKey.Value;
            }
            else
            {
               assignedLocationType = UserControlReportLocationAssigned.LocationType;
               assignedLocationKey =  UserControlReportLocationAssigned.LocationKey;
            }

            //set zero default value for separation type if null 
            int separationTypeValue = (string.IsNullOrEmpty(BaseControlDropDownListSeparationType.Text) ? 0 : Convert.ToInt32(BaseControlDropDownListSeparationType.Text));

            //If Health Concerns blank set to "All"
            if (String.IsNullOrEmpty(RadioButtonListHealthConcerns.Text))
            {
                RadioButtonListHealthConcerns.Text = "All";
            }
            //set blank values to null to avoid error on count
            if (String.IsNullOrEmpty(RadioButtonListEvaluation.Text))
            {
                RadioButtonListEvaluation.Text = "All";
            }
            string status = BaseControlListBoxStatus.Text == "" ? null : BaseControlListBoxStatus.Text;
            string dutyStatus = BaseControlListBoxDutyStatus.Text == "" ? null : BaseControlListBoxDutyStatus.Text;
            string dateRangeFormStartDate_FromDateValue = UserControlDateRangeFormStartDate.FromDateValue == "" ? null : UserControlDateRangeFormStartDate.FromDateValue;
            string dateRangeFormStartDate_ToDateValue = UserControlDateRangeFormStartDate.ToDateValue == "" ? null : UserControlDateRangeFormStartDate.ToDateValue;
            string healthFactor = BaseControlListBoxHealthFactor.Text == "" ? null : BaseControlListBoxHealthFactor.Text;
            string dateRangeFormToDate_FromDateValue = UserControlDateRangeFormToDate.FromDateValue == "" ? null : UserControlDateRangeFormToDate.FromDateValue;
            string dateRangeFormToDate_ToDateValue = UserControlDateRangeFormToDate.ToDateValue == "" ? null : UserControlDateRangeFormToDate.ToDateValue;
            string hiddenFieldQuestion = HiddenFieldQuestion.Value == "" ? null : HiddenFieldQuestion.Value;
            string answer = BaseControlListBoxAnswer.Text == "" ? null : BaseControlListBoxAnswer.Text;
            string subpopulationFlag = BaseControlDropDownListSubpopulationFlag.Text == "" ? null : BaseControlDropDownListSubpopulationFlag.Text;
            string adminFlagId = UserControlAdminFlagFilter.AdminFlagId == "" ? null : UserControlAdminFlagFilter.AdminFlagId;
            string deploymentCountryAll = BaseControlDropDownListDeploymentCountryAll.Text == "" ? null : BaseControlDropDownListDeploymentCountryAll.Text;
            string deploymentCountryExposure = BaseControlDropDownListDeploymentCountryExposure.Text == "" ? null : BaseControlDropDownListDeploymentCountryExposure.Text;
            string adminFlagFilter_AdminFlagEnteredDateFrom = UserControlAdminFlagFilter.AdminFlagEnteredDateFrom == "" ? null : UserControlAdminFlagFilter.AdminFlagEnteredDateFrom;
            string adminFlagFilter_AdminFlagEnteredDateTo = UserControlAdminFlagFilter.AdminFlagEnteredDateTo == "" ? null : UserControlAdminFlagFilter.AdminFlagEnteredDateTo;
            string gender = BaseControlDropDownListGender.Text == "" ? null : BaseControlDropDownListGender.Text;
            string race = BaseControlDropDownListRace.Text == "" ? null : BaseControlDropDownListRace.Text;
            string ethnicity = BaseControlDropDownListEthnicity.Text == "" ? null : BaseControlDropDownListEthnicity.Text;
            string dateRangeSeparation_FromDateValue = UserControlDateRangeSeparation.FromDateValue == "" ? null : UserControlDateRangeSeparation.FromDateValue;
            string dateRangeSeparation_ToDateValue = UserControlDateRangeSeparation.ToDateValue == "" ? null : UserControlDateRangeSeparation.ToDateValue;
            string enrollmentStatus = BaseControlDropDownListEnrollmentStatus.Text == "" ? null : BaseControlDropDownListEnrollmentStatus.Text;
            string dateRangeCurrentStatus_FromDateValue = UserControlCurrentStatusFromToDate.FromDateValue == "" ? null : UserControlCurrentStatusFromToDate.FromDateValue;
            string dateRangeCurrentStatus_ToDateValue = UserControlCurrentStatusFromToDate.ToDateValue == "" ? null : UserControlCurrentStatusFromToDate.ToDateValue;


            GridViewAdHocReport.DataBind();
            int total = _reportManager.GetAdHocByIndividualCount(status,
                dutyStatus,
                dateRangeFormStartDate_FromDateValue,
                dateRangeFormStartDate_ToDateValue,
                healthFactor,
                dateRangeFormToDate_FromDateValue,
                dateRangeFormToDate_ToDateValue,
                hiddenFieldQuestion,
                answer,
                RadioButtonListHealthConcerns.Text,
                RadioButtonListRequestToBeSeen.Text,
                assignedLocationType,
                assignedLocationKey,
                UserControlReportLocationEvaluation.LocationType,
                UserControlReportLocationEvaluation.LocationKey,
                subpopulationFlag,
                adminFlagId,
                deploymentCountryAll,
                deploymentCountryExposure,
                adminFlagFilter_AdminFlagEnteredDateFrom,
                adminFlagFilter_AdminFlagEnteredDateTo,
                RadioButtonListDeathFlag.Text,
                gender,
                race,
                ethnicity,
                separationTypeValue,
                dateRangeSeparation_FromDateValue,
                dateRangeSeparation_ToDateValue,
                enrollmentStatus,
                RadioButtonListEvaluation.Text,
                dateRangeCurrentStatus_FromDateValue,
                dateRangeCurrentStatus_ToDateValue,
                UserControlFacilityDropdownLists.FacilityId);
            LabelNumberOfResultsFound.Text = "Total Number of Results Found: " + total.ToString();

        }
        PanelAdHocReport.Visible = show;

        if (drillDown)
        {
            ButtonBackToSummary.Visible = true;
            LabelReportCriteria.Visible = true;
        }
        else
        {
            ButtonBackToSummary.Visible = false;
            LabelReportCriteria.Visible = false;
        }
    }

    private void ShowReportViewer(bool show)
    {
        PanelReportViewer.Visible = show;
        if (show)
        {
            ShowAdHocReport(false, false);
            ShowSelectParameterPanel(false);
        }
    }

    private void AddAttributes()
    {
        if (DropDownListQuestion.Attributes["onchange"] == null)
        {
            DropDownListQuestion.Attributes.Add("onchange",
                "SetBaseControlTextValue(this, '" + HiddenFieldQuestion.ClientID + "')");
        }
    }


    #region Ad Hoc Report


    protected void GridViewAdHocReport_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewAdHocReport.SelectedIndex = index;
            UserSession.RegistrantId = GridViewAdHocReport.SelectedIndex;
            Response.Redirect("QuestionnaireSummary.aspx?id=" + GridViewAdHocReport.SelectedIndex);
        }
    }

    protected void GridViewAdHocByLocation_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            string locationId = string.Empty;
            GridViewRow row = (GridViewRow)(((LinkButton)e.CommandSource).NamingContainer);

            // Location Title
            Label labelLocation = (Label)row.Cells[0].FindControl("LabelLocation");
            if (labelLocation != null)
            {
                LabelReportCriteria.Visible = true;

                if (RadioButtonListLocation.SelectedValue == "VISN")
                {
                    LabelReportCriteria.Text = "VISN - " + labelLocation.Text;
                    LabelBreadCrumb.Text = "<H1>Reporting > Ad Hoc Report by Location > VISN - " + labelLocation.Text + "</H1>";
                }
                else
                {
                    LabelReportCriteria.Text = "Facility - " + labelLocation.Text;
                    LabelBreadCrumb.Text = "<H1>Reporting > Ad Hoc Report by Location > Facility - " + labelLocation.Text + "</H1>";
                }
            }

            // Location Id for drill down report
            Label labelLocationId = (Label)row.Cells[0].FindControl("LabelLocationId");
            if (labelLocationId != null)
            {
                locationId = labelLocationId.Text;
            }

            if (locationId == "-1")
            {
                HiddenFieldFacility.Value = "-1";
                HiddenFieldVisn.Value = string.Empty;
                HiddenAssignedLocationType.Value = "NLA";  //no location assigned
                HiddenAssignedLocationKey.Value = string.Empty;
            }
            else
            {
                if (RadioButtonListLocation.SelectedValue == "VISN")
                {
                    HiddenFieldFacility.Value = "0";
                    HiddenFieldVisn.Value = locationId;
                    HiddenAssignedLocationType.Value = "VISN";
                    HiddenAssignedLocationKey.Value = locationId;
                }
                else
                {
                    HiddenFieldFacility.Value = locationId;
                    HiddenFieldVisn.Value = string.Empty;
                    HiddenAssignedLocationType.Value = "Institution";
                    HiddenAssignedLocationKey.Value = locationId;
                }
            }
            ShowReportViewer(false);
            ShowSelectParameterPanel(false);
            ShowAdHocReport(true, true);
        }
    }

    private void ReportParametersIntialLoad()
    {
        if (Request.QueryString["reportType"].ToString() == "Aggregate")
        {
            PanelLocation.Visible = true;
            UserControlReportLocationAssigned.Visible = false;
            UserControlReportLocationEvaluation.Visible = false;
            PanelClosestFacility.Visible = false;
        }
        else
        {
            PanelLocation.Visible = false;
            UserControlReportLocationAssigned.Visible = CheckBoxLocation.Checked;
            UserControlReportLocationEvaluation.Visible = CheckBoxLocation.Checked;
            PanelClosestFacility.Visible = CheckBoxClosestFacility.Checked;
            if (PanelClosestFacility.Visible)
            {
                UserControlFacilityDropdownLists.LoadControlsFromObject();
            }
        }
        PanelQuestion.Visible = CheckBoxQuestion.Checked;
        if (PanelQuestion.Visible)
        {
            //Load Question dropdown list
            DropDownListQuestion.DataSource = _reportManager.GetQuestions();
            DropDownListQuestion.DataValueField = "Key";
            DropDownListQuestion.DataTextField = "Value";
            DropDownListQuestion.DataBind();
            AddAttributes();
            DropDownListQuestion.Items.Insert(0, new ListItem("-- Select One --", ""));
        }

        PanelQuestionnaireDate.Visible = (RadioButtonListStartEndDate.SelectedValue == "Questionnaire Start Date"
                                          || RadioButtonListStartEndDate.SelectedValue == "Questionnaire Completed Date");
        if (PanelQuestionnaireDate.Visible)
        {
            UserControlDateRangeFormStartDate.Visible = (RadioButtonListStartEndDate.SelectedValue == "Questionnaire Start Date");
            if (UserControlDateRangeFormStartDate.Visible)
            {
                UserControlDateRangeFormStartDate.LoadControlsFromObject("Questionnaire Start Date", false, "Questionnaire Start Date is when the first questionnaire response is saved.  This data will only be available for registrants in Eligible and Participant status.  The Selection Criteria allows the user to filter for a questionnaire start date within a date range.", "OnRunReport");
            }

            UserControlDateRangeFormToDate.Visible = (RadioButtonListStartEndDate.SelectedValue == "Questionnaire Completed Date");
            if (UserControlDateRangeFormToDate.Visible)
            {
                UserControlDateRangeFormToDate.LoadControlsFromObject("Questionnaire Completed Date", false, "Questionnaire Completed Date is the date the questionnaire is submitted.  This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter for a questionnaire completed date within a date range.", "OnRunReport");
            }
        }
        BaseControlDropDownListSubpopulationFlag.Visible = CheckBoxSubpopulationFlag.Checked;
        UserControlAdminFlagFilter.Visible = CheckBoxAdminFlag.Checked;
        PanelHealthConcerns.Visible = (CheckBoxHealthConcerns.Checked || CheckBoxRequestToBeSeen.Checked);
        if (PanelHealthConcerns.Visible)
        {
            PanelRadioButtonHealthConcerns.Visible = CheckBoxHealthConcerns.Checked;
            PanelRadioButtonRequestToBeSeen.Visible = CheckBoxRequestToBeSeen.Checked;
        }
        PanelStatus.Visible = (CheckBoxRegistrantStatus.Checked || CheckBoxDutyStatus.Checked);
        BaseControlListBoxStatus.Visible = CheckBoxRegistrantStatus.Checked;
        BaseControlListBoxDutyStatus.Visible = CheckBoxDutyStatus.Checked;
        PanelHealthFactorDeployment.Visible = (CheckBoxHealthFactor.Checked
                                                || RadioButtonListDeploymentCountry.SelectedValue != "None" || CheckBoxEvaluation.Checked);
        if (PanelHealthFactorDeployment.Visible)
        {
            BaseControlDropDownListDeploymentCountryAll.Visible = (RadioButtonListDeploymentCountry.SelectedValue == "All Deployments");
            BaseControlDropDownListDeploymentCountryExposure.Visible = (RadioButtonListDeploymentCountry.SelectedValue == "Deployments With Exposure Responses");
            BaseControlListBoxHealthFactor.Visible = CheckBoxHealthFactor.Checked;
            PanelRadioButtonEvaluation.Visible = CheckBoxEvaluation.Checked;
        }
               
        BaseControlDropDownListRace.Visible = CheckBoxRace.Checked;
        BaseControlDropDownListGender.Visible = CheckBoxGender.Checked;
        BaseControlDropDownListEthnicity.Visible = CheckBoxEthnicity.Checked;
        BaseControlDropDownListSeparationType.Visible = CheckBoxSeparationType.Checked;
        BaseControlDropDownListEnrollmentStatus.Visible = CheckBoxEnrollmentStatus.Checked;
        UserControlDateRangeSeparation.Visible = CheckBoxSeparationDate.Checked;
        PanelSeparation.Visible = CheckBoxSeparationDate.Checked;
        RadioButtonListDeathFlag.Visible = CheckBoxDeathFlag.Checked;
        PanelDeathFlag.Visible = CheckBoxDeathFlag.Checked;
        UserControlCurrentStatusFromToDate.Visible = CheckBoxDateRangeCurrentStatus.Checked;
    }

    private void ClearInvisibleSearchCriteria()
    {
        if (!UserControlReportLocationAssigned.Visible)
        {
            UserControlReportLocationAssigned.ResetLocation();
        }
        if (!UserControlReportLocationEvaluation.Visible)
        {
            UserControlReportLocationEvaluation.ResetLocation();
        }
        if (!UserControlFacilityDropdownLists.Visible)
        {
            UserControlFacilityDropdownLists.Reset();
        } 
        if (!DropDownListQuestion.Visible)
        {
            DropDownListQuestion.SelectedIndex = -1;
            BaseControlListBoxAnswer.Visible = false;
            HiddenFieldQuestion.Value = string.Empty;
        }
        if (!BaseControlListBoxAnswer.Visible)
        {
            BaseControlListBoxAnswer.Text = string.Empty;
        }
        if (!UserControlDateRangeFormStartDate.Visible)
        {
            UserControlDateRangeFormStartDate.FromDateValue = string.Empty;
            UserControlDateRangeFormStartDate.ToDateValue = string.Empty;
        }
        if (!UserControlDateRangeFormToDate.Visible)
        {
            UserControlDateRangeFormToDate.FromDateValue = string.Empty;
            UserControlDateRangeFormToDate.ToDateValue = string.Empty;
        }
        if (!UserControlCurrentStatusFromToDate.Visible)
        {
            UserControlCurrentStatusFromToDate.FromDateValue = string.Empty;
            UserControlCurrentStatusFromToDate.ToDateValue = string.Empty;
        }
        if (!BaseControlDropDownListSubpopulationFlag.Visible)
        {
            BaseControlDropDownListSubpopulationFlag.Text = string.Empty;
        }
        if (!UserControlAdminFlagFilter.Visible)
        {
            UserControlAdminFlagFilter.AdminFlagId = string.Empty;
            UserControlAdminFlagFilter.AdminFlagEnteredDateFrom = string.Empty;
            UserControlAdminFlagFilter.AdminFlagEnteredDateTo = string.Empty;
        }
        if (!RadioButtonListHealthConcerns.Visible)
        {
            RadioButtonListHealthConcerns.SelectedIndex = 0;
        }
        if (!RadioButtonListEvaluation.Visible)
        {
            RadioButtonListEvaluation.SelectedIndex = 0;
        }
        if (!RadioButtonListRequestToBeSeen.Visible)
        {
            RadioButtonListRequestToBeSeen.SelectedIndex = 0;
        }
        if (!BaseControlListBoxStatus.Visible)
        {
            BaseControlListBoxStatus.Text = string.Empty;
        }
        if (!BaseControlListBoxDutyStatus.Visible)
        {
            BaseControlListBoxDutyStatus.Text = string.Empty;
        }
        if (!BaseControlDropDownListDeploymentCountryAll.Visible)
        {
            BaseControlDropDownListDeploymentCountryAll.Text = string.Empty;
        }
        if (!BaseControlDropDownListDeploymentCountryExposure.Visible)
        {
            BaseControlDropDownListDeploymentCountryExposure.Text = string.Empty;
        }
        if (!BaseControlListBoxHealthFactor.Visible)
        {
            BaseControlListBoxHealthFactor.Text = string.Empty;
        }
        if (!RadioButtonListDeathFlag.Visible)
        {
            RadioButtonListDeathFlag.SelectedIndex = 0;
        }
        if (!BaseControlDropDownListGender.Visible)
        {
            BaseControlDropDownListGender.Text = string.Empty;
        }
        if (!BaseControlDropDownListRace.Visible)
        {
            BaseControlDropDownListRace.Text = string.Empty;
        }
        if (!BaseControlDropDownListEthnicity.Visible)
        {
            BaseControlDropDownListEthnicity.Text = string.Empty;
        }
        if (!BaseControlDropDownListSeparationType.Visible)
        {
            BaseControlDropDownListSeparationType.Text = string.Empty;
        }
        if (!UserControlDateRangeSeparation.Visible)
        {
            UserControlDateRangeSeparation.FromDateValue = string.Empty;
            UserControlDateRangeSeparation.ToDateValue = string.Empty;
        }
        if (!BaseControlDropDownListEnrollmentStatus.Visible)
        {
            BaseControlDropDownListEnrollmentStatus.Text = string.Empty;
        }
    }

 

    private void ClearSearchCriteria()
    {
        UserControlReportLocationAssigned.ResetLocation();
        UserControlReportLocationEvaluation.ResetLocation();
        UserControlFacilityDropdownLists.Reset();
        DropDownListQuestion.SelectedIndex = -1;
        BaseControlListBoxAnswer.Visible = false;
        UserControlDateRangeFormStartDate.FromDateValue = string.Empty;
        UserControlDateRangeFormStartDate.ToDateValue = string.Empty;
        UserControlDateRangeFormToDate.FromDateValue = string.Empty;
        UserControlDateRangeFormToDate.ToDateValue = string.Empty;
        HiddenFieldQuestion.Value = string.Empty;
        BaseControlDropDownListSubpopulationFlag.Text = string.Empty;
        UserControlAdminFlagFilter.AdminFlagId = string.Empty;
        UserControlAdminFlagFilter.AdminFlagEnteredDateFrom = string.Empty;
        UserControlAdminFlagFilter.AdminFlagEnteredDateTo = string.Empty;
        RadioButtonListHealthConcerns.SelectedIndex = 0;
        RadioButtonListRequestToBeSeen.SelectedIndex = 0;
        BaseControlListBoxStatus.Text = string.Empty;
        BaseControlListBoxDutyStatus.Text = string.Empty;
        BaseControlDropDownListDeploymentCountryAll.Text = string.Empty;
        BaseControlDropDownListDeploymentCountryExposure.Text = string.Empty;
        BaseControlListBoxHealthFactor.Text = string.Empty;
        RadioButtonListDeathFlag.SelectedIndex = 0;
        BaseControlDropDownListGender.Text = string.Empty;
        BaseControlDropDownListRace.Text = string.Empty;
        BaseControlDropDownListEthnicity.Text = string.Empty;
        BaseControlDropDownListSeparationType.Text = string.Empty;
        UserControlDateRangeSeparation.FromDateValue = string.Empty;
        UserControlDateRangeSeparation.ToDateValue = string.Empty;
        BaseControlDropDownListEnrollmentStatus.Text = string.Empty;
        RadioButtonListEvaluation.SelectedIndex = 0;
        UserControlCurrentStatusFromToDate.FromDateValue = string.Empty;
        UserControlCurrentStatusFromToDate.ToDateValue = string.Empty;
    }

    protected void QuestionDropDownList_SelectedIndexChanged(object sender, EventArgs e)
    {
        ShowAdHocReport(false, false);
        ShowReportViewer(false);

        ShowAnswerControl(false, DropDownListQuestion.SelectedValue);
    }

    private void ShowAnswerControl(bool prepopulate, string questionId)
    {
        if (DropDownListQuestion.SelectedIndex > 0 || prepopulate)
        {
            selectedQuestion = questionId;
            
            foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_REPORT_ADHOC"))
            {
                Control userControl = PanelParameterAdHocReport.FindControl(dbItem.USER_CONTROL_ID);
                if ((userControl != null) && (dbItem.USER_CONTROL_ID == "BaseControlListBoxAnswer"))
                {
                    switch (dbItem.BASE_CONTROL_TYPE)
                    {
                        case (int)AhobprBaseControlType.ListBox:
                            controls_BaseControlListBox baseControl = (controls_BaseControlListBox)userControl;
                            baseControl.LoadControlsFromObject(dbItem.LOOKUP_LIST_CATEGORY, string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                                dbItem.INCLUDE_LABEL, dbItem.DATA_ELEMENT_WIDTH, dbItem.VALIDATION_GROUP, dbItem.REQUIRED, selectedQuestion);
                            break;

                    }
                }
            }

            BaseControlListBoxAnswer.Visible = true;
        }
        else
        {            
            BaseControlListBoxAnswer.Visible = false;
        }

    }


    #endregion


    public override string TopMenuName()
    {
        return "Reporting";
    }

    public override string AppObjectCode()
    {
        return "AHOBPR REPORT Ad Hoc";
    }

    public override string MenuItemName()
    {
        return "AHOBPR REPORT Ad Hoc";
    }

    protected void gridViewPageSizeDdlChanged(Object sender, EventArgs e)
    {
        if (GridViewAdHocReport.Visible == true)
        {
            GridViewAdHocReport.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);
        }
        if (GridViewAdHocByLocation.Visible == true)
        {
            GridViewAdHocByLocation.PageSize = int.Parse(gridViewPageSizeDdlbyLoc.SelectedValue);
        }
    }

    protected void gridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
         if (GridViewAdHocReport.Visible == true)
        {
            GridViewAdHocReport.PageIndex = e.NewPageIndex;
        }
         if (GridViewAdHocByLocation.Visible == true)
        {
            GridViewAdHocByLocation.PageIndex = e.NewPageIndex;
        }
    }

}
