﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.Business.Utilities; 
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class RegistryMaster : System.Web.UI.MasterPage
{
    private UserAccountManager _user;

    /// <summary>
    /// This script sets a focus to the control with a name to which
    /// REQUEST_LASTFOCUS was replaced. Setting focus heppens after the page
    /// (or update panel) was rendered. To delay setting focus the function
    /// window.setTimeout() will be used.
    /// </summary>
    //private const string SCRIPT_DOFOCUS =
    //    @"window.setTimeout('DoFocus()', 1);
    //    function DoFocus()
    //    {
    //        try {
    //            document.getElementById('REQUEST_LASTFOCUS').focus();
    //        } catch (ex) {}
    //    }";

    public delegate void MasterPageMenuClickHandler(object sender, MenuEventArgs e);
    
    public event MasterPageMenuClickHandler MenuClick;

    private string GetContextSensitiveHelpURL()
    {
        return "~/help/Content/Topics/Help Pages/" + Page.Page.ToString().Substring(4).Replace("_aspx", ".html");
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            _user = (UserAccountManager)HttpContext.Current.User;
            //Sets the correct URL for context sensitive help, based on content page
            HyperLinkHelp.NavigateUrl = GetContextSensitiveHelpURL();

            UserAccountManager user = (UserAccountManager)HttpContext.Current.User;

            if (Convert.ToBoolean(Helpers.GetConfigEntry("DisplayUser")) == true)
            {
                lblCurrentDateTime.Text = DateTime.Now.ToString();
                lblCurrentUser.Text = user.FullName;
                lblRole.Text = user.RoleName;
                Label1.Visible = true;
                Label2.Visible = true;
                lblCurrentDateTime.Visible = true;
                lblCurrentUser.Visible = true;
                lblRole.Visible = true;
            }

            //Set onfocus event to all apropriate controls on the page.
            if (!IsPostBack)
                HookOnFocus(this.Page as Control);

            if (!user.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleRegistryManagerCode)))
            {
                TopMenuAdmin.Visible = false;
                TopMenuTool.Visible = false;
            }

            if (user.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleRegistryManagerCode))
                || user.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleAdvancedUserCode))
                || user.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleCareTeamCode)))
            {
                TopMenuReport.Visible = true;
            }
            else if (user.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleHelpDeskCode)))
            {
                TopMenuReport.Visible = false;
            }

            Page.Header.DataBind();
        }
        catch (Exception)
        {
            Response.Redirect("Login.aspx");
        }
    }


    /// <summary>
    /// This function goes recursively all child controls and sets 
    /// onfocus attribute if the control has one of defined types.
    /// </summary>
    /// <param name="CurrentControl">the control to hook.</param>
    private void HookOnFocus(Control CurrentControl)
    {
        //checks if control is one of TextBox, DropDownList, ListBox or Button

        if ((CurrentControl is TextBox) ||
            (CurrentControl is DropDownList) ||
            (CurrentControl is ListBox) ||
            (CurrentControl is CheckBoxList) ||
            (CurrentControl is RadioButton) ||
            (CurrentControl is Button))
        {
            WebControl curr = (CurrentControl as WebControl);
            if (curr != null)
            {
                //adds a script which saves active control on receiving focus 
                //in the hidden field __LASTFOCUS.
                curr.Attributes.Add("onfocus", "try{document.getElementById('__LASTFOCUS').value=this.id; } catch(e) {}");
            }
        }

        //checks if the control has children
        if (CurrentControl.HasControls())
            //if yes do them all recursively

            foreach (Control CurrentChildControl in CurrentControl.Controls)
                HookOnFocus(CurrentChildControl);
    }


    public void SetDirtyFlag(bool flag)
    {

        dirtyFlag.Value = flag == true ? "1" : "0" ;


    }

}
