﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web.Security;
using System.Web.UI.WebControls.WebParts;
using System.Text;
using System.IO;
using System.Reflection;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class QuestionnaireSummary : BasePage
{
    private AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();

    protected void Page_Load(object sender, EventArgs e)
    {
        int registrantId = Request.QueryString["id"] == null ? UserSession.RegistrantId : Helpers.getIntFromString(Request.QueryString["id"].ToString());
        UserSession.RegistrantId = registrantId;
        UserControlRegistrant.LoadUserControl(registrantId);
        UserControlHealthFactor.LoadUserControl(registrantId);
        UserControlQuestionnaire.LoadControlsFromObject(registrantId);
        var master = (this.Master as RegistryMaster);
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        LabelQuestionnaireVersion.Text = "Questionnaire Version: " + UserControlQuestionnaire.QuestionnaireVersion;
        string registrantName = _registrantManager.SelectRegistrantNameById(registrantId);
        LabelBreadCrumb.Text = "<H1>Registrants > Registrant: " + registrantName + " > Clinically Relevant Summary</H1>"; 
        

        if (!IsPostBack)
        {
            //Log Questionnaire View:
            UserAccountManager user = (UserAccountManager)HttpContext.Current.User;
            Helpers.AddActivityToAuditLog(user.UserId.ToString(), "Questionnaire View",
                registrantId.ToString(),
                AuditLogType.RegistrantOpened, null);
        }

    }



    public override string TopMenuName()
    {
        return "Registrants";
    }

    public override string MenuItemName()
    {
        return "Clinically Relevant Summary";
    }

    public override string AppObjectCode()
    {
        return "AHOBPR QUESTIONNAIRE SUMMARY";
    }

}