﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web.Security;
using System.Web.UI.WebControls.WebParts;
using System.Text;
using System.IO;
using System.Reflection;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class QuestionnaireFollowup : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        int registrantId = Request.QueryString["id"] == null ? UserSession.RegistrantId : Helpers.getIntFromString(Request.QueryString["id"].ToString());
        UserSession.RegistrantId = registrantId;
        HiddenFieldRegistrantId.Value = registrantId.ToString();
        UserControlRegistrant.LoadUserControl(registrantId);
    }

    public override string TopMenuName()
    {
        return "Registrants";
    }

    public override string MenuItemName()
    {
        return "Follow-up Questions";
    }

    public override string AppObjectCode()
    {
        return "AHOBPR QUESTIONNAIRE SECTION";
    }

    protected override void OnUnload(EventArgs e)
    {
        var master = (this.Master as RegistryMaster);
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        base.OnUnload(e);
    }

}