﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web.Security;
using System.Web.UI.WebControls.WebParts;
using System.Text;
using System.IO;
using System.Reflection;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class ChangeStatusSearchRegistrant : BasePage
{
    private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    private List<STD_GUI_CONTROL_AHOBPR> _dbAhopbrControls = null;
    private AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();
   // USER_STATES_FILTER _stateFilter;

    #region Protected Members

    protected void Page_Load(object sender, EventArgs e)
    {
        //If an Advanced User hasn't set the states they are to filter on (set in the MyAccount page) then they need to be booted
        AHOBPRUserManager ahhobpManager = new AHOBPRUserManager();
        Dictionary<int, string> currentUserRoles = ahhobpManager.GetCurrentUserRoles(new RoleManager(), Helpers.GetConfigEntry("Registry"), CurrentUser);

        if (ahhobpManager.ShouldRedirectInvalidAdvancedUsers(currentUserRoles, CurrentUser.UserId))
        {
            Response.Redirect("RegistrantSearch.aspx?bounced=true", false);
        }

        var master = (this.Master as RegistryMaster);
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }

        LoadBaseControls();
        UserControlDateRangeStatusChangeDate.LoadControlsFromObject("Date Range for Registrant Current Status", false, "Date Range for Registrant Current Status", "onSearch");
        LabelNumberOfRegistrantsFound.Visible = false;
        UserSession.RegistrantId = 0;
        //UserSession.Registrant = null;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        if (!IsPostBack && 
            (!string.IsNullOrEmpty(UserSession.ChangeStatusSearchParameterStatus)
            || !string.IsNullOrEmpty(UserSession.ChangeStatusSearchParameterName)
            || !string.IsNullOrEmpty(UserSession.ChangeStatusSearchParameterSnum)
            || !string.IsNullOrEmpty(UserSession.ChangeStatusSearchParameterAdminFlag))
            )
        {
            if (!string.IsNullOrEmpty(UserSession.ChangeStatusSearchParameterStatus))
            {
                BaseControlListBoxStatus.Text = UserSession.ChangeStatusSearchParameterStatus;
            }

            if (!string.IsNullOrEmpty(UserSession.ChangeStatusSearchParameterName))
            {
                BaseControlTextBoxLastName.Text = UserSession.ChangeStatusSearchParameterName;
            }

            if (!string.IsNullOrEmpty(UserSession.ChangeStatusSearchParameterSnum))
            {
                BaseControlTextBoxLast4SSN.Text = UserSession.ChangeStatusSearchParameterSnum;
            }

            if (!string.IsNullOrEmpty(UserSession.ChangeStatusSearchParameterAdminFlag))
            {
                UserControlAdminFlagFilter.AdminFlagId = UserSession.ChangeStatusSearchParameterAdminFlag;
            }

            if (!string.IsNullOrEmpty(UserSession.ChangeStatusSearchParameterAdminFlag))
            {
                UserControlAdminFlagFilter.AdminFlagId = UserSession.ChangeStatusSearchParameterAdminFlag;
            }

            if (!string.IsNullOrEmpty(UserSession.ChangeStatusSearchParameterAdminFlagFromDate))
            {
                UserControlAdminFlagFilter.AdminFlagEnteredDateFrom = UserSession.ChangeStatusSearchParameterAdminFlagFromDate;
            }

            if (!string.IsNullOrEmpty(UserSession.ChangeStatusSearchParameterAdminFlagToDate))
            {
                UserControlAdminFlagFilter.AdminFlagEnteredDateTo = UserSession.ChangeStatusSearchParameterAdminFlagToDate;
            }

            if (UserSession.ExcludeReviewHecAdminFlag != null)
            {
                CheckBoxExcludeReviewHECAdminFlag.Checked = UserSession.ExcludeReviewHecAdminFlag;
            }

            if (!string.IsNullOrEmpty(UserSession.StatusFromDate))
            {
                UserControlDateRangeStatusChangeDate.FromDateValue = UserSession.StatusFromDate;
            }

            if (!string.IsNullOrEmpty(UserSession.StatusToDate))
            {
                UserControlDateRangeStatusChangeDate.ToDateValue = UserSession.StatusToDate;
            }
            
            SearchRegistrants();
        }
        ReloadBaseControlValue();

    }

    private void ReloadBaseControlValue()
    {
        BaseControlListBoxStatus.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxStatus.Text);

    }


    protected void Search_Click(object sender, EventArgs e)
    {
        SearchRegistrants();
    }

 
    private void SearchRegistrants()
    {

        // Validate that at least one value was entered    
        if (String.IsNullOrEmpty(BaseControlListBoxStatus.Text) && String.IsNullOrEmpty(BaseControlTextBoxLastName.Text) 
            && String.IsNullOrEmpty(BaseControlTextBoxLast4SSN.Text) && string.IsNullOrEmpty(UserControlAdminFlagFilter.AdminFlagId)
            && string.IsNullOrEmpty(UserControlDateRangeStatusChangeDate.FromDateValue)
            && string.IsNullOrEmpty(UserControlDateRangeStatusChangeDate.ToDateValue))
        {
            CustomValidatorSearchCriteria.ErrorMessage = "Please select at least one search criteria.";
            CustomValidatorSearchCriteria.IsValid = false;
            GridViewRegistrant.Visible = false;
            LabelNumberOfRegistrantsFound.Visible = false;
            gridViewPageSizeDdl.Visible = false;
            LabelItemsPerPage.Visible = false;
        }
        else if (String.IsNullOrEmpty(BaseControlListBoxStatus.Text)
            && (!string.IsNullOrEmpty(UserControlDateRangeStatusChangeDate.FromDateValue) || !string.IsNullOrEmpty(UserControlDateRangeStatusChangeDate.ToDateValue)))
        {
            CustomValidatorSearchCriteria.ErrorMessage = "Please select at least one status for the date range.";
            CustomValidatorSearchCriteria.IsValid = false;
            GridViewRegistrant.Visible = false;
            LabelNumberOfRegistrantsFound.Visible = false;
            gridViewPageSizeDdl.Visible = false;
            LabelItemsPerPage.Visible = false;
        }
        else
        {
            if (ValidateDateRange())
            {
                UserSession.ChangeStatusSearchParameterStatus = BaseControlListBoxStatus.Text;
                UserSession.ChangeStatusSearchParameterName = BaseControlTextBoxLastName.Text;
                UserSession.ChangeStatusSearchParameterSnum = BaseControlTextBoxLast4SSN.Text;
                UserSession.ChangeStatusSearchParameterAdminFlag = UserControlAdminFlagFilter.AdminFlagId;
                UserSession.ChangeStatusSearchParameterAdminFlagFromDate = UserControlAdminFlagFilter.AdminFlagEnteredDateFrom;
                UserSession.ChangeStatusSearchParameterAdminFlagToDate = UserControlAdminFlagFilter.AdminFlagEnteredDateTo;
                UserSession.ExcludeReviewHecAdminFlag = CheckBoxExcludeReviewHECAdminFlag.Checked;
                UserSession.StatusFromDate = UserControlDateRangeStatusChangeDate.FromDateValue;
                UserSession.StatusToDate = UserControlDateRangeStatusChangeDate.ToDateValue;
                GridViewRegistrant.DataBind();
                GridViewRegistrant.Visible = true;
                gridViewPageSizeDdl.Visible = true;
                LabelItemsPerPage.Visible = true;
            }
            else
            {
                GridViewRegistrant.Visible = false;
                LabelNumberOfRegistrantsFound.Visible = false;
                gridViewPageSizeDdl.Visible = false;
                LabelItemsPerPage.Visible = false;

            }

        }
    }

    private bool ValidateDateRange()
    {
        bool result = true;
        if (UserControlAdminFlagFilter.ValidateCustomValidator() == false)
        {
            result = false;
        }
        if (UserControlDateRangeStatusChangeDate.ValidateCustomValidator() == false)
        {
            result = false;
        }

        return result;
    }


    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        UserSession.ChangeStatusSearchParameterStatus = string.Empty;
        UserSession.ChangeStatusSearchParameterName = string.Empty;
        UserSession.ChangeStatusSearchParameterSnum = string.Empty;
        UserSession.ChangeStatusSearchParameterAdminFlag = string.Empty;
        UserSession.ChangeStatusSearchParameterAdminFlagFromDate = string.Empty;
        UserSession.ChangeStatusSearchParameterAdminFlagToDate = string.Empty;
        UserSession.ExcludeReviewHecAdminFlag = false;
        UserSession.StatusFromDate = string.Empty;
        UserSession.StatusToDate = string.Empty;

        BaseControlListBoxStatus.ResetControl();
        BaseControlTextBoxLastName.Text = string.Empty;
        BaseControlTextBoxLast4SSN.Text = string.Empty;
        UserControlAdminFlagFilter.AdminFlagId = string.Empty;
        UserControlAdminFlagFilter.AdminFlagEnteredDateFrom = string.Empty;
        UserControlAdminFlagFilter.AdminFlagEnteredDateTo = string.Empty;
        GridViewRegistrant.Visible = false;
        LabelNumberOfRegistrantsFound.Visible = false;
        CheckBoxExcludeReviewHECAdminFlag.Checked = false;
        gridViewPageSizeDdl.Visible = false;
        LabelItemsPerPage.Visible = false;
        UserControlDateRangeStatusChangeDate.FromDateValue = string.Empty;
        UserControlDateRangeStatusChangeDate.ToDateValue = string.Empty;
        LabelBreadCrumb.Text = "<H1>Change Status > Registrant Search </H1>";
    }
            
    #endregion

    #region Abstract Member Implementations
    public override string TopMenuName()
    {
        return "Registrants";
    }

    public override string MenuItemName()
    {
        return "Change Status";
    }

    public override string AppObjectCode()
    {
        return "AHOBPR CHANGE STATUS";
    }
    #endregion

    #region Private Members

    private void LoadBaseControls()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_CHANGE_STATUS_REGISTRANT_SEARCH"))
        {
            Control userControl = PanelSearchCriteria.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                if (dbItem.BASE_CONTROL_TYPE == (int)AhobprBaseControlType.ListBox)
                {
                    controls_BaseControlListBox baseControl = (controls_BaseControlListBox)userControl;
                    baseControl.LoadControlsFromObject(dbItem.LOOKUP_LIST_CATEGORY, string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                        dbItem.INCLUDE_LABEL, dbItem.DATA_ELEMENT_WIDTH, dbItem.VALIDATION_GROUP, dbItem.REQUIRED);
                }
                else if (dbItem.BASE_CONTROL_TYPE == (int)AhobprBaseControlType.TextBox)
                {
                    controls_BaseControlTextBox baseControl = (controls_BaseControlTextBox)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                        dbItem.INCLUDE_LABEL, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH,
                        dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.VALIDATION_REGULAR_EXPRESSION,
                        dbItem.REQUIRED);
                }
          }
        }
    }

    private List<STD_GUI_CONTROL_AHOBPR> GetGuiControls(string controlCategory)
    {
        if (UserSession.GuiControlsChangeStatusSearch == null)
        {
            _dbAhopbrControls = _baseControlManager.SelectGuiControlList(controlCategory).ToList<STD_GUI_CONTROL_AHOBPR>();
            UserSession.GuiControlsChangeStatusSearch = _dbAhopbrControls;
        }
        else
        {
            _dbAhopbrControls = UserSession.GuiControlsChangeStatusSearch;
        }

        return _dbAhopbrControls;
    }

    #endregion
    protected void GridViewRegistrant_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewRegistrant.SelectedIndex = index;
            UserSession.RegistrantId = (int)GridViewRegistrant.SelectedValue;
            Response.Redirect("ChangeStatus.aspx?id=" + GridViewRegistrant.SelectedValue);
        }
    }

    protected void RegistrantSearchDS_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        var totalRecordsFound = e.ReturnValue;
        LabelNumberOfRegistrantsFound.Visible = true;
        LabelNumberOfRegistrantsFound.Text = "Total Registrants Found: " + totalRecordsFound;
        LabelBreadCrumb.Text = "<H1>Change Status > Registrant Search </H1>";
    }

    /// <summary>
    /// Set the StateFilter if applicable
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void RegistrantSearchDS_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        e.InputParameters.Remove("hasStateFilter");
        e.InputParameters.Remove("stateFilter");
        e.InputParameters.Remove("registryStatusIds");
        //Get the Source values for the status listbox. These can be set programatically, so just ask the control for a list.
        var baseRegistrantStatusValues =  BaseControlListBoxStatus.LookupList.Select(i => i.ID.ToString()).ToList();
        //Get the elements that the user has selected and just rip out the values. The values will match
        var selectedRegistrantStatusValues = BaseControlListBoxStatus.DataElementValue.Select(i => i.Key).ToList();
        try
        {
            Dictionary<string, object> stateFilterInfo = _registrantManager.ApplyChangeStatusAdvancedUserRules(
                                                            Helpers.GetConfigEntry("Registry"),
                                                            new RoleManager(),
                                                            CurrentUser, baseRegistrantStatusValues,
                                                            selectedRegistrantStatusValues
                                                            );
            var cssFilter = (ChangeStatusStatesFilter)stateFilterInfo["StateFilter"];
            e.InputParameters.Add("hasStateFilter", cssFilter.HasStateFilter);
            e.InputParameters.Add("stateFilter", cssFilter.StateFilter);
            e.InputParameters.Add("registryStatusIds", (string)stateFilterInfo["StatusFilter"]);
        }
        catch (Exception ex)
        {
            Logging.LogErrorMessage("Invalid Data", "ChangeStatusSearchRegistrant.RegistrantSearchDS_Selecting()",
                   ex.Message);
        }

    }

    protected void gridViewPageSizeDdlChanged(Object sender, EventArgs e)
    {

        GridViewRegistrant.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);

    }

    protected void gridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewRegistrant.PageIndex = e.NewPageIndex;

    }


}